/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.vertexai.comparator;

import com.dataiku.dip.apideployer.datamodel.actual.common.DeploymentResourceComparator;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModelConfig;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelib.com.google.cloud.aiplatform.v1.DedicatedResources;
import com.dataiku.dss.shadelib.com.google.cloud.aiplatform.v1.DeployedModel;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class VertexAIDeployedModelComparator {
    private final VertexAIDeployedModel localDeployedModel;
    private final VertexAIDeployedModelConfigComparator configComparator;

    public VertexAIDeployedModelComparator(VertexAIDeployedModel deployedModel) {
        this.localDeployedModel = deployedModel;
        this.configComparator = new VertexAIDeployedModelConfigComparator(deployedModel.config);
    }

    public boolean isOutOfSync(@Nonnull DeployedModel deployedModel, @Nonnull String expectedModelName) {
        return !this.reportOutOfSyncFields(deployedModel, expectedModelName).isEmpty();
    }

    public Set<String> reportOutOfSyncFields(@Nonnull DeployedModel deployedModel, @Nonnull String expectedModelName) {
        HashSet<String> outOfSyncFields = new HashSet<String>();
        if (!StringUtils.equalsOrBothBlank((String)this.localDeployedModel.getId(), (String)deployedModel.getId())) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Deployed Model id", deployedModel.getId(), this.localDeployedModel.getId()));
        }
        if (!VertexAIUtils.areModelFullNamesEqual(expectedModelName, deployedModel.getModel(), true)) {
            outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Model referenced by Deployed Model", deployedModel.getModel(), expectedModelName));
        }
        outOfSyncFields.addAll(this.configComparator.reportOutOfSyncFields(deployedModel));
        return outOfSyncFields;
    }

    private static class VertexAIDeployedModelConfigComparator {
        private final VertexAIDeployedModelConfig config;

        private VertexAIDeployedModelConfigComparator(VertexAIDeployedModelConfig config) {
            this.config = config;
        }

        Set<String> reportOutOfSyncFields(@Nonnull DeployedModel deployedModel) {
            HashSet<String> outOfSyncFields = new HashSet<String>();
            DedicatedResources deployedModelDedicatedResources = deployedModel.getDedicatedResources();
            if (!StringUtils.equalsOrBothBlank((String)this.config.machineConfig.machineType, (String)deployedModelDedicatedResources.getMachineSpec().getMachineType())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Machine type", deployedModelDedicatedResources.getMachineSpec().getMachineType(), this.config.machineConfig.machineType));
            }
            if (!Objects.equals(this.config.machineConfig.minReplicaCount, deployedModelDedicatedResources.getMinReplicaCount())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Min replica count", deployedModelDedicatedResources.getMinReplicaCount(), this.config.machineConfig.minReplicaCount));
            }
            if (!Objects.equals(this.config.machineConfig.maxReplicaCount, deployedModelDedicatedResources.getMaxReplicaCount())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Max replica count", deployedModelDedicatedResources.getMaxReplicaCount(), this.config.machineConfig.maxReplicaCount));
            }
            if (!Objects.equals(this.config.machineConfig.getAcceleratorType(), deployedModelDedicatedResources.getMachineSpec().getAcceleratorType())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Accelerator type", deployedModelDedicatedResources.getMachineSpec().getAcceleratorType(), this.config.machineConfig.getAcceleratorType()));
            }
            if (!Objects.equals(this.config.machineConfig.acceleratorCount, deployedModelDedicatedResources.getMachineSpec().getAcceleratorCount())) {
                outOfSyncFields.add(DeploymentResourceComparator.outOfSyncFieldMessage("Accelerator count", deployedModelDedicatedResources.getMachineSpec().getAcceleratorCount(), this.config.machineConfig.acceleratorCount));
            }
            return outOfSyncFields;
        }
    }
}

