/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.config;

import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.deployments.AbstractAPIServiceDeploymentManager;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.ServiceState;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractAPIServiceDockerDeployment
extends AbstractAPIServiceDeployment {
    public static final String ADDITIONAL_FINALIZE_FOR_DEPLOYMENT_TYPE = "Docker.additional_finalize_deployment_type";
    public static final String LOGGING_DIR = "logging";
    public static final String SERVER_RESOURCES_DIR = "server-resources";
    public static final String INSTALL_INI_ADD = "install.ini.add";
    public static final String INSTALL_DETAILS_DIR = "install-details";
    public static final String ADDITIONAL_INIT_FOR_DEPLOYMENT_TYPE = "Docker.additional_init_deployment_type";
    public static final String DKU_LOG4J_FILENAME = "dku-log4j.properties";
    protected AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging apiNodeLogging = new AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.datamodel.config");

    protected AbstractAPIServiceDockerDeployment() {
    }

    protected AbstractAPIServiceDockerDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag);
    }

    protected AbstractAPIServiceDockerDeployment(String id, String infraId, String publishedServiceId, String version, boolean enabled, VersionTag creationTag, List<AbstractAPIServiceDeployment.AuthorizationItem> authorizationsToQueryThroughDeployer) {
        super(id, infraId, publishedServiceId, version, enabled, creationTag, authorizationsToQueryThroughDeployer);
    }

    protected AbstractAPIServiceDockerDeployment(AbstractAPIServiceDeployment existingDeployment, String deploymentId, String infraId, boolean enabled, VersionTag creationTag) {
        super(existingDeployment, deploymentId, infraId, enabled, creationTag);
    }

    @Override
    @Nonnull
    public AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging getNodeLogging() {
        return this.apiNodeLogging;
    }

    @Override
    @Nonnull
    public AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging getNodeLogging(AbstractAPIDeploymentInfra infra) {
        if (this.getOverrideSettings().apiNodeLogging) {
            AbstractAPIDeploymentInfra.APINodeLogging infraNodeLogging = infra.getNodeLogging();
            AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging result = (AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging)JSON.deepCopy((Object)this.apiNodeLogging);
            result.fsLikeSettings.connectionName = infraNodeLogging.fsLikeSettings.connectionName;
            result.fsLikeSettings.pathWithinConnection = infraNodeLogging.fsLikeSettings.pathWithinConnection;
            result.fsLikeSettings.bucket = infraNodeLogging.fsLikeSettings.bucket;
            return result;
        }
        AbstractAPIDockerDeploymentInfra dockerInfra = (AbstractAPIDockerDeploymentInfra)infra;
        return dockerInfra.getNodeLogging();
    }

    protected abstract APIServiceDockerDeploymentOverrideMask getOverrideSettings();

    public void prepareInstallIni(AbstractAPIDockerDeploymentInfra infra, File contextDir) throws IOException {
        File installFolder = new File(contextDir, INSTALL_DETAILS_DIR);
        DKUFileUtils.mkdirs((File)installFolder);
        DKUFileUtils.writeFileUTF8((File)new File(installFolder, INSTALL_INI_ADD), (String)"");
    }

    public void prepareServerResources(AbstractAPIDockerDeploymentInfra infra, File contextDir) throws IOException {
        File serverConfig = new File(contextDir, SERVER_RESOURCES_DIR);
        File loggingFolder = new File(serverConfig, LOGGING_DIR);
        DKUFileUtils.mkdirs((File)loggingFolder);
        if (StringUtils.isNotBlank((String)this.getLog4jConfiguration(infra))) {
            DKUFileUtils.writeFileUTF8((File)new File(loggingFolder, DKU_LOG4J_FILENAME), (String)this.getLog4jConfiguration(infra));
        }
    }

    public String getLog4jConfiguration(AbstractAPIDockerDeploymentInfra infra) {
        return this.getNodeLogging((AbstractAPIDeploymentInfra)infra).log4jConfiguration;
    }

    public void additionalInitForDeploymentType(File contextDir) throws IOException {
        File additionalTargetInit = new File(contextDir, ADDITIONAL_INIT_FOR_DEPLOYMENT_TYPE);
        DKUFileUtils.createIfNotExists((File)additionalTargetInit);
    }

    public void additionalFinalizeForDeploymentType(File contextDir, AbstractAPIDeploymentInfra infra) throws IOException {
        File additionalTargetInit = new File(contextDir, ADDITIONAL_FINALIZE_FOR_DEPLOYMENT_TYPE);
        DKUFileUtils.createIfNotExists((File)additionalTargetInit);
    }

    public ServiceState getDefaultServiceState() {
        ServiceState state = new ServiceState();
        state.enabled = this.enabled;
        state.activeMapping = AbstractAPIServiceDeploymentManager.enrichedGenerationsMapping(this);
        return state;
    }

    protected static Collection<SimpleKeyValue> getSimpleKeyValues(List<SimpleKeyValue> fromDeployment, List<SimpleKeyValue> fromInfra, boolean allowOverride) {
        HashMap map = new HashMap();
        fromInfra.forEach(pair -> map.put(pair.key, pair));
        if (allowOverride) {
            fromDeployment.forEach(pair -> map.put(pair.key, pair));
        } else {
            fromDeployment.forEach(pair -> map.putIfAbsent(pair.key, pair));
        }
        return map.values();
    }

    public static class APIServiceDockerDeploymentOverrideMask {
        boolean apiNodeLogging;

        public void applyToDeployment(AbstractAPIServiceDockerDeployment target, AbstractAPIDockerDeploymentInfra source) {
            if (this.apiNodeLogging) {
                AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging infraNodeLogging = source.defaultApiNodeLogging;
                target.apiNodeLogging.fsLikeSettings.connectionName = infraNodeLogging.fsLikeSettings.connectionName;
                target.apiNodeLogging.fsLikeSettings.pathWithinConnection = infraNodeLogging.fsLikeSettings.pathWithinConnection;
                target.apiNodeLogging.fsLikeSettings.bucket = infraNodeLogging.fsLikeSettings.bucket;
            } else {
                target.apiNodeLogging = (AbstractAPIDockerDeploymentInfra.DockerAPINodeLogging)JSON.deepCopy((Object)source.defaultApiNodeLogging);
            }
        }
    }
}

