/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.monitoring.MetricType;
import com.dataiku.dip.apideployer.monitoring.MetricsAggregation;
import com.dataiku.dip.apideployer.monitoring.MonitoringMetric;
import com.dataiku.dip.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NamedLock;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.Sample;

public class MetricUtils {
    private static final List<SystemMetric.Type> commonSystemMetrics = List.of(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES, SystemMetric.Type.CPU_USAGE_RELATIVE, SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES, SystemMetric.Type.MEMORY_USAGE_RELATIVE, SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES, SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES);
    private static final List<SystemMetric.Type> k8sSystemMetrics = Stream.concat(commonSystemMetrics.stream(), Stream.of(SystemMetric.Type.NODE_COUNT, SystemMetric.Type.POD_COUNT)).toList();
    private static final List<SystemMetric.Type> dataikuCloudK8sSystemMetrics = List.of(SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES, SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES, SystemMetric.Type.POD_COUNT);
    private static final List<SystemMetric.Type> staticApiNodeSystemMetrics = List.copyOf(commonSystemMetrics);
    public static final Map<AbstractDeploymentInfra.InfraType, List<SystemMetric.Type>> INFRA_TYPE_TO_SYSTEM_METRICS = Map.of(AbstractDeploymentInfra.InfraType.K8S, DKUApp.isDataikuCloud() ? dataikuCloudK8sSystemMetrics : k8sSystemMetrics, AbstractDeploymentInfra.InfraType.STATIC, staticApiNodeSystemMetrics);
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.unifiedmonitoring.metricUtils");

    private MetricUtils() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static <T extends Enum<T>> void writeRrdSample(RrdDb rrdDb, long timestamp, Map<? extends T, ? extends MonitoringMetric<T>> metricsByType) throws IOException {
        assert (NamedLock.isHeldByCurrentThread((String)rrdDb.getPath()));
        long lastUpdateTime = rrdDb.getLastUpdateTime();
        if (lastUpdateTime >= timestamp) {
            logger.debugV("Not saving values in file %s for time %d as it is <= to last update time %d", new Object[]{rrdDb.getPath(), timestamp, lastUpdateTime});
            return;
        }
        Sample sample = rrdDb.createSample(timestamp);
        for (MonitoringMetric<T> metric : metricsByType.values()) {
            sample.setValue(((MetricType)metric.getType()).getRrdFieldName(), metric.getValue());
        }
        sample.update();
    }

    public static FetchData fetchRrdData(File rrdFile, MetricsAggregation aggregation, ConsolFun consolidation, Period period) throws Exception {
        long periodInSeconds = MetricUtils.getPeriodInDays(period) * 24L * 60L * 60L;
        try (AutoCloseableLock lock = NamedLock.acquire((String)rrdFile.getAbsolutePath());){
            FetchData fetchData;
            block12: {
                RrdDb rrdDb = RrdDb.of((String)rrdFile.getAbsolutePath());
                try {
                    long now = System.currentTimeMillis() / 1000L;
                    FetchRequest request = rrdDb.createFetchRequest(consolidation, now - periodInSeconds, now, aggregation.getIntervalInSeconds());
                    fetchData = request.fetchData();
                    if (rrdDb == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rrdDb != null) {
                        try {
                            rrdDb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rrdDb.close();
            }
            return fetchData;
        }
    }

    public static long getPeriodInDays(Period period) {
        LocalDate endDate = LocalDate.now();
        LocalDate startDate = endDate.minus(period);
        return ChronoUnit.DAYS.between(startDate, endDate);
    }

    public static long[] getTimestampsInPeriod(Period period, MetricsAggregation aggregation) {
        Instant now = Instant.now();
        Instant startingPoint = Instant.now().minus(Period.ofDays((int)MetricUtils.getPeriodInDays(period)));
        long intervalInSeconds = aggregation.getIntervalInSeconds();
        return LongStream.iterate(startingPoint.getEpochSecond(), i -> i <= now.getEpochSecond(), i -> i + intervalInSeconds).toArray();
    }
}

