/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.recipes.code.julia.JuliaRecipeMeta;
import com.dataiku.dip.recipes.code.python.PythonRecipeMeta;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.recipes.code.spark.PySparkRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CodeConversionService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    private static final String NOTEBOOK_CELL = "-------------------------------------------------------------------------------- NOTEBOOK-CELL: ";
    private static final String PYTHON_MAGIC_CELL_CODE = "%pylab inline";
    private static final String PYTHON_MAGIC_CELL_REMPLACEMENT = "# Automatically replaced inline charts by \"no-op\" charts\n# %pylab inline\nimport matplotlib\nmatplotlib.use(\"Agg\")";
    private static final String COMMENT_OUTPUTS = "Recipe outputs";
    private static final String PYTHON_MAGIC_LINE_LOAD_ASSISTANT = "%load_ext";
    private static final String PYTHON_MAGIC_LINE_CODE_ASSISTANT = "%ai";
    private static final String PYTHON_MAGIC_CELL_CODE_ASSISTANT = "%%ai";
    private static final String PYTHON_MAGIC_CELL_AIEXPLAIN = "%%aiexplain";
    private String recipeType;
    private String commentLinePrefix;
    private String cellSeparator;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.jupyter.codeconversion");

    private void init(String recipeType) {
        this.recipeType = recipeType;
        if (PythonRecipeMeta.META.getType().equals(recipeType) || PySparkRecipeMeta.META.getType().equals(recipeType) || RRecipeMeta.META.getType().equals(recipeType) || SparkRRecipeMeta.META.getType().equals(recipeType) || JuliaRecipeMeta.META.getType().equals(recipeType)) {
            this.commentLinePrefix = "# ";
        } else if (SparkScalaRecipeMeta.META.getType().equals(recipeType)) {
            this.commentLinePrefix = "// ";
        } else {
            throw ErrorContext.iae((String)("Unkown recipe type: " + recipeType));
        }
        this.cellSeparator = this.commentLinePrefix + NOTEBOOK_CELL;
    }

    public String notebookToNewRecipe(String recipeType, JsonObject notebook, SerializedRecipe sr) throws IOException {
        this.init(recipeType);
        ArrayList<String> outputSourceLines = new ArrayList<String>();
        List<SerializedRecipe.RecipeOutput> outputs = sr.getOutputsForRole("main");
        for (SerializedRecipe.RecipeOutput recipeOutput : outputs) {
            outputSourceLines.addAll(this.getOutputSourceLines(sr.getProjectKey(), recipeOutput));
        }
        if (!outputSourceLines.isEmpty()) {
            JsonArray source = new JsonArray();
            source.add((JsonElement)new JsonPrimitive(this.commentLinePrefix + COMMENT_OUTPUTS));
            for (String s : outputSourceLines) {
                source.add((JsonElement)new JsonPrimitive(s + "\n"));
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("cell_type", "code");
            jsonObject.add("metadata", (JsonElement)new JsonObject());
            jsonObject.add("outputs", (JsonElement)new JsonArray());
            jsonObject.addProperty("execution_count", (Number)0);
            jsonObject.add("source", (JsonElement)source);
            JsonArray cells = notebook.get("cells").getAsJsonArray();
            cells.add((JsonElement)jsonObject);
        }
        return this.notebookToRecipe(recipeType, notebook);
    }

    private List<String> getOutputSourceLines(String projectKey, SerializedRecipe.RecipeOutput output) throws IOException {
        ArrayList<String> outputSourceLines = new ArrayList<String>();
        SerializedDataset ds = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(output.getLoc(projectKey));
        ManagedFolder mf = (ManagedFolder)this.managedFolderDAO.getOrNullUnsafe(output.getLoc(projectKey));
        String dsName = output.ref;
        String cleanedDsName = this.cleanupVariable(dsName);
        if (PythonRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add(cleanedDsName + " = dataiku.Dataset(\"" + dsName + "\")");
                outputSourceLines.add(cleanedDsName + ".write_with_schema(pandas_dataframe)");
            } else if (mf != null) {
                outputSourceLines.add(cleanedDsName + " = dataiku.Folder(\"" + dsName + "\")");
                outputSourceLines.add(cleanedDsName + "_info = " + cleanedDsName + ".get_info()");
            }
        } else if (PySparkRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add(cleanedDsName + " = dataiku.Dataset(\"" + dsName + "\")");
                outputSourceLines.add("dkuspark.write_with_schema(" + cleanedDsName + ", spark_dataframe)");
            } else if (mf != null) {
                outputSourceLines.add(cleanedDsName + " = dataiku.Folder(\"" + dsName + "\")");
                outputSourceLines.add(cleanedDsName + "_info = " + cleanedDsName + ".get_info()");
            }
        } else if (JuliaRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add(cleanedDsName + " = Dataiku.DSSDataset(\"" + dsName + "\")");
                outputSourceLines.add("Dataiku.write_with_schema(" + cleanedDsName + ", julia_dataframe)");
            } else if (mf != null) {
                outputSourceLines.add(cleanedDsName + " = Dataiku.DSSFolder(\"" + dsName + "\")");
                outputSourceLines.add(cleanedDsName + "_info = Dataiku.get_settings(" + cleanedDsName + ")");
            }
        } else if (RRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add("dkuWriteDataset(" + cleanedDsName + ",\"" + dsName + "\")");
            } else if (mf != null) {
                outputSourceLines.add(this.cleanupVariable(mf.name) + " <- dkuManagedFolderPath(\"" + dsName + "\")");
            }
        } else if (SparkRRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add("dkuSparkWriteDataset(" + cleanedDsName + ",\"" + dsName + "\")");
            } else if (mf != null) {
                outputSourceLines.add(this.cleanupVariable(mf.name) + " <- dkuManagedFolderPath(\"" + dsName + "\")");
            }
        } else if (SparkScalaRecipeMeta.META.getType().equals(this.recipeType)) {
            if (ds != null) {
                outputSourceLines.add("dkuContext.save(\"" + dsName + "\", someSparkDataFrame)");
            } else if (mf != null) {
                outputSourceLines.add("val " + this.cleanupVariable(mf.name) + " = dkuContext.getManagedFolderRoot(\"" + mf.id + (String)(projectKey.equals(mf.projectKey) ? "" : "\", \"" + mf.projectKey) + "\")");
            }
        } else {
            throw ErrorContext.iae((String)("Unkown recipe type: " + this.recipeType));
        }
        return outputSourceLines;
    }

    public String notebookToRecipe(String recipeType, JsonObject notebook) {
        this.init(recipeType);
        StringBuilder recipeCode = new StringBuilder();
        JsonArray cells = notebook.has("cells") ? notebook.get("cells").getAsJsonArray() : new JsonArray();
        Iterator cellsIt = cells.iterator();
        boolean firstCell = true;
        while (cellsIt.hasNext()) {
            JsonObject cell = ((JsonElement)cellsIt.next()).getAsJsonObject();
            String cellStr = this.notebookToRecipeCell(cell);
            if (cellStr == null) continue;
            if (!firstCell) {
                recipeCode.append("\n\n");
            }
            recipeCode.append(cellStr);
            if (!firstCell) continue;
            firstCell = false;
        }
        return recipeCode.toString();
    }

    private String notebookToRecipeCell(JsonObject inputCell) {
        boolean pythonRecipe;
        JsonArray sourceLines;
        JsonObject cell;
        JsonObject jsonObject = cell = inputCell != null ? inputCell : new JsonObject();
        if (cell.has("source")) {
            if (cell.get("source").isJsonArray()) {
                sourceLines = cell.get("source").getAsJsonArray();
            } else {
                sourceLines = new JsonArray();
                sourceLines.add(cell.get("source").getAsString());
            }
        } else {
            sourceLines = new JsonArray();
        }
        CellType cellType = CellType.forCode(cell.has("cell_type") ? cell.get("cell_type").getAsString() : "code");
        boolean bl = pythonRecipe = PythonRecipeMeta.META.getType().equals(this.recipeType) || PySparkRecipeMeta.META.getType().equals(this.recipeType);
        if (pythonRecipe && cellType == CellType.CODE && !sourceLines.isEmpty()) {
            String line = sourceLines.get(0).getAsString();
            if (PYTHON_MAGIC_CELL_CODE.equals(line)) {
                return this.cellSeparator + CellType.CODE_MAGIC_CELL.name() + "\n# Automatically replaced inline charts by \"no-op\" charts\n# %pylab inline\nimport matplotlib\nmatplotlib.use(\"Agg\")";
            }
            if (line.startsWith(PYTHON_MAGIC_CELL_AIEXPLAIN)) {
                sourceLines.set(0, JSON.toJsonElement((Object)("#" + line)));
            } else if (line.startsWith(PYTHON_MAGIC_LINE_LOAD_ASSISTANT) || line.startsWith(PYTHON_MAGIC_LINE_CODE_ASSISTANT) || line.startsWith(PYTHON_MAGIC_CELL_CODE_ASSISTANT)) {
                cellType = CellType.CODE_ASSISTANT_MAGIC_CELL;
            }
        }
        while (sourceLines.size() > 0 && StringUtils.isBlank((String)sourceLines.get(0).getAsString())) {
            sourceLines.remove(0);
        }
        while (sourceLines.size() > 0 && StringUtils.isBlank((String)sourceLines.get(sourceLines.size() - 1).getAsString())) {
            sourceLines.remove(sourceLines.size() - 1);
        }
        boolean hasContent = false;
        Iterator sourceLinesIt = sourceLines.iterator();
        StringBuilder sourceLinesStr = new StringBuilder();
        while (sourceLinesIt.hasNext()) {
            sourceLinesStr.append('\n');
            String line = StringUtils.stripEnd((String)((JsonElement)sourceLinesIt.next()).getAsString(), null);
            if (cellType != CellType.CODE) {
                sourceLinesStr.append(this.commentLinePrefix);
                line = line.replace("\n", "\n" + this.commentLinePrefix);
            }
            if (StringUtils.isNotBlank((String)line)) {
                hasContent = true;
            }
            sourceLinesStr.append(line);
        }
        if (hasContent) {
            return this.cellSeparator + cellType.name() + sourceLinesStr.toString();
        }
        return null;
    }

    public JsonObject recipeToNotebook(String recipeType, String recipeCode, JsonObject metadata) {
        this.init(recipeType);
        JsonObject notebook = new JsonObject();
        notebook.addProperty("nbformat", (Number)4);
        notebook.addProperty("nbformat_minor", (Number)0);
        notebook.add("metadata", (JsonElement)(metadata != null ? metadata : new JsonObject()));
        JsonArray cells = new JsonArray();
        try {
            String line;
            BufferedReader bufReader = new BufferedReader(new StringReader(recipeCode));
            ArrayList curSourceLines = new ArrayList<String>();
            CellType curCellType = CellType.CODE;
            while ((line = bufReader.readLine()) != null) {
                if (line.startsWith(this.cellSeparator)) {
                    this.checkAndAddCell(cells, curCellType, curSourceLines);
                    String cellTypeStr = line.substring(this.cellSeparator.length());
                    try {
                        curCellType = CellType.valueOf(cellTypeStr);
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn((Object)("Unkown cell type: " + cellTypeStr), (Throwable)e);
                        curCellType = CellType.CODE;
                    }
                    curSourceLines = new ArrayList();
                    continue;
                }
                if (!"code".equals(curCellType.code) && !line.startsWith(this.commentLinePrefix)) {
                    this.checkAndAddCell(cells, curCellType, curSourceLines);
                    curCellType = CellType.CODE;
                    curSourceLines = Lists.newArrayList((Object[])new String[]{line});
                    continue;
                }
                curSourceLines.add((String)line);
            }
            this.checkAndAddCell(cells, curCellType, curSourceLines);
        }
        catch (IOException e) {
            logger.warn((Object)("Cannot read recipe code: " + recipeCode), (Throwable)e);
        }
        notebook.add("cells", (JsonElement)cells);
        return notebook;
    }

    private void checkAndAddCell(JsonArray cells, CellType cellType, List<String> sourceLines) {
        JsonObject cell;
        if (!sourceLines.isEmpty() && (cell = this.recipeToNotebookCell(cellType, sourceLines)) != null) {
            cells.add((JsonElement)cell);
        }
    }

    private JsonObject recipeToNotebookCell(CellType cellType, List<String> sourceLinesStr) {
        JsonObject cell = new JsonObject();
        cell.addProperty("cell_type", cellType.code);
        cell.add("metadata", (JsonElement)new JsonObject());
        if ("code".equals(cellType.code)) {
            cell.add("outputs", (JsonElement)new JsonArray());
            cell.addProperty("execution_count", (Number)0);
        }
        if (cellType == CellType.CODE_MAGIC_CELL) {
            JsonArray sourceLines = new JsonArray();
            sourceLines.add((JsonElement)new JsonPrimitive(PYTHON_MAGIC_CELL_CODE));
            cell.add("source", (JsonElement)sourceLines);
        } else {
            while (!sourceLinesStr.isEmpty() && this.isEmptyLine(cellType, sourceLinesStr.get(0))) {
                sourceLinesStr.remove(0);
            }
            while (!sourceLinesStr.isEmpty() && this.isEmptyLine(cellType, sourceLinesStr.get(sourceLinesStr.size() - 1))) {
                sourceLinesStr.remove(sourceLinesStr.size() - 1);
            }
            if (sourceLinesStr.isEmpty()) {
                cell = null;
            } else {
                JsonArray sourceLines = new JsonArray();
                for (int i = 0; i < sourceLinesStr.size(); ++i) {
                    Object sLine = sourceLinesStr.get(i);
                    if (cellType != CellType.CODE && ((String)sLine).startsWith(this.commentLinePrefix)) {
                        sLine = ((String)sLine).substring(this.commentLinePrefix.length());
                    }
                    sLine = StringUtils.stripEnd((String)sLine, null) + (i < sourceLinesStr.size() - 1 ? "\n" : "");
                    sourceLines.add((JsonElement)new JsonPrimitive((String)sLine));
                }
                cell.add("source", (JsonElement)sourceLines);
            }
        }
        return cell;
    }

    private boolean isEmptyLine(CellType cellType, String sourceLine) {
        return StringUtils.isBlank((String)sourceLine) || cellType != CellType.CODE && this.commentLinePrefix.equals(sourceLine);
    }

    private String cleanupVariable(String var) {
        return var.toLowerCase().replaceAll("[^a-z0-9]", "_");
    }

    public static enum CellType {
        CODE(true, "code"),
        CODE_MAGIC_CELL(false, "code"),
        CODE_ASSISTANT_MAGIC_CELL(false, "code"),
        RAW(true, "raw"),
        MARKDOWN(true, "markdown");

        private boolean natural;
        private String code;

        private CellType(boolean natural, String code) {
            this.natural = natural;
            this.code = code;
        }

        public static CellType forCode(String code) {
            for (CellType cm : CellType.values()) {
                if (!cm.natural || !cm.code.equals(code)) continue;
                return cm;
            }
            throw ErrorContext.iae((String)("CodeMode not found: " + code));
        }
    }
}

