/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.code.CodeEnvModel;
import com.google.gson.JsonObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class JupyterCodeEnvUtils {
    public static final String JUPYTER_LANGUAGE_PYTHON = "Python";
    public static final String JUPYTER_LANGUAGE_R = "R";
    public static final String JUPYTER_LANGUAGE_JULIA = "Julia";
    public static final String JUPYTER_LANGUAGE_SCALA = "Scala";

    private JupyterCodeEnvUtils() {
    }

    public static NotebookCodeEnvInfo getCodeEnvInfoFromNotebook(JsonObject notebook) {
        if (!notebook.has("metadata")) {
            return null;
        }
        JsonObject metadata = notebook.getAsJsonObject("metadata");
        if (!metadata.has("kernelspec")) {
            return null;
        }
        if (!metadata.getAsJsonObject("kernelspec").has("name")) {
            return null;
        }
        NotebookCodeEnvInfo info = new NotebookCodeEnvInfo();
        info.kernelName = metadata.getAsJsonObject("kernelspec").get("name").getAsString();
        if (metadata.getAsJsonObject("kernelspec").has("display_name")) {
            info.kernelDisplayName = metadata.getAsJsonObject("kernelspec").get("display_name").getAsString();
            String displayName = metadata.getAsJsonObject("kernelspec").get("display_name").getAsString();
            Pattern displayNamePattern = Pattern.compile("(Python|R) (in (.*) )?\\(((version ([^.]*)\\.(.*) of )?env (.*)|builtin env)\\)");
            Matcher displayNameMatcher = displayNamePattern.matcher(displayName);
            if (displayNameMatcher.matches()) {
                info.envLang = displayNameMatcher.group(1).equals(JUPYTER_LANGUAGE_PYTHON) ? CodeEnvModel.EnvLang.PYTHON : CodeEnvModel.EnvLang.R;
                info.containerConf = displayNameMatcher.group(3);
                info.envName = displayNameMatcher.group(8);
                info.projectKey = displayNameMatcher.group(6);
                info.bundleId = displayNameMatcher.group(7);
                return info;
            }
            return null;
        }
        String name = metadata.getAsJsonObject("kernelspec").get("name").getAsString();
        Pattern namePattern = Pattern.compile("(py|r)-dku(-containerized)?-venv-(.*)");
        Matcher nameMatcher = namePattern.matcher(name);
        if (nameMatcher.matches()) {
            int sepPos;
            info.envLang = nameMatcher.group(1).equals("py") ? CodeEnvModel.EnvLang.PYTHON : CodeEnvModel.EnvLang.R;
            String envNameDesc = nameMatcher.group(3);
            if ("-containerized".equals(nameMatcher.group(2)) && (sepPos = envNameDesc.lastIndexOf(45)) >= 0) {
                info.containerConf = envNameDesc.substring(sepPos + 1);
                envNameDesc = envNameDesc.substring(0, sepPos);
            }
            if (envNameDesc.startsWith("ver-")) {
                int projectKeyPos;
                int bundleIdPos = (envNameDesc = envNameDesc.substring("ver-".length())).lastIndexOf(45);
                int n = projectKeyPos = bundleIdPos > 0 ? envNameDesc.lastIndexOf(45, bundleIdPos - 1) : -1;
                if (bundleIdPos >= 0 && projectKeyPos >= 0) {
                    info.envName = StringUtils.defaultIfBlank((String)envNameDesc.substring(0, projectKeyPos), null);
                    info.projectKey = envNameDesc.substring(projectKeyPos + 1, bundleIdPos);
                    info.bundleId = envNameDesc.substring(bundleIdPos + 1);
                } else {
                    info.envName = envNameDesc;
                }
            } else {
                info.envName = StringUtils.defaultIfBlank((String)envNameDesc, null);
            }
            return info;
        }
        return null;
    }

    public static void setKernelNameInNotebook(JsonObject notebook, String kernelName) {
        if (!notebook.has("metadata")) {
            return;
        }
        JsonObject metadata = notebook.getAsJsonObject("metadata");
        if (!metadata.has("kernelspec")) {
            return;
        }
        metadata.getAsJsonObject("kernelspec").addProperty("name", kernelName);
    }

    public static void setDisplayNameInNotebook(JsonObject notebook, String displayName) {
        if (!notebook.has("metadata")) {
            return;
        }
        JsonObject metadata = notebook.getAsJsonObject("metadata");
        if (!metadata.has("kernelspec")) {
            return;
        }
        metadata.getAsJsonObject("kernelspec").addProperty("display_name", displayName);
    }

    public static String getKernelName(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String containerConf) {
        if (StringUtils.isNotBlank((String)containerConf)) {
            if (StringUtils.isNotBlank((String)bundleId)) {
                return JupyterCodeEnvUtils.getKernelNameForContainerizedAutomationVersioned(envLang, envName, projectKey, bundleId, containerConf);
            }
            return JupyterCodeEnvUtils.getKernelNameForContainerizedDesignOrNotVersioned(envLang, envName, containerConf);
        }
        if (StringUtils.isNotBlank((String)bundleId)) {
            return JupyterCodeEnvUtils.getKernelNameForAutomationVersioned(envLang, envName, projectKey, bundleId);
        }
        return JupyterCodeEnvUtils.getKernelNameForDesignOrNotVersioned(envLang, envName);
    }

    private static String getKernelNameForDesignOrNotVersioned(CodeEnvModel.EnvLang envLang, String envName) {
        switch (envLang) {
            case PYTHON: {
                return ("py-dku-venv-" + StringUtils.defaultIfBlank((String)envName, (String)"")).toLowerCase();
            }
            case R: {
                return ("r-dku-venv-" + StringUtils.defaultIfBlank((String)envName, (String)"")).toLowerCase();
            }
        }
        throw new Error("unreachable");
    }

    private static String getKernelNameForAutomationVersioned(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId) {
        switch (envLang) {
            case PYTHON: {
                return ("py-dku-venv-ver-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + projectKey + "-" + bundleId).toLowerCase();
            }
            case R: {
                return ("r-dku-venv-ver-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + projectKey + "-" + bundleId).toLowerCase();
            }
        }
        throw new Error("unreachable");
    }

    private static String getKernelNameForContainerizedDesignOrNotVersioned(CodeEnvModel.EnvLang envLang, String envName, String containerConf) {
        switch (envLang) {
            case PYTHON: {
                return ("py-dku-containerized-venv-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + containerConf).toLowerCase();
            }
            case R: {
                return ("r-dku-containerized-venv-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + containerConf).toLowerCase();
            }
        }
        throw new Error("unreachable");
    }

    private static String getKernelNameForContainerizedAutomationVersioned(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String containerConf) {
        switch (envLang) {
            case PYTHON: {
                return ("py-dku-containerized-venv-ver-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + projectKey + "-" + bundleId + "-" + containerConf).toLowerCase();
            }
            case R: {
                return ("r-dku-containerized-venv-ver-" + StringUtils.defaultIfBlank((String)envName, (String)"") + "-" + projectKey + "-" + bundleId + "-" + containerConf).toLowerCase();
            }
        }
        throw new Error("unreachable");
    }

    public static String getLanguageFromKernelName(String name) {
        if (name.startsWith("py-dku-venv-")) {
            return JUPYTER_LANGUAGE_PYTHON;
        }
        if (name.startsWith("py-dku-databricks-venv-")) {
            return JUPYTER_LANGUAGE_PYTHON;
        }
        if (name.startsWith("py-dku-containerized-venv-")) {
            return JUPYTER_LANGUAGE_PYTHON;
        }
        if (name.startsWith("r-dku-venv-")) {
            return JUPYTER_LANGUAGE_R;
        }
        if (name.startsWith("r-dku-databricks-venv-")) {
            return JUPYTER_LANGUAGE_R;
        }
        if (name.startsWith("r-dku-containerized-venv-")) {
            return JUPYTER_LANGUAGE_R;
        }
        if (name.startsWith("julia")) {
            return JUPYTER_LANGUAGE_JULIA;
        }
        if ("ir".equals(name)) {
            return JUPYTER_LANGUAGE_R;
        }
        if ("python2".equals(name) || "python3".equals(name)) {
            return JUPYTER_LANGUAGE_PYTHON;
        }
        if ("toree".equals(name)) {
            return JUPYTER_LANGUAGE_SCALA;
        }
        return name;
    }

    public static String getDisplayName(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String containerConf) {
        if (StringUtils.isNotBlank((String)containerConf)) {
            if (StringUtils.isNotBlank((String)bundleId)) {
                return JupyterCodeEnvUtils.getDisplayNameForContainerizedVersionedEnvName(envLang, envName, projectKey, bundleId, containerConf);
            }
            return JupyterCodeEnvUtils.getDisplayNameForContainerizedEnvName(envLang, envName, containerConf);
        }
        if (StringUtils.isNotBlank((String)bundleId)) {
            return JupyterCodeEnvUtils.getDisplayNameForVersionedEnvName(envLang, envName, projectKey, bundleId);
        }
        return JupyterCodeEnvUtils.getDisplayNameForEnvName(envLang, envName);
    }

    private static String getDisplayNameChunk(String envName) {
        return StringUtils.isBlank((String)envName) ? "builtin env" : "env " + envName;
    }

    private static String getDisplayNameChunk(String envName, String projectKey, String bundleId) {
        return "version " + projectKey + "." + bundleId + " of " + JupyterCodeEnvUtils.getDisplayNameChunk(envName);
    }

    private static String getDisplayNameChunk(CodeEnvModel.EnvLang envLang) {
        switch (envLang) {
            case R: {
                return "R ";
            }
            case PYTHON: {
                return "Python ";
            }
        }
        throw new Error("unreachable");
    }

    private static String getDisplayNameChunk(CodeEnvModel.EnvLang envLang, boolean databricks, String containerConf) {
        return JupyterCodeEnvUtils.getDisplayNameChunk(envLang) + (databricks ? "on Databricks " : "") + (String)(StringUtils.isNotBlank((String)containerConf) ? "in " + containerConf + " " : "");
    }

    private static String getDisplayNameForEnvName(CodeEnvModel.EnvLang envLang, String envName) {
        return JupyterCodeEnvUtils.getDisplayNameChunk(envLang, false, null) + "(" + JupyterCodeEnvUtils.getDisplayNameChunk(envName) + ")";
    }

    private static String getDisplayNameForVersionedEnvName(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId) {
        return JupyterCodeEnvUtils.getDisplayNameChunk(envLang, false, null) + "(" + JupyterCodeEnvUtils.getDisplayNameChunk(envName, projectKey, bundleId) + ")";
    }

    private static String getDisplayNameForContainerizedEnvName(CodeEnvModel.EnvLang envLang, String envName, String containerConf) {
        return JupyterCodeEnvUtils.getDisplayNameChunk(envLang, false, containerConf) + "(" + JupyterCodeEnvUtils.getDisplayNameChunk(envName) + ")";
    }

    private static String getDisplayNameForContainerizedVersionedEnvName(CodeEnvModel.EnvLang envLang, String envName, String projectKey, String bundleId, String containerConf) {
        return JupyterCodeEnvUtils.getDisplayNameChunk(envLang, false, containerConf) + "(" + JupyterCodeEnvUtils.getDisplayNameChunk(envName, projectKey, bundleId) + ")";
    }

    public static class NotebookCodeEnvInfo {
        public String kernelName;
        public String kernelDisplayName;
        public CodeEnvModel.EnvLang envLang;
        public String envName;
        public String projectKey;
        public String bundleId;
        public String containerConf;
    }
}

