/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.manual;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.manual.ManualCodeStudioTemplateParams;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplatesService;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ManualCodeStudioMeta
implements CodeStudioMeta {
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.manual");

    @Override
    public String getType() {
        return "manual";
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    @Override
    public CodeStudioTemplate.CodeStudioTemplateType getTemplateType() {
        CodeStudioTemplate.CodeStudioTemplateType ret = new CodeStudioTemplate.CodeStudioTemplateType();
        ret.type = this.getType();
        ret.label = "Manual";
        ret.description = "User-specified container image and exposition settings";
        return ret;
    }

    @Override
    public CodeStudioObject.CodeStudioObjectType getCodeStudioType(CodeStudioTemplate template) {
        CodeStudioObject.CodeStudioObjectType ret = new CodeStudioObject.CodeStudioObjectType();
        ret.type = this.getType();
        ret.templateId = template.id;
        ret.label = template.getLabel();
        ret.shortDesc = template.shortDesc;
        ret.icon = template.icon;
        return ret;
    }

    @Override
    public Class<? extends CodeStudioTemplateParams> templateParamsClass() {
        return ManualCodeStudioTemplateParams.class;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioTemplate template) {
        return Lists.newArrayList();
    }

    @Override
    public CodeStudioMeta.CreationSpec getCreationSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.CreationEnv creationEnv) throws Exception {
        return new CodeStudioMeta.CreationSpec();
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec getBuildSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.ImageBuildEnv buildEnv) throws IOException, DKUSecurityException {
        ManualCodeStudioTemplateParams params = template.getParamsAs(ManualCodeStudioTemplateParams.class);
        CodeStudioMeta.ImageBuildSpec ret = new CodeStudioMeta.ImageBuildSpec();
        ret.dockerfile = params.dockerfile;
        VariablesContext vc = CodeStudioTemplatesService.getTemplateVariablesContext(template.id);
        for (SimpleKeyValue copy : params.resources) {
            String fromPath = vc.expand(copy.key);
            File from = new File(fromPath);
            String toPath = copy.value;
            File to = new File(buildEnv.buildDir, toPath);
            if (!from.exists()) {
                throw new FileNotFoundException("Copy source " + fromPath + " doesn't exist");
            }
            if (!from.canRead()) {
                throw new FileNotFoundException("Can't read source " + fromPath);
            }
            if (toPath.endsWith("/")) {
                to = new File(to, from.getName());
            }
            logger.info((Object)("Copying " + from.getAbsolutePath() + " to " + to.getAbsolutePath()));
            if (from.isDirectory()) {
                DKUFileUtils.copyDirectory((File)from, (File)to);
            } else {
                FileUtils.copyFile((File)from, (File)to);
            }
            if (to.setExecutable(from.canExecute())) continue;
            logger.warn((Object)("Cannot set execute permission on" + to.getName()));
        }
        return ret;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec getLaunchSpec(AuthCtx authCtx, CodeStudioTemplate template, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        ManualCodeStudioTemplateParams params = template.getParamsAs(ManualCodeStudioTemplateParams.class);
        CodeStudioMeta.CodeStudioLaunchSpec ret = new CodeStudioMeta.CodeStudioLaunchSpec();
        if (StringUtils.isNotBlank((String)params.entrypoint)) {
            ret.entrypoints.add(params.entrypoint);
        }
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getContext(launchEnv.projectKey);
        vc.add("executionId", launchEnv.executionId);
        vc.add("apiTicket", launchEnv.apiTicket);
        vc.add("apiTicketBase64", Base64.encodeBase64String((byte[])launchEnv.apiTicket.getBytes(StandardCharsets.UTF_8)));
        Object repository = StringUtils.defaultIfBlank((String)launchEnv.containerConfig.repositoryURL, (String)"");
        if (StringUtils.isNotBlank((String)repository) && !((String)repository).endsWith("/")) {
            repository = (String)repository + "/";
        }
        vc.add("imageTag", (String)repository + launchEnv.templateImage);
        vc.add("imagePullSecretName", StringUtils.defaultIfBlank((String)launchEnv.containerConfig.imagePullSecretName, (String)""));
        vc.add("backendHost", RemoteRunNetworkingUtils.getBackendHost());
        vc.add("backendPort", RemoteRunNetworkingUtils.getBackendRPCPort());
        vc.add("backendProtocal", RemoteRunNetworkingUtils.getBackendRPCProtocol());
        if (EncryptedRPC.enabled()) {
            vc.add("backendServerCert", EncryptedRPC.getPEMCertificateText());
        }
        vc.add("baseUrl", launchEnv.baseUrlLNT);
        vc.add("exposedPort", Integer.toString(params.exposedPort));
        vc.add("baseUrlPerPort", launchEnv.baseUrlLNTPerPort);
        vc.add("labels", KubernetesExecUtils.makeLabelsOrAnnotationsMap("labels", launchEnv.labels, ""));
        vc.add("annotations", KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", launchEnv.annotations, ""));
        vc.add("resources", KubernetesExecUtils.getResourcesLines(launchEnv.containerConfig.kubernetesResources).stream().collect(Collectors.joining("\n")));
        vc.add("volumeMounts", KubernetesExecUtils.getVolumeMountsLines(launchEnv.containerConfig).stream().collect(Collectors.joining("\n")));
        vc.add("volumes", KubernetesExecUtils.getVolumesLines(launchEnv.containerConfig).stream().collect(Collectors.joining("\n")));
        vc.add("tolerations", StringUtils.defaultIfBlank((String)launchEnv.containerConfig.tolerations, (String)""));
        vc.add("affinity", StringUtils.defaultIfBlank((String)launchEnv.containerConfig.affinity, (String)""));
        vc.add("topologySpreadConstraints", StringUtils.defaultIfBlank((String)launchEnv.containerConfig.deploymentTopologySpreadConstraints, (String)""));
        vc.add("nodeSelector", StringUtils.defaultIfBlank((String)launchEnv.containerConfig.nodeSelector, (String)""));
        ret.yaml = vc.expandAllowUnresolved(params.yaml);
        CodeStudioMeta.ExposedCodeStudioPort exposed = new CodeStudioMeta.ExposedCodeStudioPort();
        exposed.label = "main";
        exposed.proxyPrefixHeaderName = params.proxyPrefixHeaderName;
        exposed.port = params.exposedPort;
        exposed.proxiedUrlSuffix = params.proxiedUrlSuffix;
        ret.exposedPorts.add(exposed);
        ret.readinessProbeUrl = params.readinessProbeUrl;
        ret.readinessProbeHeaders = params.readinessProbeHeaders;
        ret.k8sHeadObjectName = vc.expandAllowUnresolved(StringUtils.defaultIfEmpty((String)params.headObjectName, (String)""));
        ret.selector = params.selector.stream().map(arg_0 -> ((VariablesContext)vc).expandAllowUnresolved(arg_0)).collect(Collectors.toList());
        ret.syncedZones = Lists.newArrayList(params.syncedZones);
        ret.excludedFromSync = params.excludedFromSync;
        ret.fileAdjustmentScript = params.fileAdjustmentScript;
        return ret;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportTemplate(AuthCtx authCtx, CodeStudioTemplate template) throws Exception {
        CodeStudioMeta.TemplateExportSpec exportSpec = new CodeStudioMeta.TemplateExportSpec();
        ManualCodeStudioTemplateParams params = template.getParamsAs(ManualCodeStudioTemplateParams.class);
        for (SimpleKeyValue resource : params.resources) {
            CodeStudioMeta.TemplateExportResource exportResource = new CodeStudioMeta.TemplateExportResource();
            exportResource.localPath = resource.key;
            exportSpec.resourcesMap.put(resource.key, exportResource);
        }
        return exportSpec;
    }

    @Override
    public CodeStudioTemplate importTemplate(AuthCtx authCtx, CodeStudioTemplate srcTemplate, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) throws Exception {
        CodeStudioTemplate template = (CodeStudioTemplate)JSON.deepCopy((Object)srcTemplate);
        ManualCodeStudioTemplateParams params = template.getParamsAs(ManualCodeStudioTemplateParams.class);
        for (SimpleKeyValue resource : params.resources) {
            CodeStudioMeta.TemplateExportResource exportResource = exportSpec.resourcesMap.get(resource.key);
            if (exportResource == null) {
                throw new IllegalArgumentException("Resource missing from export " + resource.key);
            }
            resource.key = exportResource.localPath;
        }
        return template;
    }
}

