/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.runtime;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.object.CodeStudioObject;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.UserDataService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class CodeStudioSyncZones {
    public static final String CODE_FILES_REGEXP = ".*\\.(py|r|sql|scala|shell|hive|impala|pig)";
    public static final String NOTEBOOKS_REGEXP = "\\./[^/]*\\.ipynb";
    private static Map<String, SyncZone> syncZoneLookup = Maps.newHashMap();
    public static final SyncZone CODE_STUDIO_VERSIONED = new CodeStudioVersionedZone();
    public static final SyncZone CODE_STUDIO_RESOURCES = new CodeStudioResourcesZone();
    public static final SyncZone USER_VERSIONED = new UserVersionedZone();
    public static final SyncZone USER_RESOURCES = new UserResourcesZone();
    public static final SyncZone PROJECTLIB_VERSIONED = new ProjectLibVersionedZone();
    public static final SyncZone PROJECTLIB_RESOURCES = new ProjectLibResourcesZone();
    public static final SyncZone RECIPES = new RecipesZone();
    public static final SyncZone NOTEBOOKS = new NotebooksZone();

    public static SyncZone lookup(String name) {
        if (syncZoneLookup.containsKey(name)) {
            return syncZoneLookup.get(name);
        }
        throw new IllegalArgumentException("Unknown zone type " + name);
    }

    public static List<SyncZone> all() {
        return Lists.newArrayList((Object[])new SyncZone[]{CODE_STUDIO_VERSIONED, CODE_STUDIO_RESOURCES, PROJECTLIB_VERSIONED, PROJECTLIB_RESOURCES, RECIPES, NOTEBOOKS, USER_VERSIONED, USER_RESOURCES});
    }

    public static abstract class SyncZone {
        private final String name;
        private final String dottedName;
        private final String underscoredName;
        private final String dashedName;
        private final boolean versioned;
        private final boolean global;
        private final boolean acceptNewFiles;

        private SyncZone(boolean versioned, boolean global, boolean acceptNewFiles, String ... chunks) {
            this.versioned = versioned;
            this.global = global;
            this.acceptNewFiles = acceptNewFiles;
            this.name = String.join((CharSequence)"", Lists.newArrayList((Object[])chunks));
            syncZoneLookup.put(this.name, this);
            this.dottedName = Lists.newArrayList((Object[])chunks).stream().map(String::toLowerCase).collect(Collectors.joining("."));
            syncZoneLookup.put(this.dottedName, this);
            this.underscoredName = Lists.newArrayList((Object[])chunks).stream().map(String::toLowerCase).collect(Collectors.joining("_"));
            syncZoneLookup.put(this.underscoredName, this);
            this.dashedName = Lists.newArrayList((Object[])chunks).stream().map(String::toLowerCase).collect(Collectors.joining("-"));
            syncZoneLookup.put(this.dashedName, this);
            String camelCased = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.underscoredName);
            syncZoneLookup.put(camelCased, this);
        }

        public String codeStudioName() {
            return this.name;
        }

        public boolean isVersioned() {
            return this.versioned;
        }

        public boolean isGlobal() {
            return this.global;
        }

        public boolean areNewFilesAccepted() {
            return this.acceptNewFiles;
        }

        public abstract RelFile rootRelFile(AuthCtx var1, CodeStudioObject var2) throws DKUSecurityException;

        public abstract File rootFile(AuthCtx var1, CodeStudioObject var2) throws DKUSecurityException;

        public abstract TaggableObjectsService.TaggableObjectRef tor(AuthCtx var1, CodeStudioObject var2);

        public abstract String objectId(AuthCtx var1, CodeStudioObject var2) throws DKUSecurityException;

        public abstract RelFileFilter fileFilter();

        protected TaggableObjectsService.TaggableObjectRef getCodeStudioTor(CodeStudioObject codeStudio) {
            return codeStudio.getRef();
        }

        protected TaggableObjectsService.TaggableObjectRef getProjectTor(CodeStudioObject codeStudio) {
            return new TaggableObjectsService.TaggableObjectRef(codeStudio.projectKey, ITaggingService.TaggableType.PROJECT, null);
        }

        public void addAsVariable(VariablesContext vc, CodeStudioMeta.SyncZoneInstance synced) {
            if (StringUtils.isNotBlank((String)synced.pathInContainer)) {
                vc.add(this.dottedName + ".location", synced.pathInContainer);
            }
        }

        public List<String> addAsYamlListElement(String indent, CodeStudioMeta.SyncZoneInstance synced) {
            ArrayList lines = Lists.newArrayList();
            if (StringUtils.isNotBlank((String)synced.pathInContainer)) {
                lines.add(indent + "- name: DKU_" + this.underscoredName.toUpperCase() + "_LOCATION");
                lines.add(indent + "  value: \"" + synced.pathInContainer + "\"");
            }
            return lines;
        }

        public void addInMap(Map<String, String> map, CodeStudioMeta.SyncZoneInstance synced) {
            if (StringUtils.isNotBlank((String)synced.pathInContainer)) {
                map.put("DKU_" + this.underscoredName.toUpperCase() + "_LOCATION", synced.pathInContainer);
            }
        }

        public CodeStudioMeta.SyncZoneInstance defaultWithPrefix(String prefix) {
            return new CodeStudioMeta.SyncZoneInstance().withZone(this.underscoredName).withPathInContainer(prefix + this.dashedName);
        }

        public boolean canWebapp() {
            return true;
        }
    }

    public static class CodeStudioVersionedZone
    extends SyncZone {
        public CodeStudioVersionedZone() {
            super(true, false, true, "code_studio", "versioned");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{"projects", codeStudio.projectKey, "code_studios", codeStudio.id});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getCodeStudioTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }

    public static class CodeStudioResourcesZone
    extends SyncZone {
        public CodeStudioResourcesZone() {
            super(false, false, true, "code_studio", "resources");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{codeStudio.projectKey, codeStudio.libName});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", codeStudio.projectKey, codeStudio.libName});
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getCodeStudioTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }

    public static class UserVersionedZone
    extends SyncZone {
        public UserVersionedZone() {
            super(true, true, true, "user", "versioned");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            String login = authCtx.getAssociatedDSSUserMand();
            return UserDataService.userDataFolder(login);
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return authCtx.getAssociatedDSSUserMand();
        }
    }

    public static class UserResourcesZone
    extends SyncZone {
        public UserResourcesZone() {
            super(false, true, true, "user", "resources");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            String login = authCtx.getAssociatedDSSUserMand();
            return new RelFile(new String[]{login});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            String login = authCtx.getAssociatedDSSUserMand();
            return ApplicationConfigurator.getFile((String[])new String[]{"lib", "user-data", login});
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return authCtx.getAssociatedDSSUserMand();
        }
    }

    public static class ProjectLibVersionedZone
    extends SyncZone {
        public ProjectLibVersionedZone() {
            super(true, false, true, "project", "lib", "versioned");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{"projects", codeStudio.projectKey, "lib"});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getProjectTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }

    public static class ProjectLibResourcesZone
    extends SyncZone {
        public ProjectLibResourcesZone() {
            super(false, true, true, "project", "lib", "resources");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{codeStudio.projectKey});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects", codeStudio.projectKey});
        }

        @Override
        public RelFileFilter fileFilter() {
            return new AcceptAllFilter();
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getProjectTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }

    public static class RecipesZone
    extends SyncZone {
        public RecipesZone() {
            super(true, false, false, "recipes");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{"projects", codeStudio.projectKey, "recipes"});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return null;
        }

        @Override
        public RelFileFilter fileFilter() {
            return (fs, file) -> file.getLeafName().matches(CodeStudioSyncZones.CODE_FILES_REGEXP) && fs.isFile(file);
        }

        @Override
        public boolean canWebapp() {
            return false;
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getProjectTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }

    public static class NotebooksZone
    extends SyncZone {
        public NotebooksZone() {
            super(true, false, true, "notebooks");
        }

        @Override
        public RelFile rootRelFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return new RelFile(new String[]{"projects", codeStudio.projectKey, "ipython_notebooks"});
        }

        @Override
        public File rootFile(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return ApplicationConfigurator.getFile((String[])new String[]{"notebook_results", "jupyter", codeStudio.projectKey});
        }

        @Override
        public RelFileFilter fileFilter() {
            return (fs, file) -> file.getLeafName().matches(CodeStudioSyncZones.NOTEBOOKS_REGEXP) && fs.isFile(file);
        }

        @Override
        public boolean canWebapp() {
            return false;
        }

        @Override
        public TaggableObjectsService.TaggableObjectRef tor(AuthCtx authCtx, CodeStudioObject codeStudio) {
            return this.getProjectTor(codeStudio);
        }

        @Override
        public String objectId(AuthCtx authCtx, CodeStudioObject codeStudio) throws DKUSecurityException {
            return null;
        }
    }
}

