/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.containers.exec.BaseImagesPusher;
import com.dataiku.dip.containers.exec.ContainerExecCodes;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class BaseImageBuilder {
    private final ContainerExecUtils.BaseImageType imageType;
    private final BaseImageBuildOptions buildOptions;
    private final DKUtils.SmartLogTailBuilder logTailBuilder;
    private final boolean pushAfterBuild;
    private final boolean warningOnly;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.base.image.builder");

    public BaseImageBuilder(ContainerExecUtils.BaseImageType imageType, BaseImageBuildOptions buildOptions, DKUtils.SmartLogTailBuilder logTailBuilder, boolean pushAfterBuild, boolean warningOnly) {
        this.imageType = imageType;
        this.buildOptions = buildOptions == null ? new BaseImageBuildOptions() : buildOptions;
        this.logTailBuilder = logTailBuilder == null ? new DKUtils.SmartLogTailBuilder() : logTailBuilder;
        this.pushAfterBuild = pushAfterBuild;
        this.warningOnly = warningOnly;
    }

    public BaseImageBuilder(ContainerExecUtils.BaseImageType imageType, BaseImageBuildOptions buildOptions, boolean pushAfterBuild, boolean warningOnly) {
        this(imageType, buildOptions, new DKUtils.SmartLogTailBuilder(), pushAfterBuild, warningOnly);
    }

    public BaseImageBuilder(ContainerExecUtils.BaseImageType imageType, BaseImageBuildOptions buildOptions, boolean pushAfterBuild) {
        this(imageType, buildOptions, new DKUtils.SmartLogTailBuilder(), pushAfterBuild, false);
    }

    private List<String> getCmd() {
        ArrayList<String> cmd = new ArrayList<String>();
        String dkuPythonBin = System.getenv("DKUPYTHONBIN");
        assert (StringUtils.isNotBlank((String)dkuPythonBin));
        cmd.add(dkuPythonBin);
        cmd.add(ApplicationConfigurator.getInstallFile((String[])new String[]{"resources", "container-exec", "build-images.py"}).getAbsolutePath());
        cmd.add("--type");
        switch (this.imageType) {
            case EXEC: {
                cmd.add("container-exec");
                this.addUserCodeFlags(cmd);
                break;
            }
            case CDE: {
                cmd.add("cde");
                cmd.add("--without-r");
                break;
            }
            case CDE_PLUGINS: {
                cmd.add("cde-plugins");
                break;
            }
            case SPARK: {
                cmd.add("spark");
                this.addUserCodeFlags(cmd);
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type can't be rebuilt: " + String.valueOf((Object)this.imageType));
            }
        }
        this.addCommonFlags(cmd);
        cmd.addAll(this.buildOptions.extraOptions);
        return cmd;
    }

    private Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        if (StringUtils.isNotBlank((String)System.getenv("DSS_DEV"))) {
            env.put("DEV_MODE", "1");
        }
        return env;
    }

    public int build(InfoMessage.InfoMessages messages) throws IOException, InterruptedException {
        List<String> cmd = this.getCmd();
        Map<String, String> env = this.getEnv();
        return this.build(cmd, env, messages);
    }

    private int build(List<String> cmd, Map<String, String> env, InfoMessage.InfoMessages messages) throws IOException, InterruptedException {
        logger.info((Object)("Building image with type " + String.valueOf((Object)this.imageType)));
        PluginCodeEnvErrorSniffer sniffer = new PluginCodeEnvErrorSniffer();
        DKUtils.ExecBuilder execBuilder = new DKUtils.ExecBuilder().withArgs(cmd).withEnv(env).withCwd(ApplicationConfigurator.getBaseFolderF()).withOutputConsumer((DKUtils.ExecSubscription)sniffer).withErrorConsumer((DKUtils.ExecSubscription)sniffer).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(Level.INFO)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.logTailBuilder)).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.logTailBuilder));
        final DKUtils.ExecKiller killer = execBuilder.makeNiceThenEvilKiller();
        try (FutureAborter.AutoCloseableAbortHook abort = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                killer.kill();
            }
        });){
            int rv = execBuilder.exec();
            if (rv != 0) {
                Object err = "Build failed, docker returned %s.";
                if (StringUtils.isNotBlank((String)sniffer.pluginCodeEnvName) && this.imageType == ContainerExecUtils.BaseImageType.CDE_PLUGINS) {
                    err = (String)err + " Code-env %s failed to be rebuilt";
                    if (this.warningOnly) {
                        messages.withWarningV((InfoMessage.MessageCode)ContainerExecCodes.ERR_DOCKER_FAILED, (String)err, new Object[]{rv, sniffer.pluginCodeEnvName});
                    } else {
                        messages.withErrorV((InfoMessage.MessageCode)ContainerExecCodes.ERR_DOCKER_FAILED, (String)err, new Object[]{rv, sniffer.pluginCodeEnvName});
                    }
                } else if (this.warningOnly) {
                    messages.withWarningV((InfoMessage.MessageCode)ContainerExecCodes.ERR_DOCKER_FAILED, (String)err, new Object[]{rv});
                } else {
                    messages.withErrorV((InfoMessage.MessageCode)ContainerExecCodes.ERR_DOCKER_FAILED, (String)err, new Object[]{rv});
                }
                int n = rv;
                return n;
            }
            messages.withSuccessV((InfoMessage.MessageCode)ContainerExecCodes.INFO_CONTAINER_BUILD_OK, "Successfully built %s image", new Object[]{this.imageType});
            if (this.pushAfterBuild) {
                this.push(messages);
            }
            int n = rv;
            return n;
        }
    }

    private void push(InfoMessage.InfoMessages messages) throws IOException {
        BaseImagesPusher pusher = new BaseImagesPusher();
        BaseImagesPusher.ImagePushResult result = pusher.tagAndPushForImageType(this.logTailBuilder, this.imageType);
        for (InfoMessage message : result.messages.messages) {
            messages.addMessage(message);
        }
    }

    public SimpleFutureThread<InfoMessage.InfoMessages> getBuildFuture(AuthCtx owner) {
        final List<String> cmd = this.getCmd();
        final Map<String, String> env = this.getEnv();
        return new SimpleFutureThread<InfoMessage.InfoMessages>(owner){

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
                BaseImageBuilder.this.build(cmd, env, ret);
                return ret;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"build_base_image", (String)("Build base image for " + String.valueOf((Object)BaseImageBuilder.this.imageType)));
            }

            public SmartLogTail getLog() {
                return BaseImageBuilder.this.logTailBuilder.get();
            }
        };
    }

    private void addUserCodeFlags(List<String> cmd) {
        if (this.buildOptions.R) {
            cmd.add("--with-r");
        } else {
            cmd.add("--without-r");
        }
        if (StringUtils.isNotBlank((String)this.buildOptions.cudaVersion)) {
            cmd.add("--with-cuda");
            cmd.add("--cuda-version");
            cmd.add(this.buildOptions.cudaVersion);
        }
    }

    private void addCommonFlags(List<String> cmd) {
        if (StringUtils.isNotBlank((String)this.buildOptions.distrib)) {
            cmd.add("--distrib");
            cmd.add(this.buildOptions.distrib);
        }
        cmd.addAll(this.addBuildOption(this.buildOptions.py36, "py36"));
        cmd.add(this.addBuildOption(this.buildOptions.py37, "py37"));
        cmd.add(this.addBuildOption(this.buildOptions.py38, "py38"));
        cmd.add(this.addBuildOption(this.buildOptions.py39, "py39"));
        cmd.add(this.addBuildOption(this.buildOptions.py310, "py310"));
        cmd.add(this.addBuildOption(this.buildOptions.py311, "py311"));
        cmd.add(this.addBuildOption(this.buildOptions.py312, "py312"));
        cmd.add(this.addBuildOption(this.buildOptions.py313, "py313"));
        if (StringUtils.isNotBlank((String)this.buildOptions.cudaVersion) && this.buildOptions.withoutXGBoostGpuSupport) {
            cmd.add("--without-xgboost-gpu-support");
        }
    }

    private String addBuildOption(boolean addToImage, String what) {
        if (addToImage) {
            return "--with-" + what;
        }
        return "--without-" + what;
    }

    private List<String> addBuildOption(BaseImageBuildOptions.BuildOptionStatus option, String what) {
        if (option == BaseImageBuildOptions.BuildOptionStatus.INSTALL) {
            return List.of("--with-" + what);
        }
        if (option == BaseImageBuildOptions.BuildOptionStatus.SKIP) {
            return List.of("--without-" + what);
        }
        return Collections.emptyList();
    }

    public static class BaseImageBuildOptions {
        public boolean R = true;
        public BuildOptionStatus py36 = BuildOptionStatus.DEFAULT;
        public boolean py37 = false;
        public boolean py38 = false;
        public boolean py39 = true;
        public boolean py310 = false;
        public boolean py311 = false;
        public boolean py312 = false;
        public boolean py313 = false;
        public boolean withoutXGBoostGpuSupport = false;
        public String distrib;
        public String cudaVersion;
        public final String[] AVAILABLE_DISTRIBUTIONS = new String[]{"almalinux8", "almalinux9"};
        public final String[] AVAILABLE_CUDA_VERSIONS = new String[]{"9.0", "10.0", "10.1", "10.2", "11.0", "11.2", "11.8"};
        public List<String> extraOptions = new ArrayList<String>();

        public BaseImageBuildOptions() {
        }

        public BaseImageBuildOptions(ContainerExecUtils.BaseImageType imageType) {
            if (imageType == ContainerExecUtils.BaseImageType.CDE) {
                this.R = false;
            }
        }

        public static enum BuildOptionStatus {
            DEFAULT,
            INSTALL,
            SKIP;

        }
    }

    private static class PluginCodeEnvErrorSniffer
    extends DKUtils.TagSniffingLineSubscription {
        public String pluginCodeEnvName;

        public PluginCodeEnvErrorSniffer() {
            super(Pattern.compile(".*Failed to rebuild code-env(.*)"));
        }

        protected void handleTag(String line, Matcher matcher) {
            super.handleTag(line, matcher);
            if (this.hasFoundTag()) {
                this.pluginCodeEnvName = matcher.group(1).trim();
            }
        }
    }
}

