/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.impl.FilesBasedModelEvaluationStoresDAO;
import com.dataiku.dip.dao.impl.FilesBasedSavedModelsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetHandler;
import com.dataiku.dip.datasets.jobsdb.JobsdbDatasetParams;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.llm.retrieval.FilesBasedRetrievableKnowledgeDAO;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.FilesBasedManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.savedmodels.SavedModelsAgentsBaseService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FlowGraph {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected SavedModelsDAO savedModelsDAO;
    @Autowired
    protected ManagedFolderDAO managedFolderDAO;
    @Autowired
    protected RecipesDAO recipesDAO;
    @Autowired
    protected SavedModelsDAO smDAO;
    @Autowired
    protected ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    protected ManagedFolderDAO odbDAO;
    @Autowired
    protected StreamingEndpointsDAO seDAO;
    @Autowired
    protected RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected LabelingTasksDAO labelingTaskDAO;
    @Autowired
    private SavedModelsAgentsBaseService smAgentsBaseService;
    protected boolean unsafe;
    public List<FlowRecipe> recipes = Lists.newArrayList();
    public List<FlowImplicitRecipe> implicitRecipes = Lists.newArrayList();
    public List<FlowLabelingTask> labelingTasks = Lists.newArrayList();
    private Map<String, FlowComputable> computables = new HashMap<String, FlowComputable>();
    private Map<String, FlowRunnable> runnables = new HashMap<String, FlowRunnable>();
    public Map<String, FlowDataset> datasets = Maps.newHashMap();
    public Map<String, FlowManagedFolder> folders = Maps.newHashMap();
    public Map<String, FlowRetrievableKnowledge> retrievableKnowledges = Maps.newHashMap();
    public Map<String, FlowSavedModel> models = Maps.newHashMap();
    public Map<String, FlowModelEvaluationStore> evaluationStores = Maps.newHashMap();
    public Map<String, FlowStreamingEndpoint> streamingEndpoints = Maps.newHashMap();
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipes");

    public FlowGraph() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void buildGlobal() throws IOException {
        logger.debug((Object)"Building global graph");
        this.buildGlobal_();
    }

    public void buildGlobalUnsafe() throws IOException {
        this.unsafe = true;
        logger.debug((Object)"Building global graph (unsafe)");
        this.buildGlobal_();
    }

    private void buildGlobal_() throws IOException {
        long before = System.currentTimeMillis();
        File projectsDir = ApplicationConfigurator.getFile((String[])new String[]{"config", "projects"});
        if (!projectsDir.isDirectory()) {
            return;
        }
        for (File f : projectsDir.listFiles()) {
            if (!f.isDirectory() || !new File(f, "params.json").isFile()) continue;
            String projectKey = f.getName();
            List srl = null;
            srl = this.unsafe ? this.recipesDAO.listUnsafe(projectKey) : this.recipesDAO.list(projectKey);
            for (SerializedRecipe sr : srl) {
                try {
                    if (sr.overrideTable != null) {
                        sr = sr.overrideTable.overrideObject(this.variablesService.getContext(projectKey), sr, SerializedRecipe.class);
                    }
                    this.addRecipe(sr);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to add recipe " + sr.name + " to graph: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            List sdl = null;
            sdl = this.unsafe ? this.datasetsDAO.listUnsafe(projectKey) : this.datasetsDAO.list(projectKey);
            for (SerializedDataset sd : sdl) {
                try {
                    if (sd.overrideTable != null) {
                        sd = sd.overrideTable.overrideObject(this.variablesService.getContext(projectKey), sd, SerializedDataset.class);
                    }
                    this.addImplicitRecipe(sd);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to add implicit recipe " + sd.name + " to graph: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
            }
            this.addLabelingTasks(projectKey);
            for (SavedModel sm : this.smDAO.listUnsafe(projectKey)) {
                try {
                    this.addSavedModelImplicitRecipes(sm);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to manage agent dependencies " + sm.id), (Throwable)e);
                }
            }
        }
        logger.debug((Object)("Done getting global graph t=" + (System.currentTimeMillis() - before) + "ms"));
    }

    public void buildForProject(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.buildForProject_(projectKey, includeOrphans, drawZones);
    }

    public void buildForProjectUnsafe(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        this.unsafe = true;
        this.buildForProject_(projectKey, includeOrphans, drawZones);
    }

    private void buildForProject_(String projectKey, boolean includeOrphans, boolean drawZones) throws IOException {
        List srl = null;
        srl = this.unsafe ? this.recipesDAO.listUnsafe(projectKey) : this.recipesDAO.list(projectKey);
        for (SerializedRecipe sr : srl) {
            if (sr.overrideTable != null) {
                sr = sr.overrideTable.overrideObject(this.variablesService.getContext(projectKey), sr, SerializedRecipe.class);
            }
            try {
                this.addRecipe(sr);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to read recipe " + sr.name), (Throwable)exception);
            }
        }
        for (SerializedDataset sd : this.datasetsDAO.listUnsafe(projectKey)) {
            try {
                if (includeOrphans) {
                    this.addComputable(sd.projectKey, sd.name, ITaggingService.TaggableType.DATASET);
                }
                this.addImplicitRecipe(sd);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to read dataset " + sd.name), (Throwable)exception);
            }
        }
        this.addLabelingTasks(projectKey);
        if (includeOrphans) {
            for (SavedModel sm : this.smDAO.listUnsafe(projectKey)) {
                this.addComputable(projectKey, sm.id, ITaggingService.TaggableType.SAVED_MODEL);
            }
            for (ModelEvaluationStore mes : this.modelEvaluationStoresDAO.listUnsafe(projectKey)) {
                this.addComputable(projectKey, mes.id, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
            }
            for (RetrievableKnowledge rk : this.retrievableKnowledgeDAO.listUnsafe(projectKey)) {
                this.addComputable(projectKey, rk.id, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);
            }
            for (ManagedFolder mf : this.odbDAO.listUnsafe(projectKey)) {
                this.addComputable(projectKey, mf.id, ITaggingService.TaggableType.MANAGED_FOLDER);
            }
            for (Iterator<? extends DatasetLocUtils.DatasetLoc> se : this.seDAO.listUnsafe(projectKey)) {
                this.addComputable(projectKey, ((StreamingEndpoint)((Object)se)).id, ITaggingService.TaggableType.STREAMING_ENDPOINT);
            }
            ProjectsService projectsService = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
            for (AnyLoc anyLoc : projectsService.getExposedSavedModels(projectKey)) {
                SavedModel sm = (SavedModel)this.smDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
                if (sm == null) continue;
                this.addComputable(sm.projectKey, sm.id, ITaggingService.TaggableType.SAVED_MODEL);
            }
            for (AnyLoc anyLoc : projectsService.getExposedModelEvaluationStores(projectKey)) {
                ModelEvaluationStore mes = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
                if (mes == null) continue;
                this.addComputable(mes.projectKey, mes.id, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
            }
            for (AnyLoc anyLoc : projectsService.getExposedRetrievableKnowledges(projectKey)) {
                RetrievableKnowledge rk = (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
                if (rk == null) continue;
                this.addComputable(rk.projectKey, rk.id, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);
            }
            for (AnyLoc anyLoc : projectsService.getExposedManagedFolders(projectKey)) {
                ManagedFolder odb = (ManagedFolder)this.odbDAO.getOrNullUnsafe(anyLoc.getProjectKey(), anyLoc.getId());
                if (odb == null) continue;
                this.addComputable(odb.projectKey, odb.id, ITaggingService.TaggableType.MANAGED_FOLDER);
            }
            for (DatasetLocUtils.DatasetLoc datasetLoc : projectsService.getExposedDatasets(projectKey)) {
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(datasetLoc);
                if (sd == null) continue;
                this.addComputable(sd.projectKey, sd.name, ITaggingService.TaggableType.DATASET);
            }
        }
        for (SavedModel sm : this.smDAO.listUnsafe(projectKey)) {
            try {
                this.addSavedModelImplicitRecipes(sm);
            }
            catch (Exception exception) {
                logger.error((Object)("Failed to manage agent dependencies " + sm.id), (Throwable)exception);
            }
        }
    }

    private void addLabelingTasks(String projectKey) throws IOException {
        List allLabelingTasks = this.unsafe ? this.labelingTaskDAO.listUnsafe(projectKey) : this.labelingTaskDAO.list(projectKey);
        for (LabelingTask labelingTask : allLabelingTasks) {
            try {
                this.addLabelingTask(labelingTask);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to add labeling task " + labelingTask.id), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addLabelingTask(LabelingTask labelingTask) throws IOException {
        ErrorContext.push((String)("read of labelingTask " + labelingTask.id));
        Preconditions.checkNotNull((Object)labelingTask.id);
        Preconditions.checkNotNull((Object)labelingTask.projectKey);
        try {
            FlowLabelingTask flowLabelingTask = new FlowLabelingTask(labelingTask);
            flowLabelingTask.clearPredecessors();
            for (Map.Entry<String, LabelingTask.InputRole> entry : labelingTask.inputs.entrySet()) {
                for (LabelingTask.LabelingTaskInput sinput : entry.getValue().items) {
                    flowLabelingTask.addPredecessor(this.addComputable(labelingTask.projectKey, sinput.ref), entry.getKey());
                }
            }
            flowLabelingTask.clearSuccessors();
            for (Map.Entry<String, Object> entry : labelingTask.outputs.entrySet()) {
                for (LabelingTask.LabelingTaskOutput soutput : ((LabelingTask.OutputRole)entry.getValue()).items) {
                    flowLabelingTask.addSuccessor(this.addComputable(labelingTask.projectKey, soutput.ref), entry.getKey());
                }
            }
            for (GraphNode graphNode : flowLabelingTask.getPredecessors()) {
                graphNode.addSuccessor(flowLabelingTask, null);
            }
            for (GraphNode graphNode : flowLabelingTask.getSuccessors()) {
                graphNode.addPredecessor(flowLabelingTask, null);
            }
            this.labelingTasks.add(flowLabelingTask);
            this.runnables.put(flowLabelingTask.getFullId(), flowLabelingTask);
        }
        finally {
            ErrorContext.pop();
        }
    }

    public FlowRecipe buildSingleRecipe(SerializedRecipe sr) throws IOException {
        return this.addRecipe(sr);
    }

    public List<FlowComputable> listSourceComputables() {
        ArrayList<FlowComputable> ret = new ArrayList<FlowComputable>();
        for (FlowComputable fc : this.listComputables()) {
            if (!FlowGraph.isSource(fc)) continue;
            ret.add(fc);
        }
        return ret;
    }

    public List<FlowRecipe> listSourceRecipes() {
        ArrayList<FlowRecipe> ret = new ArrayList<FlowRecipe>();
        for (FlowRecipe fc : this.recipes) {
            if (!FlowGraph.isSource(fc)) continue;
            ret.add(fc);
        }
        return ret;
    }

    private List<GraphNode> getSourceNodes() {
        return this.getNodesMap().values().stream().filter(FlowGraph::isSource).collect(Collectors.toList());
    }

    public List<GraphNode> getNodesInTraversalOrder(TraversalOrderAlgorithm algorithm) {
        logger.info((Object)"-------------- getNodesInTraversalOrder");
        LinkedHashMap set = new LinkedHashMap();
        Function<GraphNode, String> keyForNode = node -> node.getClass().getName() + "___" + node.getFullId();
        Function<GraphNode, Void> addToSet = node -> {
            String key = (String)keyForNode.apply((GraphNode)node);
            set.put(key, node);
            return null;
        };
        Predicate<GraphNode> inSet = node -> {
            logger.trace((Object)("Check if in set: " + node.getFullId() + " set has " + set.size() + " " + String.valueOf(node.getClass())));
            String key = (String)keyForNode.apply((GraphNode)node);
            boolean ret = set.containsKey(key);
            logger.trace((Object)(" --> " + ret));
            return ret;
        };
        RecursableFunction traversalPredecessorsFirst = new RecursableFunction();
        traversalPredecessorsFirst.func = (currentlyVisitingStack, node) -> {
            logger.trace((Object)("addFrom " + node.getFullId()));
            for (GraphNode graphNode : node.getPredecessors()) {
                logger.trace((Object)("recurse on pred: " + graphNode.getFullId()));
                if (inSet.test(graphNode) || currentlyVisitingStack.contains(graphNode.getFullId())) continue;
                currentlyVisitingStack.add(graphNode.getFullId());
                ((BiFunction)traversalPredecessorsFirst.func).apply(currentlyVisitingStack, graphNode);
                currentlyVisitingStack.remove(graphNode.getFullId());
            }
            logger.trace((Object)("add myself " + node.getFullId()));
            if (!inSet.test((GraphNode)node)) {
                addToSet.apply((GraphNode)node);
            }
            for (GraphNode graphNode : node.getSuccessors()) {
                logger.trace((Object)("recurse on succ: " + graphNode.getFullId()));
                if (inSet.test(graphNode) || currentlyVisitingStack.contains(graphNode.getFullId())) continue;
                currentlyVisitingStack.add(graphNode.getFullId());
                ((BiFunction)traversalPredecessorsFirst.func).apply(currentlyVisitingStack, graphNode);
                currentlyVisitingStack.remove(graphNode.getFullId());
            }
            return null;
        };
        RecursableFunction traversalForwardOnly = new RecursableFunction();
        traversalForwardOnly.func = (currentlyVisitingStack, node) -> {
            logger.trace((Object)("add myself " + node.getFullId()));
            if (!inSet.test((GraphNode)node)) {
                addToSet.apply((GraphNode)node);
            }
            for (GraphNode graphNode : node.getSuccessors()) {
                logger.trace((Object)("recurse on succ: " + graphNode.getFullId()));
                if (inSet.test(graphNode) || currentlyVisitingStack.contains(graphNode.getFullId())) continue;
                currentlyVisitingStack.add(graphNode.getFullId());
                ((BiFunction)traversalForwardOnly.func).apply(currentlyVisitingStack, graphNode);
                currentlyVisitingStack.remove(graphNode.getFullId());
            }
            return null;
        };
        List<GraphNode> sourceNodes = this.getSourceNodes();
        for (GraphNode source : sourceNodes) {
            addToSet.apply(source);
        }
        for (GraphNode source : sourceNodes) {
            HashSet currentlyVisitingStack2 = new HashSet();
            switch (algorithm) {
                case EXHAUSTIVE: {
                    ((BiFunction)traversalPredecessorsFirst.func).apply(currentlyVisitingStack2, source);
                    break;
                }
                case FORWARD_ONLY: {
                    ((BiFunction)traversalForwardOnly.func).apply(currentlyVisitingStack2, source);
                }
            }
            assert (currentlyVisitingStack2.isEmpty());
        }
        logger.info((Object)("Nodes in traversal order: " + set.values().stream().map(GraphNode::getFullId).collect(Collectors.joining(","))));
        return Lists.newArrayList(set.values());
    }

    public List<FlowComputable> listComputables() {
        return Lists.newArrayList(this.computables.values());
    }

    public List<FlowRunnable> listRunnables() {
        return Lists.newArrayList(this.runnables.values());
    }

    public List<FlowRecipe> listRecipes() {
        return Lists.newArrayList(this.recipes);
    }

    public List<FlowLabelingTask> listLabelingTaks() {
        return Lists.newArrayList(this.labelingTasks);
    }

    protected FlowComputable addComputable(String recipeProjectKey, @Nonnull String smartName) throws IOException {
        return this.addComputable(recipeProjectKey, smartName, null);
    }

    protected FlowComputable getAlreadyAddedComputable(String recipeProjectKey, @Nonnull String smartName) {
        AnyLoc loc = AnyLoc.resolveSmart(recipeProjectKey, smartName);
        return this.computables.getOrDefault(loc.getFullName(), null);
    }

    protected FlowComputable addComputable(String recipeProjectKey, @Nonnull String smartName, ITaggingService.TaggableType ofType) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)smartName), (Object)"Computable name not specified");
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(recipeProjectKey, smartName);
        if (this.computables.containsKey(loc.getFullName())) {
            return this.computables.get(loc.getFullName());
        }
        logger.trace(() -> "Adding computable " + smartName + " ofType=" + String.valueOf((Object)ofType));
        if (FilesBasedSavedModelsDAO.looksLikeASavedModelId(loc.getName()) && (ofType == null || ofType == ITaggingService.TaggableType.SAVED_MODEL)) {
            SavedModel sm = null;
            sm = this.getSavedModelOrNull(loc);
            if (sm != null) {
                FlowSavedModel fsm = new FlowSavedModel(sm);
                this.computables.put(fsm.getFullId(), fsm);
                this.models.put(fsm.getFullId(), fsm);
                return fsm;
            }
        }
        if (FilesBasedModelEvaluationStoresDAO.looksLikeAModelEvaluationStoreId(loc.getName()) && (ofType == null || ofType == ITaggingService.TaggableType.MODEL_EVALUATION_STORE)) {
            ModelEvaluationStore mes = null;
            mes = this.unsafe ? (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getName()) : (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(loc.getProjectKey(), loc.getName());
            if (mes != null) {
                FlowModelEvaluationStore fmes = new FlowModelEvaluationStore(mes);
                this.computables.put(fmes.getFullId(), fmes);
                this.evaluationStores.put(fmes.getFullId(), fmes);
                return fmes;
            }
        }
        if (FilesBasedManagedFolderDAO.looksLikeAManagedFolderId(loc.getName()) && (ofType == null || ofType == ITaggingService.TaggableType.MANAGED_FOLDER)) {
            ManagedFolder mf = null;
            mf = this.unsafe ? (ManagedFolder)this.odbDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getName()) : (ManagedFolder)this.odbDAO.getOrNull(loc.getProjectKey(), loc.getName());
            if (mf != null) {
                FlowManagedFolder fodb = new FlowManagedFolder(mf);
                this.computables.put(fodb.getFullId(), fodb);
                this.folders.put(fodb.getFullId(), fodb);
                return fodb;
            }
        }
        if (FilesBasedRetrievableKnowledgeDAO.looksLikeARetrievableKnowledgeId(loc.getName()) && (ofType == null || ofType == ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE)) {
            RetrievableKnowledge rk = null;
            rk = this.unsafe ? (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getName()) : (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(loc.getProjectKey(), loc.getName());
            if (rk != null) {
                FlowRetrievableKnowledge frk = new FlowRetrievableKnowledge(rk);
                this.computables.put(frk.getFullId(), frk);
                this.retrievableKnowledges.put(frk.getFullId(), frk);
                return frk;
            }
        }
        if (ofType == null || ofType == ITaggingService.TaggableType.STREAMING_ENDPOINT) {
            StreamingEndpoint se = null;
            se = this.unsafe ? (StreamingEndpoint)this.seDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getName()) : (StreamingEndpoint)this.seDAO.getOrNull(loc.getProjectKey(), loc.getName());
            if (se != null) {
                FlowStreamingEndpoint fse = new FlowStreamingEndpoint(se);
                this.computables.put(fse.getFullId(), fse);
                this.streamingEndpoints.put(fse.getFullId(), fse);
                return fse;
            }
        }
        this.datasetsDAO.getMandatoryUnsafe(loc);
        FlowDataset fds = new FlowDataset(loc.getFullName());
        this.computables.put(loc.getFullName(), fds);
        this.datasets.put(loc.getFullName(), fds);
        return fds;
    }

    private SerializedDataset getDatasetOrNull(AnyLoc loc) throws IOException {
        if (this.unsafe) {
            return (SerializedDataset)this.datasetsDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getId());
        }
        return (SerializedDataset)this.datasetsDAO.getOrNull(loc.getProjectKey(), loc.getId());
    }

    private SavedModel getSavedModelOrNull(AnyLoc loc) throws IOException {
        if (this.unsafe) {
            return (SavedModel)this.smDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getId());
        }
        return (SavedModel)this.smDAO.getOrNull(loc.getProjectKey(), loc.getId());
    }

    private RetrievableKnowledge getRetrievableKnowledgeOrNull(AnyLoc loc) throws IOException {
        if (this.unsafe) {
            return (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNullUnsafe(loc.getProjectKey(), loc.getId());
        }
        return (RetrievableKnowledge)this.retrievableKnowledgeDAO.getOrNull(loc.getProjectKey(), loc.getId());
    }

    protected void addImplicitRecipe(SerializedDataset sd) throws IOException {
        List<AnyLoc> dependentDatasets;
        FlowImplicitRecipe recipe;
        FlowComputable source;
        DatasetHandler.DatasetParams params;
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.forDataset(sd);
        FlowDataset fds = (FlowDataset)this.addComputable(sd.projectKey, sd.name, ITaggingService.TaggableType.DATASET);
        if (BuiltinFSDatasets.FILES_IN_FOLDER_META.getType().equals(sd.type)) {
            params = sd.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
            String targetFolderId = params.getFolderSmartId();
            try {
                FlowComputable source2 = this.addComputable(sd.projectKey, targetFolderId, ITaggingService.TaggableType.MANAGED_FOLDER);
                FlowImplicitRecipe recipe2 = new FlowImplicitRecipe(sd.type, fds, source2, "main");
                this.runnables.put(recipe2.getFullId(), recipe2);
                this.implicitRecipes.add(recipe2);
                source2.addSuccessor(recipe2, "main");
                fds.addPredecessor(recipe2, "main");
            }
            catch (Exception e) {
                logger.warn((Object)("Could not find source of dataset " + loc.getFullName()), (Throwable)e);
            }
        }
        if (JobsdbDatasetHandler.META.getType().equals(sd.type)) {
            params = sd.getParamsAs(JobsdbDatasetParams.class);
            if (((JobsdbDatasetParams)params).scope == JobsdbDatasetParams.RetrievalScope.SINGLE_OBJECT && StringUtils.isNotBlank((String)((JobsdbDatasetParams)params).smartName)) {
                try {
                    source = this.addComputable(sd.projectKey, ((JobsdbDatasetParams)params).smartName);
                    recipe = new FlowImplicitRecipe(sd.type, fds, source, "main");
                    this.runnables.put(recipe.getFullId(), recipe);
                    this.implicitRecipes.add(recipe);
                    source.addSuccessor(recipe, "main");
                    fds.addPredecessor(recipe, "main");
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not find source of dataset " + loc.getFullName()), (Throwable)e);
                }
            }
        }
        if ((dependentDatasets = DatasetInspector.getDependentDatasetsForVariablesExpansionLoop(Dataset.fromSerializedUnsafe(sd))).size() > 1) {
            throw new NotImplementedException();
        }
        if (dependentDatasets.size() == 1) {
            try {
                source = this.addComputable(sd.projectKey, dependentDatasets.get(0).getSmartName(sd.projectKey));
                recipe = new FlowImplicitRecipe(sd.type, fds, source, "main");
                recipe.roleName = "veloop";
                this.runnables.put(recipe.getFullId(), recipe);
                this.implicitRecipes.add(recipe);
                source.addSuccessor(recipe, "main");
                fds.addPredecessor(recipe, "main");
            }
            catch (Exception e) {
                logger.warn((Object)("Could not find source of dataset " + loc.getFullName()), (Throwable)e);
            }
        }
    }

    protected void addSavedModelImplicitRecipes(SavedModel sm) throws IOException {
        FlowSavedModel fsm = (FlowSavedModel)this.addComputable(sm.projectKey, sm.id, ITaggingService.TaggableType.SAVED_MODEL);
        if (sm.savedModelType != null) {
            if (sm.savedModelType.isAgent()) {
                try {
                    List<SavedModel.AgentDependency> deps = this.smAgentsBaseService.getDependencies(sm);
                    logger.info((Object)("Adding dependency for agent " + sm.id + " (" + sm.name + ") -> " + JSON.json(deps)));
                    for (SavedModel.AgentDependency dep : deps) {
                        FlowComputable source = this.getAlreadyAddedComputable(sm.projectKey, dep.ref);
                        if (source == null) {
                            RetrievableKnowledge rkDependency;
                            AnyLoc loc = AnyLoc.resolveSmart(sm.projectKey, dep.ref);
                            if (dep.type == ITaggingService.TaggableType.SAVED_MODEL) {
                                SavedModel smDependency = this.getSavedModelOrNull(loc);
                                if (smDependency != null) {
                                    source = this.addComputable(loc.getProjectKey(), loc.getSmartName(sm.projectKey));
                                }
                            } else if (dep.type == ITaggingService.TaggableType.DATASET) {
                                SerializedDataset datasetDependency = this.getDatasetOrNull(loc);
                                if (datasetDependency != null) {
                                    source = this.addComputable(loc.getProjectKey(), loc.getSmartName(sm.projectKey));
                                }
                            } else if (dep.type == ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE && (rkDependency = this.getRetrievableKnowledgeOrNull(loc)) != null) {
                                source = this.addComputable(loc.getProjectKey(), loc.getSmartName(sm.projectKey));
                            }
                        }
                        if (source != null) {
                            FlowImplicitRecipe recipe = new FlowImplicitRecipe("agentdep", fsm, source, "agent_dep");
                            this.runnables.put(recipe.getFullId(), recipe);
                            this.implicitRecipes.add(recipe);
                            source.addSuccessor(recipe, "agent_dep");
                            fsm.addPredecessor(recipe, "agent_dep");
                            continue;
                        }
                        logger.warn((Object)("Agent dependency does not exist in Flow graph: " + JSON.json((Object)dep)));
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to compute agent dependencies for " + sm.id + " (" + sm.name + ")"), e);
                }
            } else if (sm.savedModelType.isRetrievalAugmentedLlm()) {
                try {
                    DatasetLocUtils.DatasetLoc rkSmartLoc;
                    RetrievableKnowledge rk;
                    SavedModel.SavedModelInlineVersion smiv = sm.getVersion(sm.activeVersion).orElseThrow(() -> new IllegalArgumentException(String.format("Couldn't find active version in saved model %s", sm.id)));
                    FlowComputable source = this.getAlreadyAddedComputable(sm.projectKey, smiv.ragllmSettings.kbRef);
                    if (source == null && (rk = this.getRetrievableKnowledgeOrNull(rkSmartLoc = DatasetLocUtils.resolveSmart(sm.projectKey, smiv.ragllmSettings.kbRef))) != null) {
                        source = this.addComputable(rk.projectKey, rk.id);
                    }
                    logger.info((Object)("Adding dependency for Retrieval Augmented LLM " + sm.id + " (" + sm.name + ") -> KB " + smiv.ragllmSettings.kbRef));
                    if (source != null) {
                        FlowImplicitRecipe recipe = new FlowImplicitRecipe("ragdep", fsm, source, "rag_dep");
                        this.runnables.put(recipe.getFullId(), recipe);
                        this.implicitRecipes.add(recipe);
                        source.addSuccessor(recipe, "rag_dep");
                        fsm.addPredecessor(recipe, "rag_dep");
                    } else {
                        logger.warn((Object)("KB dependency does not exist in Flow graph: " + smiv.ragllmSettings.kbRef));
                    }
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to get Retrieval Augmented LLM KB dependency for " + sm.id + " (" + sm.name + ")"), e);
                }
            }
        }
    }

    public FlowDataset getDataset(String projectKey, String name) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, name);
        return this.datasets.get(loc.getFullName());
    }

    public FlowManagedFolder getFolder(String projectKey, String odbId) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, odbId);
        return this.folders.get(loc.getFullName());
    }

    public FlowSavedModel getModel(String projectKey, String smId) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, smId);
        return this.models.get(loc.getFullName());
    }

    public FlowModelEvaluationStore getEvaluationStore(String projectKey, String mesId) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, mesId);
        return this.evaluationStores.get(loc.getFullName());
    }

    public FlowRetrievableKnowledge getRetrievableKnowledge(String projectKey, String rkId) {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, rkId);
        return this.retrievableKnowledges.get(loc.getFullName());
    }

    public FlowStreamingEndpoint getStreamingEndpoint(String projectKey, String odbId) {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(projectKey, odbId);
        return this.streamingEndpoints.get(loc.getFullName());
    }

    public FlowComputable getComputable(String id) {
        return this.computables.get(id);
    }

    public FlowRunnable getRunnable(String name) {
        return this.runnables.get(name);
    }

    public static boolean isSink(GraphNode node) {
        return node.getSuccessors().isEmpty();
    }

    public static boolean isSource(GraphNode node) {
        return node.getPredecessors().isEmpty();
    }

    public FlowRecipe getRecipe(String projectKey, String name) {
        for (FlowRecipe fr : this.recipes) {
            if (!fr.getProjectKey().equals(projectKey) || !fr.getName().equals(name)) continue;
            return fr;
        }
        return null;
    }

    public FlowLabelingTask getLabelingTask(String projectKey, String id) {
        for (FlowLabelingTask flowLabelingTask : this.labelingTasks) {
            if (!flowLabelingTask.getProjectKey().equals(projectKey) || !flowLabelingTask.getId().equals(id)) continue;
            return flowLabelingTask;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FlowRecipe addRecipe(SerializedRecipe recipe) throws IOException {
        ErrorContext.push((String)("read of recipe " + recipe.name));
        Preconditions.checkNotNull((Object)recipe.name);
        Preconditions.checkNotNull((Object)recipe.projectKey);
        try {
            LinkedHashMap<String, FlowComputable.FlowComputableWithRole> recipeInputs = new LinkedHashMap<String, FlowComputable.FlowComputableWithRole>();
            LinkedHashMap<String, FlowComputable.FlowComputableWithRole> recipeOutputs = new LinkedHashMap<String, FlowComputable.FlowComputableWithRole>();
            FlowRecipe out = new FlowRecipe(recipe);
            for (Map.Entry<String, SerializedRecipe.InputRole> entry : recipe.getInputsUnsafe().entrySet()) {
                HashSet<String> inputsInRole = new HashSet<String>();
                for (SerializedRecipe.RecipeInput sinput : entry.getValue().items) {
                    if (inputsInRole.contains(sinput.ref)) {
                        throw ErrorContext.iaef((String)"Invalid recipe, '%s' appears several times.", (Object)sinput.ref, (Object[])new Object[0]);
                    }
                    if ("veloop".equals(entry.getKey()) && StringUtils.isBlank((String)sinput.ref)) {
                        logger.errorV("No parameters dataset selected for repeating recipe", new Object[0]);
                        continue;
                    }
                    inputsInRole.add(sinput.ref);
                    recipeInputs.put(sinput.ref, new FlowComputable.FlowComputableWithRole(this.addComputable(recipe.projectKey, sinput.ref), entry.getKey()));
                    for (SerializedRecipe.SDep sdep : sinput.deps) {
                        DimensionDependencySpec dds = new DimensionDependencySpec();
                        dds.inputDataset = AnyLoc.resolveSmart(recipe.projectKey, sinput.ref).getFullName();
                        dds.outputDataset = sdep.out;
                        if (dds.outputDataset != null) {
                            dds.outputDataset = AnyLoc.resolveSmart(recipe.projectKey, dds.outputDataset).getFullName();
                        }
                        dds.inputDimension = (String)ErrorContext.checkNotNull((Object)sdep.idim, (String)"missing input dimension");
                        dds.outputDimension = sdep.odim;
                        dds.function = (String)ErrorContext.checkNotNull((Object)sdep.func, (String)"missing dependency function");
                        dds.params = sdep.params;
                        dds.values = sdep.values;
                        dds.expandVariables = sdep.expandVariables;
                        out.addPartitionDeps(dds);
                    }
                }
            }
            for (Map.Entry<String, Object> entry : recipe.getOutputsUnsafe().entrySet()) {
                for (SerializedRecipe.RecipeOutput soutput : ((SerializedRecipe.OutputRole)entry.getValue()).items) {
                    if (recipeOutputs.containsKey(soutput.ref)) {
                        throw ErrorContext.iaef((String)"Invalid recipe, '%s' appears several times in output", (Object)soutput.ref, (Object[])new Object[0]);
                    }
                    recipeOutputs.put(soutput.ref, new FlowComputable.FlowComputableWithRole(this.addComputable(recipe.projectKey, soutput.ref), entry.getKey()));
                }
            }
            out.clearPredecessors();
            for (FlowComputable.FlowComputableWithRole flowComputableWithRole : recipeInputs.values()) {
                out.addPredecessor(flowComputableWithRole.computable, flowComputableWithRole.role);
            }
            out.clearSuccessors();
            for (FlowComputable.FlowComputableWithRole flowComputableWithRole : recipeOutputs.values()) {
                out.addSuccessor(flowComputableWithRole.computable, flowComputableWithRole.role);
            }
            for (FlowComputable.FlowComputableWithRole flowComputableWithRole : recipeInputs.values()) {
                flowComputableWithRole.computable.addSuccessor(out, flowComputableWithRole.role);
            }
            for (FlowComputable.FlowComputableWithRole flowComputableWithRole : recipeOutputs.values()) {
                flowComputableWithRole.computable.addPredecessor(out, flowComputableWithRole.role);
            }
            this.recipes.add(out);
            this.runnables.put(out.getFullId(), out);
            FlowRecipe flowRecipe = out;
            return flowRecipe;
        }
        finally {
            ErrorContext.pop();
        }
    }

    public Map<String, GraphNode> getNodesMap() {
        HashMap<String, GraphNode> result = new HashMap<String, GraphNode>();
        for (FlowComputable flowComputable : this.listComputables()) {
            result.put(flowComputable.getFullId(), flowComputable);
        }
        for (FlowRecipe flowRecipe : this.listRecipes()) {
            result.put(flowRecipe.getFullId(), flowRecipe);
        }
        return result;
    }

    public GraphNode getNode(String id) {
        return this.getNodesMap().get(id);
    }

    public Map<String, TaggableObjectsService.TaggableObject> getGraphElements() throws IOException {
        HashMap<String, TaggableObjectsService.TaggableObject> result = new HashMap<String, TaggableObjectsService.TaggableObject>();
        for (String datasetFullName : this.datasets.keySet()) {
            SerializedDataset sds = this.unsafe ? (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(AnyLoc.resolveFull(datasetFullName)) : (SerializedDataset)this.datasetsDAO.getMandatory(AnyLoc.resolveFull(datasetFullName));
            result.put(this.getID(sds), sds);
        }
        for (FlowManagedFolder flowManagedFolder : this.folders.values()) {
            ManagedFolder mf = flowManagedFolder.getManagedFolder();
            result.put(this.getID(mf), mf);
        }
        for (FlowSavedModel flowSavedModel : this.models.values()) {
            SavedModel sm = flowSavedModel.getSavedModel();
            result.put(this.getID(sm), sm);
        }
        for (FlowModelEvaluationStore flowModelEvaluationStore : this.evaluationStores.values()) {
            ModelEvaluationStore mes = flowModelEvaluationStore.getModelEvaluationStore();
            result.put(this.getID(mes), mes);
        }
        for (FlowStreamingEndpoint flowStreamingEndpoint : this.streamingEndpoints.values()) {
            StreamingEndpoint se = flowStreamingEndpoint.getStreamingEndpoint();
            result.put(this.getID(se), se);
        }
        for (FlowRecipe recipe : this.recipes) {
            SerializedRecipe sr = recipe.getModel();
            result.put(this.getID(sr), sr);
        }
        for (FlowLabelingTask flowLabelingTask : this.labelingTasks) {
            LabelingTask task = flowLabelingTask.getLabelingTask();
            result.put(this.getID(task), task);
        }
        for (FlowRetrievableKnowledge flowRetrievableKnowledge : this.retrievableKnowledges.values()) {
            RetrievableKnowledge retrievableKnowledge = flowRetrievableKnowledge.getRetrievableKnowledge();
            result.put(this.getID(retrievableKnowledge), retrievableKnowledge);
        }
        return result;
    }

    protected String getID(TaggableObjectsService.TaggableObject to) {
        return GraphIds.forRef(to.getRef());
    }

    private static class RecursableFunction<I> {
        public I func;

        private RecursableFunction() {
        }
    }

    public static enum TraversalOrderAlgorithm {
        EXHAUSTIVE,
        FORWARD_ONLY;

    }
}

