/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.DockerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineDef;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.JobExecutionResultHandler;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.InitializableAbortableRecipeRunner;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.util.SemaphoreRegistry;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ContainerizedStreamEngineExecutor
implements EnvironmentStash.AppendModeGetter,
InitializableAbortableRecipeRunner {
    @Autowired
    protected JobAuthCtxService authCtxService;
    @Autowired
    protected APITicketService apiTicketService;
    private static String CONTAINERIZED_LANGUAGE_INFO = "containerized-dss-engine";
    public static final int CDE_MIN_XMX_MB = 2048;
    private final JobActivity activity;
    private final FlowRecipe recipe;
    private final ContainerExecRuntimeConfig containerConfig;
    private String containerPodId;
    private boolean abortNotified;
    private File mainLogFile;
    private AutoDelete recipeTmpDir;
    private String imageId;
    private String executionId;
    private RemoteRunEnvDef envResource;
    private Status status = Status.NEW;
    private boolean podDeletionStarted = false;
    private static final int DEFAULT_ABORT_TIMEOUT_MS = 10000;
    private final int abortTimeoutMs;
    public static final String CDE_WARNINGS_FILE_NAME = "cde-warnings.json";
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.flow.cde.executor");

    public ContainerizedStreamEngineExecutor(FlowRecipe recipe, JobActivity activity, ContainerExecRuntimeConfig containerConfig) {
        this.recipe = recipe;
        this.activity = activity;
        this.containerConfig = containerConfig;
        this.abortTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.abort.cde.timeoutMs", Integer.valueOf(10000));
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public boolean isAppendMode(String computableRef) {
        return this.recipe.getModel().getOutputAnyRole((String)computableRef).appendMode;
    }

    @Override
    public void init() throws Exception {
    }

    public void init(JobActivity activity, Output.WriteMode writeMode) throws Exception {
    }

    protected void setExtraDef(ContainerizedDSSEngineDef payload) {
    }

    protected File getAndRegisterMainLogFile() throws IOException {
        File mainLogFile = FlowJobUtils.getJobTouchedFile("cde-recipe", "cde.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Remote output", mainLogFile, "text/plain");
        return mainLogFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws Exception {
        this.mainLogFile = this.getAndRegisterMainLogFile();
        ArrayList readablePaths = Lists.newArrayList();
        AutoDelete contextPath = this.recipeTmpDir = FlowJobUtils.getTmpFolder("cde-recipe", "samplout");
        this.executionId = KubernetesExecUtils.getNormalizedExecutionId("stream-" + SecretKeyGenerator.generateSmall());
        ContainerizedDSSEngineDef payload = ContainerizedDSSEngineDef.buildFromContext(this.activity);
        this.setExtraDef(payload);
        this.imageId = this.prepareContainerExecution((File)contextPath, JSON.json((Object)payload), readablePaths);
        this.imageId = ContainerExecImagesHelper.withRepositoryURL(this.containerConfig.repositoryURL, this.imageId);
        this.envResource = new RemoteRunEnvDef();
        this.envResource.runsRemotely = true;
        this.envResource.cwd = this.recipeTmpDir.getAbsolutePath();
        EnvironmentStash envStash = this.prepareEnvStash(new HashMap<String, String>());
        envStash.copyToRemoteRunEnvDef(this.envResource, false, false, true);
        this.envResource.jobId = this.executionId;
        RemoteRunsRegistry.get((String)this.executionId).envResource = this.envResource;
        try {
            switch (this.containerConfig.type) {
                case DOCKER: {
                    this.runInDocker();
                    return;
                }
                case KUBERNETES: {
                    this.runInKubernetes();
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected container type " + String.valueOf((Object)this.containerConfig.type));
                }
            }
        }
        finally {
            File warningsFile = new File((File)this.recipeTmpDir, CDE_WARNINGS_FILE_NAME);
            if (warningsFile.isFile()) {
                logger.info((Object)"Warnings file was found");
                try {
                    this.activity.warnContext.merge((WarningsContext.SerializedWarnings)JSON.parseFile((File)warningsFile, WarningsContext.SerializedWarnings.class));
                }
                catch (Exception e) {
                    logger.warn((Object)"Warnings file could not be read", (Throwable)e);
                }
            } else {
                logger.warn((Object)"Warnings file could not be found");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInDocker() throws Exception {
        Object fakeCDEBinPath;
        JobContext.getCurrentActivitySummary().containerConfType = "DOCKER";
        AuthCtx submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
        this.containerPodId = "dku_engine-" + this.executionId;
        logger.infoV("Executing recipe on Docker with config=%s, using image '%s', container '%s'", new Object[]{this.containerConfig.name, this.imageId, this.containerPodId});
        String xmxOverride = this.getXmxOverride(this.containerConfig);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().put("DKU_API_TICKET", this.apiTicketService.getSingleTicket().getSecret());
        pb.environment().put("DKU_EXECUTION_ID", this.executionId);
        pb.environment().put("DKU_EXECUTION_SECRET_ID", RemoteRunsRegistry.get((String)this.executionId).secretId);
        pb.environment().put("DKU_CDE_XMX", xmxOverride);
        if (this.isDevModeLocalProcess()) {
            pb.directory(new File(System.getenv("FAKE_CDE_HOME")));
            fakeCDEBinPath = System.getenv("FAKE_CDE_BIN");
            Object binPath = fakeCDEBinPath != null ? fakeCDEBinPath : ApplicationConfigurator.getInstallFile((String[])new String[]{"dev", "cde"}).getAbsolutePath();
            pb.command(Lists.newArrayList((Object[])new String[]{binPath}));
            pb.environment().putAll(DockerExecUtils.getEnvironmentFlags(this.containerConfig));
        } else {
            pb.directory((File)this.recipeTmpDir);
            pb.command(DockerExecUtils.getDockerRunCommand(submitter, RemoteRunsRegistry.ExecutionType.CDE, JobContext.getCurrentJobContext().projectKey, JobContext.getCurrentJobContext().jobId, this.activity.id(), this.containerConfig, "--name", this.containerPodId, "-e", "DKU_API_TICKET", "-e", "DKU_EXECUTION_ID", "-e", "DKU_EXECUTION_SECRET_ID", "-e", "DKU_CDE_XMX"));
            pb.command().addAll(DockerExecUtils.getEnvironmentCommandFlags(this.containerConfig));
            pb.command().add(this.imageId);
            ContainerExecUtils.enrichDockerEnv(this.containerConfig, pb.environment());
        }
        fakeCDEBinPath = this;
        synchronized (fakeCDEBinPath) {
            if (this.abortNotified) {
                logger.info((Object)"Already received abort, will not start execution");
                return;
            }
            this.status = Status.RUNNING;
        }
        try {
            CodeBasedThingHelper.ExecutionResult result = this.getProcessExecution().executeNoFail(pb, null, this.mainLogFile, null, true);
            this.getExecutionResultHandler().handleExecutionResult(pb.directory(), CONTAINERIZED_LANGUAGE_INFO, result);
            this.getExecutionResultHandler().throwFromErrorFileOrLogs(pb.directory(), CONTAINERIZED_LANGUAGE_INFO, result, null);
        }
        finally {
            ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor = this;
            synchronized (containerizedStreamEngineExecutor) {
                this.status = Status.DONE;
            }
            RemoteRunsRegistry.remove(this.executionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runInKubernetes() throws Exception {
        Object exception;
        KubectlHelper.KubectlLoopCaller kubectlPodTopper;
        boolean deleteK8sPod;
        ComputeResourceUsage cru;
        AuthCtx submitter;
        block56: {
            Semaphore semaphore;
            String podName;
            JobContext.getCurrentActivitySummary().containerConfType = "KUBERNETES";
            submitter = ((JobAuthCtxService)SpringUtils.getBean(JobAuthCtxService.class)).getAuthCtx();
            String k8sClusterId = new ClusterSelector().getClusterForProject(JobContext.getCurrentJobContext().projectKey, Cluster.ClusterArchitecture.KUBERNETES);
            cru = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)this.containerConfig.kubernetesResources).reportStartNoFail();
            logger.infoV("Executing recipe on Kubernetes with config=%s, using image '%s'", new Object[]{this.containerConfig.name, this.imageId});
            File secretFile = new File((File)this.recipeTmpDir, "secret.yaml");
            File podFile = new File((File)this.recipeTmpDir, "pod.yaml");
            KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(submitter, this.executionId, this.containerConfig);
            Map<String, String> environment = this.buildK8sEnvironment();
            String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.apiTicketService.getSingleTicket().getSecret(), RemoteRunsRegistry.get((String)this.executionId).secretId);
            String podDesc = KubernetesExecUtils.getPodConf(submitter, this.executionId, JobContext.getCurrentJobContext().projectKey, JobContext.getCurrentJobContext().jobId, this.activity.id(), laa, environment, this.imageId, this.containerConfig);
            this.containerPodId = StringUtils.join((Object[])new String[]{"-f", podFile.getAbsolutePath(), "-f", secretFile.getAbsolutePath()}, (String)"\n");
            DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
            DKUFileUtils.writeFileUTF8((File)podFile, (String)podDesc);
            deleteK8sPod = true;
            KubectlHelper.KubectlLoopCaller kubectlPodDescriber = null;
            kubectlPodTopper = null;
            double waited = RateLimiterRegistry.forName("k8sCodeRecipeStart", 1000.0).acquire();
            if (waited > 0.0) {
                logger.infoV("Waited %.3f seconds (rate-limited by k8sCodeRecipeStart)", new Object[]{waited});
            }
            try {
                block53: {
                    ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor;
                    block54: {
                        RemoteRunsRegistry.get((String)this.executionId).envResource = this.envResource;
                        exception = null;
                        podName = KubernetesExecUtils.getPodName(this.executionId);
                        semaphore = SemaphoreRegistry.forName("k8sCodeRecipesInStartupPhase", 100);
                        long before = System.currentTimeMillis();
                        semaphore.acquire();
                        long after = System.currentTimeMillis();
                        if (after - before > 50L) {
                            logger.infoV("Waited %.3f seconds (semaphore-limited by k8sCodeRecipesInStartupPhase", new Object[]{(double)(after - before) / 1000.0});
                        }
                        KubernetesExecUtils.createPod(submitter, this.recipe.getProjectKey(), this.containerConfig, podName, secretFile, podFile, (File)this.recipeTmpDir);
                        ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor2 = this;
                        // MONITORENTER : containerizedStreamEngineExecutor2
                        if (!this.abortNotified) break block53;
                        logger.info((Object)"Already received abort, will not start execution");
                        // MONITOREXIT : containerizedStreamEngineExecutor2
                        semaphore.release();
                        if (kubectlPodDescriber == null) break block54;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                        kubectlPodDescriber.cancel();
                    }
                    if (kubectlPodTopper != null) {
                        logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                        kubectlPodTopper.cancel();
                    }
                    RemoteRunsRegistry.remove(this.executionId);
                    cru.reportCompleteNoFail();
                    if (deleteK8sPod) {
                        containerizedStreamEngineExecutor = this;
                        // MONITORENTER : containerizedStreamEngineExecutor
                        if (this.podDeletionStarted) {
                            deleteK8sPod = false;
                        } else {
                            this.podDeletionStarted = true;
                        }
                        // MONITOREXIT : containerizedStreamEngineExecutor
                    }
                    if (deleteK8sPod) {
                        logger.info((Object)"Cleaning Kubernetes pod");
                        ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(submitter, this.recipe.getProjectKey(), this.containerConfig, false, "delete", "-f", "secret.yaml", "-f", "pod.yaml"));
                        pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                        pb.directory((File)this.recipeTmpDir);
                        File cleanupLogFile = new File((File)this.recipeTmpDir, "kubectl-cleanup-out.log");
                        CodeBasedThingHelper.ExecutionResult cleanResult = this.getProcessExecution().executeNoFail(pb, null, cleanupLogFile, null, true);
                        if (cleanResult.returnValue != 0) {
                            logger.error((Object)"Could not clean kubernetes pod");
                        }
                    }
                    containerizedStreamEngineExecutor = this;
                    // MONITORENTER : containerizedStreamEngineExecutor
                    this.status = Status.DONE;
                    // MONITOREXIT : containerizedStreamEngineExecutor
                    return;
                }
                this.status = Status.RUNNING;
                // MONITOREXIT : containerizedStreamEngineExecutor2
                try {
                    logger.info((Object)"Waiting for kubernetes logs availability");
                    exception = KubernetesExecUtils.waitForLogStart(submitter, this.recipe.getProjectKey(), podName, this.containerConfig);
                    break block55;
                }
                catch (IOException e) {
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor;
                if (kubectlPodDescriber != null) {
                    logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                    kubectlPodDescriber.cancel();
                }
                if (kubectlPodTopper != null) {
                    logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                    kubectlPodTopper.cancel();
                }
                RemoteRunsRegistry.remove(this.executionId);
                cru.reportCompleteNoFail();
                if (deleteK8sPod) {
                    containerizedStreamEngineExecutor = this;
                    // MONITORENTER : containerizedStreamEngineExecutor
                    if (this.podDeletionStarted) {
                        deleteK8sPod = false;
                    } else {
                        this.podDeletionStarted = true;
                    }
                    // MONITOREXIT : containerizedStreamEngineExecutor
                }
                if (deleteK8sPod) {
                    logger.info((Object)"Cleaning Kubernetes pod");
                    ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(submitter, this.recipe.getProjectKey(), this.containerConfig, false, "delete", "-f", "secret.yaml", "-f", "pod.yaml"));
                    pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
                    pb.directory((File)this.recipeTmpDir);
                    File cleanupLogFile = new File((File)this.recipeTmpDir, "kubectl-cleanup-out.log");
                    CodeBasedThingHelper.ExecutionResult cleanResult = this.getProcessExecution().executeNoFail(pb, null, cleanupLogFile, null, true);
                    if (cleanResult.returnValue != 0) {
                        logger.error((Object)"Could not clean kubernetes pod");
                    }
                }
                containerizedStreamEngineExecutor = this;
                // MONITORENTER : containerizedStreamEngineExecutor
                this.status = Status.DONE;
                // MONITOREXIT : containerizedStreamEngineExecutor
                throw throwable;
            }
            {
                block55: {
                    finally {
                        semaphore.release();
                    }
                }
                if (exception != null) {
                    logger.error((Object)"Could not get kubernetes pod logs");
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                    throw exception;
                }
                if (cru.context.type == ComputeResourceUsageContext.ComputeResourceUsageContextType.JOB_ACTIVITY) {
                    logger.info((Object)"In a job activity, gathering Kubernetes pod description in background");
                    JobActivity currentActivity = JobContext.getCurrentActivityObj();
                    kubectlPodDescriber = KubectlHelper.createPodDescriber(submitter, this.recipe.getProjectKey(), currentActivity, this.containerConfig, this.executionId);
                    if (kubectlPodDescriber != null) {
                        logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                        kubectlPodDescriber.start();
                    }
                    if ((kubectlPodTopper = KubectlHelper.createPodTopper(submitter, this.recipe.getProjectKey(), currentActivity, this.containerConfig, this.executionId)) != null) {
                        logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                        kubectlPodTopper.start();
                    }
                }
                logger.info((Object)"Done waiting for logs to be available, trying to start streaming them");
                int rv = KubernetesExecUtils.streamLogsUntilPodsAreDone(submitter, this.recipe.getProjectKey(), (File)this.recipeTmpDir, podName, this.containerConfig, this.mainLogFile);
                logger.info((Object)("Log streaming terminated with return code " + rv));
                if (rv != 0) {
                    logger.error((Object)"Could not get kubernetes pod logs");
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                }
                KubernetesExecUtils.KubernetesFailureCodeProvider codeProvider = new KubernetesExecUtils.KubernetesFailureCodeProvider(){

                    @Override
                    public InfoMessage.MessageCode codeForOOMKilled() {
                        return RecipeCodes.ERR_RECIPE_CODE_K8S_OOM;
                    }
                };
                try {
                    logger.info((Object)"Waiting for kubernetes pod to finish");
                    exception = KubernetesExecUtils.waitForPod(submitter, this.recipe.getProjectKey(), podName, this.containerConfig, codeProvider);
                }
                catch (IOException e) {
                    logger.warn((Object)"Will not delete kubernetes pod for debugging");
                    deleteK8sPod = false;
                    exception = e;
                }
                this.getExecutionResultHandler().throwFromErrorFileOrLogs((File)this.recipeTmpDir, CONTAINERIZED_LANGUAGE_INFO, this.mainLogFile, codeProvider);
                if (exception != null) {
                    throw exception;
                }
                if (kubectlPodDescriber == null) break block56;
            }
            logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
            kubectlPodDescriber.cancel();
        }
        if (kubectlPodTopper != null) {
            logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
            kubectlPodTopper.cancel();
        }
        RemoteRunsRegistry.remove(this.executionId);
        cru.reportCompleteNoFail();
        if (deleteK8sPod) {
            exception = this;
            // MONITORENTER : exception
            if (this.podDeletionStarted) {
                deleteK8sPod = false;
            } else {
                this.podDeletionStarted = true;
            }
            // MONITOREXIT : exception
        }
        if (deleteK8sPod) {
            logger.info((Object)"Cleaning Kubernetes pod");
            ProcessBuilder pb = new ProcessBuilder(KubernetesExecUtils.getKubeCtlCommand(submitter, this.recipe.getProjectKey(), this.containerConfig, false, "delete", "-f", "secret.yaml", "-f", "pod.yaml"));
            pb.environment().putAll(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig));
            pb.directory((File)this.recipeTmpDir);
            File cleanupLogFile = new File((File)this.recipeTmpDir, "kubectl-cleanup-out.log");
            CodeBasedThingHelper.ExecutionResult cleanResult = this.getProcessExecution().executeNoFail(pb, null, cleanupLogFile, null, true);
            if (cleanResult.returnValue != 0) {
                logger.error((Object)"Could not clean kubernetes pod");
            }
        }
        ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor = this;
        // MONITORENTER : containerizedStreamEngineExecutor
        this.status = Status.DONE;
        // MONITOREXIT : containerizedStreamEngineExecutor
    }

    private Map<String, String> buildK8sEnvironment() {
        String overheadFactor;
        HashMap environment = Maps.newHashMap();
        String xmxOverride = this.getXmxOverride(this.containerConfig);
        if (StringUtils.isNotBlank((String)xmxOverride)) {
            environment.put("DKU_CDE_XMX", xmxOverride);
        } else if (this.containerConfig.kubernetesResources.memLimitMB > 0 && StringUtils.isNotBlank((String)(overheadFactor = this.getContainerConfigValue(this.containerConfig, "dku.cde.memoryOverheadFactor")))) {
            int memory = (int)((float)this.containerConfig.kubernetesResources.memLimitMB / (1.0f + Float.parseFloat(overheadFactor)));
            environment.put("DKU_CDE_XMX", Integer.max(memory, 2048) + "m");
        }
        return environment;
    }

    @Override
    public void notifyBeforeAborting() {
        this.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor;
        logger.warn((Object)("Abort received, will let the container gracefully terminate " + this.containerPodId));
        ContainerizedStreamEngineExecutor containerizedStreamEngineExecutor2 = this;
        synchronized (containerizedStreamEngineExecutor2) {
            if (this.abortNotified) {
                logger.info((Object)"Abort already received");
                return;
            }
            if (this.status == Status.NEW) {
                logger.info((Object)"CDE executor did not start yet");
                return;
            }
            this.abortNotified = true;
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)this.abortTimeoutMs) {
            containerizedStreamEngineExecutor = this;
            synchronized (containerizedStreamEngineExecutor) {
                if (this.status == Status.DONE) {
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn((Object)"Waiting for graceful abort interrupted", (Throwable)e);
                break;
            }
        }
        switch (this.containerConfig.type) {
            case DOCKER: {
                if (this.isDevModeLocalProcess()) break;
                containerizedStreamEngineExecutor = this;
                synchronized (containerizedStreamEngineExecutor) {
                    if (this.status == Status.DONE) {
                        break;
                    }
                }
                this.abortDocker();
                break;
            }
            case KUBERNETES: {
                containerizedStreamEngineExecutor = this;
                synchronized (containerizedStreamEngineExecutor) {
                    if (this.podDeletionStarted) {
                        break;
                    }
                    this.podDeletionStarted = true;
                }
                this.abortKubernetes();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected container type " + String.valueOf((Object)this.containerConfig.type));
            }
        }
    }

    private void abortDocker() {
        logger.warn((Object)("Abort received, will kill Docker container " + this.containerPodId));
        HashMap<String, String> env = new HashMap<String, String>(1);
        ContainerExecUtils.enrichDockerEnv(this.containerConfig, env);
        ContainerExecUtils.killDockerContainer(this.containerPodId, true, env, logger);
    }

    private void abortKubernetes() {
        logger.warn((Object)("Abort received, will kill Kubernetes pod " + this.containerPodId));
        try {
            KubernetesExecUtils.delete(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), this.containerConfig, true, this.containerPodId.split("\n"));
        }
        catch (IOException e) {
            logger.error((Object)"Could not stop Kubernetes pod", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.error((Object)"Interrupted while stopping Kubernetes pod", (Throwable)e);
        }
    }

    private EnvironmentStash prepareEnvStash(Map<String, String> extraEnv) {
        EnvironmentStash environmentStash = new EnvironmentStash();
        environmentStash.fillDefaultForRemote();
        environmentStash.fillForVisualRecipe(this.activity);
        environmentStash.env.putAll(extraEnv);
        environmentStash.flowSpec = EnvironmentStash.buildBareFlowSpec();
        return environmentStash;
    }

    private String prepareContainerExecution(File contextPath, String payload, Collection<String> readablePaths) throws IOException {
        CodeEnvModel.EnvFullRef env = new CodeEnvModel.EnvFullRef(null, null, null);
        RemoteRunsRegistry.add(this.executionId, this.apiTicketService.getSingleTicket().getOriginalUser(), this.recipe.getProjectKey(), contextPath.getPath(), this.recipeTmpDir.getPath(), RemoteRunsRegistry.ExecutionType.CDE, JSON.json((Object)this.activity.getSerialized()), payload, readablePaths, null, Collections.singletonList(env));
        ContainerSettings containerSettings = new ClusterSelector().selectGlobal().getContainerSettings();
        return ContainerExecImagesHelper.getImageTagToUse(this.containerConfig.dockerHost, containerSettings.cdeBaseImage, ContainerExecUtils.BaseImageType.CDE, null, null, null);
    }

    private JobExecutionResultHandler getExecutionResultHandler() {
        return new JobExecutionResultHandler();
    }

    private JobProcessExecution getProcessExecution() {
        return new JobProcessExecution(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey());
    }

    private String getContainerConfigValue(ContainerExecRuntimeConfig containerConfig, String key) {
        for (SimpleKeyValue prop : containerConfig.properties) {
            if (!key.equals(prop.key)) continue;
            return StringUtils.defaultIfBlank((String)prop.value, (String)"");
        }
        return "";
    }

    private String getXmxOverride(ContainerExecRuntimeConfig containerConfig) {
        return this.getContainerConfigValue(containerConfig, "dku.cde.xmx");
    }

    private boolean isDevModeLocalProcess() {
        return System.getenv("FAKE_CDE_HOME") != null;
    }

    static enum Status {
        NEW,
        RUNNING,
        DONE;

    }
}

