/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeStatusComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class FuzzyJoinRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    FuzzyJoinRecipeStatusComputer statusComputer;
    private final FuzzyJoinRecipeHelper helper = new FuzzyJoinRecipeHelper();
    private FuzzyJoinRecipePayloadParams params;

    public FuzzyJoinRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.setParams(this.helper.loadParams(payload, this.recipe));
        this.statusComputer = new FuzzyJoinRecipeStatusComputer(this.recipe, payload);
        SpringUtils.getInstance().autowire((Object)this.statusComputer);
    }

    public void setParams(FuzzyJoinRecipePayloadParams params) {
        this.params = params;
    }

    @Override
    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            Preconditions.checkArgument((boolean)role.equals("main"), (Object)("Recipe only has output role 'main', got: " + role));
            this.recipesValidationService.checkComplianceWithRecipeDesc(this.authCtx, this.recipe);
            ArrayList arrayList = Lists.newArrayList((Object[])new Schema[]{this.getSchema()});
            return arrayList;
        }
    }

    public Schema getSchema() throws Exception {
        this.helper.initInputDatasets(this.activity, this.params);
        this.helper.initAliases(this.params);
        if (this.statusComputer != null) {
            InfoMessage.InfoMessages statusMessages = this.checkValidParams();
            if (statusMessages.error) {
                throw statusMessages.firstFatal().asCodedException();
            }
        }
        return this.buildSchema();
    }

    private InfoMessage.InfoMessages checkValidParams() {
        FuzzyJoinRecipeStatusComputer.FuzzyJoinRecipeStatus status = new FuzzyJoinRecipeStatusComputer.FuzzyJoinRecipeStatus();
        status.params = this.params;
        this.statusComputer.checkJoins(status, this.helper);
        return status.gatherAllMessages();
    }

    private Schema buildSchema() {
        HashSet<String> usedColumnNames = new HashSet<String>();
        Schema outputSchema = new Schema();
        if (this.params.getSelectedColumns() != null) {
            for (ColumnDesc cd : this.params.getSelectedColumns()) {
                JoinInputDescBase inputDesc = (JoinInputDescBase)this.params.virtualInputs.get(cd.table);
                Dataset dataset = this.helper.datasetsMap.get(inputDesc.name);
                if (dataset == null) {
                    throw ErrorContext.iaef((String)"Dataset not found in inputs: \"%s\"", (Object)inputDesc.name, (Object[])new Object[0]);
                }
                if (usedColumnNames.contains(cd.alias)) {
                    throw ErrorContext.iaef((String)"Output schema contains duplicate column name \"%s\"", (Object)cd.alias, (Object[])new Object[0]);
                }
                usedColumnNames.add(cd.alias);
                if (cd.name == null || cd.name.isEmpty()) continue;
                SchemaColumn col = ExpressionUtils.getSchemaColumn(cd.name, dataset.getSchema(), inputDesc.computedColumns);
                outputSchema.addColumn(SchemaColumn.copyWithNewName((String)cd.alias, (SchemaColumn)col));
            }
        }
        if (this.params.withMetaColumn || this.params.debugMode) {
            outputSchema.addColumn(new SchemaColumn("meta", Type.STRING));
        }
        return outputSchema;
    }
}

