/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.PostgreSQLConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeHelper;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnsStepStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipeStatus;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeStatusUtils;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.sql.SQLQueryRecipeRunner;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeoJoinRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin.status");

    public GeoJoinRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public GeoJoinRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), authCtx);
    }

    @Override
    public GeoJoinRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        GeoJoinRecipeStatus status;
        JoinLikeStatusUtils joinLikeStatusUtils = new JoinLikeStatusUtils(authCtx, this.transactionService);
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
        }
        if (status.isInvalid()) {
            return status;
        }
        GeoJoinRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        GeoJoinRecipeHelper helper = init.helper;
        List<Dataset> sources = init.sources;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        if (status.selectedEngine == null) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No available engine can run this recipe");
            return status;
        }
        boolean lowerCaseColumnsNames = params.engineParams.lowerCaseSchemaIfEngineRequiresIt && status.getSelectedSQLBasedEngine().lowercasesColumnNames();
        helper.initAliases(params, lowerCaseColumnsNames);
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(selectedEngine, params);
        }
        List<Object> preFilterSQLExpressions = new ArrayList(params.virtualInputs.size());
        String postFilterSQLExpression = null;
        this.validatePostGISsupport(authCtx, init, status);
        try {
            if (!status.isInvalid()) {
                preFilterSQLExpressions = this.checkVirtualInputs(init, status, helper);
            }
            if (!status.isInvalid() && dialect instanceof SnowflakeSQLDialect) {
                this.checkSnowflakeMatchingConditions(status);
            }
            if (!status.isInvalid()) {
                this.checkJoins(status, helper);
            }
            if (!status.isInvalid()) {
                joinLikeStatusUtils.validateOutputSchema(status, params, dialect != null && dialect.hasCaseInsensitiveColumns(), this.payload, init.activity);
            }
            if (!status.isInvalid() && params.postFilter != null) {
                if (params.postFilter.enabled) {
                    status.postFilter = new RecipeStatus.StepStatus();
                    boolean translateFully = !status.selectedEngine.type.equals("DSS");
                    postFilterSQLExpression = this.visualRecipesService.checkFilter(params.postFilter, new Dataset().withSchema(status.outputSchema), dialect, status.postFilter, translateFully);
                } else if (params.postFilter.distinct) {
                    status.postFilter = new RecipeStatus.StepStatus();
                }
            }
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            boolean errorOriginFound = false;
            if (status.selectedEngine instanceof VisualSQLRecipesBaseService.SQLBasedEngineStatus && this.needToComputeExecutionPlan((VisualSQLRecipesBaseService.SQLBasedEngineStatus)status.selectedEngine, status, request)) {
                try {
                    status.executionPlan = this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), status.sql, params.engineParams);
                }
                catch (ExecutionPlanService.HiveTableNotFound e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore:" + ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                    logger.info((Object)("Query:\n" + status.sql));
                    executionPlanErrMsg = e.getMessage();
                    executionPlanFailed = true;
                    status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            if (init.error != null && !status.isInvalid()) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
            }
            if (executionPlanFailed && status.selectedEngine.type.equals("HIVE")) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
            } else if (executionPlanFailed) {
                ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
                logger.info((Object)"Check pre-filters");
                for (int i = 0; i < preFilterSQLExpressions.size(); ++i) {
                    String filterSQLExpression = (String)preFilterSQLExpressions.get(i);
                    if (filterSQLExpression == null) continue;
                    JoinInputDescBase input = (JoinInputDescBase)params.virtualInputs.get(i);
                    SelectQueryBuilder qb = new SelectQueryBuilder();
                    SQLUtils.SQLTable table = helper.sqlTablesMap.get(input.name);
                    qb.from(table, null);
                    qb.where(ef.expr(filterSQLExpression));
                    String sql = qb.toSQL(dialect);
                    try {
                        this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Pre-filter " + i + " invalid"), (Throwable)e);
                        status.preFilters.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_JOIN_INVALID_FILTER, (String)ExceptionUtils.getMessageWithCauses((Throwable)e)).withPos(i, 0));
                        errorOriginFound = true;
                    }
                }
                if (postFilterSQLExpression != null && !errorOriginFound) {
                    logger.info((Object)"Check post-filter");
                    GeoJoinRecipePayloadParams params2 = (GeoJoinRecipePayloadParams)JSON.deepCopy((Object)params);
                    for (JoinInputDescBase input : params.virtualInputs) {
                        input.preFilter = null;
                    }
                    params2.postFilter = null;
                    String sql = helper.generateSQLIgnorePartitioning_NT(authCtx, init.activity, dialect, params2, lowerCaseColumnsNames);
                    this.getExecutionPlan(authCtx, sources, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                    status.postFilter.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_FILTER, this.formatDatabaseErrorMsg(executionPlanErrMsg, dialect));
                    logger.info((Object)"Post-filter invalid");
                    errorOriginFound = true;
                }
                if (!errorOriginFound) {
                    status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Some recipe steps did not validate");
        }
        return status;
    }

    private void validatePostGISsupport(AuthCtx authCtx, StatusInitializer init, GeoJoinRecipeStatus status) {
        if (!status.selectedEngine.type.equals("SQL")) {
            return;
        }
        try (Transaction t = this.transactionService.beginRead();){
            boolean postGISenabled;
            String mainConnectionName = SQLQueryRecipeRunner.getMainSingleConnection(authCtx, (RecipeRunnableSubgraph)init.activity.getSubgraph(), this.datasetsDAO);
            AbstractSQLConnection mainConnection = SQLConnectionProvider.getDSSConnection(authCtx, mainConnectionName);
            if ((mainConnection.getType().equals("PostgreSQL") || mainConnection.getType().equals("AlloyDB")) && !(postGISenabled = ((PostgreSQLConnection.Params)mainConnection.getParams()).postGISenabled)) {
                status.join.withWarning(RecipeCodes.WARN_RECIPE_GEOJOIN_ENFORCE_POSTGIS_EXTENSION, String.format("PostGIS support is not explicitly enabled in the connection settings of: \"%s\". Make sure that PostGIS extension is installed in the corresponding PostgreSQL database.", mainConnectionName));
            }
        }
        catch (IOException | SQLException e) {
            logger.error((Object)"Failed to get the main connection", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Failed to get the main connection " + ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
    }

    private List<String> checkVirtualInputs(StatusInitializer init, GeoJoinRecipeStatus status, GeoJoinRecipeHelper helper) {
        GeoJoinRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        Map<String, Dataset> datasetsMap = helper.datasetsMap;
        ArrayList<String> preFilterSQLExpressions = new ArrayList<String>();
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            JoinInputDescBase input = (JoinInputDescBase)params.virtualInputs.get(i);
            FilterDesc filterDesc = input.preFilter;
            String filterExpression = null;
            if (filterDesc != null && (filterDesc.enabled || filterDesc.distinct)) {
                if (status.preFilters == null) {
                    status.preFilters = new RecipeStatus.StepStatus();
                }
                RecipeStatus.StepStatus fakeStatus = new RecipeStatus.StepStatus();
                Dataset dataset = datasetsMap.get(input.name);
                boolean translateFully = status.getSelectedSQLBasedEngine().queryBased && !status.getSelectedSQLBasedEngine().type.equals("DSS");
                filterExpression = this.visualRecipesService.checkFilter(filterDesc, dataset, dialect, fakeStatus, translateFully);
                if (fakeStatus.anyFatal()) {
                    status.preFilters.addMessage(fakeStatus.firstFatal().withPos(i, 0));
                }
            }
            preFilterSQLExpressions.add(filterExpression);
        }
        return preFilterSQLExpressions;
    }

    boolean checkJoins(GeoJoinRecipeStatus status, GeoJoinRecipeHelper helper) {
        GeoJoinRecipePayloadParams params = status.params;
        boolean usedCrossJoin = false;
        for (GeoJoinRecipePayloadParams.JoinDesc join : params.joins) {
            JoinInputDescBase input1 = (JoinInputDescBase)params.virtualInputs.get(join.table1);
            JoinInputDescBase input2 = (JoinInputDescBase)params.virtualInputs.get(join.table2);
            usedCrossJoin = usedCrossJoin || join.type == JoinType.CROSS;
            Dataset ds1 = helper.datasetsMap.get(input1.name);
            Dataset ds2 = helper.datasetsMap.get(input2.name);
            if (ds1 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input1.name);
            }
            if (ds2 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve dataset " + input2.name);
            }
            if (ds1 == null || ds2 == null) continue;
            Schema schema1 = ds1.getSchema();
            Schema schema2 = ds2.getSchema();
            if (schema1 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input1.name);
            }
            if (schema2 == null) {
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve schema from dataset " + input2.name);
            }
            if (schema1 == null || schema2 == null) continue;
            this.validateGeospatialColumnsInSchema(status, input1, schema1, input2, schema2);
            for (GeoJoinRecipePayloadParams.MatchingCondition matchingCondition : join.on) {
                if (!schema1.hasColumn(matchingCondition.column1.name)) {
                    status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve column " + matchingCondition.column1.name + " from dataset " + ds1.getFullName());
                }
                if (schema2.hasColumn(matchingCondition.column2.name)) continue;
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Cannot retrieve column " + matchingCondition.column2.name + " from dataset " + ds2.getFullName());
            }
        }
        if (usedCrossJoin) {
            status.join.withWarning(RecipeCodes.WARN_RECIPE_JOIN_EXPENSIVE, "Cross join may result in a very large output");
        }
        return !status.join.anyFatal();
    }

    private void validateGeospatialColumnsInSchema(GeoJoinRecipeStatus status, JoinInputDescBase input1, Schema schema1, JoinInputDescBase input2, Schema schema2) {
        String messageTemplate = "Dataset %s has no geospatial columns. Verify that the column types are set correctly.";
        if (schema1.columns.stream().noneMatch(sc -> sc.getType().isGeo())) {
            status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, messageTemplate, new Object[]{input1.name});
        }
        if (schema2.columns.stream().noneMatch(sc -> sc.getType().isGeo())) {
            status.join.withFatalV(RecipeCodes.ERR_RECIPE_JOIN_INVALID_SELECTED, messageTemplate, new Object[]{input2.name});
        }
    }

    @Override
    public GeoJoinRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        GeoJoinRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, authCtx);
            VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
            this.generateSQLqueryIfRequired(init, authCtx, status, selectedEngine);
        }
        return status;
    }

    private GeoJoinRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, AuthCtx authCtx) {
        GeoJoinRecipeStatus status = new GeoJoinRecipeStatus();
        try {
            this.performBasicStructureChecks(status, authCtx);
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            init.helper = new GeoJoinRecipeHelper();
            String dynamicPayload = null;
            if ("{}".equals(this.payload)) {
                RecipesDAO recipesDAO = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
                dynamicPayload = recipesDAO.getPayloadOrNull(this.recipe.projectKey, this.recipe.name);
            }
            status.params = init.helper.loadParams(dynamicPayload != null ? dynamicPayload : this.payload, this.recipe);
            status.engineParams = status.params.engineParams;
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        try {
            SQLDialect dialect;
            init.sources = new ArrayList<Dataset>();
            for (FlowDataset fd : init.activity.getSubgraph().getSourceDatasets()) {
                init.sources.add(fd.getMandatoryUnsafe(this.datasetsDAO));
            }
            status.engines = this.getEnginesStatus(authCtx, init);
            this.performBasicCDEChecks(status, authCtx);
            RecipeEnginesPreferenceConfig repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, status.params.enginesPreferences);
            this.visualRecipesService.selectEngine(authCtx, init.activity, status.params.engineType, status, this.recipe.type, repc);
            this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Join in-database then streaming of results");
            VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
            init.dialect = dialect = this.visualRecipesService.getDialect(authCtx, init.activity, selectedEngine);
            this.checkEngines(authCtx, status, status.params, init);
            boolean mustLowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)status.params, selectedEngine);
            boolean caseInsensitive = mustLowerCaseColumnsNames || dialect != null && dialect.hasCaseInsensitiveColumns();
            init.helper.initInputDatasets(init.activity, status.params, init.dialect, caseInsensitive);
            if (!this.checkJoins(status, init.helper)) {
                return status;
            }
            try {
                status.params.validateJoins();
            }
            catch (Exception e) {
                logger.error((Object)"Invalid join params", (Throwable)e);
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, ExceptionUtils.getMessageWithCauses((Throwable)e));
                return status;
            }
            this.generateSQLqueryIfRequired(init, authCtx, status, selectedEngine);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.join.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
        }
        return status;
    }

    public List<RecipeEngineStatus> getEnginesStatus(AuthCtx authCtx, StatusInitializer init) throws Exception {
        String mainConnectionName;
        AbstractSQLConnection mainConnection;
        ArrayList<RecipeEngineStatus> ret = new ArrayList<RecipeEngineStatus>();
        JobActivity activity = init.activity;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus dss = this.visualRecipesService.makeDSSBasedEngineStatus();
        VisualSQLRecipesBaseService.SQLBasedEngineStatus sql = this.visualRecipesService.makeSQLEngineStatus(authCtx, activity);
        dss.canFullOuterJoin = true;
        if (sql.isSelectable && ("PostgreSQL".equals((mainConnection = SQLConnectionProvider.getDSSConnection(authCtx, mainConnectionName = SQLQueryRecipeRunner.getMainSingleConnection(authCtx, (RecipeRunnableSubgraph)init.activity.getSubgraph(), this.datasetsDAO))).getType()) || "AlloyDB".equals(mainConnection.getType()))) {
            sql.canFullOuterJoin = false;
        }
        ret.add(dss);
        ret.add(sql);
        return ret;
    }

    private void generateSQLqueryIfRequired(StatusInitializer init, AuthCtx authCtx, GeoJoinRecipeStatus status, VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine) {
        if (selectedEngine.type.equals("DSS")) {
            return;
        }
        try {
            boolean lowerCaseColumnsNames = status.params.engineParams.lowerCaseSchemaIfEngineRequiresIt && selectedEngine.lowercasesColumnNames();
            status.sql = init.helper.generateSQLIgnorePartitioning(authCtx, init.activity, init.dialect, status.params, lowerCaseColumnsNames);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to generate SQL query", (Throwable)e);
            init.error = e.getMessage();
        }
    }

    private void checkEngines(AuthCtx authCtx, GeoJoinRecipeStatus status, GeoJoinRecipePayloadParams params, StatusInitializer init) {
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            this.checkEngine(authCtx, engine, status, params, engine.equals(status.getSelectedSQLBasedEngine()), init);
        }
    }

    private void checkEngine(AuthCtx authCtx, VisualSQLRecipesBaseService.SQLBasedEngineStatus engine, GeoJoinRecipeStatus status, GeoJoinRecipePayloadParams params, boolean engineIsSelected, StatusInitializer init) {
        if (engine.isSelectable) {
            if (engine.type.equals("DSS") && engineIsSelected) {
                JoinLikeStatusUtils.warnIfExpectedEngineIsNotSelectable(init.sources, status.getEngines(), status.join);
            }
            JoinLikeStatusUtils.checkFullOuterJoinSupport(engine, engineIsSelected, params.joins, status.join);
            JoinLikeStatusUtils.checkJoinMatchDeduplication(engine, engineIsSelected, status.join, params.joins);
            if (engine.queryBased) {
                try {
                    boolean translateFully = !engine.type.equals("DSS");
                    SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                    for (JoinInputDescBase virtualInput : params.virtualInputs) {
                        if (virtualInput.preFilter == null || !virtualInput.preFilter.enabled) continue;
                        FilterDescUtils.getSQLExpression(virtualInput.preFilter, dialect, null, translateFully);
                    }
                    if (params.postFilter != null && params.postFilter.enabled) {
                        FilterDescUtils.getSQLExpression(params.postFilter, dialect, null, translateFully);
                    }
                }
                catch (Exception e) {
                    if (engine.type.equals("DSS")) {
                        RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    }
                    RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                }
            }
        }
    }

    private void checkSnowflakeMatchingConditions(GeoJoinRecipeStatus status) {
        for (GeoJoinRecipePayloadParams.JoinDesc join : status.params.joins) {
            for (GeoJoinRecipePayloadParams.MatchingCondition matchingCondition : join.on) {
                if (matchingCondition.type != GeoJoinRecipePayloadParams.MatchingType.TOUCHES) continue;
                status.join.withFatal(RecipeCodes.ERR_RECIPE_JOIN_INVALID_JOIN, "Operator TOUCHES is not supported by SnowFlake.");
                return;
            }
        }
    }

    private static class StatusInitializer {
        public JobActivity activity;
        public String error;
        GeoJoinRecipeHelper helper;
        List<Dataset> sources;
        SQLDialect dialect;

        private StatusInitializer() {
        }
    }

    public static class GeoJoinRecipeStatus
    extends VisualSQLRecipeStatus
    implements JoinLikeRecipeStatus {
        public Schema outputSchemaWithoutComputedColumns;
        RecipeStatus.StepStatus preFilters;
        RecipeStatus.StepStatus join = new RecipeStatus.StepStatus();
        ColumnsStepStatus selectedColumns = new ColumnsStepStatus();
        RecipeStatus.StepStatus postFilter;
        GeoJoinRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            ret.mergeFrom((InfoMessage.InfoMessages)this.preFilters);
            ret.mergeFrom((InfoMessage.InfoMessages)this.join);
            ret.mergeFrom((InfoMessage.InfoMessages)this.selectedColumns);
            ret.mergeFrom((InfoMessage.InfoMessages)this.postFilter);
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }

        @Override
        public void setOutputSchema(Schema schema) {
            this.outputSchema = schema;
        }

        @Override
        public ColumnsStepStatus getSelectedColumns() {
            return this.selectedColumns;
        }

        @Override
        public void initOutputSchema(AuthCtx authCtx, JobActivity activity, String payload) throws Exception {
            GeoJoinRecipeSchemaComputer schemaComputer = new GeoJoinRecipeSchemaComputer(authCtx, activity);
            schemaComputer.setPayload(payload);
            this.setOutputSchema(schemaComputer.getSchema());
            this.outputSchemaWithoutComputedColumns = schemaComputer.getSchema();
        }
    }
}

