/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.geojoin.geotools;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.geojoin.geotools.RowInputStreamDataStore;
import com.dataiku.dip.datalayer.sort.NumberedRow;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class RowFactoryFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final RowInputStreamDataStore dataStore;
    protected ContentState state;
    private SimpleFeature next;
    protected SimpleFeatureBuilder builder;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.geojoin.geotools");

    public RowFactoryFeatureReader(ContentState state, Query query) {
        this.state = state;
        this.dataStore = (RowInputStreamDataStore)state.getEntry().getDataStore();
        this.builder = new SimpleFeatureBuilder(state.getFeatureType());
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature;
        if (this.next != null) {
            feature = this.next;
            this.next = null;
        } else {
            feature = this.readFeature();
        }
        return feature;
    }

    SimpleFeature readFeature() {
        GeometryMeaning geometryMeaning = new GeometryMeaning();
        NumberedRow numberedRow = null;
        try {
            numberedRow = this.dataStore.rowInputStream.next();
        }
        catch (NoSuchElementException e) {
            logger.errorV((Throwable)e, "Not found datastore element", new Object[0]);
            return null;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Failed to read input stream", new Object[0]);
        }
        if (numberedRow == null) {
            return null;
        }
        for (SchemaColumn column : this.dataStore.columns) {
            String columnName = column.getName();
            String value = numberedRow.row.get(this.dataStore.cf.column(columnName));
            if (value == null) {
                this.builder.set(columnName, null);
                continue;
            }
            if (column.getType() == Type.GEOMETRY || column.getType() == Type.GEOPOINT) {
                this.builder.set(columnName, (Object)geometryMeaning.toGeometry(value));
                continue;
            }
            this.builder.set(columnName, (Object)value);
        }
        SimpleFeature feature = this.builder.buildFeature(String.valueOf(numberedRow.number));
        this.dataStore.featuresById.put(numberedRow.number, feature);
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (this.next != null) {
            return true;
        }
        this.next = this.readFeature();
        return this.next != null;
    }

    public void close() throws IOException {
    }
}

