/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.listaccess;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.listaccess.ContainerizedListAccessRecipeExecutor;
import com.dataiku.dip.dataflow.exec.listaccess.ListAccessRecipeExecutor;
import com.dataiku.dip.dataflow.exec.listaccess.ListAccessRecipeParams;
import com.dataiku.dip.dataflow.exec.listaccess.ListAccessRecipeStreamExecutor;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.azure.AzureADSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ListAccessRecipeRunner
implements RecipeRunner,
AbortableRecipeRunner,
ContainerizedDSSEngineAble {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    private final JobActivity activity;
    private ListAccessRecipeExecutor executor;
    private boolean isRunningInContainer;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.runner.list_access");

    public ListAccessRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.activity.initStatus();
    }

    @Override
    public void init() throws Exception {
        this.activity.setStatusMessage("Initializing");
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        if (!(authCtx instanceof DSSAuthCtx)) {
            throw new IllegalStateException("Your user needs the proper DSS authentication to run this recipe.");
        }
        ListAccessRecipeParams params = (ListAccessRecipeParams)JSON.deepCopy((Object)RecipeRegistry.getParamsAs(this.activity, ListAccessRecipeParams.class));
        this.checkAzureADSettings(authCtx, params);
        FlowRecipe recipe = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        this.executor = this.getExecutor(recipe, params);
    }

    @Override
    public void run() throws Exception {
        this.executor.run();
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void notifyBeforeAborting() {
        this.executor.notifyBeforeAborting();
    }

    private void checkAzureADSettings(AuthCtx authCtx, ListAccessRecipeParams params) throws IOException, UnauthorizedException {
        GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafeAutoTXN();
        if (generalSettings == null) {
            throw new IllegalStateException("Error retrieving general settings.");
        }
        if (generalSettings.azureADSettings == null) {
            throw new IllegalStateException("Error retrieving Azure AD settings.");
        }
        if (!generalSettings.azureADSettings.isEnabled()) {
            throw new IllegalStateException("Azure AD settings are not enabled. Please contact your admin to enable them via Settings > Security & Audit > User login & provisioning > Azure AD.");
        }
        if (!authCtx.isAdmin()) {
            RunnableSubgraph subgraph;
            FlowRecipe recipe;
            if (generalSettings.azureADSettings.azureADGroupsRetrievableBy == null) {
                throw new IllegalStateException("Error retrieving Azure AD settings.");
            }
            if (generalSettings.azureADSettings.azureADGroupsRetrievableBy.equals((Object)AzureADSettings.AzureADGroupsRetrievableBy.NOBODY) && ((recipe = ((RecipeRunnableSubgraph)(subgraph = this.activity.getSubgraph())).getRecipe()).getPredecessors().size() != 2 || recipe.getPredecessors().get(1) == null || StringUtils.isEmpty((String)params.manualMappingDssGroupCol) || StringUtils.isEmpty((String)params.manualMappingEntraGroupCol))) {
                throw new UnauthorizedException("This recipe requires permission to read Azure AD groups. Please contact your admin to enable it via Settings > Security & Audit > User login & provisioning > Azure AD > Permissions. Alternatively, you can add a manual mapping as an input and set the corresponding column to map DSS groups to Entra groups.", "unauthorized-to-retrieve-azuread-groups");
            }
        }
    }

    private ListAccessRecipeExecutor getExecutor(FlowRecipe recipe, ListAccessRecipeParams params) throws IOException, DKUSecurityException {
        JobContext.getCurrentActivitySummary().engineType = "DSS";
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, params.engineParams.containerSelection, recipe.getModel(), null);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            return new ContainerizedListAccessRecipeExecutor(recipe, this.activity, containerConfig);
        }
        return new ListAccessRecipeStreamExecutor(this.authCtxService.getAuthCtx(), this.activity, params);
    }
}

