/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.partitioning.Partition;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

public class SubgraphPrinter {
    private static String indent(int indent) {
        Object s = "";
        for (int i = 0; i < indent; ++i) {
            s = (String)s + "  ";
        }
        return s;
    }

    public static String print(RunnableSubgraph subgraph, int startIndent, boolean header) {
        StringBuilder sb = new StringBuilder();
        if (header) {
            sb.append(SubgraphPrinter.indent(startIndent) + "SUBGRAPH\n");
        }
        sb.append(SubgraphPrinter.indent(startIndent + 1) + "SGID: " + subgraph.id() + "\n");
        for (FlowComputable flowComputable : subgraph.getSources()) {
            sb.append(SubgraphPrinter.indent(startIndent + 1) + "SRC: " + flowComputable.getFullId());
            if (subgraph.getSourcePartitions() != null && subgraph.getSourcePartitions(flowComputable) != null) {
                ArrayList<String> l = new ArrayList<String>();
                for (Partition p : subgraph.getSourcePartitions(flowComputable)) {
                    l.add(p.id());
                }
                sb.append(" (partitions: " + StringUtils.join(l, (String)", ") + ")");
            }
            sb.append("\n");
        }
        for (FlowComputable flowComputable : subgraph.getTargets()) {
            sb.append(SubgraphPrinter.indent(startIndent + 1) + "DST: " + flowComputable.getFullId());
            if (subgraph.getTargetPartition(flowComputable) != null) {
                sb.append(" (partition: " + subgraph.getTargetPartition(flowComputable).id() + ")");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String print(FlowRecipe subgraph, int startIndent) {
        StringBuilder sb = new StringBuilder();
        sb.append(SubgraphPrinter.indent(startIndent) + "RECIPE\n");
        for (GraphNode graphNode : subgraph.getSources()) {
            sb.append(SubgraphPrinter.indent(startIndent + 1) + " SRC: " + graphNode.getFullId());
            sb.append("\n");
        }
        for (FlowComputable flowComputable : subgraph.getTargets()) {
            sb.append(SubgraphPrinter.indent(startIndent + 1) + " DST: " + flowComputable.getFullId());
            sb.append("\n");
        }
        return sb.toString();
    }
}

