/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master.postactions;

import com.dataiku.dip.dataflow.kernel.master.postactions.CleanupH2Databases;
import com.dataiku.dip.dataflow.kernel.master.postactions.CompressLocalconfig;
import com.dataiku.dip.dataflow.kernel.master.postactions.ReduceActivityProcessOutputLogs;
import com.dataiku.dip.dataflow.kernel.master.postactions.ReduceJobLogs;
import com.dataiku.dip.dataflow.kernel.master.postactions.RemoveDanglingPods;
import com.dataiku.dip.dataflow.kernel.master.postactions.RemoveIntermediatePartitionedModelVersions;
import com.dataiku.dip.server.services.AsyncTasksService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostJobActionsHandler {
    @Autowired
    private AsyncTasksService asyncTasksService;

    public void onEndOfJob(String projectKey, String jobId) {
        this.asyncTasksService.enqueue("post-job-actions", "Post job actions projectKey=" + projectKey + " jobId= " + jobId, new JobCleanuper(projectKey, jobId));
    }

    public static class JobCleanuper
    implements Runnable {
        private final String projectKey;
        private final String jobId;

        JobCleanuper(String projectKey, String jobId) {
            this.projectKey = projectKey;
            this.jobId = jobId;
        }

        @Override
        public void run() {
            try {
                new CleanupH2Databases(this.projectKey, this.jobId).run();
                new ReduceJobLogs(this.projectKey, this.jobId).run();
                new ReduceActivityProcessOutputLogs(this.projectKey, this.jobId).run();
                new RemoveDanglingPods(this.projectKey, this.jobId).run();
                new CompressLocalconfig(this.projectKey, this.jobId).run();
                new RemoveIntermediatePartitionedModelVersions(this.projectKey, this.jobId).run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

