/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Partitionable;
import com.dataiku.dip.dataflow.pdep.AllAvailableEvaluator;
import com.dataiku.dip.dataflow.pdep.CurrentMonthEvaluator;
import com.dataiku.dip.dataflow.pdep.CurrentWeekEvaluator;
import com.dataiku.dip.dataflow.pdep.CustomPythonDependencyEvaluator;
import com.dataiku.dip.dataflow.pdep.DimensionDependencyEvaluator;
import com.dataiku.dip.dataflow.pdep.DimensionDependencySpec;
import com.dataiku.dip.dataflow.pdep.EqualsEvaluator;
import com.dataiku.dip.dataflow.pdep.LatestAvailableEvaluator;
import com.dataiku.dip.dataflow.pdep.SlidingDaysEvaluator;
import com.dataiku.dip.dataflow.pdep.TimeRangeEvaluator;
import com.dataiku.dip.dataflow.pdep.ValuesEvaluator;
import com.dataiku.dip.dataflow.pdep.WholeMonthEvaluator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Params;
import com.dataiku.dip.variables.VariablesService;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluatorFactory {
    private static Logger logger = Logger.getLogger((String)"dku.pdep");

    public static Set<Date> parseBlackList(String blackList) throws Exception {
        String[] dates;
        SimpleDateFormat fmt = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd");
        HashSet<Date> bl = new HashSet<Date>();
        Calendar cal = DKUtils.getUTCCalendar();
        for (String d : dates = blackList.split(",")) {
            if (d.length() == 0) continue;
            if (d.contains("/")) {
                String[] range = d.split("/", 2);
                Date first = fmt.parse(range[0]);
                Date last = fmt.parse(range[1]);
                Date pos = first;
                while (pos.before(last) || pos.equals(last)) {
                    bl.add(pos);
                    cal.setTime(pos);
                    cal.add(5, 1);
                    pos = cal.getTime();
                }
                continue;
            }
            bl.add(fmt.parse(d));
        }
        return bl;
    }

    public static DimensionDependencyEvaluator build(AuthCtx authCtx, String projectKey, VariablesService variablesService, Partitionable dataset, DimensionDependencySpec spec, boolean isAllTargetPartitions) throws Exception {
        Params p = new Params(spec.params);
        String flowEpochStr = ApplicationConfigurator.getProperty((String)"flowEpoch", (String)"1970-01-01");
        if (dataset != null && dataset.getFlowOptions().flowEpoch != null) {
            flowEpochStr = dataset.getFlowOptions().flowEpoch;
        }
        Date flowEpoch = DKUtils.getSimpleDateFormatUTCStrict((String)"yyyy-MM-dd").parse(flowEpochStr);
        String dateBlackList = ApplicationConfigurator.getProperty((String)"dateBlacklist", (String)"");
        if (dataset != null && dataset.getFlowOptions().dateBlacklist != null) {
            dateBlackList = dataset.getFlowOptions().dateBlacklist;
            logger.info((Object)("Using per-dataset blacklist " + dateBlackList));
        }
        Set<Date> blacklist = EvaluatorFactory.parseBlackList(dateBlackList);
        switch (spec.function) {
            case "time_range": {
                return new TimeRangeEvaluator(blacklist, flowEpoch, p);
            }
            case "sliding_days": {
                int firstDay = p.getIntParam("firstDay");
                int lastDay = p.getIntParam("lastDay", Integer.valueOf(0));
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new SlidingDaysEvaluator(blacklist, flowEpoch, firstDay, lastDay);
            }
            case "current_month": {
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new CurrentMonthEvaluator(blacklist, flowEpoch);
            }
            case "current_week": {
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new CurrentWeekEvaluator(blacklist, flowEpoch, p.getParam("weekStartsOn", "monday"));
            }
            case "equals": {
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new EqualsEvaluator();
            }
            case "whole_month": {
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new WholeMonthEvaluator(blacklist, flowEpoch);
            }
            case "values": {
                if (dataset == null) {
                    throw ErrorContext.iae((String)"Explicit values dependency requires a dataset");
                }
                if (spec.values == null || spec.values.size() == 0) {
                    throw ErrorContext.iaef((String)"Explicit values dependency (for dataset %s), values are required", (Object)dataset.getFullName(), (Object[])new Object[0]);
                }
                return new ValuesEvaluator(spec.values, spec.expandVariables, variablesService.getContext(projectKey));
            }
            case "latest_available": {
                return new LatestAvailableEvaluator(authCtx, dataset);
            }
            case "all_available": {
                return new AllAvailableEvaluator(authCtx, dataset, false);
            }
            case "custom_python": {
                return isAllTargetPartitions ? new AllAvailableEvaluator(authCtx, dataset, true) : new CustomPythonDependencyEvaluator(p.getMandParam("code"), variablesService.getContext(projectKey));
            }
        }
        throw new IllegalArgumentException("Unknown partition dependency type " + spec.function);
    }
}

