/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineElement;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.SqlPipelineRecipeParams;
import com.dataiku.dip.recipes.shaker.ShakerRecipeParams;
import com.dataiku.dip.recipes.shaker.ShakerSparkRecipeDefBuilder;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.processors.PrepareSnowflakeUDFUtils;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.shaker.sql.ShakerSQLTranslator;
import com.dataiku.dip.shaker.sql.SqlQueryWithSchemaBuilder;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SparkSQLDialect;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class ShakerRecipePipelineHelper
extends RecipePipelineHelper {
    ShakerRecipeParams params;
    private ShakerRecipeParams.SparkParams sparkParams;
    private SqlPipelineRecipeParams sqlPipelineParams;
    private String engineType;

    public ShakerRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void initialize(JobActivity jobActivity) {
        this.params = this.recipe.getParamsAs(ShakerRecipeParams.class);
        this.engineType = this.params.engineType;
        if (this.engineType == null) {
            this.engineType = this.engineType();
        }
    }

    @Override
    protected void initializeForSpark() {
        this.sparkParams = this.params.engineParams.spark;
        this.allowPipelineStart = this.sparkParams.pipelineAllowStart;
        this.allowPipelineMerge = this.sparkParams.pipelineAllowMerge;
    }

    @Override
    protected void initializeForSql() {
        this.sqlPipelineParams = this.params.engineParams.sqlPipelineParams;
        this.allowPipelineStart = this.sqlPipelineParams.pipelineAllowStart;
        this.allowPipelineMerge = this.sqlPipelineParams.pipelineAllowMerge;
    }

    @Override
    protected String generateSqlQuery(JobActivity activity, SQLDialect dialect) throws Exception {
        throw new Error("unreachable");
    }

    @Override
    List<SqlPipelineElement> generateSqlQueries(JobActivity activity, SQLDialect dialect) throws Exception {
        SqlQueryWithSchemaBuilder sqlQueryWithSchemaBuilder = new SqlQueryWithSchemaBuilder(activity);
        ShakerSQLTranslator.TranslatorResult translatorResult = sqlQueryWithSchemaBuilder.setDialect(dialect).setPayload(this.payload).init().build();
        ArrayList<String> setupQueries = new ArrayList<String>();
        ArrayList<String> teardownQueries = new ArrayList<String>();
        AbstractSQLConnection conn = sqlQueryWithSchemaBuilder.getDSSConnection();
        if (PrepareSnowflakeUDFUtils.canUseSnowflakeUDF(conn)) {
            PrepareSnowflakeUDFUtils.fillPrePostQueriesForUDF(conn, translatorResult, setupQueries, teardownQueries);
        }
        String sqlQuery = translatorResult.translated.toSQL(dialect);
        return ImmutableList.of((Object)new SqlPipelineElement(activity, sqlQuery).withSetupSqlQueries(setupQueries).withTeardownSqlQueries(teardownQueries));
    }

    @Override
    String setSparkPipelineability(boolean allowStart, boolean allowMerge) {
        this.sparkParams.pipelineAllowStart = allowStart;
        this.sparkParams.pipelineAllowMerge = allowMerge;
        return this.payload;
    }

    @Override
    String setSqlPipelineability(boolean allowStart, boolean allowMerge) {
        this.sqlPipelineParams.pipelineAllowStart = allowStart;
        this.sqlPipelineParams.pipelineAllowMerge = allowMerge;
        return this.payload;
    }

    @Override
    protected void assertConfiguration() {
        assert (this.isValidEngine());
    }

    @Override
    protected String getEngineType() {
        return this.engineType;
    }

    @Override
    protected boolean isValidConfiguration() {
        return true;
    }

    @Override
    protected boolean useGlobalMetastore() {
        return this.sparkParams.useGlobalMetastore;
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.shaker = new ShakerSparkRecipeDefBuilder(activity, gatherer).build();
    }

    @Override
    protected SparkOverrideConfig sparkConfig() {
        return this.sparkParams.sparkConfig;
    }

    @Override
    protected AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine() {
        return this.sparkParams.executionEngine;
    }
}

