/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.refactoring;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.recipes.ManagedDatasetsCreationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowRefactoringService {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private ManagedDatasetsCreationService managedDatasetsCreationService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.refactoring");

    public ConnectionsChangeStartResponse startChangeConnections_NT(String projectKey, Set<TaggableObjectsService.TaggableObjectRef> items, AuthCtx authCtx) throws IOException {
        ConnectionsChangeStartResponse cci = new ConnectionsChangeStartResponse();
        this.checkOnlyLocalDatasetsAndFolders(items);
        try (Transaction t = this.transactionService.beginRead();){
            ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
            this.collectInfoMessages(items, graph, cci.messages);
            cci.connections = this.getUsableConnections(items, graph, authCtx);
        }
        return cci;
    }

    public ConnectionsChangeTestResponse testChangeConnections_NT(String projectKey, Collection<TaggableObjectsService.TaggableObjectRef> refs, ChangeConnectionsOptions options, AuthCtx authCtx) throws Exception {
        this.checkOnlyLocalDatasetsAndFolders(refs);
        this.checkOptions(options);
        ConnectionsChangeTestResponse ret = new ConnectionsChangeTestResponse();
        ArrayList<Dataset> datasets = new ArrayList<Dataset>(refs.size());
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            DSSConnection targetConnection = this.getAndValidateTargetConnection(projectKey, refs, authCtx, options, ret);
            InfoMessage.InfoMessages partitioningIssues = this.checkPartitioningIssues(authCtx, refs, targetConnection);
            if (partitioningIssues.anyFatal()) {
                ret.addMessage(partitioningIssues.firstFatal());
                ConnectionsChangeTestResponse connectionsChangeTestResponse = ret;
                return connectionsChangeTestResponse;
            }
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                if (ref.type != ITaggingService.TaggableType.DATASET) continue;
                datasets.add(this.prepareDataset(ref, options, targetConnection));
            }
        }
        for (Dataset dataset : datasets) {
            DatasetTestHandler dh = DatasetHandlerFactory.buildTestHandlerAs(authCtx, dataset, DatasetTestHandler.class);
            try {
                ret.mergeFrom(dh.checkManagedDatasetNameSafety(dataset.getName()));
            }
            finally {
                if (dh == null) continue;
                dh.close();
            }
        }
        return ret;
    }

    private InfoMessage.InfoMessages checkPartitioningIssues(AuthCtx authCtx, Collection<TaggableObjectsService.TaggableObjectRef> refs, DSSConnection targetConnection) throws IOException, DKUSecurityException {
        boolean targetConnectionIsFS = targetConnection.isFS();
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            String connectionName;
            if (ref.type != ITaggingService.TaggableType.DATASET) continue;
            SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(ref.getLoc().resolved());
            if (!sds.partitioning.isPartitioned() || !StringUtils.isNotBlank((String)(connectionName = sds.getParams().getConnection()))) continue;
            DSSConnection sourceConnection = this.connectionsDAO.getConnection(authCtx, connectionName);
            boolean sourceConnectionIsFS = sourceConnection.isFS();
            if (sourceConnectionIsFS && !targetConnectionIsFS) {
                messages.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot move partitioned datasets from filesystem-like connections to non filesystem-like");
            }
            if (sourceConnectionIsFS || !targetConnectionIsFS) continue;
            messages.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot move partitioned datasets from non filesystem-like connections to filesystem-like");
        }
        return messages;
    }

    public InfoMessage.InfoMessages changeConnections_NT(String projectKey, List<TaggableObjectsService.TaggableObjectRef> refs, ChangeConnectionsOptions options, AuthCtx authCtx) throws Exception {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        ConnectionsChangeTestResponse testRes = this.testChangeConnections_NT(projectKey, refs, options, authCtx);
        if (testRes.anyFatal()) {
            return testRes;
        }
        LinkedList<TaggableObjectsService.TaggableObject> datasetsToDrop = new LinkedList<TaggableObjectsService.TaggableObject>();
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            DSSConnection connection = this.getAndValidateTargetConnection(projectKey, refs, authCtx, options, messages);
            for (TaggableObjectsService.TaggableObjectRef ref : refs) {
                if (!this.isMoveable(ref)) {
                    logger.info((Object)(ref.toString() + " is not moveable, skipping"));
                    continue;
                }
                TaggableObjectsService.TaggableObject originalDataset = this.doChangeConnection(ref, options, connection, authCtx);
                if (originalDataset == null || !options.dropData) continue;
                datasetsToDrop.add(originalDataset);
            }
            String commitMsg = "Change datasets connections for dataset " + String.valueOf(refs.size() == 1 ? refs.get(0).getLoc().getFullName() : refs.get(0)) + (options.dropData ? " and dropping old data" : "");
            t.commit(commitMsg);
        }
        if (!datasetsToDrop.isEmpty()) {
            datasetsToDrop.forEach(dataset -> {
                this.dropData(authCtx, (TaggableObjectsService.TaggableObject)dataset, messages);
                logger.infoV("Dropped old data from dataset '%s'", new Object[]{dataset.getDisplayName()});
            });
        }
        return messages;
    }

    TaggableObjectsService.TaggableObject doChangeConnection(TaggableObjectsService.TaggableObjectRef ref, ChangeConnectionsOptions options, DSSConnection connection, AuthCtx authCtx) throws Exception {
        if (ref.type == ITaggingService.TaggableType.DATASET) {
            Dataset newDataset = this.prepareDataset(ref, options, connection);
            SerializedDataset existingDataset = (SerializedDataset)this.datasetsDAO.getMandatory(newDataset.getLoc());
            SerializedDataset originalDataset = Dataset.fromSerialized(existingDataset).serialize();
            existingDataset.setParams(newDataset.getParams());
            existingDataset.formatType = newDataset.getFormatType();
            existingDataset.setFormatParams(newDataset.getFormatParams());
            existingDataset.type = newDataset.getType();
            VersionTag.increment(existingDataset.versionTag, authCtx.getIdentifier());
            if (this.neverBuiltComputablesCacheService.canBeAdded(newDataset)) {
                this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(newDataset.serialize()));
            }
            this.datasetSaveService.save(newDataset.getLoc(), existingDataset, authCtx);
            return originalDataset;
        }
        if (ref.type == ITaggingService.TaggableType.MANAGED_FOLDER) {
            ManagedFolder newManagedFolder = this.prepareManagedFolder(ref, options, connection);
            ManagedFolder existingFolder = this.managedFoldersService.getMandatory(ref.projectKey, ref.id);
            ManagedFolder originalFolder = new ManagedFolder(existingFolder);
            existingFolder.type = newManagedFolder.getType();
            existingFolder.setParams(newManagedFolder.getParams());
            VersionTag.increment(existingFolder.versionTag, authCtx.getIdentifier());
            this.managedFoldersService.save(existingFolder, false, false);
            return originalFolder;
        }
        return null;
    }

    void dropData(AuthCtx authCtx, TaggableObjectsService.TaggableObject dataToDrop, InfoMessage.InfoMessages messages) {
        block9: {
            try {
                if (dataToDrop.getTaggableType().equals((Object)ITaggingService.TaggableType.MANAGED_FOLDER)) {
                    this.managedFoldersService.clear(authCtx, (ManagedFolder)dataToDrop);
                    break block9;
                }
                if (!dataToDrop.getTaggableType().equals((Object)ITaggingService.TaggableType.DATASET)) break block9;
                Dataset datasetToDrop = Dataset.fromSerialized((SerializedDataset)dataToDrop);
                try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, datasetToDrop);){
                    dh.clearAllDataAndStructure();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while clearing dataset " + dataToDrop.getDisplayName() + ": "), (Throwable)e);
                messages.withWarningV((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DELETION_DATA_FAILED, "Unable to clear data for %s %s: %s", new Object[]{dataToDrop.getTaggableType(), dataToDrop.getDisplayName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
        }
    }

    private Dataset prepareDataset(TaggableObjectsService.TaggableObjectRef ref, ChangeConnectionsOptions options, DSSConnection connection) throws IOException, CodedException {
        SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatory(ref.getLoc());
        Dataset ds = Dataset.fromSerialized(sds);
        sds.type = connection.getMainManagedDatasetType();
        DatasetHandler.DatasetMeta<?, ?> newMeta = DatasetHandlerFactory.getMeta(sds.type);
        newMeta.fillManagedDatasetParams(ds, connection, options.specificSettings, options.useExistingParams);
        return ds;
    }

    private ManagedFolder prepareManagedFolder(TaggableObjectsService.TaggableObjectRef ref, ChangeConnectionsOptions options, DSSConnection connection) throws IOException, CodedException {
        ManagedFolder mf = this.managedFoldersService.getMandatory(ref.projectKey, ref.id);
        mf.type = connection.getMainManagedDatasetType();
        DatasetHandler.DatasetMeta<?, ?> newMeta = DatasetHandlerFactory.getMeta(mf.getType());
        newMeta.fillManagedFolderParams(mf, connection, options.useExistingParams);
        return mf;
    }

    private DSSConnection getAndValidateTargetConnection(String projectKey, Collection<TaggableObjectsService.TaggableObjectRef> items, AuthCtx authCtx, ChangeConnectionsOptions options, InfoMessage.InfoMessages messages) throws IOException, DKUSecurityException {
        ProjectFlowGraph graph = this.graphService.getProjectGraphUnsafe(projectKey);
        this.collectInfoMessages(items, graph, messages);
        Collection<ConnectionUsability> connections = this.getUsableConnections(items, graph, authCtx);
        for (ConnectionUsability cu : connections) {
            if (!cu.name.equals(options.connection) || cu.usable) continue;
            throw ErrorContext.iaef((String)"Selected connection is not usable: %s", (Object)cu.reason, (Object[])new Object[0]);
        }
        return this.connectionsDAO.getConnection(authCtx, options.connection);
    }

    private void checkOnlyLocalDatasetsAndFolders(Collection<TaggableObjectsService.TaggableObjectRef> refs) {
        Preconditions.checkNotNull(refs, (Object)"No items provided");
        for (TaggableObjectsService.TaggableObjectRef ref : refs) {
            if (ref.type != ITaggingService.TaggableType.DATASET && ref.type != ITaggingService.TaggableType.MANAGED_FOLDER) {
                throw ErrorContext.iaef((String)"Expected only datasets and managed folders, got type: %s", (Object)((Object)ref.type), (Object[])new Object[0]);
            }
            if (StringUtils.equals((String)ref.getLoc().resolved().getProjectKey(), (String)ref.getLoc().getProjectKey())) continue;
            throw ErrorContext.iae((String)"Connot change connection for exposed objects");
        }
    }

    private void checkOptions(ChangeConnectionsOptions options) {
        Preconditions.checkNotNull((Object)options, (Object)"No options provided");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)options.connection), (Object)"No connection provided");
    }

    private Collection<ConnectionUsability> getUsableConnections(Collection<TaggableObjectsService.TaggableObjectRef> items, FlowGraph graph, AuthCtx authCtx) throws IOException {
        Collection<ConnectionWithUsability> connections = this.getAuthorizedConnections(authCtx);
        for (TaggableObjectsService.TaggableObjectRef item : items) {
            if (item.type != ITaggingService.TaggableType.MANAGED_FOLDER) continue;
            this.disableNonFs(connections, "Managed folders can only be stored in file systems");
            break;
        }
        for (TaggableObjectsService.TaggableObjectRef item : items) {
            FlowDataset fds;
            if (item.type != ITaggingService.TaggableType.DATASET || (fds = graph.datasets.get(item.getLoc().getFullName())) == null || fds.getSuccessors() == null) continue;
            for (GraphNode graphNode : fds.getSuccessors()) {
                if (!(graphNode instanceof FlowRecipe)) continue;
                FlowRecipe fr = (FlowRecipe)graphNode;
                switch (fr.getModel().type) {
                    case "sql_query": 
                    case "sql_script": {
                        this.disableNonSql(connections, item.id + " is used as input of an SQL recipe");
                        break;
                    }
                    case "hive": 
                    case "pig": 
                    case "impala": {
                        this.disableNonHDFS(connections, item.id + " is used as input of an SQL recipe");
                    }
                }
            }
        }
        return this.getConnectionHeaders(connections);
    }

    private boolean isMoveable(TaggableObjectsService.TaggableObjectRef item) throws IOException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        this.collectInfoMessages(Lists.newArrayList((Object[])new TaggableObjectsService.TaggableObjectRef[]{item}), null, messages);
        return !messages.anyFatal();
    }

    void collectInfoMessages(Collection<TaggableObjectsService.TaggableObjectRef> items, FlowGraph graph, InfoMessage.InfoMessages messages) throws IOException {
        boolean anyMovable = false;
        boolean anyForeign = false;
        HashSet<String> forbiddenTypes = new HashSet<String>();
        boolean anyUnmanaged = false;
        for (TaggableObjectsService.TaggableObjectRef item : items) {
            FlowManagedFolder fds;
            boolean isLocal = item.getLoc().resolved().getId().equals(item.getLoc().getId());
            if (!isLocal) {
                anyForeign = true;
                continue;
            }
            if (item.type == ITaggingService.TaggableType.DATASET) {
                FlowDataset fds2;
                SerializedDataset sds = (SerializedDataset)this.datasetsDAO.getMandatoryUnsafe(item.getLoc());
                String connectionName = sds.getParams().getConnection();
                if (StringUtils.isBlank((String)connectionName)) {
                    forbiddenTypes.add(sds.type);
                    continue;
                }
                if (!sds.managed) {
                    anyUnmanaged = true;
                    continue;
                }
                anyMovable = true;
                if (graph == null || (fds2 = graph.datasets.get(item.getLoc().getFullName())) != null && !fds2.getPredecessors().isEmpty()) continue;
                messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Dataset " + item.id + " has no predecessor in the graph, it won't be possible to rebuild it");
                continue;
            }
            if (item.type != ITaggingService.TaggableType.MANAGED_FOLDER) continue;
            anyMovable = true;
            if (graph == null || (fds = graph.folders.get(item.getLoc().getFullName())) != null && !fds.getPredecessors().isEmpty()) continue;
            messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Folder " + item.id + " has no predecessor in the graph, it won't be possible to rebuild it");
        }
        if (!anyMovable) {
            messages.withFatal((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot change the connection for any of the specified items");
        } else {
            if (anyForeign) {
                messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot change connection for foreign datasets");
            }
            if (anyUnmanaged) {
                messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot change connection for unmanaged datasets");
            }
            if (!forbiddenTypes.isEmpty()) {
                messages.withWarning((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_ACTION_NOT_SUPPORTED, "Cannot change connection for dataset types " + ((Object)forbiddenTypes).toString());
            }
        }
    }

    private void disableNonSql(Collection<ConnectionWithUsability> connections, String reason) {
        for (ConnectionWithUsability c2 : connections) {
            if (c2.connection.isProperSQL() || !c2.usable) continue;
            c2.usable = false;
            c2.reason = reason;
        }
    }

    private void disableNonFs(Collection<ConnectionWithUsability> connections, String reason) {
        for (ConnectionWithUsability c2 : connections) {
            if (c2.connection.isFS() || !c2.usable) continue;
            c2.usable = false;
            c2.reason = reason;
        }
    }

    private void disableNonHDFS(Collection<ConnectionWithUsability> connections, String reason) {
        for (ConnectionWithUsability c2 : connections) {
            if ("HDFS".equals(c2.connection.type) || !c2.usable) continue;
            c2.usable = false;
            c2.reason = reason;
        }
    }

    private Collection<ConnectionWithUsability> getAuthorizedConnections(AuthCtx authCtx) throws IOException {
        ArrayList<ConnectionWithUsability> ret = new ArrayList<ConnectionWithUsability>();
        for (DSSConnection c2 : this.connectionsDAO.listUnsafe().values()) {
            if (!c2.allowManagedDatasets || !c2.isFreelyUsableBy(authCtx)) continue;
            ConnectionWithUsability u = new ConnectionWithUsability(c2);
            u.formats = this.managedDatasetsCreationService.getFormats(u.connection, null);
            if (c2 instanceof AbstractSQLConnection) {
                AbstractSQLConnection.AbstractSQLParams params = ((AbstractSQLConnection)c2).getParams();
                u.canOverrideSQLCatalog = params.namingRule.canOverrideCatalogInManagedDatasetCreation;
                u.unoverridenSQLCatalog = params.namingRule.catalog;
                u.canOverrideSQLSchema = params.namingRule.canOverrideSchemaInManagedDatasetCreation;
                u.unoverridenSQLSchema = params.namingRule.schemaName;
            }
            ret.add(u);
        }
        return ret;
    }

    private Collection<ConnectionUsability> getConnectionHeaders(Collection<ConnectionWithUsability> connections) {
        ArrayList<ConnectionUsability> ret = new ArrayList<ConnectionUsability>();
        for (ConnectionWithUsability c2 : connections) {
            ConnectionUsability u = new ConnectionUsability(c2);
            ret.add(u);
        }
        return ret;
    }

    public static class ConnectionsChangeStartResponse {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public Collection<ConnectionUsability> connections;
    }

    public static class ChangeConnectionsOptions {
        public String connection;
        public boolean dropData;
        public boolean useExistingParams;
        public ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings specificSettings = new ManagedDatasetsCreationService.ManagedDatasetCreationSpecificSettings();
    }

    public static class ConnectionsChangeTestResponse
    extends InfoMessage.InfoMessages {
    }

    public static class ConnectionUsability {
        public final String name;
        public final String type;
        public boolean usable;
        public String reason;
        public Collection<? extends ManagedDatasetsCreationService.FormatOption> formats;
        public String unoverridenSQLCatalog;
        public boolean canOverrideSQLCatalog;
        public String unoverridenSQLSchema;
        public boolean canOverrideSQLSchema;

        public ConnectionUsability(ConnectionWithUsability c2) {
            this.name = c2.connection.name;
            this.type = c2.connection.type;
            this.usable = c2.usable;
            this.reason = c2.reason;
            this.formats = c2.formats;
            this.unoverridenSQLCatalog = c2.unoverridenSQLCatalog;
            this.canOverrideSQLCatalog = c2.canOverrideSQLCatalog;
            this.unoverridenSQLSchema = c2.unoverridenSQLSchema;
            this.canOverrideSQLSchema = c2.canOverrideSQLSchema;
        }
    }

    static class ConnectionWithUsability {
        public String unoverridenSQLCatalog;
        public boolean canOverrideSQLCatalog;
        public String unoverridenSQLSchema;
        public boolean canOverrideSQLSchema;
        Collection<? extends ManagedDatasetsCreationService.FormatOption> formats;
        DSSConnection connection;
        boolean usable = true;
        String reason;

        public ConnectionWithUsability(DSSConnection c2) {
            this.connection = c2;
        }

        public String toString() {
            return "EnrichedConnection{connection=" + String.valueOf(this.connection) + "}";
        }
    }
}

