/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeMetric;
import com.dataiku.dip.dataquality.rules.AbstractColumnsInRangeRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.engines.DSSMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValuesInRangeStreamComputer
extends DSSMetricsEngine.DSSMetricsEngineComputer {
    @Override
    public String getProbeType() {
        return "temporary_metrics_probe";
    }

    @Override
    public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object dataset, MetricTargetType objectType, Partition partition) {
        return new DSSMetricsEngine.DSSMetricsEngineRun().with(new MetricComputation(probe, this, metric, 10.0));
    }

    @Override
    public DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession start(DSSMetricsEngine.DSSMetricsEngineCallbacks engine, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ValuesInRangeStreamComputerSession session = new ValuesInRangeStreamComputerSession();
        for (MetricComputation computation : computations) {
            ValuesInRangeStreamComputerSingleSession columnSession = new ValuesInRangeStreamComputerSingleSession();
            ValuesInRangeMetric metric = (ValuesInRangeMetric)computation.metric;
            columnSession.computation = computation;
            columnSession.column = engine.getColumnFactory().column(metric.getColumn());
            columnSession.minimum = metric.minimum;
            columnSession.maximum = metric.maximum;
            columnSession.minimumEnabled = metric.minimumEnabled;
            columnSession.maximumEnabled = metric.maximumEnabled;
            columnSession.softMinimum = metric.softMinimum;
            columnSession.softMaximum = metric.softMaximum;
            columnSession.softMinimumEnabled = metric.softMinimumEnabled;
            columnSession.softMaximumEnabled = metric.softMaximumEnabled;
            columnSession.hardOutlierCount = 0L;
            columnSession.softOutlierCount = 0L;
            session.columnSessions.add(columnSession);
        }
        return session;
    }

    @Override
    public boolean accumulate(Row row, DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession rawSession) throws Exception {
        ValuesInRangeStreamComputerSession session = (ValuesInRangeStreamComputerSession)rawSession;
        for (ValuesInRangeStreamComputerSingleSession columnSession : session.columnSessions) {
            this.processRowForSession(row, columnSession);
        }
        return true;
    }

    private void processRowForSession(Row row, ValuesInRangeStreamComputerSingleSession columnSession) {
        boolean softEnabled;
        boolean hardEnabled = columnSession.minimumEnabled || columnSession.maximumEnabled;
        boolean bl = softEnabled = (columnSession.softMinimumEnabled || columnSession.softMaximumEnabled) && columnSession.hardOutlierCount == 0L;
        if (!hardEnabled && !softEnabled) {
            return;
        }
        String dataValue = row.get(columnSession.column);
        if (StringUtils.isBlank((CharSequence)dataValue)) {
            return;
        }
        try {
            double numericValue = Double.parseDouble(dataValue);
            this.updateOutlierCounts(columnSession, numericValue);
        }
        catch (NumberFormatException e) {
            this.handleInvalidNumber(columnSession, hardEnabled, softEnabled);
        }
    }

    private void updateOutlierCounts(ValuesInRangeStreamComputerSingleSession columnSession, double numericValue) {
        if (AbstractColumnsInRangeRule.isRangeViolation(numericValue, columnSession.minimumEnabled, columnSession.minimum, columnSession.maximumEnabled, columnSession.maximum)) {
            ++columnSession.hardOutlierCount;
        } else if (AbstractColumnsInRangeRule.isRangeViolation(numericValue, columnSession.softMinimumEnabled, columnSession.softMinimum, columnSession.softMaximumEnabled, columnSession.softMaximum)) {
            ++columnSession.softOutlierCount;
        }
    }

    private void handleInvalidNumber(ValuesInRangeStreamComputerSingleSession columnSession, boolean hardEnabled, boolean softEnabled) {
        if (hardEnabled) {
            ++columnSession.hardOutlierCount;
        }
        if (softEnabled) {
            ++columnSession.softOutlierCount;
        }
    }

    @Override
    public Map<Metric, String> getAggregates(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession rawSession) throws Exception {
        ValuesInRangeStreamComputerSession session = (ValuesInRangeStreamComputerSession)rawSession;
        HashMap<Metric, String> aggregates = new HashMap<Metric, String>();
        for (ValuesInRangeStreamComputerSingleSession columnSession : session.columnSessions) {
            Map<String, Long> counts = Map.of("hard", columnSession.hardOutlierCount, "soft", columnSession.softOutlierCount);
            aggregates.put(columnSession.computation.metric, JSON.json(counts));
        }
        return aggregates;
    }

    @Override
    public boolean canComputeWith(List<MetricComputation> handledComputations, List<MetricComputation> otherComputations) {
        return otherComputations.stream().allMatch(computation -> computation.computer instanceof ValuesInRangeStreamComputer);
    }

    @Override
    public void cleanup(DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession dssComputerSession) throws Exception {
    }

    @Override
    public JsonObject writeJson(JsonSerializationContext ctx) {
        return new JsonObject();
    }

    @Override
    public void readJson(JsonObject jsonObj, JsonDeserializationContext ctx) {
    }

    public static class ValuesInRangeStreamComputerSession
    implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
        public List<ValuesInRangeStreamComputerSingleSession> columnSessions = new ArrayList<ValuesInRangeStreamComputerSingleSession>();
    }

    public static class ValuesInRangeStreamComputerSingleSession
    implements DSSMetricsEngine.DSSMetricsEngineComputer.DSSComputerSession {
        public MetricComputation computation;
        public Column column;
        public double minimum;
        public double maximum;
        public boolean minimumEnabled;
        public boolean maximumEnabled;
        public double softMinimum;
        public double softMaximum;
        public boolean softMinimumEnabled;
        public boolean softMaximumEnabled;
        public long hardOutlierCount;
        public long softOutlierCount;
    }
}

