/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractNewDataQualityRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.DatasetCheckContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class CompareMetricsRule
extends AbstractNewDataQualityRule
implements MetricsBasedDataQualityRule {
    public static final String TYPE = "CompareMetricsRule";
    @Nullable
    public String metricId;
    @Nullable
    public String metricBId;
    @Nullable
    public String datasetBName;
    public boolean autoComputeMetric = false;
    @Nullable
    public Operator operator;

    @Override
    public List<Metric> getMetrics() {
        if (this.metricId == null || !this.autoComputeMetric) {
            return Collections.emptyList();
        }
        return List.of(Metric.deserializeMetric(this.metricId));
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext rawContext, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        ReadOnlyJobsInternalDB.MetricDataPoint metricBData;
        DatasetCheckContext context = (DatasetCheckContext)rawContext;
        ReadOnlyJobsInternalDB.MetricDataPoint metricAData = context.getCurrentValue(this.metricId);
        SerializedDataset datasetB = this.readDatasetBConfig(context.getProjectKey());
        if (datasetB == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Cannot compare: comparison dataset does not exist");
        }
        if (datasetB.isPartitioned()) {
            metricBData = context.getDataset().getPartitioningSchema().isPartitioned() ? context.getCurrentValueDifferentDataset(this.datasetBName, this.metricBId, context.partition.id()) : context.getCurrentValueDifferentDataset(this.datasetBName, this.metricBId, "ALL");
            if (metricBData == null) {
                metricBData = context.getCurrentValueDifferentDataset(this.datasetBName, this.metricBId, null);
            }
        } else {
            metricBData = context.getCurrentValueDifferentDataset(this.datasetBName, this.metricBId, "NP");
        }
        if (metricAData == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Cannot compare: primary metric was not computed");
        }
        if (metricAData.value == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Cannot compare: primary metric value is null");
        }
        if (metricBData == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Cannot compare: comparison metric was not computed");
        }
        if (metricBData.value == null) {
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, "Cannot compare: comparison metric value is null");
        }
        Preconditions.checkArgument((this.operator != null ? 1 : 0) != 0);
        return this.operator.compare(metricAData, metricBData);
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfig(Dataset dataset) {
        if (StringUtils.isBlank((CharSequence)this.metricId)) {
            return new RuleValidationError("Primary metric must be selected.");
        }
        if (StringUtils.isBlank((CharSequence)this.datasetBName)) {
            return new RuleValidationError("Comparison dataset must be selected.");
        }
        if (StringUtils.isBlank((CharSequence)this.metricBId)) {
            return new RuleValidationError("Comparison metric must be selected.");
        }
        if (this.operator == null) {
            return new RuleValidationError("Operator must be selected.");
        }
        return null;
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }

    @Nullable
    private SerializedDataset readDatasetBConfig(String projectKey) throws IOException {
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        DatasetsDAO datasetsDao = (DatasetsDAO)SpringUtils.getBean(DatasetsDAO.class);
        try (Transaction t = transactionService.beginRead();){
            SerializedDataset serializedDataset = (SerializedDataset)datasetsDao.getOrNullUnsafe(projectKey, this.datasetBName);
            return serializedDataset;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Operator {
        EQUALS{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                return Objects.equals(a, b);
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return a.equals(b);
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not equal to", b);
            }
        }
        ,
        LT{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                if (a instanceof Long && b instanceof Long) {
                    return a.longValue() < b.longValue();
                }
                return a.doubleValue() < b.doubleValue();
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return a.compareTo(b) < 0;
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not less than", b);
            }
        }
        ,
        LTE{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                if (a instanceof Long && b instanceof Long) {
                    return a.longValue() <= b.longValue();
                }
                return a.doubleValue() <= b.doubleValue();
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return a.compareTo(b) <= 0;
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not less than or equal to", b);
            }
        }
        ,
        GT{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                if (a instanceof Long && b instanceof Long) {
                    return a.longValue() > b.longValue();
                }
                return a.doubleValue() > b.doubleValue();
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return a.compareTo(b) > 0;
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not greater than", b);
            }
        }
        ,
        GTE{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                if (a instanceof Long && b instanceof Long) {
                    return a.longValue() >= b.longValue();
                }
                return a.doubleValue() >= b.doubleValue();
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return a.compareTo(b) >= 0;
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not greater than or equal to", b);
            }
        }
        ,
        NE{

            @Override
            protected boolean compareNumbers(Number a, Number b) {
                if (a instanceof Long && b instanceof Long) {
                    return a.longValue() != b.longValue();
                }
                return a.doubleValue() != b.doubleValue();
            }

            @Override
            protected boolean compareStrings(String a, String b) {
                return !a.equals(b);
            }

            @Override
            protected String failureMessage(String a, String b) {
                return String.format("%s %s %s", a, "is not different from", b);
            }
        };


        protected abstract boolean compareNumbers(Number var1, Number var2);

        protected abstract boolean compareStrings(String var1, String var2);

        protected abstract String failureMessage(String var1, String var2);

        public AbstractCheckContext.CheckResult compare(ReadOnlyJobsInternalDB.MetricDataPoint metricA, ReadOnlyJobsInternalDB.MetricDataPoint metricB) {
            if (metricA.type.isNumeric() && metricB.type.isNumeric()) {
                Double b;
                Double a = metricA.type.isInteger() ? (double)Long.parseLong(metricA.value) : Double.parseDouble(metricA.value);
                if (this.compareNumbers(a, b = Double.valueOf(metricA.type.isInteger() ? (double)Long.parseLong(metricB.value) : Double.parseDouble(metricB.value)))) {
                    return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, metricA.value);
                }
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, this.failureMessage(metricA.value, metricB.value));
            }
            if (this.compareStrings(metricA.value, metricB.value)) {
                return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.OK, metricA.value);
            }
            return new AbstractCheckContext.CheckResult(AbstractCheckContext.CheckOutcome.ERROR, this.failureMessage(metricA.value, metricB.value));
        }
    }
}

