/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.elasticsearch;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDatasetHandler;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchDialect;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchHttpClient;
import com.dataiku.dip.datasets.elasticsearch.ElasticSearchIndex;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dss.shadelib.com.google.common.collect.Maps;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ElasticSearchUtils {
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final Pattern MANAGED_INDEX_FORBIDDEN_CHARS = Pattern.compile("(?:^_+)|[/\\\\*\"<>|,\\x00\\s]+");
    private static String NO_TZ_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static String NO_TZ_FORMAT_NO_MILLI = "yyyy-MM-dd HH:mm:ss";
    private static Set<String> wellKnownDateOnlyFormats = Sets.newHashSet((Object[])new String[]{"date", "strict_date"});
    private static Set<String> wellKnownDateFormats = Sets.newHashSet((Object[])new String[]{"date_time", "strict_date_time", "date_optional_time", "strict_date_optional_time"});
    private static final Logger logger = Logger.getLogger((String)"dku.elasticsearch");

    static String normalizeName(String name, boolean isManaged) {
        String norm;
        if (isManaged) {
            norm = MANAGED_INDEX_FORBIDDEN_CHARS.matcher(name.toLowerCase()).replaceAll("");
            if (norm.isEmpty() || norm.startsWith("_") && !"_doc".equals(norm)) {
                throw new IllegalArgumentException("Index or Type name is empty or invalid: " + name);
            }
        } else {
            norm = name.toLowerCase();
        }
        return norm;
    }

    public static Type getDSSTypeFromESType(ElasticSearchIndex.TypeAndFormat esTypeAndFormat, ElasticSearchDatasetHandler.ReadTemporalMode readTemporalMode) {
        switch (esTypeAndFormat.type) {
            case "binary": {
                return Type.STRING;
            }
            case "boolean": {
                return Type.BOOLEAN;
            }
            case "long": {
                return Type.BIGINT;
            }
            case "integer": {
                return Type.INT;
            }
            case "short": {
                return Type.SMALLINT;
            }
            case "byte": {
                return Type.TINYINT;
            }
            case "double": {
                return Type.DOUBLE;
            }
            case "float": {
                return Type.FLOAT;
            }
            case "half_float": {
                return Type.FLOAT;
            }
            case "scaled_float": {
                return Type.FLOAT;
            }
            case "unsigned_long": {
                return Type.BIGINT;
            }
            case "string": 
            case "text": 
            case "match_only_text": 
            case "completion": 
            case "search_as_you_type": 
            case "keyword": 
            case "constant_keyword": 
            case "wildcard": {
                return Type.STRING;
            }
            case "date": {
                String format = esTypeAndFormat.format;
                if (format != null && readTemporalMode == ElasticSearchDatasetHandler.ReadTemporalMode.AS_IS) {
                    List formats = Arrays.stream(format.split("\\|\\|")).map(String::trim).collect(Collectors.toList());
                    for (String f : formats) {
                        if (wellKnownDateFormats.contains(f.toLowerCase())) {
                            return Type.DATE;
                        }
                        if (wellKnownDateOnlyFormats.contains(f.toLowerCase()) || f.length() == 10) {
                            return Type.DATEONLY;
                        }
                        if (!f.startsWith("yyyy-MM-dd ")) continue;
                        return Type.DATETIMENOTZ;
                    }
                    return Type.DATE;
                }
                return Type.DATE;
            }
            case "date_nanos": {
                return Type.STRING;
            }
            case "object": 
            case "flattened": 
            case "nested": {
                return Type.OBJECT;
            }
            case "integer_range": 
            case "float_range": 
            case "long_range": 
            case "double_range": 
            case "date_range": 
            case "ip_range": {
                return Type.STRING;
            }
            case "ip": 
            case "version": 
            case "aggregate_metric_double": 
            case "histogram": 
            case "dense_vector": 
            case "rank_features": {
                return Type.STRING;
            }
            case "token_count": 
            case "rank_feature": {
                return Type.BIGINT;
            }
            case "geo_point": {
                return Type.GEOPOINT;
            }
            case "geo_shape": {
                return Type.STRING;
            }
            case "point": 
            case "shape": 
            case "percolator": {
                return Type.STRING;
            }
        }
        return Type.STRING;
    }

    private static String getElasticSearchCoreType(Type t) {
        switch (t) {
            case TINYINT: {
                return "integer";
            }
            case SMALLINT: {
                return "integer";
            }
            case INT: {
                return "integer";
            }
            case BIGINT: {
                return "long";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case STRING: {
                return "string";
            }
            case DATE: 
            case DATEONLY: 
            case DATETIMENOTZ: {
                return "date";
            }
            case GEOPOINT: {
                return "geo_point";
            }
            case GEOMETRY: {
                throw new IllegalArgumentException("Geometry column are not supported for ElasticSearch mapping");
            }
            case OBJECT: 
            case ARRAY: 
            case MAP: {
                throw new Error("Unreachable");
            }
        }
        throw new Error("unreachable");
    }

    private static JSONObject getElasticSearchType(SchemaColumn column, ElasticSearchDialect dialect, SerializedDataset.TypeSystemVersion version) throws JSONException {
        switch (column.getType()) {
            case STRING: {
                return new JSONObject().put("type", (Object)dialect.stringType);
            }
            case ARRAY: {
                if (column.arrayContent != null) {
                    return ElasticSearchUtils.getElasticSearchType(column.arrayContent, dialect, version);
                }
                return null;
            }
            case MAP: {
                if (column.mapKeys != null && column.mapValues != null && column.mapKeys.getType().isPrimitive()) {
                    return new JSONObject().put("properties", (Object)new JSONObject().put("key", (Object)ElasticSearchUtils.getElasticSearchType(column.mapKeys, dialect, version)).put("value", (Object)ElasticSearchUtils.getElasticSearchType(column.mapValues, dialect, version)));
                }
                return new JSONObject().put("type", (Object)"object");
            }
            case OBJECT: {
                if (column.objectFields != null) {
                    JSONObject ret = new JSONObject().put("type", (Object)"object");
                    JSONObject nestedProps = new JSONObject();
                    ret.put("properties", (Object)nestedProps);
                    for (SchemaColumn nc : column.objectFields) {
                        nestedProps.put(nc.getName(), (Object)ElasticSearchUtils.getElasticSearchType(nc, dialect, version));
                    }
                    return ret;
                }
                return new JSONObject().put("type", (Object)"object");
            }
        }
        JSONObject ret = new JSONObject().put("type", (Object)ElasticSearchUtils.getElasticSearchCoreType(column.getType())).put("store", (Object)"true");
        if (column.getType() == Type.DATE) {
            ret.put("format", (Object)(version == SerializedDataset.TypeSystemVersion.V1 ? "strict_date_optional_time||epoch_millis" : "strict_date_time||epoch_millis"));
        } else if (column.getType() == Type.DATEONLY) {
            ret.put("format", (Object)"yyyy-MM-dd");
        } else if (column.getType() == Type.DATETIMENOTZ) {
            ret.put("format", (Object)NO_TZ_FORMAT);
        }
        return ret;
    }

    public static JSONObject getMappingDefinition(Dataset dataset, ElasticSearchDialect dialect, SerializedDataset.TypeSystemVersion version) throws JSONException {
        String customMapping = dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class).customMapping;
        if (customMapping != null && !customMapping.isEmpty()) {
            return new JSONObject(customMapping);
        }
        return ElasticSearchUtils.getDefaultMappingDefinition(dataset, dialect, version);
    }

    public static JSONObject getDefaultMappingDefinition(Dataset dataset, ElasticSearchDialect dialect, SerializedDataset.TypeSystemVersion version) throws JSONException {
        ElasticSearchDatasetHandler.Config config = dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class);
        boolean rawCopyAll = "*".equals(config.rawCopyColumns);
        ArrayList rawCopyCols = config.rawCopyColumns == null || rawCopyAll ? Lists.newArrayList() : Lists.newArrayList((Object[])config.rawCopyColumns.split("(?:\\s*,\\s*)+", 0));
        JSONObject str_not_analyzed = new JSONObject().put("type", (Object)dialect.keywordType);
        if (dialect.needsNotAnalyzed) {
            str_not_analyzed = str_not_analyzed.put("index", (Object)"not_analyzed");
        }
        JSONObject props = new JSONObject();
        if (dataset.getSchema() != null) {
            for (SchemaColumn c2 : dataset.getSchema().getColumns()) {
                JSONObject typeMapping = ElasticSearchUtils.getElasticSearchType(c2, dialect, version);
                if (typeMapping == null) continue;
                if (rawCopyAll || rawCopyCols.contains(c2.getName())) {
                    typeMapping.put("fields", (Object)new JSONObject().put(c2.getName() + "_facet", (Object)str_not_analyzed));
                }
                props.put(c2.getName(), (Object)typeMapping);
            }
        }
        if (dataset.getPartitioningSchema().isPartitioned()) {
            for (String dimName : dataset.getPartitioningSchema().getDimensionNames()) {
                Dimension dim = dataset.getPartitioningSchema().getDimension(dimName);
                JSONObject typeMapping = new JSONObject().put("store", true);
                if (dim instanceof TimeDimension) {
                    typeMapping.put("type", (Object)"date");
                } else {
                    typeMapping.put("type", (Object)dialect.keywordType);
                    if (rawCopyAll || rawCopyCols.contains(dimName)) {
                        typeMapping.put("fields", (Object)new JSONObject().put(dimName + "_facet", (Object)str_not_analyzed));
                    }
                }
                props.put(dimName, (Object)typeMapping);
            }
        }
        return new JSONObject().put("properties", (Object)props).put("date_detection", (Object)(dialect.strictBooleanOptions ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0)));
    }

    public static JSONObject getElasticSearchValue(Dataset dataset, ColumnFactory cf, Row row) throws JSONException {
        JSONObject o = new JSONObject();
        boolean hasDefaultMapping = StringUtils.isEmpty((String)dataset.getParamsAs(ElasticSearchDatasetHandler.Config.class).customMapping);
        block15: for (SchemaColumn c2 : dataset.getSchema().getColumns()) {
            Column cd = cf.column(c2.getName());
            String v = row.get(cd);
            if (v == null || v.isEmpty()) continue;
            switch (c2.getType()) {
                case ARRAY: {
                    try {
                        JSONArray array = new JSONArray(v);
                        o.put(c2.getName(), (Object)array);
                    }
                    catch (Exception array) {}
                    continue block15;
                }
                case MAP: {
                    JSONObject obj2;
                    try {
                        obj2 = new JSONObject(v);
                        Iterator it = obj2.keys();
                        JSONArray retarr = new JSONArray();
                        while (it.hasNext()) {
                            JSONObject valobj = new JSONObject();
                            String key = (String)it.next();
                            valobj.put("key", (Object)key);
                            valobj.put("value", (Object)obj2.get(key).toString());
                            retarr.put((Object)valobj);
                        }
                        o.put(c2.getName(), (Object)retarr);
                    }
                    catch (Exception obj2) {}
                    continue block15;
                }
                case OBJECT: {
                    JSONObject obj2;
                    try {
                        obj2 = new JSONObject(v);
                        o.put(c2.getName(), (Object)obj2);
                    }
                    catch (Exception obj) {}
                    continue block15;
                }
                case GEOPOINT: {
                    try {
                        GeoPoint.Coords pt = GeoPoint.convert(v);
                        JSONObject obj = new JSONObject().put("lat", pt.latitude).put("lon", pt.longitude);
                        o.put(c2.getName(), (Object)obj);
                    }
                    catch (Exception exception) {}
                    continue block15;
                }
                case DATETIMENOTZ: {
                    if (v.length() != NO_TZ_FORMAT.length() && hasDefaultMapping) {
                        v = ElasticSearchUtils.reformatDateTimeNoTZ(v);
                    }
                    o.put(c2.getName(), (Object)v);
                    continue block15;
                }
            }
            o.put(c2.getName(), (Object)v);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("INDEXING: \n" + o.toString(4)));
        }
        return o;
    }

    public static String reformatDateTimeNoTZ(String v) {
        if (((String)v).length() == NO_TZ_FORMAT_NO_MILLI.length()) {
            return (String)v + ".000";
        }
        if (((String)v).length() > NO_TZ_FORMAT_NO_MILLI.length() && ((String)v).charAt(NO_TZ_FORMAT_NO_MILLI.length()) == '.') {
            String datetime = ((String)v).substring(0, NO_TZ_FORMAT_NO_MILLI.length());
            String end = ((String)v).substring(NO_TZ_FORMAT_NO_MILLI.length() + 1);
            if (StringUtils.isNumeric((String)end)) {
                v = end.length() > 3 ? datetime + "." + end.substring(0, 3) : datetime + "." + String.format("%-3s", end).replace(' ', '0');
            }
        }
        return v;
    }

    public static String getPartitionValue(DimensionValue val) {
        if (!(val instanceof TimeDimensionValue)) {
            return val.id();
        }
        TimeDimensionValue timeVal = (TimeDimensionValue)val;
        return DKUDateUtils.isoFormatUTC((long)timeVal.getUTCCalendar().getTimeInMillis());
    }

    @Nullable
    public static String getValueAsDSSString(@Nullable Object o, @Nullable Type type) {
        if (o == null || o == JSONObject.NULL) {
            return null;
        }
        if (type != null) {
            switch (type) {
                case GEOPOINT: {
                    if (!(o instanceof JSONObject)) break;
                    JSONObject jo = (JSONObject)o;
                    try {
                        if (jo.has("lat") && jo.has("lon")) {
                            GeoPoint.Coords c2 = new GeoPoint.Coords(jo.getDouble("lat"), jo.getDouble("lon"));
                            return c2.toWKT();
                        }
                    }
                    catch (JSONException jSONException) {}
                    break;
                }
            }
        }
        return o.toString();
    }

    public static long getTotal(ElasticSearchDialect dialect, JSONObject object) {
        return dialect.hasTotalHitsAsObject ? object.getJSONObject("hits").getJSONObject("total").getLong("value") : object.getJSONObject("hits").getLong("total");
    }

    public static String tryToGetString(InputStream is) {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)is);
            return new String(data, CHARSET);
        }
        catch (IOException e) {
            return "(failed to read content : " + e.getMessage() + ")";
        }
    }

    public static Map<String, Integer> listIndicesWithCount(ElasticSearchHttpClient client, String address) throws IOException {
        return ElasticSearchUtils.listIndicesWithCount(client, address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> listIndicesWithCount(ElasticSearchHttpClient client, String address, String index_pattern) throws IOException {
        int notFound = 404;
        StringBuilder path = new StringBuilder().append("_cat/indices");
        if (index_pattern != null) {
            path.append("/").append(URLEncoder.encode(index_pattern, StandardCharsets.UTF_8));
        }
        path.append("?format=json");
        HttpResponse resp = client.execute((HttpUriRequest)new HttpGet(address + String.valueOf(path)), false, "Can't fetch stats", notFound);
        try {
            if (resp.getStatusLine().getStatusCode() == notFound) {
                HashMap hashMap = Maps.newHashMap();
                return hashMap;
            }
            JSONArray indices = new JSONArray(ElasticSearchUtils.tryToGetString(resp.getEntity().getContent()));
            Iterator it = indices.iterator();
            LinkedHashMap<String, Integer> indicesWithCount = new LinkedHashMap<String, Integer>();
            while (it.hasNext()) {
                JSONObject indexData = (JSONObject)it.next();
                String index = indexData.getString("index");
                if (index.startsWith(".")) continue;
                int total = Integer.parseInt(indexData.getString("docs.count"));
                indicesWithCount.put(index, total);
            }
            LinkedHashMap<String, Integer> linkedHashMap = indicesWithCount;
            return linkedHashMap;
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
    }

    public static enum SearchDistribution {
        ELASTIC_SEARCH("ElasticSearch"),
        OPEN_SEARCH("OpenSearch");

        public final String displayName;

        private SearchDistribution(String displayName) {
            this.displayName = displayName;
        }

        public static SearchDistribution getDistribution(JSONObject jresp) {
            JSONObject version = jresp.getJSONObject("version");
            if (version.has("distribution") && "opensearch".equals(version.getString("distribution"))) {
                return OPEN_SEARCH;
            }
            if (jresp.has("tagline") && jresp.getString("tagline").toLowerCase().contains("opensearch")) {
                return OPEN_SEARCH;
            }
            return ELASTIC_SEARCH;
        }

        public ElasticSearchDialect getDialect(String version) {
            if (OPEN_SEARCH.equals((Object)this)) {
                return ElasticSearchDialect.ES_7;
            }
            switch (version.substring(0, version.indexOf(46))) {
                case "0": 
                case "1": 
                case "2": {
                    return ElasticSearchDialect.ES_LE_2;
                }
                case "3": 
                case "4": {
                    throw new IllegalArgumentException("Unrecognized version for Elasticsearch: " + version);
                }
                case "5": 
                case "6": {
                    return ElasticSearchDialect.ES_5;
                }
            }
            return ElasticSearchDialect.ES_7;
        }
    }

    public static class HttpGetWithEntity
    extends HttpEntityEnclosingRequestBase {
        public static final String METHOD_NAME = "GET";

        public HttpGetWithEntity(String uri) {
            this.setURI(URI.create(uri));
        }

        public String getMethod() {
            return METHOD_NAME;
        }
    }
}

