/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.InputSplit;
import com.dataiku.dip.input.filter.FilterResultWithSplits;
import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;

public abstract class DelegateFSDatasetHandler
extends AbstractFSDatasetHandler {
    private Dataset realDataset;
    private AbstractFSDatasetHandler realHandler;

    public DelegateFSDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.realHandler != null) {
            this.realHandler.close();
        }
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, CodedException, DKUSecurityException {
        this.ensureRealDatasetAndHandler();
        return this.realHandler.getProviderInternal(path);
    }

    private synchronized void ensureRealDatasetAndHandler() throws IOException {
        if (this.realDataset == null) {
            this.buildReal();
            assert (this.realDataset != null);
            assert (this.realHandler != null);
        }
    }

    public Dataset getRealDataset() throws IOException {
        this.ensureRealDatasetAndHandler();
        return this.realDataset;
    }

    protected void setRealDataset(Dataset realDataset) {
        this.realDataset = realDataset;
    }

    public AbstractFSDatasetHandler getRealHandler() throws IOException {
        this.ensureRealDatasetAndHandler();
        return this.realHandler;
    }

    protected void setRealHandler(AbstractFSDatasetHandler realHandler) {
        this.realHandler = realHandler;
    }

    protected abstract void buildReal() throws IOException;

    @Override
    public abstract String suggestName() throws CodedException, DKUSecurityException;

    @Override
    public void checkConfiguration() throws IllegalArgumentException, IOException, CodedException, DKUSecurityException {
        this.getRealHandler().checkConfiguration();
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return this.getRealHandler().executeFastPostCreateOperations();
    }

    @Override
    public void executePreRenameOperations() throws IOException {
        this.getRealHandler().executePreRenameOperations();
    }

    @Override
    public InputSplit getSampleSplit() throws Exception {
        return this.getRealHandler().getSampleSplit();
    }

    @Override
    public InputSplit getSingleSplit() throws Exception {
        return this.getRealHandler().getSingleSplit();
    }

    @Override
    public List<Partition> listPartitions() throws Exception {
        return this.getRealHandler().listPartitions();
    }

    @Override
    public long getRecords() throws Exception {
        return this.getRealHandler().getRecords();
    }

    @Override
    public long getPartitionRecords(Partition p) throws Exception {
        return this.getRealHandler().getPartitionRecords(p);
    }

    @Override
    public boolean partitionExists(Partition p) throws Exception {
        return this.getRealHandler().partitionExists(p);
    }

    @Override
    public void createManaged() throws Exception {
        this.getRealHandler().createManaged();
    }

    @Override
    public void clearAllData() throws Exception {
        this.getRealHandler().clearAllData();
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        this.getRealHandler().clearPartitions(partitions);
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        this.getRealHandler().clearAllDataAndStructure();
    }

    @Override
    public InputSplit getPartitionSplit(Partition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().getPartitionSplit(partition);
    }

    @Override
    public FilterResultWithSplits getFilterSplits(InputFilter filter) throws Exception {
        return this.getRealHandler().getFilterSplits(filter);
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return this.getRealHandler().buildOutput(targetPartition, targetSplit, resplitFactor, warningsContext);
    }

    @Override
    public boolean matchesPartitioningScheme(String path) throws IOException {
        return this.getRealHandler().matchesPartitioningScheme(path);
    }

    @Override
    public FilePartitioner.ResolvedFilesFilterResult getRequiredFiles(InputFilter filter) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().getRequiredFiles(filter);
    }

    @Override
    public StreamsInputSplit getSplitForBucket(FilePartition fp, FileBucket bucket) throws IOException {
        return this.getRealHandler().getSplitForBucket(fp, bucket);
    }

    @Override
    public StreamsInputSplit getSplitForFile(FilePartition fp, FSPath p) throws IOException {
        return this.getRealHandler().getSplitForFile(fp, p);
    }

    @Override
    public StreamsInputSplit getGlobalSplit() throws Exception {
        return this.getRealHandler().getGlobalSplit();
    }

    @Override
    public StreamsInputSplit getSplitForPartitions(List<FilePartition> partitions) throws IOException {
        return this.getRealHandler().getSplitForPartitions(partitions);
    }

    @Override
    public StreamsInputSplit getSplitForPartition(FilePartition partition) throws IOException {
        return this.getRealHandler().getSplitForPartition(partition);
    }

    @Override
    public List<FSPath> enumerateFilesystem() throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().enumerateFilesystem();
    }

    @Override
    public List<FSPath> enumeratePartition(Partition partition, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().enumeratePartition(partition, enumerationSettings);
    }

    @Override
    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings enumerationSettings) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().enumerateFilesystem(prefix, enumerationSettings);
    }

    @Override
    public FSEnumerationSettings getEnumerationSettings() {
        try {
            return this.getRealHandler().getEnumerationSettings();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get real handler to get enumeration settings", e);
        }
    }

    @Override
    public EnrichedInputStream getStream(FSPath path, FilePartition partition) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        return this.getRealHandler().getStream(path, partition);
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        return this.getRealHandler().getInformationalRootPath();
    }

    @Override
    public boolean isSingleFile() throws IOException, DKUSecurityException, CodedException {
        return this.getRealHandler().isSingleFile();
    }
}

