/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FTPConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.ChrootUtils;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FSLikeFSProvider;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.remote.FTPRemote;
import com.dataiku.dip.input.remote.RemoteFileUtils;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.io.OutputStreamWrapper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class FTPFSProvider
extends FSLikeFSProvider {
    public static final int MAX_RECURSION_DEPTH = 20;
    private final FTPConnection connection;
    private final String root;
    private final int timeout;
    private final AuthCtx authCtx;
    private final boolean useRelativePaths;
    private FTPRemote ftpRemote = null;
    private final int enumerationLimit = DKUApp.getParams().getIntParam("dku.fsproviders.enumerationLimit", Integer.valueOf(1000000));
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fsproviders.ftp");

    public FTPFSProvider(AuthCtx authCtx, DSSConnection connection, String root, int timeout) throws DKUSecurityException {
        this.authCtx = authCtx;
        this.connection = (FTPConnection)connection;
        this.root = PathUtils.canonical((String)ChrootUtils.getChrootedPath(this.connection.params.path, root, true));
        boolean bl = this.useRelativePaths = StringUtils.isBlank((String)this.root) || this.root.charAt(0) != '/';
        if (PathUtils.makeNotLeadingNoTrailing((String)PathUtils.canonical((String)root)).startsWith("..")) {
            throw new DKUSecurityException("Cannot access '" + this.root + "' outside the connection root directory");
        }
        this.timeout = timeout;
        logger.info((Object)("Effective root : '" + this.root + "' from '" + this.connection.params.path + "' / '" + root + "' useRelativePaths=" + this.useRelativePaths));
    }

    private synchronized FTPRemote getRemote() throws IOException, DKUSecurityException {
        if (this.ftpRemote == null) {
            this.ftpRemote = this.createRemote();
        }
        return this.ftpRemote;
    }

    private FTPRemote createRemote() throws IOException, DKUSecurityException {
        ICredentialsService.BasicCredential creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ICredentialsService.BasicCredential.class);
        return new FTPRemote(this.connection.params.host, this.connection.params.port, creds.user, creds.password, this.connection.params.passive, this.connection.getProxySettings(), this.timeout);
    }

    private String getPathInsideRoot(String rawPath) {
        String path;
        String string = path = StringUtils.isBlank((String)this.root) ? rawPath : PathUtils.canonical((String)(this.root + "/" + rawPath));
        if (StringUtils.isBlank((String)path)) {
            if (this.useRelativePaths) {
                return "";
            }
            return "/";
        }
        if (path.charAt(0) != '/') {
            if (this.useRelativePaths) {
                return path;
            }
            return "/" + path;
        }
        if (this.useRelativePaths) {
            return path.length() == 1 ? "" : path.substring(1);
        }
        return path;
    }

    private void checkPathStaysInsideRoot(String path) {
        if (!path.startsWith(this.root)) {
            throw ErrorContext.iae((String)("Cannot reach outside " + path));
        }
    }

    public synchronized void close() throws IOException {
        if (this.ftpRemote != null) {
            this.ftpRemote.close();
        }
    }

    @Override
    public String getConnectionRootWithinURIAuthority() {
        return StringUtils.defaultIfEmpty((String)this.connection.params.path, (String)"");
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws DKUSecurityException, IOException {
        HashMap ret = Maps.newHashMap();
        ret.put("root", this.root);
        ret.put("host", this.connection.params.host);
        ret.put("port", Integer.toString(this.connection.params.port));
        ret.put("passive", Boolean.toString(this.connection.params.passive));
        if (withSensitiveInfo && this.connection.detailsReadableBy(this.authCtx)) {
            ICredentialsService.BasicCredential creds = this.connection.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(this.authCtx, null), ICredentialsService.BasicCredential.class);
            ret.put("user", creds.user);
            ret.put("password", creds.password);
            ProxyUtils.applyProxySettings((ProxySettings)this.connection.getProxySettings(), (Map)ret);
        }
        return ret;
    }

    public void makeEmpty(String prefix) throws IOException, DKUSecurityException {
        FSPathOrDirectory status = this.stat(prefix);
        if (status != null && !status.isDirectory) {
            this.write(prefix).close();
        } else {
            this.deleteRecursive(prefix);
            FTPRemote remote = this.getRemote();
            String path = this.getPathInsideRoot(prefix);
            if (!remote.mkdirs(path)) {
                throw new IOException("Cannot create directory at " + path);
            }
        }
    }

    public void ensureDirectory(String prefix) throws IOException, DKUSecurityException {
        String path;
        FSPathOrDirectory status = this.stat(prefix);
        if (status != null && !status.isDirectory) {
            throw new IOException("Cannot make directory, '" + prefix + "' is a file");
        }
        FTPRemote remote = this.getRemote();
        if (!remote.mkdirs(path = this.getPathInsideRoot(prefix))) {
            throw new IOException("Cannot create directory at " + path);
        }
    }

    public FSBrowsePath browse(String prefix, FSProvider.FSBrowseStrategy strategy) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        FSBrowsePath ret = FSBrowsePath.makeRoot((String)prefix, (boolean)false);
        RemoteFileUtils.RemoteFile rr = remote.get(path);
        if (rr != null) {
            if (!(rr.isDirectory() || strategy != FSProvider.FSBrowseStrategy.FILE && strategy != FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY)) {
                ret.exists = true;
                ret.directory = false;
                ret.size = rr.size();
                ret.lastModified = rr.mtime();
                return ret;
            }
            if (rr.isDirectory() && (strategy == FSProvider.FSBrowseStrategy.DIRECTORY || strategy == FSProvider.FSBrowseStrategy.FILE_OR_DIRECTORY)) {
                ret.exists = true;
                ret.directory = true;
                List<RemoteFileUtils.RemoteFile> remoteFiles = remote.list(path);
                if (ret.children.size() + remoteFiles.size() > this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this FTP location (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                for (RemoteFileUtils.RemoteFile r : remoteFiles) {
                    ret.children.add(FSBrowsePath.makeChild((FSBrowsePath)ret, (String)r.basename(), (boolean)r.isDirectory(), (long)r.size(), (long)r.mtime()));
                }
                return ret;
            }
        }
        return new FSBrowsePath();
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        try {
            PathUtils.ensurePathStaysWithinRoot((String)prefix);
            List<FSPath> paths = this.enumerateFilesystem(prefix, enumerationSettings);
            if (paths == null) {
                return FTPFSEnumerationResult.fromNonExistingPrefix();
            }
            return FTPFSEnumerationResult.fromPaths(enumerationSettings.filter(paths));
        }
        catch (Exception e) {
            return FTPFSEnumerationResult.fromError(e);
        }
    }

    public List<FSPath> enumerateFilesystem(String prefix, FSEnumerationSettings settings) throws IOException, DKUSecurityException {
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        logger.info((Object)("Enumerate FTP: " + path));
        String rootLNT = PathUtils.makeLeadingNoTrailing((String)this.root);
        int prefixLength = "/".equals(rootLNT) ? 0 : rootLNT.length();
        RemoteFileUtils.RemoteFile prefixF = remote.get(path);
        if (prefixF != null && !prefixF.isDirectory()) {
            String relativePath = PathUtils.makeLeadingNoTrailing((String)prefixF.path()).substring(prefixLength);
            if (StringUtils.isBlank((String)relativePath)) {
                relativePath = "/";
            }
            return Lists.newArrayList((Object[])new FSPath[]{new FSPath(relativePath, prefixF.size(), prefixF.mtime())});
        }
        try {
            ArrayList<FSPath> ret = new ArrayList<FSPath>();
            for (RemoteFileUtils.RemoteFile f : remote.enumerate(path, 20, settings, prefixLength)) {
                String relPath = PathUtils.makeLeadingNoTrailing((String)f.path()).substring(prefixLength);
                if (FSDatasetUtils.isBadFile(f.basename(), settings.showHiddenFiles) || FSDatasetUtils.isBadPath(relPath)) continue;
                if (ret.size() + 1 > this.enumerationLimit) {
                    throw new CodedIOException((InfoMessage.MessageCode)FSProviderCodes.ERR_FSPROVIDER_TOO_MANY_FILES, String.format("There are too many files in this FTP location (> %d). Enumeration aborted.", this.enumerationLimit));
                }
                ret.add(new FSPath(relPath, f.size(), f.mtime()));
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public FSPathOrDirectory stat(String prefix) throws IOException, DKUSecurityException {
        String datasetRootPath;
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        try {
            RemoteFileUtils.RemoteFile datasetRoot = remote.get(this.root);
            if (datasetRoot == null) {
                throw new FileNotFoundException();
            }
            datasetRootPath = datasetRoot.path();
            if (datasetRootPath == null) {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Dataset root path does not exist : " + this.root), (Throwable)e);
            return null;
        }
        RemoteFileUtils.RemoteFile status = null;
        try {
            status = remote.get(path);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (status == null) {
            return null;
        }
        String filePathInDataset = status.path().replace(datasetRootPath, "");
        if ("".equals(filePathInDataset)) {
            filePathInDataset = "/";
        }
        return new FSPathOrDirectory(filePathInDataset, status.size(), status.mtime(), status.isDirectory());
    }

    public void deleteRecursive(String prefix) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        remote.forceRemove(path, true);
    }

    private void rename(String from, String to) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)from);
        PathUtils.ensurePathStaysWithinRoot((String)to);
        FTPRemote remote = this.getRemote();
        String fromPath = this.getPathInsideRoot(from);
        this.checkPathStaysInsideRoot(fromPath);
        String toPath = this.getPathInsideRoot(to);
        this.checkPathStaysInsideRoot(toPath);
        FSDatasetUtils.checkDestPathDoesNotExist(to, this.stat(to));
        this.ensureDirectory(PathUtils.getParent((String)to));
        if (!remote.rename(fromPath, toPath)) {
            throw new IOException("Failed to rename '" + from + "' to '" + to + "'");
        }
    }

    public void moveDirectory(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public void moveFile(String from, String to) throws IOException, DKUSecurityException {
        this.rename(from, to);
    }

    public EnrichedInputStream read(String prefix) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        RemoteFileUtils.RemoteFile remoteFile = remote.get(path);
        if (remoteFile == null) {
            throw new IOException("File '" + prefix + "' doesn't exist");
        }
        return new RemoteFileEnrichedInputStream(this, remoteFile, path);
    }

    public OutputStream write(String prefix) throws IOException, DKUSecurityException {
        this.checkConnectionWritability();
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        remote.mkdirs(PathUtils.getParent((String)path));
        FTPRemote streamRemote = this.createRemote();
        return new SeparateClientFTPRemoteOutputStream(streamRemote, streamRemote.getOutputStream(path));
    }

    private void checkConnectionWritability() {
        if (!this.connection.allowWrite) {
            throw new IllegalArgumentException("Cannot write on connection " + this.connection.name);
        }
    }

    public void setLastModified(String prefix, long lastModified) throws IOException, DKUSecurityException {
        PathUtils.ensurePathStaysWithinRoot((String)prefix);
        FTPRemote remote = this.getRemote();
        String path = this.getPathInsideRoot(prefix);
        this.checkPathStaysInsideRoot(path);
        remote.setLastModified(path, lastModified);
    }

    static class FTPFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public FTPFSEnumerationResult() {
        }

        public FTPFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public FTPFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static FTPFSEnumerationResult fromError(Throwable error) {
            return new FTPFSEnumerationResult(error);
        }

        private static FTPFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new FTPFSEnumerationResult(paths);
        }

        private static FTPFSEnumerationResult fromNonExistingPrefix() {
            return new FTPFSEnumerationResult();
        }
    }

    public static class RemoteFileEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final RemoteFileUtils.RemoteFile file;
        private final FTPFSProvider provider;

        public RemoteFileEnrichedInputStream(FTPFSProvider provider, RemoteFileUtils.RemoteFile file, String desc) {
            super(file.size(), file.basename(), file.basename(), desc, file::mtime);
            this.provider = provider;
            this.file = file;
        }

        protected InputStream getBasicInputStream() throws IOException, DKUSecurityException {
            final FTPRemote remote = this.provider.createRemote();
            return new FilterInputStream(remote.getInputStream(this.file.path())){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        remote.close();
                    }
                }
            };
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException, DKUSecurityException {
            return this.getBasicInputStream();
        }
    }

    class SeparateClientFTPRemoteOutputStream
    extends OutputStreamWrapper {
        protected boolean closed;
        private final FTPRemote streamRemote;

        SeparateClientFTPRemoteOutputStream(FTPRemote streamRemote, OutputStream out) {
            super(out);
            this.closed = false;
            this.streamRemote = streamRemote;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                this.streamRemote.close();
            }
        }
    }
}

