/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.DelegateFSDatasetHandler;
import com.dataiku.dip.datasets.fs.FSLikeDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FilesInFolderDatasetHandler
extends DelegateFSDatasetHandler {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    private static final Logger logger = Logger.getLogger(FilesInFolderDatasetHandler.class);

    public FilesInFolderDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
    }

    @Override
    protected void buildReal() throws IOException {
        AbstractFSDatasetHandler.AbstractFSConfig resolvedConfig;
        ManagedFolder odb;
        BuiltinFSDatasets.FilesInFolderConfig config = this.dataset.getParamsAs(BuiltinFSDatasets.FilesInFolderConfig.class);
        SpringUtils.getInstance().autowire((Object)this);
        String folderSmartId = config.getFolderSmartId();
        if (StringUtils.isBlank((String)folderSmartId)) {
            throw new IOException("No folder selected");
        }
        AnyLoc loc = DatasetLocUtils.DatasetLoc.resolveSmart(this.dataset.getProjectKey(), folderSmartId);
        if (TransactionContext.hasAttachedTransaction()) {
            odb = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                odb = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(loc.getProjectKey(), loc.getId());
            }
        }
        try (ManagedFolderHandler folderHandler = new ManagedFolderHandler(this.authCtx, odb);){
            resolvedConfig = folderHandler.getResolvedConfig();
        }
        Dataset subDataset = Dataset.fromSerialized(this.dataset.serialize());
        subDataset.setType(odb.getType());
        AbstractFSDatasetHandler.AbstractFSConfig configCopy = (AbstractFSDatasetHandler.AbstractFSConfig)JSON.deepCopy((Object)resolvedConfig);
        configCopy.filesSelectionRules = config.filesSelectionRules;
        configCopy.previewFile = config.previewFile;
        configCopy.markerFile = config.markerFile;
        configCopy.variablesExpansionLoopConfig = config.variablesExpansionLoopConfig;
        subDataset.setParams(configCopy);
        logger.info((Object)("Build real handler with filter " + JSON.json((Object)configCopy)));
        this.setRealDataset(subDataset);
        this.setRealHandler((AbstractFSDatasetHandler)DatasetHandlerFactory.build(this.authCtx, subDataset));
    }

    @Override
    public boolean executeFastPostCreateOperations() throws Exception {
        return false;
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.FILES_IN_FOLDER_META;
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException, DKUSecurityException, CodedException {
        DatasetTestHandler testHandler = this.getRealHandler().buildTestHandler();
        if (testHandler instanceof FSLikeDatasetTestHandler) {
            ((FSLikeDatasetTestHandler)testHandler).setHandlerForName(this);
        }
        return testHandler;
    }

    @Override
    public String suggestName() throws CodedException, DKUSecurityException {
        try {
            FSPath first = this.getRealHandler().getFirstNonEmptyPath();
            if (first != null) {
                return DatasetHandlerFactory.nameFromFileName((String)DKUtils.lastElement((Object[])first.path().split("/")));
            }
            return "on_folder_" + this.getRealHandler().suggestName();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to build suggested name", (Throwable)e);
            return "";
        }
    }

    @Override
    public void clearAllData() throws Exception {
        throw new RuntimeException("Cannot clear a files-on-folder dataset, clear the associated folder directly");
    }

    @Override
    public void clearPartitions(List<Partition> partitions) throws Exception {
        throw new RuntimeException("Cannot clear a files-on-folder dataset, clear the associated folder directly");
    }

    @Override
    public void clearAllDataAndStructure() throws Exception {
        throw new RuntimeException("Cannot clear a files-on-folder dataset, clear the associated folder directly");
    }
}

