/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.dataset;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RelatedChartsIterable
implements FlowPlaceholder.IterablePlaceholder<SerializedDataset, DatasetExploreSettings.DatasetChart> {
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private TransactionService transactionService;

    public RelatedChartsIterable() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public IterableDescription<SerializedDataset, DatasetExploreSettings.DatasetChart> getDescription() {
        return IterableDescription.iterablePlaceholder(SerializedDataset.class, DatasetExploreSettings.DatasetChart.class, "$chart");
    }

    @Override
    public Collection<DatasetExploreSettings.DatasetChart> resolve(FlowDocumentContext flowDocumentContext, SerializedDataset dataset) throws PlaceholderExpectedException {
        Transaction t = this.transactionService.beginRead();
        try {
            String smartName = DatasetLocUtils.forDataset(dataset).getSmartName(flowDocumentContext.projectKey);
            List<DatasetExploreSettings.DatasetChart> list = this.exploresService.listChartsForDatasetUnsafe(flowDocumentContext.projectKey, smartName);
            return list;
        }
        catch (IOException e) {
            throw PlaceholderExpectedException.createWithLog("Unable to read charts for the dataset " + dataset.getFullName(), e);
        }
        finally {
            if (t != null) {
                try {
                    t.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }
}

