/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractCardContainer
extends Card {
    public List<Card> cards = new ArrayList<Card>();

    public Card get(int index) {
        return this.cards.get(index);
    }

    public AbstractCardContainer withCards(List<Card> cards) {
        AbstractCardContainer copy = (AbstractCardContainer)((Object)JSON.deepCopy((Object)((Object)this)));
        copy.cards = cards;
        return copy;
    }

    protected abstract AbstractCardContainerResult buildContainerResult(List<CardResult> var1);

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        final ArrayList<CompiledCard> compiledChildCards = new ArrayList<CompiledCard>();
        for (Card card : this.cards) {
            compiledChildCards.add(card.compile());
        }
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                ArrayList<Computation> computations = new ArrayList<Computation>();
                for (CompiledCard compiledChild : compiledChildCards) {
                    computations.add(compiledChild.getComputationPlan());
                }
                return new MultiComputation(computations);
            }

            @Override
            public AbstractCardContainerResult buildResult(ComputationResult result, ComputationResultDataStreamer dataStreamer) {
                ArrayList perCardComputationResults = new ArrayList();
                if (result.isAvailable()) {
                    Iterables.addAll(perCardComputationResults, (Iterable)result.asMulti());
                } else {
                    Iterables.addAll(perCardComputationResults, Collections.nCopies(compiledChildCards.size(), result));
                }
                ArrayList<CardResult> cardResults = new ArrayList<CardResult>();
                for (int i = 0; i < AbstractCardContainer.this.cards.size(); ++i) {
                    CompiledCard compiledCard = (CompiledCard)compiledChildCards.get(i);
                    CardResult compiledCardResult = compiledCard.buildResult((ComputationResult)((Object)perCardComputationResults.get(i)), dataStreamer);
                    ComputationResult.ComputationCounts counts = ((ComputationResult)((Object)perCardComputationResults.get(i))).getComputationCounts();
                    compiledCardResult.computationCount = counts.computationsCount;
                    compiledCardResult.notComputedCount = counts.notComputedCount;
                    compiledCardResult.failedComputationsCount = counts.failedComputationsCount;
                    cardResults.add(compiledCardResult);
                }
                return AbstractCardContainer.this.buildContainerResult(cardResults);
            }
        };
    }

    public static abstract class AbstractCardContainerResult
    extends CardResult {
        public List<CardResult> results;
    }
}

