/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.experimenttracking;

import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.mlflow.api.proto.Service;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;

@UIModel
public class RunMetric {
    public String key;
    @UINullable
    public double value;
    public long timestamp;
    public long step;
    @UINullable
    public String invalidValue;

    public RunMetric() {
    }

    public RunMetric(String key, double value, long step, long timestamp) {
        this.key = key;
        this.value = value;
        this.timestamp = timestamp;
        this.step = step;
    }

    public Service.Metric toMLflowMetric() {
        Service.Metric.Builder mlflowMetricBuilder = Service.Metric.newBuilder();
        mlflowMetricBuilder.setKey(this.key);
        mlflowMetricBuilder.setValue(this.value);
        mlflowMetricBuilder.setTimestamp(this.timestamp);
        mlflowMetricBuilder.setStep(this.step);
        return mlflowMetricBuilder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RunMetric)) {
            return false;
        }
        RunMetric runMetric = (RunMetric)o;
        return Double.compare(runMetric.value, this.value) == 0 && this.timestamp == runMetric.timestamp && this.step == runMetric.step && Objects.equals(this.key, runMetric.key);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.timestamp, this.step);
    }

    static {
        JSON.registerAdapter(RunMetric.class, (Object)new JsonSerializer<RunMetric>(){

            public JsonElement serialize(RunMetric runMetric, Type type, JsonSerializationContext ctx) {
                JsonObject ret = new JsonObject();
                ret.addProperty("key", runMetric.key);
                ret.addProperty("timestamp", (Number)runMetric.timestamp);
                ret.addProperty("step", (Number)runMetric.step);
                if (Double.isFinite(runMetric.value)) {
                    ret.addProperty("value", (Number)runMetric.value);
                } else {
                    ret.addProperty("value", (Number)0);
                    ret.addProperty("invalidValue", Double.toString(runMetric.value));
                }
                return ret;
            }
        });
    }
}

