/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.CustomExporterPythonKernel;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.LoadedPythonExporter;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.log4j.Logger;

public class CustomPythonExportOutput
implements ExportOutput {
    protected final AuthCtx authCtx;
    protected final String projectKey;
    protected final JsonObject config;
    protected final LoadedPythonExporter loaded;
    protected final CustomPythonExportersService customPythonExporterService;
    private SingleCommandKernelLink link;
    private CustomExporterPythonKernel kernel;
    private SingleCommandKernelLink.IOCallable<SecretProtectedKernelLink.AcknowledgeResponse> commandResult;
    private final CSVOutputFormatter formatter;
    private PipedOutputStream csvOutputStream;
    private ColumnFactory cf;
    private static Logger logger = Logger.getLogger((String)"dip.pyexporter.output");

    public CustomPythonExportOutput(AuthCtx authCtx, String projectKey, JsonObject config, LoadedPythonExporter loaded, CustomPythonExportersService customPythonExporterService) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.loaded = loaded;
        this.customPythonExporterService = customPythonExporterService;
        this.formatter = this.getCsvWriter();
    }

    private CSVOutputFormatter getCsvWriter() {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        config.setSeparatorStr(",");
        config.parseHeaderRow = false;
        return new CSVOutputFormatter(config);
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.cf = cf;
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        String secret = SecretKeyGenerator.generate((int)16);
        this.link = new SingleCommandKernelLink(secret, dssPortRange);
        String envName = new CodeEnvSelector().selectForCustomPythonRecipe(this.loaded.ownerPluginId);
        this.kernel = new CustomExporterPythonKernel(this.authCtx, this.link, this.customPythonExporterService.getResourceFolder(this.loaded.getType()), this.customPythonExporterService.getLibFolder(this.loaded.getType()), this.projectKey, envName, job.ticket);
        this.kernel.start();
        for (SchemaColumn column : schema.getColumns()) {
            cf.column(column.getName());
        }
        PipedInputStream pis = new PipedInputStream(0x100000);
        this.csvOutputStream = new PipedOutputStream(pis);
        this.formatter.header(cf, this.csvOutputStream);
        PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customPythonExporterService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
        String code = this.customPythonExporterService.getCode(this.loaded.getType());
        CustomExporterPythonKernel.PythonCommand command = new CustomExporterPythonKernel.PythonCommand("export", this.loaded.getExportBehavior(), code, schema, expandedPluginSettings.config, expandedPluginSettings.pluginConfig);
        command.destinationFilePath = this.getDestinationFilePath();
        try {
            this.commandResult = this.link.executeAsync((Object)command, (InputStream)pis, SecretProtectedKernelLink.AcknowledgeResponse.class, "Failed to export rows");
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        logger.info((Object)"Kernel ready to export");
    }

    protected String getDestinationFilePath() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stream(RowInputStream stream) throws Exception {
        logger.info((Object)"Start streaming");
        try {
            try {
                try {
                    Row row = stream.next();
                    while (row != null) {
                        this.formatter.format(row, this.cf, this.csvOutputStream);
                        row = stream.next();
                    }
                    this.formatter.footer(this.cf, this.csvOutputStream);
                }
                finally {
                    this.csvOutputStream.close();
                }
                logger.info((Object)"Done streaming");
            }
            catch (Throwable throwable) {
                logger.info((Object)"Python worker closing");
                if (this.commandResult != null) {
                    SecretProtectedKernelLink.AcknowledgeResponse ack = (SecretProtectedKernelLink.AcknowledgeResponse)this.commandResult.call();
                    logger.info((Object)("Exported " + ack.count + " rows"));
                } else {
                    logger.info((Object)"Python streaming not started, nothing to clean");
                }
                throw throwable;
            }
            logger.info((Object)"Python worker closing");
            if (this.commandResult != null) {
                SecretProtectedKernelLink.AcknowledgeResponse ack = (SecretProtectedKernelLink.AcknowledgeResponse)this.commandResult.call();
                logger.info((Object)("Exported " + ack.count + " rows"));
            } else {
                logger.info((Object)"Python streaming not started, nothing to clean");
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.kernel);
            throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        finally {
            logger.info((Object)"Cleaning up python worker");
            if (this.link != null) {
                this.link.close();
                this.link = null;
            }
            if (this.kernel != null) {
                this.kernel.killWithoutMercy();
                this.kernel = null;
            }
        }
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return 0L;
    }

    @Override
    public void close() {
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) {
    }
}

