/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.sagemaker;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.connections.ConnectionWithAWSAuthCredentials;
import com.dataiku.dip.connections.SageMakerConnection;
import com.dataiku.dip.connections.aws.ShadedS3ConnectionAWSSessionCredentialsProviderV2;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfraRegionDTO;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerCodes;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkClientException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.http.SdkHttpClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.AddTagsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.AddTagsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateModelRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateModelResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DataCaptureConfig;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DeleteEndpointConfigRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DeleteModelRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointConfigResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeModelResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointConfigSortKey;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointConfigSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointSortKey;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Filter;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListEndpointConfigsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListEndpointsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListEndpointsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListModelsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListModelsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListTagsRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ListTagsResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ModelSortKey;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ModelSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Operator;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.OrderKey;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariantInstanceType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ResourceType;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.SageMakerException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.SearchResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.UpdateEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;
import com.google.api.client.util.BackOff;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class SageMakerUtils {
    public static final String SAGEMAKER_RATE_LIMITER_NAME = "sageMakerUtils";
    public static final double DEFAULT_SAGEMAKER_RATE_LIMIT = 5.0;
    public static final int DEFAULT_SAGEMAKER_LISTS_MAX_RESULTS = 100;
    private static final int DEFAULT_ENDPOINT_READINESS_MIN_WAIT_S = 30;
    private static final int DEFAULT_ENDPOINT_READINESS_MAX_WAIT_S = 60;
    private static final int DEFAULT_ENDPOINT_READINESS_TIMEOUT_S = 1800;
    private static final String DEFAULT_ENDPOINT_READINESS_MIN_WAIT_CONFIG_KEY = "dku.deployer.deployment.sagemaker.utils.endpointReadinessMinWaitS";
    private static final String DEFAULT_ENDPOINT_READINESS_MAX_WAIT_CONFIG_KEY = "dku.deployer.deployment.sagemaker.utils.endpointReadinessMaxWaitS";
    private static final String DEFAULT_ENDPOINT_READINESS_TIMEOUT_CONFIG_KEY = "dku.deployer.deployment.sagemaker.utils.endpointReadinessTimeoutS";
    private static final BackOffStrategy ENDPOINT_READINESS_BACKOFF_STRATEGY;
    private static final DKULogger logger;
    private static List<ExternalInfraRegionDTO> sageMakerRegions;

    private SageMakerUtils() {
    }

    public static List<String> getInstanceTypes() {
        return ProductionVariantInstanceType.knownValues().stream().map(ProductionVariantInstanceType::toString).toList();
    }

    public static String getDefaultConfiguredRegion_NT() {
        TransactionContext.assertNoAttachedTransaction();
        try {
            DefaultAwsRegionProviderChain providerChain = new DefaultAwsRegionProviderChain();
            return providerChain.getRegion().id();
        }
        catch (SdkClientException e) {
            logger.warn((Object)"Could not retrieve default AWS region", (Throwable)e);
            return null;
        }
    }

    public static boolean isSageMakerSupported(String region) {
        return SageMakerClient.serviceMetadata().regions().contains(Region.of((String)region));
    }

    public static void checkRate(String action) {
        double waited = SageMakerUtils.getSageMakerRateLimiter().acquire();
        if (waited > 0.0) {
            logger.infoV("Waited %.3f seconds for %s (rate-limited by %s)", new Object[]{waited, action, SAGEMAKER_RATE_LIMITER_NAME});
        }
    }

    private static RateLimiter getSageMakerRateLimiter() {
        return RateLimiterRegistry.forName(SAGEMAKER_RATE_LIMITER_NAME, 5.0);
    }

    public static <B extends AwsClientBuilder<B, C>, C> void addCredentialsFromConnection(AwsClientBuilder<B, C> builder, AuthCtx authCtx, SageMakerConnection connection) {
        if (Objects.nonNull(connection) && !ConnectionWithAWSAuthCredentials.AWSCredentialMode.ENVIRONMENT.equals((Object)connection.params.credentialsMode)) {
            builder.credentialsProvider((AwsCredentialsProvider)new ShadedS3ConnectionAWSSessionCredentialsProviderV2(authCtx, connection));
        }
    }

    public static SageMakerRuntimeClient loginSageMakerRuntime_NT(AuthCtx authCtx, String connectionName, String region, int connectTimeout, int socketTimeout) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Trying to login into aws with region %s ...", new Object[]{region});
        SageMakerConnection connection = (SageMakerConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName);
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        SdkHttpClient.Builder httpClientBuilder = awsClientBrokerService.getHttpClientBuilder(proxySettings, connectTimeout, socketTimeout);
        SageMakerRuntimeClientBuilder clientBuilder = awsClientBrokerService.createSageMakerRuntimeClientBuilder(httpClientBuilder, null, Region.of((String)region));
        SageMakerUtils.addCredentialsFromConnection(clientBuilder, authCtx, connection);
        return (SageMakerRuntimeClient)clientBuilder.build();
    }

    public static SageMakerClient loginSageMaker_NT(AuthCtx authCtx, String connectionName, String region, int connectTimeout, int socketTimeout) throws DKUSecurityException, IOException {
        return SageMakerUtils.loginSageMaker_NT(authCtx, (SageMakerConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, connectionName), region, connectTimeout, socketTimeout);
    }

    public static SageMakerClient loginSageMaker_NT(AuthCtx authCtx, @Nullable SageMakerConnection connection, String region, int connectTimeout, int socketTimeout) {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Trying to login into aws on region %s ...", new Object[]{region});
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        SdkHttpClient.Builder httpClientBuilder = awsClientBrokerService.getHttpClientBuilder(proxySettings, connectTimeout, socketTimeout);
        SageMakerClientBuilder clientBuilder = awsClientBrokerService.createSageMakerClientBuilder(httpClientBuilder, null, Region.of((String)region));
        SageMakerUtils.addCredentialsFromConnection(clientBuilder, authCtx, connection);
        return (SageMakerClient)clientBuilder.build();
    }

    public static SageMakerClient checkAndLoginSageMaker_NT(AuthCtx authCtx, String connectionName, String region, int connectTimeout, int socketTimeout) throws CodedException, DKUSecurityException, IOException {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV(String.format("Trying to login into aws using %s region.", region), new Object[0]);
        if (!SageMakerUtils.isSageMakerSupported(region)) {
            throw new CodedException((InfoMessage.MessageCode)SageMakerCodes.ERR_REGION_NO_SAGEMAKER, String.format("The region %s does not support the use of SageMaker services.", region));
        }
        return SageMakerUtils.loginSageMaker_NT(authCtx, connectionName, region, connectTimeout, socketTimeout);
    }

    public static List<ModelSummary> retrieveModelsList_NT(SageMakerClient sageMakerClient, String modelName, boolean sortAscending) {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Retrieving SageMaker model list filtered by name " + modelName, new Object[0]);
        ArrayList<ModelSummary> ret = new ArrayList<ModelSummary>();
        ListModelsRequest.Builder listModelsRequestBuilder = ListModelsRequest.builder().maxResults(Integer.valueOf(100));
        if (StringUtils.isNotBlank((String)modelName)) {
            listModelsRequestBuilder.nameContains(modelName);
        }
        if (sortAscending) {
            listModelsRequestBuilder.sortBy(ModelSortKey.NAME).sortOrder(OrderKey.ASCENDING);
        }
        ListModelsResponse listModelsResponse = null;
        do {
            SageMakerUtils.checkRate("Retrieve SageMaker models list");
            if (listModelsResponse != null) {
                listModelsRequestBuilder.nextToken(listModelsResponse.nextToken());
            }
            listModelsResponse = sageMakerClient.listModels((ListModelsRequest)listModelsRequestBuilder.build());
            ret.addAll(listModelsResponse.models());
        } while (StringUtils.isNotBlank((String)listModelsResponse.nextToken()));
        return ret;
    }

    public static boolean checkSageMakerModelExists_NT(SageMakerClient sageMakerClient, String modelName) {
        List<ModelSummary> listModelsResult = SageMakerUtils.retrieveModelsList_NT(sageMakerClient, modelName, false);
        return listModelsResult.stream().anyMatch(model -> modelName.equals(model.modelName()));
    }

    public static Optional<DescribeModelResponse> retrieveCheckSageMakerModel_NT(SageMakerClient sageMakerClient, String modelName) {
        logger.debugV("Checking SageMaker model %s exists.", new Object[]{modelName});
        boolean modelExists = SageMakerUtils.checkSageMakerModelExists_NT(sageMakerClient, modelName);
        if (modelExists) {
            logger.debugV("Retrieving SageMaker model description for %s.", new Object[]{modelName});
            return Optional.of(sageMakerClient.describeModel((DescribeModelRequest)DescribeModelRequest.builder().modelName(modelName).build()));
        }
        logger.debugV("SageMaker model with name %s does not exist.", new Object[]{modelName});
        return Optional.empty();
    }

    public static void deleteCheckSageMakerModel_NT(SageMakerClient sageMaker, String modelName) {
        boolean modelExists = SageMakerUtils.checkSageMakerModelExists_NT(sageMaker, modelName);
        if (modelExists) {
            try {
                SageMakerUtils.checkRate("Delete SageMaker Model");
                logger.info((Object)("Deleting SageMaker model with name " + modelName));
                sageMaker.deleteModel((DeleteModelRequest)DeleteModelRequest.builder().modelName(modelName).build());
                logger.info((Object)String.format("SageMaker model with name %s deleted.", modelName));
            }
            catch (SdkException e) {
                logger.errorV((Throwable)e, "Error while deleting SageMaker model %s.", new Object[]{modelName});
                throw e;
            }
        } else {
            logger.info((Object)String.format("SageMaker model with name %s does not exist.", modelName));
        }
    }

    public static AddTagsResponse updateTags_NT(SageMakerClient sageMaker, String resourceArn, Collection<Tag> tags) {
        TransactionContext.assertNoAttachedTransaction();
        SageMakerUtils.checkRate("Update SageMaker Tags");
        logger.debugV("Updating tags for %s.", new Object[]{resourceArn});
        try {
            return sageMaker.addTags((AddTagsRequest)AddTagsRequest.builder().resourceArn(resourceArn).tags(tags).build());
        }
        catch (SdkException e) {
            logger.errorV("Error while updating SageMaker tags for resource %s.", new Object[]{resourceArn});
            throw e;
        }
    }

    public static List<Tag> listTags_NT(SageMakerClient sageMaker, String resourceArn) {
        TransactionContext.assertNoAttachedTransaction();
        SageMakerUtils.checkRate("List SageMaker Tags");
        logger.debugV("Retrieving tags for %s.", new Object[]{resourceArn});
        try {
            ListTagsResponse listTagsResult = sageMaker.listTags((ListTagsRequest)ListTagsRequest.builder().resourceArn(resourceArn).maxResults(Integer.valueOf(100)).build());
            return listTagsResult.tags() != null ? listTagsResult.tags() : new ArrayList();
        }
        catch (SdkException e) {
            logger.errorV("Error while retrieving SageMaker tags for resource %s.", new Object[]{resourceArn});
            throw e;
        }
    }

    public static DescribeEndpointConfigResponse retrieveEndpointConfigDescription_NT(SageMakerClient sageMaker, String endpointConfigName) {
        TransactionContext.assertNoAttachedTransaction();
        SageMakerUtils.checkRate("Retrieve endpoint configuration description");
        logger.debugV("Retrieving endpoint configuration description for %s.", new Object[]{endpointConfigName});
        return sageMaker.describeEndpointConfig((DescribeEndpointConfigRequest)DescribeEndpointConfigRequest.builder().endpointConfigName(endpointConfigName).build());
    }

    public static List<EndpointConfigSummary> retrieveEndpointConfigsList_NT(SageMakerClient sageMakerClient, String endpointConfigName, boolean sortAscending) {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Retrieving SageMaker Endpoint Configs list filtered by name " + endpointConfigName, new Object[0]);
        ArrayList<EndpointConfigSummary> ret = new ArrayList<EndpointConfigSummary>();
        ListEndpointConfigsRequest.Builder listEndpointConfigsRequest = ListEndpointConfigsRequest.builder();
        listEndpointConfigsRequest.maxResults(Integer.valueOf(100));
        if (StringUtils.isNotBlank((String)endpointConfigName)) {
            listEndpointConfigsRequest.nameContains(endpointConfigName);
        }
        if (sortAscending) {
            listEndpointConfigsRequest.sortBy(EndpointConfigSortKey.NAME).sortOrder(OrderKey.ASCENDING);
        }
        ListEndpointConfigsResponse listEndpointConfigsResponse = null;
        do {
            SageMakerUtils.checkRate("Retrieve SageMaker Endpoint Configs list");
            if (listEndpointConfigsResponse != null) {
                listEndpointConfigsRequest.nextToken(listEndpointConfigsResponse.nextToken());
            }
            listEndpointConfigsResponse = sageMakerClient.listEndpointConfigs((ListEndpointConfigsRequest)listEndpointConfigsRequest.build());
            ret.addAll(listEndpointConfigsResponse.endpointConfigs());
        } while (StringUtils.isNotBlank((String)listEndpointConfigsResponse.nextToken()));
        return ret;
    }

    public static List<EndpointSummary> retrieveEndpointList_NT(SageMakerClient sageMaker, @Nullable String endpointName, boolean sortAscending) {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Retrieving SageMaker Endpoint list", new Object[0]);
        ArrayList<EndpointSummary> ret = new ArrayList<EndpointSummary>();
        ListEndpointsRequest.Builder listEndpointsRequest = ListEndpointsRequest.builder();
        listEndpointsRequest.maxResults(Integer.valueOf(100));
        if (StringUtils.isNotBlank((String)endpointName)) {
            listEndpointsRequest.nameContains(endpointName);
        }
        if (sortAscending) {
            listEndpointsRequest.sortBy(EndpointSortKey.NAME).sortOrder(OrderKey.ASCENDING);
        }
        ListEndpointsResponse listEndpointsResponse = null;
        int currentPage = 0;
        do {
            String futureStateName = "Listing endpoints, retrieving result page " + ++currentPage + " (page size: 100)...";
            logger.infoV(futureStateName, new Object[0]);
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)futureStateName);){
                if (listEndpointsResponse != null) {
                    listEndpointsRequest.nextToken(listEndpointsResponse.nextToken());
                }
                SageMakerUtils.checkRate("Retrieve SageMaker Endpoint list");
                listEndpointsResponse = sageMaker.listEndpoints((ListEndpointsRequest)listEndpointsRequest.build());
                ret.addAll(listEndpointsResponse.endpoints());
            }
        } while (StringUtils.isNotBlank((String)listEndpointsResponse.nextToken()));
        logger.infoV("Retrieved %d endpoints", new Object[]{ret.size()});
        return ret;
    }

    public static List<ExternalInfraEndpoint> listSageMakerEndpoints_NT(SageMakerClient sageMaker, @Nullable String endpointName, boolean sortAscending, String region) {
        return SageMakerUtils.retrieveEndpointList_NT(sageMaker, endpointName, sortAscending).stream().map(es -> new ExternalInfraEndpoint(null, es.endpointName(), es.endpointArn(), (DeploymentHealth)((Object)((Object)SageMakerUtils.getEndpointHealth((String)es.endpointStatusAsString(), null).first)), (InfoMessage.InfoMessages)SageMakerUtils.getEndpointHealth((String)es.endpointStatusAsString(), null).second, SageMakerUtils.getEndpointResourceLink(region, es.endpointName()))).toList();
    }

    private static String getEndpointStatus_NT(SageMakerClient sageMaker, @Nonnull String endpointName) {
        try {
            return SageMakerUtils.retrieveEndpointDescription_NT(sageMaker, endpointName).endpointStatusAsString();
        }
        catch (SageMakerException e) {
            if (e.awsErrorDetails().errorMessage().toLowerCase().contains("could not find endpoint")) {
                logger.warnV((Throwable)e, "SageMaker endpoint not found: '%s'", new Object[]{endpointName});
                return "NOT_FOUND";
            }
            logger.warnV((Throwable)e, "Received unexpected SageMaker exception when describing endpoint '%s'", new Object[]{endpointName});
            return "UNKNOWN";
        }
    }

    public static String awaitEndpointCreationResult_NT(SageMakerClient sageMakerClient, @Nonnull String endpointName) throws IOException, InterruptedException {
        long interval;
        BackOff backOffStrategy = ENDPOINT_READINESS_BACKOFF_STRATEGY.build();
        String endpointStatus = SageMakerUtils.getEndpointStatus_NT(sageMakerClient, endpointName);
        while (List.of(EndpointStatus.CREATING.toString(), EndpointStatus.UPDATING.toString()).contains(endpointStatus) && (interval = backOffStrategy.nextBackOffMillis()) > 0L) {
            Thread.sleep(interval);
            endpointStatus = SageMakerUtils.getEndpointStatus_NT(sageMakerClient, endpointName);
        }
        return endpointStatus;
    }

    public static boolean checkSageMakerEndpointConfigExists_NT(SageMakerClient sageMakerClient, String endpointConfigName) {
        List<EndpointConfigSummary> endpointConfigs = SageMakerUtils.retrieveEndpointConfigsList_NT(sageMakerClient, endpointConfigName, false);
        return endpointConfigs.stream().anyMatch(endpointConfig -> endpointConfigName.equals(endpointConfig.endpointConfigName()));
    }

    public static Optional<DescribeEndpointConfigResponse> retrieveCheckEndpointConfig_NT(SageMakerClient sageMakerClient, String endpointConfigName) {
        logger.debugV("Checking SageMaker Endpoint Config with name %s exists.", new Object[]{endpointConfigName});
        boolean endpointConfigExists = SageMakerUtils.checkSageMakerEndpointConfigExists_NT(sageMakerClient, endpointConfigName);
        if (endpointConfigExists) {
            return Optional.of(SageMakerUtils.retrieveEndpointConfigDescription_NT(sageMakerClient, endpointConfigName));
        }
        logger.debugV(String.format("SageMaker Endpoint Config with name %s does not exist.", endpointConfigName), new Object[0]);
        return Optional.empty();
    }

    public static void deleteCheckEndpointConfig_NT(SageMakerClient sageMakerClient, String endpointConfigName) {
        logger.infoV("Deleting SageMaker Endpoint Config with name %s.", new Object[]{endpointConfigName});
        boolean endpointConfigExists = SageMakerUtils.checkSageMakerEndpointConfigExists_NT(sageMakerClient, endpointConfigName);
        if (endpointConfigExists) {
            try {
                SageMakerUtils.checkRate("Delete SageMaker Endpoint Config");
                sageMakerClient.deleteEndpointConfig((DeleteEndpointConfigRequest)DeleteEndpointConfigRequest.builder().endpointConfigName(endpointConfigName).build());
                logger.infoV("SageMaker Endpoint Config with name %s deleted.", new Object[]{endpointConfigName});
            }
            catch (SdkException e) {
                logger.errorV((Throwable)e, "Error while deleting SageMaker Endpoint Config %s.", new Object[]{endpointConfigName});
                throw e;
            }
        } else {
            logger.infoV("SageMaker Endpoint Config with name %s does not exist.", new Object[]{endpointConfigName});
        }
    }

    public static DescribeEndpointResponse retrieveEndpointDescription_NT(SageMakerClient sageMakerClient, String endpointName) {
        TransactionContext.assertNoAttachedTransaction();
        logger.debugV("Retrieving endpoint description for %s.", new Object[]{endpointName});
        SageMakerUtils.checkRate("Retrieve endpoint description ");
        return sageMakerClient.describeEndpoint((DescribeEndpointRequest)DescribeEndpointRequest.builder().endpointName(endpointName).build());
    }

    public static Optional<DescribeEndpointResponse> retrieveCheckEndpointDescription_NT(SageMakerClient sageMakerClient, String endpointName) {
        Optional<Object> result;
        if (SageMakerUtils.checkSageMakerEndpointExists_NT(sageMakerClient, endpointName)) {
            DescribeEndpointResponse describeEndpointResult = SageMakerUtils.retrieveEndpointDescription_NT(sageMakerClient, endpointName);
            result = Optional.of(describeEndpointResult);
        } else {
            logger.debugV(String.format("SageMaker Endpoint with name %s does not exist.", endpointName), new Object[0]);
            result = Optional.empty();
        }
        return result;
    }

    public static boolean checkSageMakerEndpointExists_NT(SageMakerClient sageMakerClient, String endpointName) {
        TransactionContext.assertNoAttachedTransaction();
        SageMakerUtils.checkRate("Search SageMaker endpoint");
        logger.debug((Object)("Check SageMaker endpoint with name " + endpointName + " exists."));
        Filter filter = (Filter)Filter.builder().name("EndpointName").operator(Operator.EQUALS).value(endpointName).build();
        SearchRequest searchRequest = (SearchRequest)SearchRequest.builder().resource(ResourceType.ENDPOINT).searchExpression(s -> s.filters(new Filter[]{filter})).build();
        SearchResponse searchResponse = sageMakerClient.search(searchRequest);
        return !searchResponse.results().isEmpty();
    }

    public static void deleteCheckEndpoint_NT(SageMakerClient sageMakerClient, String endpointName) {
        boolean endpointExists = SageMakerUtils.checkSageMakerEndpointExists_NT(sageMakerClient, endpointName);
        if (endpointExists) {
            SageMakerUtils.checkRate("Delete SageMaker endpoint");
            logger.info((Object)("Deleting SageMaker endpoint with name " + endpointName));
            sageMakerClient.deleteEndpoint(r -> r.endpointName(endpointName));
            logger.info((Object)String.format("SageMaker endpoint with name %s deleted.", endpointName));
        } else {
            logger.info((Object)String.format("SageMaker endpoint with name %s does not exist.", endpointName));
        }
    }

    public static CreateModelResponse createModel_NT(SageMakerClient sageMakerClient, CreateModelRequest createModelRequest) {
        try {
            TransactionContext.assertNoAttachedTransaction();
            SageMakerUtils.checkRate("Create SageMaker Model");
            logger.debugV("Creating SageMaker model with name %s.", new Object[]{createModelRequest.modelName()});
            CreateModelResponse createModelResponse = sageMakerClient.createModel(createModelRequest);
            logger.debugV("SageMaker model %s successfully created.", new Object[]{createModelRequest.modelName()});
            return createModelResponse;
        }
        catch (SdkException e) {
            logger.errorV("Error while creating SageMaker Model with config %s.", new Object[]{createModelRequest.toString()});
            throw e;
        }
    }

    public static CreateEndpointConfigResponse createEndpointConfig_NT(SageMakerClient sageMakerClient, CreateEndpointConfigRequest createEndpointConfigRequest) {
        try {
            TransactionContext.assertNoAttachedTransaction();
            SageMakerUtils.checkRate("Create SageMaker Endpoint Config");
            logger.debugV("Creating SageMaker Endpoint Configuration with name %s.", new Object[]{createEndpointConfigRequest.endpointConfigName()});
            CreateEndpointConfigResponse endpointConfigResponse = sageMakerClient.createEndpointConfig(createEndpointConfigRequest);
            logger.debugV("SageMaker Endpoint Configuration %s successfully created.", new Object[]{createEndpointConfigRequest.endpointConfigName()});
            return endpointConfigResponse;
        }
        catch (SdkException e) {
            logger.errorV("Error while creating SageMaker Endpoint Configuration with config %s.", new Object[]{createEndpointConfigRequest.toString()});
            throw e;
        }
    }

    public static UpdateEndpointResponse updateEndpoint_NT(SageMakerClient sageMakerClient, UpdateEndpointRequest updateEndpointRequest) {
        try {
            TransactionContext.assertNoAttachedTransaction();
            SageMakerUtils.checkRate("Update SageMaker Endpoint");
            logger.debugV("Update SageMaker Endpoint with name %s.", new Object[]{updateEndpointRequest.endpointName()});
            UpdateEndpointResponse updateEndpointResponse = sageMakerClient.updateEndpoint(updateEndpointRequest);
            logger.debugV("SageMaker Endpoint %s successfully updated.", new Object[]{updateEndpointRequest.endpointName()});
            return updateEndpointResponse;
        }
        catch (SdkException e) {
            logger.errorV("Error while updating SageMaker endpoint %s.", new Object[]{updateEndpointRequest.endpointName()});
            throw e;
        }
    }

    public static CreateEndpointResponse createEndpoint_NT(SageMakerClient sageMakerClient, CreateEndpointRequest createEndpointRequest) {
        try {
            TransactionContext.assertNoAttachedTransaction();
            SageMakerUtils.checkRate("Create SageMaker Endpoint");
            logger.debugV("Creating SageMaker Endpoint with name %s.", new Object[]{createEndpointRequest.endpointName()});
            CreateEndpointResponse createEndpointResult = sageMakerClient.createEndpoint(createEndpointRequest);
            logger.debugV("Endpoint %s successfully created.", new Object[]{createEndpointRequest.endpointName()});
            return createEndpointResult;
        }
        catch (SdkException e) {
            logger.errorV("Error while creating SageMaker endpoint %s.", new Object[]{createEndpointRequest.endpointName()});
            throw e;
        }
    }

    public static InvokeEndpointResponse invokeEndpoint_NT(SageMakerRuntimeClient sageMakerRuntime, InvokeEndpointRequest invokeEndpointRequest) {
        try {
            TransactionContext.assertNoAttachedTransaction();
            logger.debugV("Invoke SageMaker Endpoint with name %s.", new Object[]{invokeEndpointRequest.endpointName()});
            return sageMakerRuntime.invokeEndpoint(invokeEndpointRequest);
        }
        catch (SdkException e) {
            logger.errorV("Error while invoking SageMaker endpoint %s.", new Object[]{invokeEndpointRequest.endpointName()});
            throw e;
        }
    }

    public static FutureResponse<List<ExternalInfraEndpoint>> startListEndpoints_NT(DSSAuthCtx user, String projectKey, String connection, String region, int connectTimeout, int socketTimeout) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        EndpointListingFutureThread elft = new EndpointListingFutureThread(user, projectKey, connection, region, connectTimeout, socketTimeout);
        return futureService.runFuture(elft, 0L, new TypeToken<FutureResponse<List<ExternalInfraEndpoint>>>(){});
    }

    public static List<ExternalInfraRegionDTO> getSageMakerRegions_NT() {
        if (null == sageMakerRegions) {
            sageMakerRegions = new ArrayList<ExternalInfraRegionDTO>();
            String defaultConfiguredRegion = SageMakerUtils.getDefaultConfiguredRegion_NT();
            sageMakerRegions = Region.regions().stream().filter(r -> SageMakerUtils.isSageMakerSupported(r.id())).sorted(Comparator.comparing(Region::id)).map(r -> new ExternalInfraRegionDTO(r.id(), r.metadata().description(), StringUtils.equals((String)r.id(), (String)defaultConfiguredRegion))).toList();
        }
        return sageMakerRegions;
    }

    public static ProxyModelVersionConfiguration.ConsolidatedEndpointInfo getConsolidatedEndpointInfo_NT(AuthCtx authCtx, String connection, String region, String endpointName, int connectTimeout, int socketTimeout) throws IOException, DKUSecurityException {
        SageMakerClient asm = SageMakerUtils.loginSageMaker_NT(authCtx, connection, region, connectTimeout, socketTimeout);
        try {
            DescribeEndpointResponse describeEndpointResult = SageMakerUtils.retrieveEndpointDescription_NT(asm, endpointName);
            DescribeEndpointConfigResponse describeEndpointConfigResult = SageMakerUtils.retrieveEndpointConfigDescription_NT(asm, describeEndpointResult.endpointConfigName());
            return new DSSSageMakerConsolidatedEndpointInfo(describeEndpointResult, describeEndpointConfigResult);
        }
        catch (SageMakerException e) {
            ProxyModelVersionConfiguration.ErrorEndpointInfo ret = new ProxyModelVersionConfiguration.ErrorEndpointInfo();
            ret.errorMessage = e.getMessage();
            return ret;
        }
    }

    public static Pair<DeploymentHealth, InfoMessage.InfoMessages> getEndpointHealth(@Nullable String endpointStatus, @Nullable String failureMessage) {
        DeploymentHealth endpointHealth;
        InfoMessage.InfoMessages endpointHealthMessages = new InfoMessage.InfoMessages();
        if (EndpointStatus.FAILED.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.UNHEALTHY;
            endpointHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_FAILED_STATE, (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)failureMessage, (CharSequence)""));
        } else if (EndpointStatus.OUT_OF_SERVICE.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.UNHEALTHY;
            endpointHealthMessages.withError((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_OUT_OF_SERVICE_STATE, "SageMaker endpoint is not available to take incoming requests.");
        } else if (EndpointStatus.ROLLING_BACK.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_ROLLING_BACK_STATE, "The SageMaker endpoint is rolling back.");
        } else if (EndpointStatus.SYSTEM_UPDATING.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_SYSTEM_UPDATE_STATE, "The SageMaker endpoint is updating system.");
        } else if (EndpointStatus.DELETING.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_DELETING_STATE, "");
        } else if (EndpointStatus.UPDATING.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_UPDATING_STATE, "Refresh to fetch the latest status.");
        } else if (EndpointStatus.CREATING.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.WARNING;
            endpointHealthMessages.withWarning((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_CREATING_STATE, "Refresh to fetch the latest status.");
        } else if (EndpointStatus.IN_SERVICE.toString().equals(endpointStatus)) {
            endpointHealth = DeploymentHealth.HEALTHY;
            endpointHealthMessages.withSuccess((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_IN_SERVICE_STATE, "The SageMaker endpoint is available to process incoming requests.");
        } else {
            endpointHealth = DeploymentHealth.UNKNOWN;
            endpointHealthMessages.withWarningV((InfoMessage.MessageCode)DeployerCodes.INFO_API_DEPLOYER_SAGEMAKER_UNKNOWN_STATE, "The SageMaker endpoint is in status %s.", new Object[]{endpointStatus});
        }
        return new Pair((Object)endpointHealth, (Object)endpointHealthMessages);
    }

    private static String getEndpointResourceLink(String region, String endpointName) {
        return String.format("https://%s.console.aws.amazon.com/sagemaker/home#/endpoints/%s", region, endpointName);
    }

    static {
        int endpointReadinessBackOffMinWaitS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_MIN_WAIT_CONFIG_KEY, Integer.valueOf(30));
        int endpointReadinessBackOffMaxWaitS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_MAX_WAIT_CONFIG_KEY, Integer.valueOf(60));
        int endpointReadinessBackOffTimeoutS = DKUApp.getParams().getIntParam(DEFAULT_ENDPOINT_READINESS_TIMEOUT_CONFIG_KEY, Integer.valueOf(1800));
        ENDPOINT_READINESS_BACKOFF_STRATEGY = BackOffStrategy.expBackOff((int)(endpointReadinessBackOffMinWaitS * 1000), (int)(endpointReadinessBackOffMaxWaitS * 1000), (double)1.015, (int)(endpointReadinessBackOffTimeoutS * 1000));
        logger = DKULogger.getLogger((String)"dku.externalinfras.sagemaker.utils");
    }

    public static class EndpointListingFutureThread
    extends FutureThread<List<ExternalInfraEndpoint>> {
        private final String projectKey;
        private final String connection;
        private final String region;
        private List<ExternalInfraEndpoint> result;
        private final FuturePayload futurePayload;
        private final int connectTimeout;
        private final int socketTimeout;

        public EndpointListingFutureThread(DSSAuthCtx user, String projectKey, String connection, String region, int connectTimeout, int socketTimeout) {
            super(user);
            this.projectKey = projectKey;
            this.connection = connection;
            this.region = region;
            this.futurePayload = this.buildFuturePayload();
            this.connectTimeout = connectTimeout;
            this.socketTimeout = socketTimeout;
        }

        public FuturePayload buildFuturePayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "list_endpoints";
            String id = this.region + "_" + this.connection;
            fp.targets.add(new FuturePayload.FuturePayloadTarget(this.projectKey, id, id, "BUNDLE"));
            fp.displayName = "List endpoints in " + this.region + " authentication with optional connection " + this.connection;
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<ExternalInfraEndpoint> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            SageMakerClient sageMakerClient;
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Login on SageMaker...");){
                sageMakerClient = SageMakerUtils.checkAndLoginSageMaker_NT(this.owner, this.connection, this.region, this.connectTimeout, this.socketTimeout);
            }
            this.result = SageMakerUtils.listSageMakerEndpoints_NT(sageMakerClient, null, true, this.region);
        }
    }

    public static class DSSSageMakerConsolidatedEndpointInfo
    extends ProxyModelVersionConfiguration.ConsolidatedEndpointInfo {
        public String arn;
        public String configName;
        public String configArn;
        public String endpointName;
        public List<DSSSageMakerProductionVariant> variants = new ArrayList<DSSSageMakerProductionVariant>();
        @Nullable
        public DataCaptureConfig dataCaptureConfig = (DataCaptureConfig)DataCaptureConfig.builder().build();

        public DSSSageMakerConsolidatedEndpointInfo() {
        }

        public DSSSageMakerConsolidatedEndpointInfo(DescribeEndpointResponse describeEndpointResponse, DescribeEndpointConfigResponse describeEndpointConfigResponse) {
            this.arn = describeEndpointResponse.endpointArn();
            this.endpointName = describeEndpointResponse.endpointName();
            this.configName = describeEndpointConfigResponse.endpointConfigName();
            this.configArn = describeEndpointConfigResponse.endpointConfigArn();
            this.variants = describeEndpointConfigResponse.productionVariants().stream().map(DSSSageMakerProductionVariant::new).collect(Collectors.toList());
            this.dataCaptureConfig = describeEndpointConfigResponse.dataCaptureConfig();
            this.predictionLogsUri = this.dataCaptureConfig == null ? null : this.dataCaptureConfig.destinationS3Uri();
        }

        @Override
        public InfoMessage.InfoMessages computeDifferences(@Nonnull ProxyModelVersionConfiguration.ConsolidatedEndpointInfo other) {
            Sets.SetView difference;
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (other.getClass() == ProxyModelVersionConfiguration.ErrorEndpointInfo.class) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Remote endpoint error", ((ProxyModelVersionConfiguration.ErrorEndpointInfo)other).errorMessage));
                return ret;
            }
            if (this.getClass() != other.getClass()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Wrong type", "Type mismatch between configuration and remote endpoint"));
                return ret;
            }
            DSSSageMakerConsolidatedEndpointInfo sageMakerOther = (DSSSageMakerConsolidatedEndpointInfo)other;
            if (!StringUtils.equals((String)this.arn, (String)sageMakerOther.arn)) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Arn differs", String.format("Arn at version creation: %s. Current Arn: %s.", this.arn, sageMakerOther.arn)));
            }
            if (!StringUtils.equals((String)this.configName, (String)sageMakerOther.configName)) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Configuration name differs", String.format("Configuration name at version creation: %s. Current configuration name: %s.", this.configName, sageMakerOther.configName)));
            }
            if (!StringUtils.equals((String)this.configArn, (String)sageMakerOther.configArn)) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Configuration Arn differs", String.format("Configuration Arn at version creation: %s. Current configuration name: %s.", this.configArn, sageMakerOther.configArn)));
            }
            if (!(difference = Sets.difference(this.variants.stream().map(v -> v.modelName).collect(Collectors.toSet()), sageMakerOther.variants.stream().map(v -> v.modelName).collect(Collectors.toSet()))).isEmpty()) {
                String msg = String.format("Models at version creation: %s.%nCurrent models: %s", this.variants.stream().map(v -> v.modelName).sorted().collect(Collectors.joining(", ")), sageMakerOther.variants.stream().map(v -> v.modelName).sorted().collect(Collectors.joining(", ")));
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Deployed models differ", msg));
            } else {
                List currentWeights;
                List creationWeights = this.variants.stream().sorted(Comparator.comparing(v -> v.modelName)).map(v -> v.weight).collect(Collectors.toList());
                if (!creationWeights.equals(currentWeights = sageMakerOther.variants.stream().sorted(Comparator.comparing(v -> v.modelName)).map(v -> v.weight).collect(Collectors.toList()))) {
                    String msg = String.format("Models at version creation: %s.%nCurrent models: %s", this.variants.stream().map(v -> v.modelName + " -> " + v.weight).sorted().collect(Collectors.joining(", ")), sageMakerOther.variants.stream().map(v -> v.modelName + " -> " + v.weight).sorted().collect(Collectors.joining(", ")));
                    ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Model weights differ", msg));
                }
            }
            if (ret.messages.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.INFO, "Information matches", "The endpoint has the same configuration as when this DSS saved model version was created"));
            }
            return ret;
        }
    }

    public static class DSSSageMakerProductionVariant {
        public String name;
        public String modelName;
        public Float weight;

        public DSSSageMakerProductionVariant() {
        }

        public DSSSageMakerProductionVariant(ProductionVariant pv) {
            this.name = pv.variantName();
            this.modelName = pv.modelName();
            this.weight = pv.initialVariantWeight();
        }
    }
}

