/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.fs.FSDatasetUtils;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.formats.excel.ExcelFilesAnalyzer;
import com.dataiku.dip.formats.excel.ExcelFormatExtractor;
import com.dataiku.dip.formats.excel.model.ExcelWorkbook;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.formats.FileBasedFormatDetector;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class ExcelFormatDetector
implements FileBasedFormatDetector {
    private static final String EXCEL = "excel";
    private static final String SHEET_NAME_IMPORT_ALL = "__DKU_ALL__";
    private static final Logger logger = Logger.getLogger((String)"dku.formats.excel");

    public ExcelFormatDetector() {
        Preconditions.checkState((boolean)PoiUtils.isInitialized(), (Object)"POI not initialized");
    }

    @Override
    public Map<String, String> recomputeMetadata(String autoDetectedFormatId, Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        if (EXCEL.equals(autoDetectedFormatId) && ExcelFilesAnalyzer.isExcelFileType(filename)) {
            String password = null;
            if (dataset.getFormatParams() instanceof ExcelFormatExtractor.Config) {
                PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
                ExcelFormatExtractor.Config config = dataset.getFormatParamsAs(ExcelFormatExtractor.Config.class);
                password = cryptoService.decryptIfEncrypted(config.password);
            }
            try (ExcelWorkbook wb = ExcelFilesAnalyzer.readWorkbook(split.getStreamForPath(path), password);){
                Map<String, String> map = ExcelFormatDetector.buildMetadata(wb.listSheetNames());
                return map;
            }
        }
        return null;
    }

    @Override
    public List<InputFormatsDetector.FormatWithMetadata> detect(Dataset dataset, FSDatasetUtils.PathsBasedSplit split, FSPath path, String filename) throws Exception {
        String preferredSheetNames;
        EnrichedInputStream eis = split.getStreamForPath(path);
        InputFormatsDetector.FormatWithMetadata fwm = ExcelFormatDetector.detect(eis, filename, preferredSheetNames = dataset.getParams() instanceof FilesystemDatasetConfig ? ((FilesystemDatasetConfig)dataset.getParams()).sheetName : null);
        if (fwm != null) {
            return Lists.newArrayList((Object[])new InputFormatsDetector.FormatWithMetadata[]{fwm});
        }
        return new ArrayList<InputFormatsDetector.FormatWithMetadata>();
    }

    @VisibleForTesting
    public static InputFormatsDetector.FormatWithMetadata detect(EnrichedInputStream eis, String filename, String preferredSheetNames) {
        InputFormatsDetector.FormatWithMetadata formatWithMetadata;
        block10: {
            if (!ExcelFilesAnalyzer.isExcelFileType(filename)) {
                logger.error((Object)"Detected as an Excel file but the filename extension is not .xlsx, .xls, .xlsb, .xltx, .xlsm, .xlt or .xltm");
                return null;
            }
            ExcelWorkbook wb = ExcelFilesAnalyzer.readWorkbook(eis.decompressedStream(), null);
            try {
                List<String> sheetNames = wb.listSheetNames();
                List<String> sheetNamesToImport = ExcelFormatDetector.getSheetNamesToImport(sheetNames, preferredSheetNames);
                int detectOnSheetIndex = sheetNames.indexOf(sheetNamesToImport.get(0));
                InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
                fwm.type = EXCEL;
                fwm.params = ExcelFormatDetector.buildConfig(wb, detectOnSheetIndex, sheetNamesToImport);
                fwm.metadata = ExcelFormatDetector.buildMetadata(sheetNames);
                formatWithMetadata = fwm;
                if (wb == null) break block10;
            }
            catch (Throwable sheetNames) {
                try {
                    if (wb != null) {
                        try {
                            wb.close();
                        }
                        catch (Throwable throwable) {
                            sheetNames.addSuppressed(throwable);
                        }
                    }
                    throw sheetNames;
                }
                catch (ExcelFilesAnalyzer.EncryptedFileException e) {
                    logger.warn((Object)("Detected as an encrypted Excel file so we can't read the list of sheets: " + filename));
                    InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
                    fwm.type = EXCEL;
                    fwm.params = ExcelFormatDetector.buildConfigWithPasswordRequired();
                    return fwm;
                }
                catch (Exception e) {
                    logger.error((Object)("Extension is xlsx/xlsm/xls but could not open as an Excel file: " + filename), (Throwable)e);
                    return null;
                }
            }
            wb.close();
        }
        return formatWithMetadata;
    }

    private static List<String> getSheetNamesToImport(List<String> allSheetNames, String value) {
        if (value == null) {
            return Arrays.asList(allSheetNames.get(0));
        }
        if (SHEET_NAME_IMPORT_ALL.equals(value)) {
            return allSheetNames;
        }
        List<String> sheetNamesToImport = Arrays.stream(value.split("\n")).filter(allSheetNames::contains).collect(Collectors.toList());
        if (sheetNamesToImport.isEmpty()) {
            sheetNamesToImport = Arrays.asList(allSheetNames.get(0));
        }
        return sheetNamesToImport;
    }

    private static Map<String, String> buildMetadata(List<String> sheetNames) {
        HashMap<String, String> meta = new HashMap<String, String>();
        int nbSheets = sheetNames.size();
        meta.put("nbSheets", String.valueOf(nbSheets));
        for (int i = 0; i < nbSheets; ++i) {
            meta.put("sheet." + i + ".name", sheetNames.get(i));
        }
        return meta;
    }

    private static ExcelFormatExtractor.Config buildConfigWithPasswordRequired() {
        ExcelFormatExtractor.Config config = new ExcelFormatExtractor.Config();
        config.parseHeaderRow = true;
        config.skipRowsBeforeHeader = 0;
        config.preserveNumberFormatting = false;
        config.sheetSelectionMode = ExcelFormatExtractor.SheetSelectionMode.ALL;
        config.sheetsToColumn = false;
        config.passwordRequired = true;
        return config;
    }

    private static ExcelFormatExtractor.Config buildConfig(ExcelWorkbook wb, int detectOnSheetIndex, List<String> sheetNamesToImport) {
        ExcelWorkbook.Sheet s = wb.getSheetAt(detectOnSheetIndex);
        int firstValidRowId = -1;
        for (int minValidCells = 3; minValidCells >= 1; --minValidCells) {
            ExcelWorkbook.Row r;
            Iterator iterator = s.iterator();
            while (iterator.hasNext() && (r = (ExcelWorkbook.Row)iterator.next()).getRowNum() < 30) {
                if (ExcelFormatDetector.getNbValidCells(r) < minValidCells) continue;
                firstValidRowId = r.getRowNum();
                break;
            }
            if (firstValidRowId >= 0) break;
        }
        ExcelFormatExtractor.Config config = new ExcelFormatExtractor.Config();
        boolean bl = config.parseHeaderRow = firstValidRowId >= 0;
        if (firstValidRowId >= 1) {
            config.skipRowsBeforeHeader = firstValidRowId;
        }
        config.preserveNumberFormatting = false;
        config.sheets = "*" + String.join((CharSequence)"\n", sheetNamesToImport);
        config.sheetsToColumn = sheetNamesToImport.size() > 1;
        return config;
    }

    private static int getNbValidCells(ExcelWorkbook.Row row) {
        if (row == null) {
            return 0;
        }
        int valid = 0;
        for (ExcelWorkbook.Cell cell : row) {
            if (cell == null || cell.isEmpty()) continue;
            ++valid;
        }
        return valid;
    }
}

