/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.charts.execution;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.docgen.model.MdgCodes;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.graphicsexport.charts.execution.DomElementEnrichedExport;
import com.dataiku.dip.graphicsexport.execution.ExportScriptRunner;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChartExportScriptRunner
extends ExportScriptRunner {
    public ChartExportScriptRunner(DomElementEnrichedExport export, File exportDirectory, InternalAPIKeysService.APIKey apiKey, final FutureProgressState progressState, final InfoMessage.InfoMessages messages) {
        super(export, exportDirectory, apiKey);
        ExportScriptRunner.ExportProgressObserver progressObserver = new ExportScriptRunner.ExportProgressObserver(){

            @Override
            public void update(int exportedCount) throws InterruptedException {
                progressState.set((double)exportedCount);
            }
        };
        ExportScriptRunner.ExportWarningObserver warningObserver = new ExportScriptRunner.ExportWarningObserver(){

            @Override
            public void update(String details) {
                InfoMessage errorMessage = InfoMessage.warning((InfoMessage.MessageCode)MdgCodes.ERR_PUPPETEER_STEP_FAILED, (String)details);
                messages.addMessage(errorMessage);
            }
        };
        ExportScriptRunner.ProgressSubscription progressSubscription = new ExportScriptRunner.ProgressSubscription(progressObserver, this.getLogProgressMarker());
        ExportScriptRunner.WarningSubscription warningSubscription = new ExportScriptRunner.WarningSubscription(warningObserver, this.getLogWarningMarker());
        this.outputSubscriptions.addAll(Arrays.asList(progressSubscription, warningSubscription));
    }

    @Override
    protected String getScriptFileName() {
        return "export-charts.js";
    }

    @Override
    protected ExportScriptRunner.ScriptConfig getScriptConfig() {
        Config result = new Config();
        result.browserSandBoxing = this.export.browserSandBoxing;
        result.pageDefaultTimeout = ApplicationConfigurator.getProperty((String)"dku.exports.puppeteer.pageDefaultTimeout", (int)0);
        result.outputDirectory = this.exportDirectory.getAbsolutePath();
        result.fileType = String.valueOf((Object)this.export.format.fileType);
        result.width = String.valueOf(this.export.format.width);
        result.height = String.valueOf(this.export.format.height);
        result.puppeteerInstructions = new ArrayList<DomElementEnrichedExport.Target>();
        for (DomElementEnrichedExport.Target item : ((DomElementEnrichedExport)this.export).elements) {
            if (item.steps.size() == 0) continue;
            result.puppeteerInstructions.add(item);
        }
        return result;
    }

    @Override
    protected String getLogProgressMarker() {
        return "Processing export step";
    }

    private static class Config
    implements ExportScriptRunner.ScriptConfig {
        public boolean browserSandBoxing;
        public int pageDefaultTimeout;
        public String outputDirectory;
        public String fileType;
        public String width;
        public String height;
        public List<DomElementEnrichedExport.Target> puppeteerInstructions;

        private Config() {
        }
    }
}

