/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.MetastoreDBBasedConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.HiveQueryDatasetHandler;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.JSONUtils;
import com.dataiku.dip.formats.avro.AvroFormatMeta;
import com.dataiku.dip.formats.avro.SchemaConverter;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.hive.DescribeFormattedParser;
import com.dataiku.dip.hive.HiveMetadataTools;
import com.dataiku.dip.hive.HiveTableMeta;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.DataikuHiveXMLUDFFormat;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import com.dataiku.dip.input.formats.hive.sequencefile.SequenceFileFormatMeta;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatMeta;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.SafeColumnNamer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.PartitionSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.dataiku.hproxy.model.hive.ValidationResult;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableInt;

public class HiveSchemaHandler {
    public static final String DSS_DEFAUT_HIVE_TABLE_TAG = "DSS_DEFAUT_HIVE_TABLE_TAG";
    private static final HashMap<String, Type> hiveToDkuTypeMap = new HashMap();
    private static final HashSet<String> hiveToDkuLoss = new HashSet();
    private static final Set<String> hiveTypesWithExtraInfo = Sets.newHashSet();
    private static final Pattern validColumnNamePattern;
    private static DKULogger logger;

    public static String hiveTypeFromSchemaType(SchemaColumn col) {
        return HiveSchemaHandler.hiveTypeFromSchemaType(col, true);
    }

    public static String hiveTypeFromSchemaTypeAsHiveWouldReturnIt(SchemaColumn col) {
        return HiveSchemaHandler.hiveTypeFromSchemaType(col, false);
    }

    private static String hiveTypeFromSchemaType(SchemaColumn col, boolean quoteFielsInCplxTypes) {
        switch (col.getType()) {
            case TINYINT: {
                return "tinyint";
            }
            case SMALLINT: {
                return "smallint";
            }
            case INT: {
                return "int";
            }
            case BIGINT: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case STRING: {
                if (col.getMaxLength() > -1 && "true".equals(ApplicationConfigurator.getProperty((String)"hadoop.hive.forceVarchar", (String)"false"))) {
                    return "varchar(" + col.getMaxLength() + ")";
                }
                return "string";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: {
                return "timestamp";
            }
            case DATEONLY: {
                return "date";
            }
            case DATETIMENOTZ: {
                return "timestamp";
            }
            case ARRAY: {
                SchemaColumn arrayContent = col.arrayContent;
                if (arrayContent == null) {
                    throw ErrorContext.iaef((String)"In column %s: cannot handle an array without an explicit content type to Hive", (Object)col.getName(), (Object[])new Object[0]);
                }
                String hiveArrayContentType = HiveSchemaHandler.hiveTypeFromSchemaType(arrayContent, quoteFielsInCplxTypes);
                return "array<" + hiveArrayContentType + ">";
            }
            case MAP: {
                if (col.mapKeys == null || col.mapValues == null) {
                    throw ErrorContext.iaef((String)"In column %s: cannot handle a map without explicit keys and values types to Hive", (Object)col.getName(), (Object[])new Object[0]);
                }
                if (!col.mapKeys.getType().isPrimitive()) {
                    throw ErrorContext.iaef((String)"In column %s:  Map keys must be a primitive type, was %s instead", (Object)col.getName(), (Object[])new Object[]{col.mapKeys.getType()});
                }
                String keyType = HiveSchemaHandler.hiveTypeFromSchemaType(col.mapKeys, quoteFielsInCplxTypes);
                String valueType = HiveSchemaHandler.hiveTypeFromSchemaType(col.mapValues, quoteFielsInCplxTypes);
                return "map<" + keyType + "," + valueType + ">";
            }
            case OBJECT: {
                if (col.objectFields == null || col.objectFields.size() == 0) {
                    throw ErrorContext.iaef((String)"In column %s: cannot handle an object without explicit fields", (Object)col.getName(), (Object[])new Object[0]);
                }
                ArrayList<CallSite> subtypes = new ArrayList<CallSite>();
                for (SchemaColumn fieldCol : col.objectFields) {
                    Object fieldName = fieldCol.getName().toLowerCase(Locale.ENGLISH);
                    if (quoteFielsInCplxTypes) {
                        fieldName = "`" + (String)fieldName + "`";
                    }
                    subtypes.add((CallSite)((Object)((String)fieldName + ":" + HiveSchemaHandler.hiveTypeFromSchemaType(fieldCol, quoteFielsInCplxTypes))));
                }
                return "struct<" + StringUtils.join(subtypes, (String)",") + ">";
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("Geometry column are not supported for Hive mapping");
            }
        }
        throw new Error("Unreachable");
    }

    static void checkChar(String hiveType, MutableInt ptr, char expected) {
        if (hiveType.charAt(ptr.intValue()) != expected) {
            throw new IllegalArgumentException("Parse error, expected " + expected + " at  " + ptr.intValue() + " in " + hiveType + " but found '" + hiveType.charAt(ptr.intValue()) + "'");
        }
    }

    public static SchemaColumn readType(String hiveType, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        MutableInt ptr = new MutableInt();
        return HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
    }

    static SchemaColumn readType(String hiveType, MutableInt ptr, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        SchemaColumn ret = new SchemaColumn();
        ret.setName("");
        if (hiveType.startsWith("map<", ptr.intValue())) {
            ret.setType(Type.MAP);
            ptr.add(4);
            ret.mapKeys = HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
            HiveSchemaHandler.checkChar(hiveType, ptr, ',');
            ptr.increment();
            ret.mapValues = HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
            HiveSchemaHandler.checkChar(hiveType, ptr, '>');
            ptr.increment();
        } else if (hiveType.startsWith("array<", ptr.intValue())) {
            ret.setType(Type.ARRAY);
            ptr.add(6);
            ret.arrayContent = HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
            HiveSchemaHandler.checkChar(hiveType, ptr, '>');
            ptr.increment();
        } else if (hiveType.startsWith("struct<", ptr.intValue())) {
            ret.setType(Type.OBJECT);
            ptr.add(7);
            ret.objectFields = new ArrayList();
            while (hiveType.charAt(ptr.intValue()) != '>') {
                StringBuilder curName = new StringBuilder();
                while (hiveType.charAt(ptr.intValue()) != ':') {
                    curName.append(hiveType.charAt(ptr.intValue()));
                    ptr.increment();
                }
                HiveSchemaHandler.checkChar(hiveType, ptr, ':');
                ptr.increment();
                SchemaColumn curCol = HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
                curCol.setName(curName.toString());
                ret.objectFields.add(curCol);
                if (hiveType.charAt(ptr.intValue()) == ',') {
                    ptr.increment();
                    continue;
                }
                if (hiveType.charAt(ptr.intValue()) != '>') continue;
                ptr.increment();
                break;
            }
        } else {
            for (String type : hiveToDkuTypeMap.keySet()) {
                int endPos;
                if (!hiveType.startsWith(type, ptr.intValue())) continue;
                if ("date".equals(type) && dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING) {
                    ret.setType(Type.STRING);
                } else if ("date".equals(type) && dateonlyReadMode == AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE) {
                    ret.setType(Type.DATE);
                    ret.timestampNoTzAsDate = true;
                } else if ("date".equals(type)) {
                    ret.setType(Type.DATEONLY);
                } else {
                    ret.setType(hiveToDkuTypeMap.get(type));
                }
                ptr.add(type.length());
                StringBuilder originalType = new StringBuilder(type);
                if (hiveTypesWithExtraInfo.contains(type) && hiveType.length() > ptr.intValue() && hiveType.charAt(ptr.intValue()) == '(' && (endPos = hiveType.indexOf(41, ptr.intValue())) >= 0) {
                    originalType.append(hiveType.substring(ptr.intValue(), endPos + 1));
                    int commaPos = hiveType.indexOf(44, ptr.intValue());
                    if (commaPos < 0 || commaPos > endPos) {
                        try {
                            int endNumberPos = Math.min(endPos, commaPos < 0 ? hiveType.length() : commaPos);
                            ret.maxLength = Integer.parseInt(hiveType.substring(ptr.intValue() + 1, endNumberPos));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ptr.setValue(endPos + 1);
                }
                if (!hiveToDkuLoss.contains(type)) break;
                ret.originalType = originalType.toString();
                break;
            }
        }
        return ret;
    }

    public static SchemaColumn dssColumnFromHiveColumnDef(String name, String hiveType, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        MutableInt ptr = new MutableInt();
        hiveType = hiveType.toLowerCase(Locale.ENGLISH);
        SchemaColumn col = HiveSchemaHandler.readType(hiveType, ptr, datetimenotzReadMode, dateonlyReadMode);
        col.setName(name);
        return col;
    }

    public static String detectPotentialSchemaIssues(com.dataiku.dip.coremodel.Schema schema) {
        ArrayList issues = Lists.newArrayList();
        HashSet lowercased = Sets.newHashSet();
        HashSet duplicates = Sets.newHashSet();
        for (Object column : schema.getColumns()) {
            if (column.getName() == null) {
                issues.add("a column has no name");
                continue;
            }
            String name = column.getName().toLowerCase();
            if (lowercased.contains(name)) {
                duplicates.add(name);
            }
            lowercased.add(name);
        }
        if (!duplicates.isEmpty()) {
            issues.add("some columns are duplicated when lowercased (" + Joiner.on((String)", ").join((Iterable)duplicates) + ")");
        }
        HashSet invalids = Sets.newHashSet();
        for (String name : lowercased) {
            if (name.indexOf(44) < 0) continue;
            invalids.add(name);
        }
        if (!invalids.isEmpty()) {
            issues.add("some columns contain invalid characters like ',' (" + Joiner.on((String)", ").join((Iterable)invalids) + ")");
        }
        HashSet invalidTypes = Sets.newHashSet();
        for (SchemaColumn column : schema.getColumns()) {
            if (!HiveSchemaHandler.detectPotentialSchemaTypeIssues(column)) continue;
            invalidTypes.add(column.getName());
        }
        if (!invalidTypes.isEmpty()) {
            issues.add("some columns' complex types contain invalid characters like ',' (" + Joiner.on((String)", ").join((Iterable)invalidTypes) + ")");
        }
        return issues.isEmpty() ? null : "Schema not compatible with Hive : " + Joiner.on((String)", ").join((Iterable)issues);
    }

    private static boolean detectPotentialSchemaTypeIssues(SchemaColumn column) {
        if (column == null) {
            return false;
        }
        if (column.getType() == Type.ARRAY) {
            return HiveSchemaHandler.detectPotentialSchemaTypeIssues(column.arrayContent);
        }
        if (column.getType() == Type.MAP) {
            return HiveSchemaHandler.detectPotentialSchemaTypeIssues(column.mapKeys) || HiveSchemaHandler.detectPotentialSchemaTypeIssues(column.mapValues);
        }
        if (column.getType() == Type.OBJECT && column.objectFields != null) {
            for (SchemaColumn objectField : column.objectFields) {
                if (objectField.getName().indexOf(44) >= 0) {
                    return true;
                }
                if (!HiveSchemaHandler.detectPotentialSchemaTypeIssues(objectField)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tableDefFromSchema(com.dataiku.dip.coremodel.Schema schema) {
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        if (schema.getColumns().size() == 0) {
            throw ErrorContext.iae((String)"Unable to generate empty Hive table definition");
        }
        for (SchemaColumn col : schema.getColumns()) {
            ErrorContext.push((String)("column " + col.getName()));
            try {
                columns.add((CallSite)((Object)("`" + col.getName() + "` " + HiveSchemaHandler.hiveTypeFromSchemaType(col))));
            }
            finally {
                ErrorContext.pop();
            }
        }
        return StringUtils.join(columns, (String)",\n");
    }

    public static String getPartitionedByString(PartitioningScheme scheme) {
        ArrayList<CallSite> chunks = new ArrayList<CallSite>();
        if (scheme.getDimensionNames().size() == 0) {
            throw ErrorContext.iae((String)"Unable to generate empty Hive partitioning scheme");
        }
        for (String dimName : scheme.getDimensionNames()) {
            chunks.add((CallSite)((Object)("`" + dimName + "` string")));
        }
        return StringUtils.join(chunks, (String)",");
    }

    public static String getHiveSettingsHash(Dataset ds) {
        Object hashableString = HiveSchemaHandler.getRowFormat((Dataset)ds, (String)ds.getName(), (MetastoreInspectionService.MetastoreKind)MetastoreInspectionService.MetastoreKind.HIVE_VIA_HS2).asScript;
        FormatMeta<?, ?> formatMeta = FormatFactory.getMeta(ds.getFormatType());
        if (formatMeta == AvroFormatMeta.META) {
            com.dataiku.dip.coremodel.Schema dssSchema = ds.getSchema();
            Schema avroSchema = SchemaConverter.convertSchema(dssSchema);
            hashableString = (String)hashableString + "|||" + String.valueOf(avroSchema);
        }
        return DKUtils.md5Base64((String)hashableString).substring(0, 6);
    }

    public static String getHiveLocationHash(AuthCtx authCtx, Dataset ds) throws IOException, DKUSecurityException, CodedException {
        if (ds.getType().equals("HDFS")) {
            try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(authCtx, ds);){
                String string = DKUtils.md5Base64((String)handler.getEffectiveDatasetRootWithinAuthority()).substring(0, 6);
                return string;
            }
        }
        try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), ds);){
            String string = DKUtils.md5Base64((String)handler.getEffectiveDatasetRootWithinAuthority()).substring(0, 6);
            return string;
        }
    }

    public static String getHivePartitioningHash(Dataset ds) {
        String partitionString = "";
        PartitioningScheme partitioningSchema = ds.getPartitioningSchema();
        if (partitioningSchema != null && partitioningSchema.isPartitioned()) {
            partitionString = HiveSchemaHandler.getPartitionedByString(partitioningSchema);
        }
        return DKUtils.md5Base64((String)partitionString).substring(0, 6);
    }

    public static String getTableProperties(AuthCtx authCtx, Dataset dataset) throws IOException, DKUSecurityException, CodedException {
        return " TBLPROPERTIES(" + HiveSchemaHandler.dumpProperties(HiveSchemaHandler.getTablePropertiesMap(authCtx, dataset, true)) + ") ";
    }

    public static SortedMap<String, String> getTablePropertiesMap(AuthCtx authCtx, Dataset dataset, boolean withHash) throws IOException, DKUSecurityException, CodedException {
        TreeMap<String, String> tblProperties = new TreeMap<String, String>();
        FormatMeta<?, ?> formatMeta = FormatFactory.getMeta(dataset.getFormatType());
        FormatParams formatParams = dataset.getFormatParams();
        if (withHash) {
            HiveTableMeta meta = new HiveTableMeta();
            meta.mgt = true;
            meta.fmt = HiveSchemaHandler.getHiveSettingsHash(dataset);
            meta.part = HiveSchemaHandler.getHivePartitioningHash(dataset);
            meta.loc = HiveSchemaHandler.getHiveLocationHash(authCtx, dataset);
            tblProperties.put(DSS_DEFAUT_HIVE_TABLE_TAG, HiveSchemaHandler.buildDSSTableMeta(meta));
        }
        if (formatMeta == DataikuHiveXMLUDFFormat.META) {
            String xmlElement = dataset.getFormatParamsAs(DataikuHiveXMLUDFFormat.DataikuHiveXMLUDFFormatConfig.class).xml_element;
            tblProperties.put("xml.tag", xmlElement);
        } else if (formatMeta != AvroFormatMeta.META) {
            if (formatMeta == ORCFileFormatMeta.META) {
                ORCFileFormatConfig orcFormatParams = (ORCFileFormatConfig)formatParams;
                if (orcFormatParams.compressionMethod != null) {
                    tblProperties.put("orc.compress", orcFormatParams.compressionMethod.name());
                }
            } else if (formatMeta == ParquetFormatMeta.META) {
                ParquetFormatConfig parquetFormatParams = (ParquetFormatConfig)formatParams;
                if (parquetFormatParams.parquetCompressionMethod != null) {
                    tblProperties.put("parquet.compression", parquetFormatParams.parquetCompressionMethod.name());
                }
            } else if (formatParams instanceof CSVFormatConfig) {
                CSVFormatConfig csvFormatParams = (CSVFormatConfig)formatParams;
                int skip = csvFormatParams.skipRowsAfterHeader + csvFormatParams.skipRowsBeforeHeader + (csvFormatParams.parseHeaderRow ? 1 : 0);
                if (skip > 0) {
                    tblProperties.put("skip.header.line.count", "" + skip);
                }
            }
        }
        return tblProperties;
    }

    public static String hiveEscape(char c2) {
        if (c2 == ';') {
            return "\\;";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        return "" + c2;
    }

    private static String dumpProperties(SortedMap<String, String> props) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : props.entrySet()) {
            if (!isFirst) {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(JSONUtils.escapeJSONString(entry.getKey()));
            sb.append("\"=\"");
            sb.append(JSONUtils.escapeJSONString(entry.getValue()));
            sb.append('\"');
            isFirst = false;
        }
        return sb.toString();
    }

    private static String escapeSpecialChars(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c2 = str.charAt(i);
            switch (c2) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c2);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c2 < ' ') {
                        String hex = Integer.toHexString(c2);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c2);
                }
            }
        }
        return escape.toString();
    }

    public static HiveRowFormatInfo getRowFormat(Dataset dataset, String name, MetastoreInspectionService.MetastoreKind metastoreKind) {
        Object query = "";
        HiveRowFormatInfo info = new HiveRowFormatInfo();
        if (dataset.getFormatType() == null) {
            throw ErrorContext.iaef((String)"Format is mandatory for a dataset used in Hive source: %s", (Object)name, (Object[])new Object[0]);
        }
        FormatMeta<?, ?> formatMeta = FormatFactory.getMeta(dataset.getFormatType());
        if (formatMeta == CSVFormatExtractor.META) {
            int skip;
            CSVFormatConfig config = dataset.getFormatParamsAs(CSVFormatConfig.class);
            switch (config.style) {
                case ESCAPE_ONLY_NO_QUOTE: {
                    query = (String)query + " ROW FORMAT DELIMITED FIELDS TERMINATED BY '" + HiveSchemaHandler.hiveEscape(config.getSeparatorChar()) + "' ESCAPED BY '" + HiveSchemaHandler.hiveEscape(config.getEscapeChar()) + "'";
                    break;
                }
                case NO_ESCAPE_NO_QUOTE: {
                    query = (String)query + " ROW FORMAT DELIMITED FIELDS TERMINATED BY '" + HiveSchemaHandler.hiveEscape(config.getSeparatorChar()) + "'";
                    break;
                }
                case EXCEL: 
                case UNIX: {
                    throw ErrorContext.iaef((String)"CSV quoting style %s is not supported for a Hive table", (Object)((Object)config.style), (Object[])new Object[0]);
                }
            }
            if (StringUtils.isNotBlank((String)config.arrayItemSeparator)) {
                query = (String)query + " COLLECTION ITEMS TERMINATED BY '" + HiveSchemaHandler.hiveEscape(config.getArrayItemSeparatorChar()) + "'";
            }
            if (StringUtils.isNotBlank((String)config.mapKeySeparator)) {
                query = (String)query + " MAP KEYS TERMINATED BY '" + HiveSchemaHandler.hiveEscape(config.getMapKeySeparatorChar()) + "'";
            }
            query = (String)query + " STORED AS TEXTFILE ";
            info.serializationLib = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
            info.inputFormat = "org.apache.hadoop.mapred.TextInputFormat";
            info.outputFormat = "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat";
            info.compressed = "gz".equals(config.compress);
            info.serdeParams.put("field.delim", "" + config.getSeparatorChar());
            info.serdeParams.put("serialization.format", "" + config.getSeparatorChar());
            if (config.style == CSVFormatConfig.CSVStyle.ESCAPE_ONLY_NO_QUOTE) {
                info.serdeParams.put("escape.delim", "" + config.getEscapeChar());
            }
            if (StringUtils.isNotBlank((String)config.arrayItemSeparator)) {
                info.serdeParams.put("colelction.delim", "" + config.getArrayItemSeparatorChar());
            }
            if (StringUtils.isNotBlank((String)config.mapKeySeparator)) {
                info.serdeParams.put("mapkey.delim", "" + config.getMapKeySeparatorChar());
            }
            if ((skip = config.skipRowsAfterHeader + config.skipRowsBeforeHeader + (config.parseHeaderRow ? 1 : 0)) > 0) {
                info.storageParams.put("skip.header.line.count", "" + skip);
            }
        } else if (formatMeta == DataikuHiveXMLUDFFormat.META) {
            query = (String)query + "STORED BY 'com.dataiku.hive.storage.XMLHiveStorageHandler'\n";
        } else if (formatMeta == ParquetFormatMeta.META) {
            query = (String)query + " STORED AS PARQUET ";
            ParquetFormatConfig config = dataset.getFormatParamsAs(ParquetFormatConfig.class);
            info.serializationLib = "org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe";
            info.inputFormat = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat";
            info.outputFormat = "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat";
            info.serdeParams.put("serialization.format", "1");
            info.compressed = false;
            if (config.parquetCompressionMethod != null) {
                info.storageParams.put("parquet.compression", config.parquetCompressionMethod.name());
            }
        } else if (formatMeta == SequenceFileFormatMeta.META) {
            query = (String)query + " STORED AS SEQUENCEFILE ";
        } else if (formatMeta == RCFileFormatMeta.META) {
            query = (String)query + " STORED AS RCFILE ";
        } else if (formatMeta == ORCFileFormatMeta.META) {
            ORCFileFormatConfig config = dataset.getFormatParamsAs(ORCFileFormatConfig.class);
            query = (String)query + " STORED AS ORC ";
            info.serializationLib = "org.apache.hadoop.hive.ql.io.orc.OrcSerde";
            info.inputFormat = "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat";
            info.outputFormat = "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat";
            info.serdeParams.put("serialization.format", "1");
            info.compressed = false;
            if (config.compressionMethod != null) {
                info.storageParams.put("orc.compress", config.compressionMethod.name());
            }
        } else if (formatMeta == AvroFormatMeta.META) {
            query = (String)query + " STORED AS AVRO ";
            info.serializationLib = "org.apache.hadoop.hive.serde2.avro.AvroSerDe";
            info.inputFormat = "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat";
            info.outputFormat = "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat";
            info.serdeParams.put("serialization.format", "1");
            info.compressed = false;
        } else {
            throw new UnsupportedFormatException("Unsupported format " + dataset.getFormatType() + " for Hive input or output on dataset " + dataset.getFullName());
        }
        info.asScript = query;
        return info;
    }

    public static HiveCompatibilityStatus isCompatible(AuthCtx authCtx, Dataset dataset) {
        if (!DatasetInspector.canHive(dataset)) {
            return HiveCompatibilityStatus.no("Dataset is not compatible with Hive");
        }
        if (!DatasetInspector.canHDFS(dataset)) {
            return HiveCompatibilityStatus.yes();
        }
        if (!Pattern.matches("^[0-9a-zA-Z_]*$", dataset.getName())) {
            return HiveCompatibilityStatus.no("Hive/Impala tables names can only contain alphanumeric and underscore");
        }
        if (dataset.getFormatType() == null) {
            return HiveCompatibilityStatus.no("Dataset has no format");
        }
        FormatMeta<?, ?> formatMeta = FormatFactory.getMeta(dataset.getFormatType());
        if (formatMeta != DataikuHiveXMLUDFFormat.META) {
            try {
                DatasetInspector.checkDatasetFormat(authCtx, dataset);
            }
            catch (Exception e) {
                return HiveCompatibilityStatus.no("Dataset format is invalid: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
        if (!HiveSchemaHandler.isCompatibleWithHive(formatMeta)) {
            return HiveCompatibilityStatus.no("The format of this dataset cannot be read by Hive");
        }
        if (dataset.getPartitioningSchema().isPartitioned() && !FilePartitioner.isSchemeRepresentableAsFolder(dataset.getPartitioningSchema())) {
            return HiveCompatibilityStatus.no("The partitioning scheme cannot match partitions to folders. Hive needs this");
        }
        if (dataset.getSchema() != null) {
            for (SchemaColumn col : dataset.getSchema().getColumns()) {
                String name = col.getName();
                if (StringUtils.isBlank((String)name)) {
                    return HiveCompatibilityStatus.no("The dataset's schema contains at least one unnamed column. ");
                }
                if (validColumnNamePattern.matcher(name).find()) continue;
                return HiveCompatibilityStatus.no("Column name '" + name + "' is not supported by Hive. Must be [a-zA-Z0-9_]+");
            }
        }
        return HiveCompatibilityStatus.yes();
    }

    public static com.dataiku.dip.coremodel.Schema generateSchema(ValidationResult.InsertOverwriteDef iodef, List<String> partitionNamesToIgnore) {
        ArrayList<ColumnSchema> colsWithoutPartitions = new ArrayList<ColumnSchema>();
        List allCols = iodef.schema;
        for (ColumnSchema def : allCols) {
            boolean ok = true;
            if (partitionNamesToIgnore != null) {
                for (String partition : partitionNamesToIgnore) {
                    if (!partition.equalsIgnoreCase(def.name)) continue;
                    ok = false;
                }
            }
            if (!ok) continue;
            colsWithoutPartitions.add(def);
        }
        com.dataiku.dip.coremodel.Schema schema = new com.dataiku.dip.coremodel.Schema();
        SafeColumnNamer namer = new SafeColumnNamer();
        for (ColumnSchema col : colsWithoutPartitions) {
            namer.addUnsafe(col.name);
        }
        List<String> safeNames = namer.getSafeNames();
        for (int i = 0; i < colsWithoutPartitions.size(); ++i) {
            ColumnSchema col = (ColumnSchema)colsWithoutPartitions.get(i);
            schema.addColumn(HiveSchemaHandler.dssColumnFromHiveColumnDef(safeNames.get(i), col.type, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING));
        }
        return schema;
    }

    public static List<Suggestion> generateSuggestions(DatasetsDAO dao, Map<String, FlowDataset> targetableDatasets, List<ValidationResult.InsertOverwriteDef> iodefs) throws IOException {
        ArrayList<Suggestion> suggests = new ArrayList<Suggestion>();
        if (iodefs == null) {
            return suggests;
        }
        for (ValidationResult.InsertOverwriteDef iodef : iodefs) {
            FlowDataset flowDataset = targetableDatasets.get(iodef.destinationTable);
            if (flowDataset == null || flowDataset.getOrNull(dao) == null) continue;
            Dataset dataset = flowDataset.getOrNull(dao);
            List partitionNamesToIgnore = null;
            PartitioningScheme ps2 = dataset.getPartitioningSchema();
            if (ps2 != null) {
                partitionNamesToIgnore = ps2.getDimensionNames();
            }
            com.dataiku.dip.coremodel.Schema generatedSchema = HiveSchemaHandler.generateSchema(iodef, partitionNamesToIgnore);
            List<String> incompatibilityMsgs = SchemaComparator.findIncompatibilities(dataset.getSchema(), generatedSchema, false);
            if (incompatibilityMsgs.size() <= 0) continue;
            Dataset datasetCopy = Dataset.fromSerialized(dataset.serialize());
            datasetCopy.setSchema(generatedSchema);
            Suggestion suggestion = new Suggestion();
            suggestion.reasons = incompatibilityMsgs;
            suggestion.dataset = datasetCopy.serialize();
            suggests.add(suggestion);
        }
        return suggests;
    }

    public static String getConnectionForHiveFromDataset(Dataset dataset) throws IOException {
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
            String string = handler.getDSSConnectionForHive();
            return string;
        }
    }

    public static SQLUtils.SQLTable getUnresolvedHiveTableRefFromDataset(Dataset dataset) throws IOException {
        if (dataset.getType().equals("HDFS")) {
            try (HDFSDatasetHandler handler = new HDFSDatasetHandler(DSSAuthCtx.newNone(), dataset, true);){
                SQLUtils.SQLTable sQLTable = handler.getUnresolvedHiveTableRef();
                return sQLTable;
            }
        }
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
            SQLUtils.SQLTable sQLTable = handler.getUnresolvedHiveTableRef();
            return sQLTable;
        }
    }

    public static SQLUtils.SQLTable getResolvedHiveTableRefFromDataset(SerializedDataset dataset) throws IOException {
        return HiveSchemaHandler.getResolvedHiveTableRefFromDataset(Dataset.fromSerialized(dataset));
    }

    public static SQLUtils.SQLTable getResolvedHiveTableRefFromDataset(Dataset dataset) throws IOException {
        return HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset, true);
    }

    public static SQLUtils.SQLTable getResolvedHiveTableRefFromDataset(Dataset dataset, boolean databaseIsMandatory) throws IOException {
        if (dataset.getType().equals("HDFS")) {
            try (HDFSDatasetHandler handler = new HDFSDatasetHandler(DSSAuthCtx.newNone(), dataset, true);){
                SQLUtils.SQLTable sQLTable = handler.getResolvedHiveTableRef(databaseIsMandatory);
                return sQLTable;
            }
        }
        try (MetastoreAwareDatasetHandler handler = (MetastoreAwareDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
            SQLUtils.SQLTable sQLTable = handler.getResolvedHiveTableRef(databaseIsMandatory);
            return sQLTable;
        }
    }

    public static String getResolvedHiveDatabaseFromDataset(Dataset dataset) throws IOException {
        return HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(dataset, true);
    }

    public static String getResolvedHiveDatabaseFromDataset(Dataset dataset, boolean databaseIsMandatory) throws IOException {
        if (DatasetInspector.isHiveQuery(dataset)) {
            try (HiveQueryDatasetHandler handler = (HiveQueryDatasetHandler)DatasetHandlerFactory.build(DSSAuthCtx.newNone(), dataset);){
                String string = handler.getResolvedHiveSchema(databaseIsMandatory);
                return string;
            }
        }
        return HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset, databaseIsMandatory).getSchemaNullIfBlank();
    }

    public static String getHiveDatabaseFromVirtualConnection(AuthCtx authCtx, String connectionName) throws IOException, DKUSecurityException {
        DSSConnection conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionName);
        if (!(conn instanceof MetastoreDBBasedConnection)) {
            throw ErrorContext.iaef((String)"Not an hadoop connection type: %s", (Object)conn.getType(), (Object[])new Object[0]);
        }
        return HiveSchemaHandler.getHiveDatabaseFromVirtualConnection((MetastoreDBBasedConnection)((Object)conn));
    }

    public static String getHiveDatabaseFromVirtualConnection(MetastoreDBBasedConnection conn) {
        String db = conn.getDatabaseName();
        if (StringUtils.isBlank((String)db)) {
            return null;
        }
        return db;
    }

    private static String buildDSSTableMeta(HiveTableMeta meta) {
        try {
            if (meta != null) {
                return Base64.getEncoder().encodeToString(new Gson().toJson((Object)meta).getBytes("UTF8"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public static TableSchema getTableSchema(String db, String table, List<Partition> withPartitions, SQLConnectionProvider.SQLConnectionWrapper conn, SQLDialect dialect) throws SQLException, InterruptedException {
        ResultSet rs2;
        String query;
        logger.infoV("Get schema of Hive table db=%s table=%s partitions=%s", new Object[]{db, table, withPartitions == null ? null : withPartitions.stream().map(p -> p.id()).collect(Collectors.joining(","))});
        ArrayList rows = Lists.newArrayList();
        try (Statement stmt = conn.createStatement();){
            logger.debug((Object)"Performing DESCRIBE FORMATTED");
            ResultSet rs3 = stmt.executeQuery("DESCRIBE FORMATTED " + dialect.getQuotedTableFullName(null, db, table));
            while (rs3.next()) {
                rows.add(new String[]{rs3.getString(1), rs3.getString(2), rs3.getString(3)});
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("DESCRIBE FORMATTED Done: " + JSON.json((Object)rows)));
            }
        }
        TableSchema tableSchema = DescribeFormattedParser.parseDescribeFormatted(rows);
        tableSchema.name = table;
        if (tableSchema.partitionColumns.size() > 0 && (withPartitions == null || withPartitions.size() > 0)) {
            List<Integer> dimensionIndices;
            PartitioningScheme partitioningScheme;
            HashSet partitionFilter = Sets.newHashSet();
            if (withPartitions != null) {
                logger.info((Object)"Table is partitioned, and explicit partitions selected");
                partitioningScheme = withPartitions.get(0).getScheme();
                dimensionIndices = HiveMetadataTools.getPartitioningDimensionIndices(tableSchema, partitioningScheme);
                if (dimensionIndices == null) {
                    partitioningScheme = null;
                }
                for (Partition partition : withPartitions) {
                    partitionFilter.add(partition.id());
                }
            } else {
                partitioningScheme = null;
                dimensionIndices = null;
            }
            logger.info((Object)"Getting partitions information");
            try (Statement stmt = conn.createStatement();){
                query = "SHOW PARTITIONS " + dialect.getQuotedTableFullName(null, db, table);
                rs2 = stmt.executeQuery(query);
                ArrayList specChunks = Lists.newArrayList();
                for (ColumnSchema column : tableSchema.partitionColumns) {
                    specChunks.add(Pattern.quote(column.name) + "=(.*)");
                }
                Pattern specPattern = Pattern.compile(Joiner.on((String)"/").join((Iterable)specChunks));
                while (rs2.next()) {
                    String identifier = rs2.getString(1);
                    Matcher specMatcher = specPattern.matcher(identifier);
                    if (specMatcher.matches()) {
                        PartitionSchema partitionSchema = new PartitionSchema();
                        for (int i = 1; i <= specChunks.size(); ++i) {
                            partitionSchema.keys.add(specMatcher.group(i));
                        }
                        if (partitioningScheme != null) {
                            ArrayList partitionKeys = Lists.newArrayList();
                            for (int partitionIndex : dimensionIndices) {
                                partitionKeys.add((String)partitionSchema.keys.get(partitionIndex));
                            }
                            String partitionId = Joiner.on((String)"|").join((Iterable)partitionKeys);
                            if (!partitionFilter.contains(partitionId)) continue;
                            tableSchema.partitions.add(partitionSchema);
                            continue;
                        }
                        tableSchema.partitions.add(partitionSchema);
                        continue;
                    }
                    logger.warn((Object)("Cannot split partition identifier '" + identifier + "'"));
                }
            }
        }
        logger.info((Object)("Getting location of partitions one by one on " + tableSchema.partitions.size() + " partitions"));
        for (PartitionSchema partition : tableSchema.partitions) {
            try (Statement stmt = conn.createStatement();){
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Getting location of partition " + JSON.json((Object)partition.keys)));
                }
                ArrayList specChunks = Lists.newArrayList();
                for (int i = 0; i < tableSchema.partitionColumns.size(); ++i) {
                    specChunks.add(dialect.quoteIdentifier(((ColumnSchema)tableSchema.partitionColumns.get((int)i)).name) + "=" + dialect.quoteString((String)partition.keys.get(i)));
                }
                query = "DESCRIBE FORMATTED " + dialect.getQuotedTableFullName(null, db, table) + " PARTITION(" + Joiner.on((String)",").join((Iterable)specChunks) + ")";
                rs2 = stmt.executeQuery(query);
                ArrayList partitionRows = Lists.newArrayList();
                while (rs2.next()) {
                    partitionRows.add(new String[]{rs2.getString(1), rs2.getString(2), rs2.getString(3)});
                }
                TableSchema partitionTableSchema = DescribeFormattedParser.parseDescribeFormatted(partitionRows);
                partition.location = partitionTableSchema.location;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Location of partition acquired (" + partition.location + ")"));
                }
            }
            FutureProgressState.checkInterrupt();
        }
        return tableSchema;
    }

    private static boolean isCompatibleWithHive(FormatMeta<?, ?> formatMeta) {
        return formatMeta == CSVFormatExtractor.META || formatMeta == ParquetFormatMeta.META || formatMeta == DataikuHiveXMLUDFFormat.META || formatMeta == RCFileFormatMeta.META || formatMeta == SequenceFileFormatMeta.META || formatMeta == ORCFileFormatMeta.META || formatMeta == AvroFormatMeta.META;
    }

    private HiveSchemaHandler() {
    }

    static {
        hiveToDkuTypeMap.put("tinyint", Type.TINYINT);
        hiveToDkuTypeMap.put("smallint", Type.SMALLINT);
        hiveToDkuTypeMap.put("int", Type.INT);
        hiveToDkuTypeMap.put("bigint", Type.BIGINT);
        hiveToDkuTypeMap.put("float", Type.FLOAT);
        hiveToDkuTypeMap.put("double", Type.DOUBLE);
        hiveToDkuTypeMap.put("timestamp", Type.DATE);
        hiveToDkuTypeMap.put("date", Type.DATEONLY);
        hiveToDkuTypeMap.put("string", Type.STRING);
        hiveToDkuTypeMap.put("varchar", Type.STRING);
        hiveToDkuTypeMap.put("char", Type.STRING);
        hiveToDkuTypeMap.put("boolean", Type.BOOLEAN);
        hiveToDkuTypeMap.put("binary", Type.STRING);
        hiveToDkuTypeMap.put("string", Type.STRING);
        hiveToDkuTypeMap.put("void", Type.STRING);
        hiveToDkuTypeMap.put("decimal", Type.DOUBLE);
        hiveToDkuLoss.add("decimal");
        hiveTypesWithExtraInfo.add("char");
        hiveTypesWithExtraInfo.add("varchar");
        hiveTypesWithExtraInfo.add("decimal");
        validColumnNamePattern = Pattern.compile("[a-zA-Z_0-9]+");
        logger = DKULogger.getLogger((String)"dku.flow.hive.handler");
    }

    public static class HiveRowFormatInfo {
        public String asScript;
        public String inputFormat;
        public String outputFormat;
        public String serializationLib;
        public Map<String, String> serdeParams = Maps.newHashMap();
        public Map<String, String> storageParams = Maps.newHashMap();
        public boolean compressed;
    }

    public static class UnsupportedFormatException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 4696510949229300463L;

        public UnsupportedFormatException(String message) {
            super(message);
        }
    }

    public static class HiveCompatibilityStatus {
        public boolean compatible;
        public String reason;

        static HiveCompatibilityStatus no(String reason) {
            HiveCompatibilityStatus ret = new HiveCompatibilityStatus();
            ret.reason = reason;
            return ret;
        }

        static HiveCompatibilityStatus yes() {
            HiveCompatibilityStatus ret = new HiveCompatibilityStatus();
            ret.compatible = true;
            return ret;
        }
    }

    public static class Suggestion {
        public SerializedDataset dataset;
        public List<String> reasons;
    }
}

