/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.FSProviderCodes;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.datasets.fs.HDFSableDatasetHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsHandler;
import com.dataiku.dip.datasets.sql.SQLExceptionsParser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.hadoop.HDFSPathUtils;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveMetadataTools;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveScriptPreprocessor;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.impala.ImpalaUpdater;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.partitioning.FilePartition;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class HiveServer2HiveMetastoreSynchronizer
extends HiveMetastoreSynchronizer {
    static final DKULogger logger = DKULogger.getLogger((String)"dku.hive.synchro");
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private ImpersonationResolverService impersonationService;
    private final MetastoreInspectionService.MetastoreKind metastoreKind;
    private final AuthCtx authCtx;

    public HiveServer2HiveMetastoreSynchronizer(AuthCtx authCtx) throws IOException, DKUSecurityException {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.metastoreKind = this.metastoreInspectionService.getMetastoreKind(authCtx, null);
    }

    @Override
    public InfoMessage.InfoMessages synchronizeOneDataset(Dataset ds, boolean simulate, boolean forceDrop, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        return this.synchronizeOneDataset(ds, simulate, forceDrop, null, reason, warningsContext, lenient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InfoMessage.InfoMessages synchronizeOneDataset(Dataset ds, boolean simulate, boolean forceDrop, String partitionCreationScript, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = HiveServer2HiveMetastoreSynchronizer.getTableLock(ds.getFullName());
        synchronized (object) {
            InfoMessage.InfoMessages messages;
            block21: {
                messages = new InfoMessage.InfoMessages();
                try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
                    boolean writeIsSafe;
                    block22: {
                        HiveSettings hs;
                        HDFSDatasetHandler hdfsHandler;
                        block23: {
                            block24: {
                                MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(this.authCtx, ds);
                                if (!requestedStatus.requested) {
                                    logger.info((Object)("Synchronization not requested(" + requestedStatus.reason + "), doing nothing"));
                                    messages.withWarning((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_TABLE_NOT_SYNCHRONIZED, requestedStatus.reason + ", doing nothing");
                                    InfoMessage.InfoMessages infoMessages = messages;
                                    return infoMessages;
                                }
                                if (!(handler instanceof HDFSDatasetHandler)) break block22;
                                hdfsHandler = (HDFSDatasetHandler)handler;
                                HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(hdfsHandler);
                                permHandler.setGatewayACLCreate(this.authCtx);
                                permHandler.setDataUsabilityAndDeletabilityACL(this.authCtx);
                                if (this.impersonationService.isEnabled()) break block23;
                                if (reason != HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET) break block24;
                                hs = new ClusterSelector().selectForProject(this.authCtx, ds.getProjectKey()).getHiveSettings();
                                if (hs.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes && !hdfsHandler.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes()) {
                                    logger.info((Object)("About to run a recipe that writes by HiveServer2: creating managed dataset folder before sync target: " + ds.getFullName()));
                                    hdfsHandler.createManaged();
                                }
                                break block22;
                            }
                            if (reason == HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET) {
                                ImpalaSettings is = new ClusterSelector().selectForProject(this.authCtx, ds.getProjectKey()).getImpalaSettings();
                                if (is.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes && !hdfsHandler.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes()) {
                                    logger.info((Object)("About to run a recipe that writes by Impala: creating managed dataset folder before sync target: " + ds.getFullName()));
                                    hdfsHandler.createManaged();
                                }
                                break block22;
                            } else {
                                hdfsHandler.createManaged();
                            }
                            break block22;
                        }
                        if (reason == HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET) {
                            hs = new ClusterSelector().selectForProject(this.authCtx, ds.getProjectKey()).getHiveSettings();
                            if (hs.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes) {
                                logger.info((Object)("About to run a recipe that writes by HiveServer2: creating managed dataset folder before sync target: " + ds.getFullName()));
                                hdfsHandler.createManaged();
                            }
                        }
                    }
                    this.checkCanBeRepresented(ds);
                    boolean bl = writeIsSafe = forceDrop || this.isTableWriteSafe(ds);
                    if (!writeIsSafe) {
                        throw ErrorContext.iae((String)("The Hive table corresponding to dataset \"" + ds.getName() + "\" already exists and is not EXTERNAL. Metastore synchronization aborted for safety."));
                    }
                    StringBuilder outHiveScript = new StringBuilder();
                    this.appendDatasetData(ds, outHiveScript, false, true);
                    if (partitionCreationScript != null) {
                        outHiveScript.append(partitionCreationScript);
                    }
                    if (simulate) break block21;
                    try {
                        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtx, ds.getProjectKey()).getHiveSettings();
                        this.executeScript(ds, HiveScriptPreprocessor.getHiveJarScript(false, hiveSettings), outHiveScript.toString(), HiveScriptPreprocessor.getFSExtraConfForHiveserver2(handler.getFSExtraConf()));
                    }
                    catch (Exception e) {
                        String potentialSchemaProblems;
                        logger.warn((Object)"Execute script caught exception", (Throwable)e);
                        if ((e instanceof SQLException || e.getClass().getName().equals("org.apache.hadoop.hive.ql.metadata.HiveException")) && StringUtils.isNotBlank((String)(potentialSchemaProblems = HiveSchemaHandler.detectPotentialSchemaIssues(ds.getSchema())))) {
                            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_HIVE_INCOMPATIBLE_SCHEMA, potentialSchemaProblems, (Throwable)e);
                        }
                        throw e;
                    }
                    logger.info((Object)"Hive metastore successfully synchronized");
                    this.synchronizeImpalaForDataset(ds, warningsContext, lenient);
                }
            }
            return messages;
        }
    }

    @Override
    public void dropExternalTable(Dataset ds) throws Exception {
        if (this.isTableWriteSafe(ds)) {
            String clusterId;
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
            MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtx, ds.getProjectKey());
            if (inspector.isHiveDatabase(clusterId = new ClusterSelector().getClusterForProject(ds.getProjectKey(), Cluster.ClusterArchitecture.HADOOP), tableRef.getSchemaNullIfBlank(), this.authCtx, ds.getProjectKey()) && inspector.isHiveTable(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), this.authCtx, ds.getProjectKey())) {
                if (inspector.isExternalTable(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), this.authCtx, ds.getProjectKey())) {
                    try (HDFSableDatasetHandler hdfsDatasetHandler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
                        this.executeScript(ds, "", " USE `" + tableRef.getSchemaNullIfBlank() + "`;  DROP TABLE `" + tableRef.getTable() + "`;", HiveScriptPreprocessor.getFSExtraConfForHiveserver2(hdfsDatasetHandler.getFSExtraConf()));
                    }
                } else {
                    throw new IOException("Safety guard: cannot delete Hive table " + tableRef.getSchemaNullIfBlank() + "." + tableRef.getTable() + " because it is not EXTERNAL.");
                }
            }
        }
    }

    @Override
    public void dropTableIfExists(Dataset ds) throws Exception {
        logger.infoV("Dropping partition if exists dataset=%s", new Object[]{ds.getFullName()});
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        String script = "USE `" + tableRef.getSchemaNullIfBlank() + "`;";
        script = script + "DROP TABLE IF EXISTS `" + tableRef.getTable() + "`;";
        try (HDFSableDatasetHandler hdfsDatasetHandler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
            this.executeScript(ds, "", script, HiveScriptPreprocessor.getFSExtraConfForHiveserver2(hdfsDatasetHandler.getFSExtraConf()));
        }
    }

    @Override
    public void dropPartitionIfExistsNoFail(Dataset ds, Partition partition) throws Exception {
        logger.infoV("Dropping partition if exists dataset=%s partition=%s", new Object[]{ds.getFullName(), partition});
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        String script = "USE `" + tableRef.getSchemaNullIfBlank() + "`;";
        script = script + "ALTER TABLE `" + tableRef.getTable() + "` DROP IF EXISTS PARTITION " + HiveMetadataTools.getPartitionSpec(partition) + ";\n";
        try (HDFSableDatasetHandler hdfsDatasetHandler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
            this.executeScript(ds, "", script, HiveScriptPreprocessor.getFSExtraConfForHiveserver2(hdfsDatasetHandler.getFSExtraConf()));
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to drop partition " + String.valueOf(partition) + " of " + ds.getFullName() + ", table probably did not exist: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void synchronizeOneDatasetPartition(Dataset dataset, Partition partition, boolean simulate, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason reason, WarningsContext warningsContext, boolean lenient) throws Exception {
        Object tableLock;
        Object object = tableLock = HiveServer2HiveMetastoreSynchronizer.getTableLock(dataset.getFullName());
        synchronized (object) {
            try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
                block37: {
                    HiveSettings hs;
                    HDFSDatasetHandler hdfsHandler;
                    block38: {
                        block39: {
                            MetastoreSynchronizationUtils.SynchronizationRequestedStatus requestedStatus = MetastoreSynchronizationUtils.synchronizationRequested(this.authCtx, dataset);
                            if (!requestedStatus.requested) {
                                logger.info((Object)("Synchronization not requested(" + requestedStatus.reason + "), doing nothing"));
                                return;
                            }
                            if (!(handler instanceof HDFSDatasetHandler)) break block37;
                            hdfsHandler = (HDFSDatasetHandler)handler;
                            HDFSPermissionsHandler permHandler = new HDFSPermissionsHandler(hdfsHandler);
                            permHandler.setGatewayACLCreate(this.authCtx);
                            permHandler.setDataUsabilityAndDeletabilityACL(this.authCtx, partition);
                            if (this.impersonationService.isEnabled()) break block38;
                            if (reason != HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET) break block39;
                            hs = new ClusterSelector().selectForProject(this.authCtx, dataset.getProjectKey()).getHiveSettings();
                            if (hs.preCreateManagedDatasetFolderBeforeMetastoreSyncForHS2Recipes && !hdfsHandler.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes()) {
                                logger.info((Object)("About to run a recipe that writes by HiveServer2: creating managed dataset folder before sync target: " + dataset.getFullName()));
                                hdfsHandler.createManaged();
                            }
                            break block37;
                        }
                        if (reason == HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET) {
                            ImpalaSettings is = new ClusterSelector().selectForProject(this.authCtx, dataset.getProjectKey()).getImpalaSettings();
                            if (is.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes && !hdfsHandler.overridePreCreateManagedDatasetFolderBeforeMetastoreSyncForRecipes()) {
                                logger.info((Object)("About to run a recipe that writes by Impala: creating managed dataset folder before sync target: " + dataset.getFullName()));
                                hdfsHandler.createManaged();
                            }
                            break block37;
                        } else {
                            hdfsHandler.createManaged();
                        }
                        break block37;
                    }
                    if (reason == HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_HS2_TARGET) {
                        hs = new ClusterSelector().selectForProject(this.authCtx, dataset.getProjectKey()).getHiveSettings();
                        if (hs.preCreateManagedDatasetFolderBeforeMetastoreSyncForMUSHS2Recipes) {
                            logger.info((Object)("About to run a recipe that writes by HiveServer2: creating managed dataset folder before sync target: " + dataset.getFullName()));
                            hdfsHandler.createManaged();
                        }
                    }
                }
                this.checkCanBeRepresented(dataset);
                Boolean writeIsSafe = this.isTableWriteSafe(dataset);
                if (!writeIsSafe.booleanValue()) {
                    throw ErrorContext.iae((String)("The Hive table corresponding to dataset \"" + dataset.getName() + "\" already exists and is not EXTERNAL. Metastore synchronization aborted for safety."));
                }
                HiveSchemaCompatibility schemaCompatibility = this.isExistingSchemaCompatible(dataset);
                if (schemaCompatibility.schemaCompatible) {
                    logger.info((Object)"Hive schema is up to date: (re)synchronizing a single partition");
                }
                if (schemaCompatibility.unknown) {
                    schemaCompatibility.schemaCompatible = true;
                    logger.info((Object)"We assume that the current Hive schema is up to date (we won't force drop/create table), because we can't verify (HProxy is not available)");
                }
                if (schemaCompatibility.schemaCompatible) {
                    logger.info((Object)"Since Hive table schema/partitioning/location cannot be checked, we assume that everything is up to date");
                    StringBuilder outHiveScript = new StringBuilder();
                    this.appendDatasetData(dataset, outHiveScript, true, false);
                    if (partition != null && dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
                        if (this.isExistingPartitionSchemaCompatible(dataset, partition)) {
                            logger.info((Object)"The partition location is up-to-date, not resynchronizing it");
                        } else if (partition.isAll()) {
                            List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, dataset);
                            assert (partitions != null);
                            for (Partition partition2 : partitions) {
                                outHiveScript.append(this.datasetPartitionData(dataset, partition2, true));
                            }
                        } else {
                            outHiveScript.append(this.datasetPartitionData(dataset, partition, true));
                        }
                    }
                    if (simulate) return;
                    try {
                        HiveSettings hiveSettings = new ClusterSelector().selectForProject(this.authCtx, dataset.getProjectKey()).getHiveSettings();
                        this.executeScript(dataset, HiveScriptPreprocessor.getHiveJarScript(false, hiveSettings), outHiveScript.toString(), HiveScriptPreprocessor.getFSExtraConfForHiveserver2(handler.getFSExtraConf()));
                    }
                    catch (Exception e) {
                        String potentialSchemaProblems;
                        if (!(e instanceof SQLException)) {
                            if (!e.getClass().getName().equals("org.apache.hadoop.hive.ql.metadata.HiveException")) throw e;
                        }
                        if (!StringUtils.isNotBlank((String)(potentialSchemaProblems = HiveSchemaHandler.detectPotentialSchemaIssues(dataset.getSchema())))) throw e;
                        throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_HIVE_INCOMPATIBLE_SCHEMA, potentialSchemaProblems, (Throwable)e);
                    }
                    logger.info((Object)"Hive metastore successfully synchronized");
                    this.synchronizeImpalaForDataset(dataset, warningsContext, lenient);
                    return;
                }
                logger.info((Object)"Hive schema is not up to date: (re)synchronize the whole table");
                String partitionCreationScript = null;
                if (partition != null && partition.getScheme() != null && partition.getScheme().isPartitioned()) {
                    if (partition.isAll()) {
                        List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, dataset);
                        assert (partitions != null);
                        for (Partition partition3 : partitions) {
                            partitionCreationScript = this.datasetPartitionData(dataset, partition3, true);
                        }
                    } else {
                        partitionCreationScript = this.datasetPartitionData(dataset, partition, true);
                    }
                }
                this.synchronizeOneDataset(dataset, simulate, false, partitionCreationScript, reason, warningsContext, lenient);
            }
            return;
        }
    }

    private boolean isTableWriteSafe(Dataset ds) throws Exception {
        String schema;
        String clusterId;
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtx, ds.getProjectKey());
        return !inspector.isHiveDatabase(clusterId = new ClusterSelector().getClusterForProject(ds.getProjectKey(), Cluster.ClusterArchitecture.HADOOP), schema = tableRef.getSchemaNullIfBlank(), this.authCtx, ds.getProjectKey()) || !inspector.isHiveTable(clusterId, schema, tableRef.getTable(), this.authCtx, ds.getProjectKey()) || inspector.isExternalTable(clusterId, schema, tableRef.getTable(), this.authCtx, ds.getProjectKey());
    }

    private void synchronizeImpalaForDataset(Dataset ds, WarningsContext warningsContext, boolean lenient) throws Exception {
        if (ImpalaConfigurator.impalaAvailable(this.authCtx, ds.getProjectKey())) {
            SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
            ImpalaUpdater updater = new ImpalaUpdater();
            updater.invalidateTable(ds.getProjectKey(), tableRef.getSchemaNullIfBlank(), tableRef.getTable(), this.authCtx, warningsContext, lenient);
        }
    }

    private boolean isExistingPartitionSchemaCompatible(Dataset ds, Partition partition) throws Exception {
        logger.debug((Object)("checking if existing partition schema compatible, p=" + (partition == null ? null : partition.id())));
        try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, ds);){
            SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
            String location = HDFSPathUtils.concat(handler.getFullyQualifiedRootPath(), FilePartitioner.computePartitionRelPathAsFolder(partition, ds.getPartitioningSchema()));
            MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtx, ds.getProjectKey());
            String clusterId = new ClusterSelector().getClusterForProject(ds.getProjectKey(), Cluster.ClusterArchitecture.HADOOP);
            TableSchema tableSchema = inspector.getTableSchema(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), Lists.newArrayList((Object[])new Partition[]{partition}), this.authCtx, ds.getProjectKey());
            boolean bl = HiveMetadataTools.isSamePartitionPath(tableSchema, partition, location);
            return bl;
        }
    }

    public HiveSchemaCompatibility isExistingSchemaCompatible(Dataset dataset) throws Exception {
        HiveSchemaCompatibility ret = new HiveSchemaCompatibility();
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtx, dataset.getProjectKey());
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
        String clusterId = new ClusterSelector().getClusterForProject(dataset.getProjectKey(), Cluster.ClusterArchitecture.HADOOP);
        if (!inspector.isHiveDatabase(clusterId, tableRef.getSchemaNullIfBlank(), this.authCtx, dataset.getProjectKey())) {
            return ret;
        }
        if (!inspector.isHiveTable(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), this.authCtx, dataset.getProjectKey())) {
            return ret;
        }
        ret.tableExists = true;
        List<ColumnSchema> hiveSchema = inspector.listColumns(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), this.authCtx, dataset.getProjectKey());
        int nbHiveColumn = 0;
        int nbHivePartition = 0;
        boolean expectPartitionColumnsInDatasetSchema = DatasetInspector.isHive(dataset);
        for (ColumnSchema cs2 : hiveSchema) {
            if (cs2.partition) {
                boolean match = false;
                ++nbHivePartition;
                for (String dim : dataset.getPartitioningSchema().getDimensionNames()) {
                    if (!StringUtils.equalsIgnoreCase((String)dim, (String)cs2.name)) continue;
                    match = true;
                }
                if (!match) {
                    logger.info((Object)("The Hive partition " + cs2.name + " of type +cs.type+ doesn't match dataset partitioning scheme"));
                    return ret;
                }
            }
            if (cs2.partition && !expectPartitionColumnsInDatasetSchema) continue;
            for (SchemaColumn column : dataset.getSchema().getColumns()) {
                String currentHiveType = cs2.type;
                String expectedHiveType = HiveSchemaHandler.hiveTypeFromSchemaTypeAsHiveWouldReturnIt(column);
                if (!StringUtils.equalsIgnoreCase((String)column.getName(), (String)cs2.name)) continue;
                if (StringUtils.equalsIgnoreCase((String)currentHiveType, (String)expectedHiveType)) {
                    ++nbHiveColumn;
                    continue;
                }
                if (column.originalType != null && column.originalType.equals(currentHiveType)) {
                    ++nbHiveColumn;
                    continue;
                }
                logger.info((Object)("The column " + cs2.name + " of type " + cs2.type + " doesn't match dataset schema which is " + expectedHiveType));
                return ret;
            }
        }
        if (!expectPartitionColumnsInDatasetSchema && nbHiveColumn + nbHivePartition != hiveSchema.size()) {
            logger.info((Object)("The schema of dataset " + dataset.getName() + " doesn't have " + hiveSchema.size() + " (partitioning) columns but " + (nbHiveColumn + nbHivePartition)));
            return ret;
        }
        int expectedNbColumn = dataset.getSchema().getColumns().size();
        if (nbHiveColumn != expectedNbColumn) {
            logger.info((Object)("The Hive table " + dataset.getName() + " doesn't have " + expectedNbColumn + " columns but " + nbHiveColumn));
            return ret;
        }
        int expectedNbPartitionDim = dataset.getPartitioningSchema().getDimensionNames().size();
        if (nbHivePartition != expectedNbPartitionDim) {
            logger.info((Object)("The Hive table " + dataset.getName() + " doesn't have " + expectedNbPartitionDim + " partition dimensions but " + nbHivePartition));
            return ret;
        }
        ret.schemaCompatible = true;
        return ret;
    }

    private void executeScript(Dataset ds, String init, String script, List<SimpleKeyValue> extraConf) throws Exception {
        switch (this.metastoreKind) {
            case HIVE_VIA_HS2: {
                this.executeScriptUsingHS2(ds, init, script, extraConf);
            }
        }
    }

    private void executeScriptUsingHS2(Dataset ds, String init, String script, List<SimpleKeyValue> extraConf) throws Exception {
        MetastoreInspectionService.MetastoreInspector inspector = this.metastoreInspectionService.newInspector(this.authCtx, ds.getProjectKey());
        logger.debug((Object)("Synchronization script : \n" + script));
        String clusterId = new ClusterSelector().getClusterForProject(ds.getProjectKey(), Cluster.ClusterArchitecture.HADOOP);
        try (HiveServer2ConnectionPoolService.HiveServer2Connection conn = ((MetastoreInspectionService.HiveServer2MetastoreInspector)inspector).takeForMetastore(clusterId, this.authCtx, "default", extraConf, ds.getProjectKey());){
            this.executeScriptInner(conn, init, script);
        }
        catch (Exception e) {
            if (e.getClass().getCanonicalName().equals("import org.apache.hive.service.cli.HiveSQLException")) {
                SQLExceptionsParser.SQLExceptionDetails sd = SQLExceptionsParser.parse(new HiveSQLDialect(), null, (SQLException)e, false);
                if (sd.code != null) {
                    throw new CodedSQLException(sd.code, "Failed to synchronize Hive table", (Throwable)e);
                }
                throw e;
            }
            throw e;
        }
    }

    private void executeScriptInner(SQLConnectionProvider.SQLConnectionWrapper conn, String init, String script) throws SQLException {
        HiveSQLDialect dialect = new HiveSQLDialect();
        Pattern addJarPattern = Pattern.compile("^\\s*add\\s+jar\\s+.*$", 2);
        Splitter splitter = new Splitter(dialect.getSemicolonExclusionPortionFinders());
        try (Statement stmt = conn.createStatement();){
            for (String query : splitter.split(init)) {
                logger.info((Object)("Running " + query));
                if (query.trim().toUpperCase().startsWith("CREATE DATABASE")) {
                    try {
                        stmt.execute(query);
                    }
                    catch (SQLException e) {
                        logger.warn((Object)("Could not create database with : " + query + " . Trying to simply use database."));
                        query = this.fallbackToUseDb(query);
                        stmt.execute(query);
                    }
                    continue;
                }
                if (addJarPattern.matcher(query).matches()) {
                    logger.info((Object)("Detected an ADD JAR ... query. Ignoring : " + query));
                    continue;
                }
                stmt.execute(query);
            }
            for (String query : splitter.split(script)) {
                logger.info((Object)("Running " + query));
                if (query.trim().toUpperCase().startsWith("CREATE DATABASE")) {
                    try {
                        stmt.execute(query);
                    }
                    catch (SQLException e) {
                        logger.warn((Object)("Could not create database with : " + query + " . Trying to simply use database."));
                        query = this.fallbackToUseDb(query);
                        stmt.execute(query);
                    }
                    continue;
                }
                if (addJarPattern.matcher(query).matches()) {
                    logger.info((Object)("Detected an ADD JAR ... query. Ignoring : " + query));
                    continue;
                }
                stmt.execute(query);
            }
        }
    }

    private String fallbackToUseDb(String query) throws SQLException {
        Pattern databasePattern = Pattern.compile("create\\s+database\\s+(if\\s+not\\s+exists\\s+)([^;]+)", 2);
        Matcher databaseMatcher = databasePattern.matcher((CharSequence)query);
        if (!databaseMatcher.matches()) {
            throw new SQLException("Unexpected create database statement, cannot extract database name");
        }
        query = "use " + databaseMatcher.group(2);
        return query;
    }

    private void checkCanBeRepresented(Dataset dataset) {
        boolean rep;
        if (dataset.getPartitioningSchema().isPartitioned() && !(rep = FilePartitioner.isSchemeRepresentableAsFolder(dataset.getPartitioningSchema()))) {
            throw ErrorContext.iaef((String)"Dataset %s cannot be represented in Hive: partition does not map to a folder", (Object)dataset.getFullName(), (Object[])new Object[0]);
        }
    }

    private String datasetPartitionData(Dataset dataset, Partition p, boolean drop) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(dataset);
        Object addPartitions = "";
        try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
            if (drop) {
                addPartitions = (String)addPartitions + "ALTER TABLE " + tableRef.getTable() + " DROP IF EXISTS PARTITION " + HiveMetadataTools.getPartitionSpec(p) + ";\n";
            }
            addPartitions = (String)addPartitions + "ALTER TABLE " + tableRef.getTable() + " ADD IF NOT EXISTS";
            addPartitions = (String)addPartitions + " PARTITION " + HiveMetadataTools.getPartitionSpec(p);
            addPartitions = (String)addPartitions + " LOCATION '" + HDFSPathUtils.concat(handler.getFullyQualifiedRootPath(), FilePartitioner.computePartitionRelPathAsFolder(p, dataset.getPartitioningSchema())) + "'";
            Object object = addPartitions = (String)addPartitions + ";\n";
            return object;
        }
    }

    private void appendDatasetData(Dataset dataset, StringBuilder outHiveScript, boolean onlyCheckExists, boolean addPartitions) throws IOException, InterruptedException, DKUSecurityException, CodedException {
        block12: {
            PartitioningScheme scheme = dataset.getPartitioningSchema();
            try (HDFSableDatasetHandler handler = (HDFSableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, dataset);){
                SQLUtils.SQLTable tableRef = handler.getResolvedHiveTableRef(true);
                outHiveScript.append(HiveServer2HiveMetastoreSynchronizer.queryChangeDatabase(tableRef.getSchemaNullIfBlank()));
                String ifExistsChunk = "";
                Object createTable = onlyCheckExists ? "" : "DROP TABLE " + ifExistsChunk + tableRef.getTable() + ";\n";
                createTable = (String)createTable + "CREATE EXTERNAL TABLE " + (onlyCheckExists ? " IF NOT EXISTS " : "") + tableRef.getTable() + "(" + HiveSchemaHandler.tableDefFromSchema(dataset.getSchema()) + ")";
                if (scheme.isPartitioned()) {
                    createTable = (String)createTable + " PARTITIONED BY (" + HiveSchemaHandler.getPartitionedByString(scheme) + ")";
                }
                createTable = (String)createTable + HiveSchemaHandler.getRowFormat((Dataset)dataset, (String)dataset.getName(), (MetastoreInspectionService.MetastoreKind)this.metastoreKind).asScript;
                createTable = (String)createTable + " LOCATION '" + handler.getFullyQualifiedRootPath() + "'";
                createTable = (String)createTable + HiveSchemaHandler.getTableProperties(this.authCtx, dataset);
                createTable = (String)createTable + ";\n";
                outHiveScript.append((String)createTable);
                if (!scheme.isPartitioned() || !addPartitions) break block12;
                try {
                    List<FilePartition> partitions = FilePartitioner.listPartitions(this.authCtx, dataset);
                    assert (partitions != null);
                    for (Partition partition : partitions) {
                        outHiveScript.append(this.datasetPartitionData(dataset, partition, !onlyCheckExists));
                    }
                }
                catch (DataStoreIOException e) {
                    if (e.getCode() == FSProviderCodes.ERR_FSPROVIDER_ROOT_PATH_DOES_NOT_EXIST) {
                        logger.info((Object)"Dataset root path does not exist, not adding partitions");
                        break block12;
                    }
                    throw e;
                }
            }
        }
    }

    private static String queryChangeDatabase(String dbname) {
        if (dbname == null || dbname.isEmpty()) {
            dbname = "default";
        }
        return "CREATE DATABASE IF NOT EXISTS `" + dbname + "`;\n USE `" + dbname + "`;\n ";
    }

    public static class HiveSchemaCompatibility {
        public boolean unknown;
        public boolean tableExists;
        public boolean schemaCompatible;
    }
}

