/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.i18n;

import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FrontendTranslationFilesHelper {
    private static final String DKUINSTALLDIR = System.getenv("DKUINSTALLDIR");
    private static final List<String> FALSE_POSITIVES = Arrays.asList("SHAKER.FORMULA.NO_SAMPLE_DATA", "PROJECT.ACTIONS.DATASETS.ALL_DATASET_TYPES", "ANALYSIS.MLCOMMON.SETTINGS.DEBUGGING.ASSERTIONS.INTRO", "ANALYSIS.PREDICTION.SETTINGS.ALGORITHMS.PY_MEMORY.RANDOM_FOREST_REGRESSION.DESCRIPTION");
    private static final String detectQuotedKey = "(?<keyQuote>['\\\"])(?<key>[\\w.]+)\\k<keyQuote>";
    private static final String detectQuotedValue = "(?<valueQuote>['\\\"])(?<value>(?:(?!\\k<valueQuote>).)+)\\k<valueQuote>";
    private static final List<String> FILES_TO_IGNORE = Arrays.asList("dip/server/src/frontend/src/app/shared/i18n/translation-test/translation-test.component.ts", "dip/server/src/frontend/src/app/shared/i18n/translation-test/translation-test.component.html");
    static final List<String> commonSimpleTags = Arrays.asList("em", "strong", "b");

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && "reformat".equals(args[0])) {
            FrontendTranslationFilesHelper.reformat(DKUINSTALLDIR);
        } else {
            FrontendTranslationFilesHelper.scanValidateAndUpdate(DKUINSTALLDIR);
        }
    }

    private static void reformat(String dssRootDir) throws IOException {
        FrontendTranslationFilesHelper.reformat(new File(dssRootDir + "/resources/i18n/frontend/en.json"));
        FrontendTranslationFilesHelper.reformat(new File(dssRootDir + "/resources/i18n/frontend/fr.json"));
    }

    private static boolean isIgnored(File file) {
        return FILES_TO_IGNORE.stream().anyMatch(f -> file.getAbsolutePath().endsWith((String)f));
    }

    private static void reformat(File translationFile) throws IOException {
        System.out.println("Reformatting " + String.valueOf(translationFile));
        LanguageData languageData = (LanguageData)JSON.parse((String)DKUFileUtils.readFileToStringUTF8((File)translationFile), LanguageData.class);
        languageData.translations = new TreeMap<String, String>(languageData.translations);
        String formatted = JSON.createGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((Object)languageData);
        DKUFileUtils.writeFileUTF8((File)translationFile, (String)formatted);
    }

    private static void scanValidateAndUpdate(String dssRootDir) throws IOException {
        Stopwatch sw = Stopwatch.createStarted();
        List<File> directoriesToScan = Arrays.asList(new File(dssRootDir, "src/main/platypus/templates"), new File(dssRootDir, "/src/main/platypus/static/dataiku"), new File(dssRootDir, "/server/src/frontend/src/app"));
        File translationFile = new File(dssRootDir + "/resources/i18n/frontend/en.json");
        File frenchTranslationFile = new File(dssRootDir + "/resources/i18n/frontend/fr.json");
        LanguageData languageData = (LanguageData)JSON.parse((String)DKUFileUtils.readFileToStringUTF8((File)translationFile), LanguageData.class);
        for (File dir : directoriesToScan) {
            FrontendTranslationFilesHelper.findNewInHtml(languageData, dir);
            FrontendTranslationFilesHelper.findNewInJS(languageData, dir);
            FrontendTranslationFilesHelper.findUnknown(languageData, dir);
        }
        LanguageData languageDataFR = (LanguageData)JSON.parse((String)DKUFileUtils.readFileToStringUTF8((File)frenchTranslationFile), LanguageData.class);
        languageDataFR.translations.forEach((k, v) -> {
            if (!languageData.translations.containsKey(k) && !k.endsWith(".PLURAL")) {
                System.out.println("WARN: Found missing key in EN (present in FR): " + k);
            }
        });
        languageData.translations = new TreeMap<String, String>(languageData.translations);
        String formatted = JSON.createGsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((Object)languageData);
        DKUFileUtils.writeFileUTF8((File)translationFile, (String)formatted);
        System.out.println("Done! Total time: " + String.valueOf(sw));
    }

    private static void findUnknown(LanguageData languageData, File root) throws IOException {
        Pattern pattern1 = Pattern.compile("translate=\"(?<key>[\\w.]+)\"[^>]*>");
        Pattern pattern2 = Pattern.compile("translate\\((?<keyQuote>['\\\"])(?<key>[\\w.]+)\\k<keyQuote>\\s*,");
        Pattern pattern4 = Pattern.compile("\\|\\s*translate\\s*:\\s*'(?<key>[\\w.]+)'");
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (FrontendTranslationFilesHelper.isIgnored(file)) continue;
            if (file.isDirectory()) {
                FrontendTranslationFilesHelper.findUnknown(languageData, file);
                continue;
            }
            if (!file.getName().endsWith(".html") && !file.getName().endsWith(".js") && !file.getName().endsWith(".ts")) continue;
            FrontendTranslationFilesHelper.checkUnknown(languageData, pattern1, file);
            FrontendTranslationFilesHelper.checkUnknown(languageData, pattern2, file);
            FrontendTranslationFilesHelper.checkUnknown(languageData, pattern4, file);
        }
    }

    private static void checkUnknown(LanguageData languageData, Pattern pattern, File file) throws IOException {
        String s = FrontendTranslationFilesHelper.readFile(file);
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String key = matcher.group("key");
            if (key.equals("x") || key.equals("y") || languageData.translations.containsKey(key)) continue;
            System.out.println("WARN: Found missing key: " + key);
        }
    }

    private static void findNewInHtml(LanguageData languageData, File root) throws IOException {
        List<Pattern> allPatterns = Arrays.asList(Pattern.compile("\\stranslate=\"(?<key>[\\w.]+)\"[^>]*>(?<value>[^<]+)", 32), Pattern.compile("'(?<value>[^']+)'\\s*\\|\\s*translate\\s*:\\s*'(?<key>[\\w.]+)'", 32));
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (FrontendTranslationFilesHelper.isIgnored(file)) continue;
            if (file.isDirectory()) {
                FrontendTranslationFilesHelper.findNewInHtml(languageData, file);
                continue;
            }
            if (!file.getName().endsWith(".html")) continue;
            String s = FrontendTranslationFilesHelper.readFile(file);
            s = FrontendTranslationFilesHelper.escapeCommonBlocks(s);
            for (Pattern pattern : allPatterns) {
                Matcher matcher = pattern.matcher(s);
                while (matcher.find()) {
                    String key = matcher.group("key");
                    String group = FrontendTranslationFilesHelper.normalizeCommonBlocksQuotes(FrontendTranslationFilesHelper.unEscapeCommonBlocks(matcher.group("value"))).trim();
                    if (languageData.translations.containsKey(key)) {
                        String value = languageData.translations.get(key);
                        if (value.replaceAll("\\s", "").equals(group.replaceAll("\\s", "")) || FALSE_POSITIVES.contains(key)) continue;
                        System.out.println("WARN: Ambiguous value for key " + key);
                        System.out.println(" - " + value.trim());
                        System.out.println(" - " + group.trim());
                        continue;
                    }
                    System.out.println("INFO: Added " + key);
                    languageData.translations.put(key, group);
                }
            }
        }
    }

    private static String readFile(File file) throws IOException {
        return FrontendTranslationFilesHelper.escapeCommonBlocks(DKUFileUtils.fileToString((File)file));
    }

    private static void findNewInJS(LanguageData languageData, File root) throws IOException {
        Pattern pattern = Pattern.compile("translate\\((?<keyQuote>['\\\"])(?<key>[\\w.]+)\\k<keyQuote>\\s*,\\s*(?<valueQuote>['\\\"])(?<value>(?:(?!\\k<valueQuote>).)+)\\k<valueQuote>", 32);
        File[] files = root.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (FrontendTranslationFilesHelper.isIgnored(file)) continue;
            if (file.isDirectory()) {
                FrontendTranslationFilesHelper.findNewInJS(languageData, file);
                continue;
            }
            if (!file.getName().endsWith(".js") && !file.getName().endsWith(".ts") && !file.getName().endsWith(".html")) continue;
            String s = FrontendTranslationFilesHelper.readFile(file);
            s = s.replaceAll("actionVerb\\(\"([^\"]+)\"\\)", "\"<span class='action-verb'>$1</span>\"");
            s = s.replaceAll("\"\\s*\\+\\s*\"", "");
            FrontendTranslationFilesHelper.replacePattern(languageData, pattern, s);
        }
    }

    private static void replacePattern(LanguageData languageData, Pattern pattern, String s) {
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            String key = matcher.group("key");
            String group = FrontendTranslationFilesHelper.normalizeCommonBlocksQuotes(FrontendTranslationFilesHelper.unEscapeCommonBlocks(matcher.group("value"))).trim();
            group = group.replace("\\s+", " ");
            if (languageData.translations.containsKey(key)) {
                String value = languageData.translations.get(key);
                if (value.trim().equals(group.trim())) continue;
                System.out.println("WARN: Ambiguous value for key " + key);
                System.out.println(" - " + value);
                System.out.println(" - " + group);
                continue;
            }
            System.out.println("INFO: Add " + key);
            languageData.translations.put(key, group);
        }
    }

    private static String escapeCommonBlocks(String s) {
        for (String tag : commonSimpleTags) {
            s = s.replaceAll("<" + tag + " translate(.*)</" + tag + ">", "<" + tag + "><span translate$1</span></" + tag + ">");
            s = s.replaceAll("<" + tag + ">", "__DKU_" + tag + "_OPEN__");
            s = s.replaceAll("</" + tag + ">", "__DKU_" + tag + "_CLOSE__");
        }
        s = s.replaceAll("<i class", "__DKU_ICON_OPEN__");
        s = s.replaceAll("></i>", "__DKU_ICON_CLOSE__");
        s = s.replaceAll("\\\\'", "__DKU_ESCAPED_SINGLE_QUOTE__");
        s = s.replaceAll("\\\\\"", "__DKU_ESCAPED_DOUBLE_QUOTE__");
        return s;
    }

    private static String unEscapeCommonBlocks(String s) {
        for (String tag : commonSimpleTags) {
            s = s.replaceAll("__DKU_" + tag + "_OPEN__", "<" + tag + ">");
            s = s.replaceAll("__DKU_" + tag + "_CLOSE__", "</" + tag + ">");
        }
        s = s.replaceAll("__DKU_ICON_OPEN__", "<i class");
        s = s.replaceAll("__DKU_ICON_CLOSE__", "></i>");
        s = s.replaceAll("__DKU_ESCAPED_SINGLE_QUOTE__", "'");
        s = s.replaceAll("__DKU_ESCAPED_DOUBLE_QUOTE__", "\"");
        return s;
    }

    private static String normalizeCommonBlocksQuotes(String s) {
        s = s.replaceAll("<span class=\\\\\"action-verb\\\\\">", "<span class='action-verb'>");
        s = s.replaceAll("<span class=\"action-verb\">", "<span class='action-verb'>");
        s = s.replaceAll("<i class=\"([^\"]+)\"", "<i class='$1'");
        return s;
    }

    private static class LanguageData {
        Map<String, String> translations = new HashMap<String, String>();

        private LanguageData() {
        }
    }
}

