/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive;

import com.dataiku.dip.hive.HiveSerdeShimsLoader;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

public class SerdeVisitor {
    public static void inspectObject(Object o, ObjectInspector oi) {
        if (o == null) {
            return;
        }
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                SerdeVisitor.inspectPrimitiveObject(o, (PrimitiveObjectInspector)oi);
                break;
            }
            case LIST: {
                SerdeVisitor.inspectListObject(o, (ListObjectInspector)oi);
                break;
            }
            case MAP: {
                SerdeVisitor.inspectMapObject(o, (MapObjectInspector)oi);
                break;
            }
            case STRUCT: {
                SerdeVisitor.inspectStructObject(o, (StructObjectInspector)oi);
                break;
            }
            case UNION: {
                SerdeVisitor.inspectUnionObject(o, (UnionObjectInspector)oi);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + oi.getTypeName());
            }
        }
    }

    private static void inspectUnionObject(Object o, UnionObjectInspector oi) {
        throw new RuntimeException("DSS doesn't handle the Hive UNION type");
    }

    private static void inspectStructObject(Object o, StructObjectInspector oi) {
        List fields = oi.getAllStructFieldRefs();
        List values = oi.getStructFieldsDataAsList(o);
        if (values.size() != fields.size()) {
            throw new RuntimeException("Invalid struct : " + values.size() + " elements, but " + fields.size() + " fields");
        }
        for (int i = 0; i < fields.size(); ++i) {
            SerdeVisitor.inspectObject(values.get(i), ((StructField)fields.get(i)).getFieldObjectInspector());
        }
    }

    private static void inspectMapObject(Object o, MapObjectInspector oi) {
        Map data = oi.getMap(o);
        for (Map.Entry entry : data.entrySet()) {
            SerdeVisitor.inspectObject(entry.getKey(), oi.getMapKeyObjectInspector());
            SerdeVisitor.inspectObject(entry.getValue(), oi.getMapValueObjectInspector());
        }
    }

    private static void inspectListObject(Object o, ListObjectInspector oi) {
        ObjectInspector elementInspector = oi.getListElementObjectInspector();
        for (Object thisObj : oi.getList(o)) {
            SerdeVisitor.inspectObject(thisObj, elementInspector);
        }
    }

    private static void inspectPrimitiveObject(Object o, PrimitiveObjectInspector oi) {
        switch (oi.getPrimitiveCategory()) {
            case VOID: {
                break;
            }
            case BOOLEAN: {
                ((BooleanObjectInspector)oi).get(o);
                break;
            }
            case BYTE: {
                ((ByteObjectInspector)oi).get(o);
                break;
            }
            case SHORT: {
                ((ShortObjectInspector)oi).get(o);
                break;
            }
            case INT: {
                ((IntObjectInspector)oi).get(o);
                break;
            }
            case LONG: {
                ((LongObjectInspector)oi).get(o);
                break;
            }
            case FLOAT: {
                ((FloatObjectInspector)oi).get(o);
                break;
            }
            case DOUBLE: {
                ((DoubleObjectInspector)oi).get(o);
                break;
            }
            case STRING: {
                ((StringObjectInspector)oi).getPrimitiveJavaObject(o);
                break;
            }
            case TIMESTAMP: {
                HiveSerdeShimsLoader.get().readTimestamp(oi, o);
                break;
            }
            case DATE: {
                HiveSerdeShimsLoader.get().readDate(oi, o);
                break;
            }
            case BINARY: {
                ((BinaryObjectInspector)oi).getPrimitiveJavaObject(o);
                break;
            }
            case DECIMAL: {
                ((HiveDecimalObjectInspector)oi).getPrimitiveJavaObject(o);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + oi.getTypeName());
            }
        }
    }
}

