/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.classification.ClassificationAnnotation;
import com.dataiku.dip.labeling.entityextraction.NamedEntity;
import com.dataiku.dip.labeling.freetext.FreeTextAnnotation;
import com.dataiku.dip.labeling.objectdetection.BoundingBox;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=ObjectDetectionLabel.class, type="OBJECT_DETECTION"), @Mapping(value=ClassificationLabel.class, type="CLASSIFICATION", typeAliases={"IMAGE_CLASSIFICATION"}), @Mapping(value=NamedEntityExtractionLabel.class, type="NAMED_ENTITY_EXTRACTION"), @Mapping(value=FreeTextLabel.class, type="FREE_TEXT")})
@UIModel
public abstract class Label<T extends Annotation> {
    public List<T> annotations = new ArrayList<T>();
    @Nullable
    public String comment;

    public void validate(LabelingTask task) {
        if (!task.type.emptyAnnotationsAllowed && (this.annotations == null || this.annotations.isEmpty())) {
            throw ErrorContext.iae((String)("Empty annotations are not allowed for " + String.valueOf((Object)task.type) + " labeling tasks"));
        }
        for (Annotation annotation : this.annotations) {
            annotation.validate(task);
        }
    }

    public String format() {
        return JSON.json(this.annotations);
    }

    public abstract void setAnnotations(String var1);

    public static class FreeTextLabel
    extends Label<FreeTextAnnotation> {
        public static final String TYPE = "FREE_TEXT";

        @Override
        public String format() {
            if (this.annotations == null || this.annotations.size() == 0) {
                return null;
            }
            return ((FreeTextAnnotation)this.annotations.get((int)0)).text;
        }

        @Override
        public void setAnnotations(String rawAnnotation) {
            this.annotations = !Strings.isNullOrEmpty((String)rawAnnotation) ? Arrays.asList(new FreeTextAnnotation(rawAnnotation)) : null;
        }
    }

    public static class NamedEntityExtractionLabel
    extends Label<NamedEntity> {
        public static final String TYPE = "NAMED_ENTITY_EXTRACTION";

        @Override
        public void setAnnotations(String rawAnnotations) {
            if (!Strings.isNullOrEmpty((String)rawAnnotations)) {
                this.annotations = (List)JSON.parse((String)rawAnnotations, (TypeToken)new TypeToken<List<NamedEntity>>(){});
                this.annotations.stream().forEach(a -> a.checkFormat());
            } else {
                this.annotations = null;
            }
        }
    }

    public static class ClassificationLabel
    extends Label<ClassificationAnnotation> {
        public static final String DEPRECATED_TYPE = "IMAGE_CLASSIFICATION";
        public static final String TYPE = "CLASSIFICATION";

        @Override
        public String format() {
            return ((ClassificationAnnotation)this.annotations.get((int)0)).category;
        }

        @Override
        public void setAnnotations(String rawAnnotations) {
            this.annotations = !Strings.isNullOrEmpty((String)rawAnnotations) ? Arrays.asList(new ClassificationAnnotation(rawAnnotations)) : null;
        }
    }

    public static class ObjectDetectionLabel
    extends Label<BoundingBox> {
        public static final String TYPE = "OBJECT_DETECTION";

        @Override
        public String format() {
            ArrayList<LabelsDatasetBoundingBox> labelsDatasetBoundingBoxes = new ArrayList<LabelsDatasetBoundingBox>();
            for (BoundingBox boundingBox : this.annotations) {
                labelsDatasetBoundingBoxes.add(new LabelsDatasetBoundingBox(boundingBox));
            }
            return JSON.json(labelsDatasetBoundingBoxes);
        }

        @Override
        public void setAnnotations(String rawAnnotations) {
            if (!Strings.isNullOrEmpty((String)rawAnnotations)) {
                List labelsDatasetBoundingBoxes = (List)JSON.parse((String)rawAnnotations, (TypeToken)new TypeToken<List<LabelsDatasetBoundingBox>>(){});
                this.annotations = labelsDatasetBoundingBoxes.stream().map(LabelsDatasetBoundingBox::toBoundingBox).collect(Collectors.toList());
            } else {
                this.annotations = null;
            }
        }

        public static class LabelsDatasetBoundingBox {
            public static final int BB_INDEX_X0 = 0;
            public static final int BB_INDEX_Y0 = 1;
            public static final int BB_INDEX_WIDTH = 2;
            public static final int BB_INDEX_HEIGHT = 3;
            public String category;
            public double[] bbox;

            public LabelsDatasetBoundingBox(BoundingBox boundingBox) {
                this.category = boundingBox.category;
                this.bbox = this.flattenBoxCoordinates(boundingBox.bbox);
            }

            private double[] flattenBoxCoordinates(BoundingBox.BoxCoordinates bbox) {
                double[] boundingBox = new double[]{bbox.x0, bbox.y0, bbox.width, bbox.height};
                return boundingBox;
            }

            public void checkFormat() {
                ArrayList<String> missingAttributes = new ArrayList<String>();
                if (Strings.isNullOrEmpty((String)this.category)) {
                    missingAttributes.add("category");
                }
                if (this.bbox == null) {
                    missingAttributes.add("bbox");
                }
                if (!missingAttributes.isEmpty()) {
                    throw new IllegalArgumentException("Invalid annotation format, missing attributes: " + String.join((CharSequence)", ", missingAttributes));
                }
                if (this.bbox.length != 4) {
                    throw new IllegalArgumentException("Invalid annotation format, bbox should be an array of size 4.");
                }
            }

            public BoundingBox toBoundingBox() {
                this.checkFormat();
                return new BoundingBox(this.category, this.bbox[0], this.bbox[1], this.bbox[2], this.bbox[3]);
            }
        }
    }
}

