/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.util.AnyLoc;
import com.google.common.collect.Maps;
import java.util.List;

public class ManagedFolderCheckContext
extends AbstractCheckContext {
    public final ManagedFolder managedFolder;
    public final Partition partition;

    public ManagedFolderCheckContext(ManagedFolder savedModel, Partition partition, long timeCheck, ReadWriteJobsInternalDB jobsDatabaseService, APITicketService.Ticket ticket, String projectKey) {
        super(timeCheck, jobsDatabaseService, ticket, projectKey);
        this.managedFolder = savedModel;
        this.partition = partition;
    }

    public Partition getPartition() {
        return this.partition;
    }

    @Override
    public void ensureLastValues() throws Exception {
        if (this.lastValues == null) {
            this.lastValues = Maps.newHashMap();
            AnyLoc loc = new AnyLoc(this.managedFolder.projectKey, this.managedFolder.id);
            for (ReadOnlyJobsInternalDB.MetricDataPoint computed : this.jobsDatabaseService.getLastMetrics(loc, this.partition == null ? null : this.partition.id())) {
                this.lastValues.put(computed.metric.getId(), computed);
            }
        }
    }

    @Override
    public List<ReadOnlyJobsInternalDB.MetricDataPoint> getHistory(String metricId) throws Exception {
        AnyLoc loc = new AnyLoc(this.managedFolder.projectKey, this.managedFolder.id);
        return this.jobsDatabaseService.getMetrics(loc, this.partition == null ? null : this.partition.id(), metricId);
    }

    @Override
    public AbstractCheckContext.CheckParameters setParamsForPythonChecks() throws Exception {
        String partitionId = this.getPartition() != null ? this.getPartition().id() : "NP";
        String fullName = this.managedFolder.projectKey + "." + this.managedFolder.id;
        MetricTargetType objectType = MetricTargetType.MANAGED_FOLDER;
        return new AbstractCheckContext.CheckParameters(objectType, partitionId, fullName);
    }
}

