/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.checks;

import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.google.common.collect.Maps;
import java.util.List;

public class ModelEvaluationCheckContext
extends AbstractCheckContext {
    public final ModelEvaluationStore mes;
    public final String evaluationId;

    public ModelEvaluationCheckContext(ModelEvaluationStore mes, String evaluationId, long timeCheck, ReadWriteJobsInternalDB jobsDatabaseService, APITicketService.Ticket ticket, String projectKey) {
        super(timeCheck, jobsDatabaseService, ticket, projectKey);
        this.mes = mes;
        this.evaluationId = evaluationId;
    }

    @Override
    public void ensureLastValues() throws Exception {
        if (this.lastValues == null) {
            this.lastValues = Maps.newHashMap();
            for (ReadOnlyJobsInternalDB.MetricDataPoint computed : this.jobsDatabaseService.getLastMetrics(this.mes.getLoc(), this.evaluationId)) {
                this.lastValues.put(computed.metric.getId(), computed);
            }
        }
    }

    @Override
    public List<ReadOnlyJobsInternalDB.MetricDataPoint> getHistory(String metricId) throws Exception {
        return this.jobsDatabaseService.getMetrics(this.mes.getLoc(), this.evaluationId, metricId);
    }

    @Override
    public AbstractCheckContext.CheckParameters setParamsForPythonChecks() throws Exception {
        String partitionId = this.evaluationId;
        String fullName = this.mes.getFullName();
        MetricTargetType objectType = MetricTargetType.MODEL_EVALUATION_STORE;
        return new AbstractCheckContext.CheckParameters(objectType, partitionId, fullName);
    }
}

