/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkMetricsEngine
extends JdbcEngine
implements MetricsQueryBuilder.MetricsQueryBuilderEngine {
    @Autowired
    private SparkSQLConnectionPoolService connectionPoolService;
    private final JdbcEngine.SparkMetricsEngineConfig config;
    private final String filter;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.spark.metrics");

    public SparkMetricsEngine(MetricsEngineRun engineRun, Dataset dataset, Partition partition, JdbcEngine.SparkMetricsEngineConfig config) {
        super(dataset, partition);
        this.config = config;
        this.filter = ((SparkMetricsEngineRun)engineRun).filter;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        logger.info((Object)("Spark metrics engine on dataset : " + this.dataset.getFullName()));
        SparkConnection datasetConnection = SparkConfigurator.configureConnectionForDatabase("default", this.config.extraConf, this.connectionPoolService);
        String datasetTableName = this.dataset.getProjectKey() + "_" + this.dataset.getName();
        datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.dataset." + this.dataset.getFullName(), datasetTableName, false));
        Partition partition = this.getPartition();
        if (partition != null) {
            datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.partition." + this.dataset.getFullName(), partition.id(), false));
        }
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricsQueryBuilder builder = new MetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations, alreadyComputed, this.filter);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult rs2, List<MetricComputation> computations) throws Exception {
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            MetricsQueryBuilder.MetricsQueryBuilderAggregation computer = (MetricsQueryBuilder.MetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(rs2, computation));
        }
        return metricsValues;
    }

    @Override
    public ExpressionBuilder getPartitionFilter() {
        return null;
    }

    public static class SparkMetricsEngineRun
    extends MetricsEngineRun {
        public String filter;
        private boolean neverMergeable = false;

        public SparkMetricsEngineRun() {
            super(MetricsEngineDesc.SparkMetricsEngine);
        }

        public SparkMetricsEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SparkMetricsEngine, cost, computations, pass);
        }

        public SparkMetricsEngineRun withFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public SparkMetricsEngineRun neverMergeable() {
            this.neverMergeable = true;
            return this;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SparkMetricsEngineRun(cost, computations, this.pass).withFilter(this.filter);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            int maxComputationCount = DKUApp.getParams().getIntParam("dku.metricsEngine.spark.maxMetricsPerRun", Integer.valueOf(500));
            return super.canMergeWith(other) && !this.neverMergeable && other instanceof SparkMetricsEngineRun && StringUtils.equals((String)this.filter, (String)((SparkMetricsEngineRun)other).filter) && !((SparkMetricsEngineRun)other).neverMergeable && this.countAfterMergeStaysBelow(other, maxComputationCount);
        }
    }
}

