/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.probes.CustomPythonProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public abstract class ProbeType {
    public String type;
    private static final Map<String, ProbeType> types = Maps.newHashMap();

    public String getType() {
        return this.type;
    }

    public abstract Class<? extends ProbeConfiguration> getParamsClazz();

    public abstract ProbeMetadata getMeta();

    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        return Lists.newArrayList();
    }

    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        return null;
    }

    public abstract boolean isUserSelectedProbe();

    public abstract List<Metric> getMetricsToCompute(Probe var1, Object var2, MetricTargetType var3, boolean var4);

    public abstract List<MetricComputer> getComputers(IBasicMeaningsService var1);

    public abstract ProbeType trimForSave();

    public abstract ProbeConfiguration buildFullConfiguration(List<SchemaColumn> var1, Probe var2);

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProbeType other = (ProbeType)obj;
        return this.type.equals(other.type);
    }

    public static synchronized void register(ProbeType probeType) {
        types.put(probeType.getType(), probeType);
    }

    public static synchronized ProbeType getProbeType(String type) {
        return types.get(type);
    }

    public static Class<? extends ProbeConfiguration> getProbeParamsClazz(String type) {
        ProbeType probeType = types.get(type);
        if (probeType != null) {
            return probeType.getParamsClazz();
        }
        if (type.startsWith("py_plugin")) {
            return CustomPythonProbeType.CustomPythonProbeConfiguration.class;
        }
        return null;
    }

    public static synchronized Map<String, ProbeType> list() {
        return Maps.newHashMap(types);
    }
}

