/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.automaticbin;

import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningMode;
import com.dataiku.dip.pivot.backend.common.automaticbin.TimeInterval;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.DateAxisParams;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class BinningModeComputer {
    static final DateAxisParams.BinningMode SMALLEST_BINNING_MODE = DateAxisParams.BinningMode.SECOND;
    static final List<DateAxisParams.BinningMode> VALID_AGGREGATION_LEVELS = ImmutableList.of((Object)((Object)DateAxisParams.BinningMode.SECOND), (Object)((Object)DateAxisParams.BinningMode.QUARTER_OF_MINUTE), (Object)((Object)DateAxisParams.BinningMode.MINUTE), (Object)((Object)DateAxisParams.BinningMode.QUARTER_OF_HOUR), (Object)((Object)DateAxisParams.BinningMode.HOUR), (Object)((Object)DateAxisParams.BinningMode.QUARTER_OF_DAY), (Object)((Object)DateAxisParams.BinningMode.DAY), (Object)((Object)DateAxisParams.BinningMode.WEEK), (Object)((Object)DateAxisParams.BinningMode.MONTH), (Object)((Object)DateAxisParams.BinningMode.QUARTER), (Object)((Object)DateAxisParams.BinningMode.YEAR));
    private final int maxBinNumberForAutomaticMode;
    protected DKULogger logger = DKULogger.getLogger((String)"dku.charts.automaticbin");

    BinningModeComputer(int maxBinNumberForAutomaticMode) {
        this.maxBinNumberForAutomaticMode = maxBinNumberForAutomaticMode;
    }

    public ComputedBinningMode compute(TimeInterval timeInterval, DateAxisParams.BinningMode smallestValidBinningMode) {
        this.logger.infoV("Computing the smallest aggregation level for data range %s with a maximum of %s bins.", new Object[]{timeInterval, this.maxBinNumberForAutomaticMode});
        if (timeInterval.endTime().equals((Object)timeInterval.startTime())) {
            this.logger.infoV("Interval %s is empty. Defaulting to the smallest valid binning mode '%s'.", new Object[]{timeInterval, this.maxBinNumberForAutomaticMode});
            return new ComputedBinningMode(smallestValidBinningMode, this.maxBinNumberForAutomaticMode);
        }
        List<DateAxisParams.BinningMode> validAggregationLevels = this.computeValidAggregationLevels();
        for (int i = validAggregationLevels.indexOf((Object)smallestValidBinningMode); i < validAggregationLevels.size(); ++i) {
            boolean validNumberOfBins;
            DateAxisParams.BinningMode mode = validAggregationLevels.get(i);
            IDateBinner dateBinner = mode.getDateBinner();
            int numberOfBin = dateBinner.getNbBinsFromTimeInterval(timeInterval);
            this.logger.debugV("Computed number of bins for data range %s and mode '%s': %s", new Object[]{timeInterval, mode, numberOfBin});
            boolean bl = validNumberOfBins = numberOfBin <= this.maxBinNumberForAutomaticMode;
            if (!validNumberOfBins) continue;
            this.logger.infoV("Smallest aggregation level for data range %s found: '%s'", new Object[]{timeInterval, mode});
            return new ComputedBinningMode(mode, numberOfBin);
        }
        DateAxisParams.BinningMode defaultValue = validAggregationLevels.get(validAggregationLevels.size() - 1);
        this.logger.warnV("Could not find a valid aggregation level for the time series. The range of data is too large %s. Defaulting to '%s'.", new Object[]{timeInterval, defaultValue});
        return new ComputedBinningMode(defaultValue, this.maxBinNumberForAutomaticMode);
    }

    protected List<DateAxisParams.BinningMode> computeValidAggregationLevels() {
        return VALID_AGGREGATION_LEVELS;
    }
}

