/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoMetaFile;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.backend.sql.utils.FilterUtils;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import java.util.Objects;

public class StringDictAxisFaceter
implements AxisFaceter {
    final List<String> linoDict;
    private final ChartFilter.FilterSortingOptions sortingOptions;
    final long[] counts;
    final long[] rawCounts;
    final String columName;
    private static final DKULogger logger = DKULogger.getLogger(StringDictAxisFaceter.class);

    public StringDictAxisFaceter(LinoMetaFile.ColumnHeader header, RowFilter rowFilter) {
        this.columName = header.name;
        this.linoDict = header.stringDict;
        this.sortingOptions = rowFilter.facetSorting;
        this.counts = new long[this.linoDict.size()];
        this.rawCounts = rowFilter.allValuesInSample && Objects.requireNonNullElse(rowFilter.facetSorting, ChartFilter.FilterSortingOptions.COUNT_DESC).getType() == ChartFilter.FilterSortingType.COUNT ? new long[this.linoDict.size()] : null;
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        assert (block.getMemoryType() == ColumnBlock.MemoryType.STRING_DICT);
        for (int i = 0; i < block.nbRecords(); ++i) {
            if (this.rawCounts != null) {
                int n = block.ints[i];
                this.rawCounts[n] = this.rawCounts[n] + 1L;
            }
            if (filters != null && !filters[i]) continue;
            int n = block.ints[i];
            this.counts[n] = this.counts[n] + 1L;
        }
    }

    @Override
    public FilterFacet compute(boolean shouldKeepRelevantValuesOnly) {
        long facetsSafetyThreshold = FilterUtils.getAlphanumFacetsSafetyThreshold();
        FilterFacet ff = new FilterFacet();
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0L && shouldKeepRelevantValuesOnly || this.rawCounts != null && this.rawCounts[i] == 0L) continue;
            ff.values.add(new FilterFacet.Val(this.linoDict.get(i), this.getLabel(this.linoDict.get(i)), this.counts[i], this.rawCounts == null ? null : Long.valueOf(this.rawCounts[i])));
        }
        ff.count = ff.values.size();
        ff.values.sort(PivotUtils.buildStringComparator(Objects.requireNonNullElse(this.sortingOptions, ChartFilter.FilterSortingOptions.COUNT_DESC)));
        if (this.rawCounts != null) {
            ff.values.forEach(val -> {
                val.rowCount = null;
            });
        }
        if ((long)ff.values.size() > facetsSafetyThreshold) {
            ff.values.subList((int)facetsSafetyThreshold, ff.values.size()).clear();
            ff.isTruncated = true;
            logger.error((Object)("Truncated alpha-numerical facet on column \"" + this.columName + "\" (too many values: > " + facetsSafetyThreshold + ")"));
        }
        return ff;
    }

    private String getLabel(String value) {
        if ("___dku_no_value___".equals(value)) {
            return "No value";
        }
        return value;
    }
}

