/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.impala;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.hproxy.utils.Reflector;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.service.cli.thrift.TCLIService;
import org.apache.hive.service.cli.thrift.TGetOperationStatusReq;
import org.apache.hive.service.cli.thrift.TGetOperationStatusResp;
import org.apache.hive.service.cli.thrift.TOperationHandle;
import org.apache.hive.service.cli.thrift.TStatus;

public class ImpalaCTASWorkaround {
    private static DKULogger logger = DKULogger.getLogger(ImpalaCTASWorkaround.class);

    private static boolean isHiveStatementLessThan013Impl(Statement stmt) {
        Reflector reflector = new Reflector(stmt.getClass().getClassLoader());
        if (stmt instanceof HiveStatement) {
            try {
                int majorVersion = stmt.getConnection().getMetaData().getDriverMajorVersion();
                int minorVersion = stmt.getConnection().getMetaData().getDriverMinorVersion();
                logger.info((Object)("Hive driver is " + majorVersion + "." + minorVersion));
                if (majorVersion >= 1) {
                    return false;
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Could not get Hive version directly from driver", (Throwable)e);
            }
            try {
                reflector.getAttribute((Object)stmt, "transportLock");
                logger.debug((Object)"Transport lock found => Hive >=0.13");
                return false;
            }
            catch (Exception e) {
                logger.debug((Object)"No transport lock => Hive <0.13");
                return true;
            }
        }
        return false;
    }

    public static boolean isHiveStatementLessThan013(Statement stmt) {
        try {
            Class.forName("org.apache.hive.jdbc.HiveStatement");
            return ImpalaCTASWorkaround.isHiveStatementLessThan013Impl(stmt);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static void waitForCTAS(Statement stmt) throws Exception {
        try {
            Class.forName("org.apache.hive.jdbc.HiveStatement");
            ImpalaCTASWorkaround.waitForCTASImpl(stmt);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void waitForCTASImpl(Statement stmt) throws Exception {
        Reflector reflector = new Reflector(stmt.getClass().getClassLoader());
        if (!ImpalaCTASWorkaround.isHiveStatementLessThan013(stmt)) {
            return;
        }
        TOperationHandle stmtHandle = (TOperationHandle)reflector.getAttribute((Object)stmt, "stmtHandle");
        TCLIService.Iface client = (TCLIService.Iface)reflector.getAttribute((Object)stmt, "client");
        TGetOperationStatusReq statusReq = new TGetOperationStatusReq(stmtHandle);
        boolean requestComplete = false;
        while (!requestComplete) {
            try {
                TGetOperationStatusResp statusResp = client.GetOperationStatus(statusReq);
                Utils.verifySuccessWithInfo((TStatus)statusResp.getStatus());
                if (statusResp.isSetOperationState()) {
                    switch (statusResp.getOperationState()) {
                        case CLOSED_STATE: 
                        case FINISHED_STATE: {
                            return;
                        }
                        case CANCELED_STATE: {
                            throw new SQLException("Query was cancelled", "01000");
                        }
                        case ERROR_STATE: {
                            throw new SQLException("Query failed", "HY000");
                        }
                        case UKNOWN_STATE: {
                            throw new SQLException("Unknown query", "HY000");
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new SQLException(ex.toString(), "08S01", ex);
            }
            Thread.sleep(100L);
        }
    }
}

