/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.queries;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.LatestPartitionsSelector;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InputTable {
    public SQLConnectionProvider.SQLConnectionData connection;
    public SQLDialect dialect;
    public SQLUtils.SQLTable table;
    public PartitionSelection partitionSelection;
    public AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode;
    public AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode;
    public String assumedDBTzForUnknownTz;
    public String projectKey;

    public static InputTable fromDataset(Dataset ds, DatasetSelection selection, AuthCtx authCtx, boolean useSpark) throws Exception {
        InputTable inputTable = InputTable.fromDataset(ds, authCtx, useSpark);
        if (selection == null) {
            return inputTable;
        }
        if (selection.partitionSelectionMethod == DatasetSelection.PartitionSelectionMethod.ALL || selection.selectedPartitions == null) {
            return inputTable;
        }
        if (!ds.getPartitioningSchema().isPartitioned()) {
            throw new UnsupportedOperation("Cannot select partitions on a non-partitioned table");
        }
        PartitionSelection psel = new PartitionSelection();
        psel.partitioningColumn = ds.getPartitioningSchema().getSingleDimension().getName();
        switch (selection.partitionSelectionMethod) {
            case ALL: {
                throw new Error("unreachable");
            }
            case SELECTED: {
                psel.partitions = selection.selectedPartitions;
                break;
            }
            case LATEST_N: {
                psel.partitions = PartitioningUtils.toIds(LatestPartitionsSelector.select(authCtx, ds, selection.latestPartitionsN));
            }
        }
        inputTable.partitionSelection = psel;
        return inputTable;
    }

    public static InputTable fromDataset(Dataset ds, AuthCtx authCtx, boolean useSpark) throws Exception {
        DKULogger.getLogger((String)"dku").info((Object)("InputTable from dataset " + ds.getFullName() + " useSpark=" + useSpark));
        if (DatasetInspector.isSQL(ds)) {
            SQLConnectionProvider.SQLConnectionData sqlData;
            AbstractSQLDatasetHandler.AbstractSQLConfig conf = ds.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class).getResolved(ds.getProjectKey());
            if (StringUtils.isBlank((String)conf.table)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "No table defined on SQL dataset " + ds.getFullName());
            }
            InputTable table = new InputTable();
            AbstractSQLConnection connection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, conf.connection, AbstractSQLConnection.class);
            table.connection = sqlData = connection.getConnectionData_NT(authCtx, ds.getProjectKey());
            table.dialect = sqlData.getDialect();
            table.table = new SQLUtils.SQLTable(conf.catalog, conf.schema, conf.table, true);
            table.dateonlyReadMode = conf.dateonlyReadMode;
            table.datetimenotzReadMode = conf.datetimenotzReadMode;
            table.assumedDBTzForUnknownTz = conf.getAssumedDBTzForUnknownTz();
            table.projectKey = ds.getProjectKey();
            return table;
        }
        if (useSpark) {
            DKULogger.getLogger((String)"dku").info((Object)"USE SPARK !!!");
            assert (SparkConfigurator.interactiveSparkSQLAvailable(authCtx, ds.getProjectKey()));
            AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine = SparkConfigurator.interactiveSparkSQLExecutionEngine(authCtx, ds.getProjectKey());
            switch (sparkExecutionEngine) {
                case SPARK_SUBMIT: {
                    boolean registerDataset;
                    InputTable ret = new InputTable();
                    if (DatasetInspector.syncsHiveTable(ds) && !ApplicationConfigurator.getParams().getBoolParam("dku.interactiveSparkSQL.forceRegisterHDFS", false)) {
                        Logger.getLogger((String)"dip.input.table").info((Object)"Dataset synchronizes its hive table, using it directly");
                        ret.table = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
                        registerDataset = false;
                    } else {
                        Logger.getLogger((String)"dip.input.table").info((Object)"Dataset doesn't synchronize its hive table, registering a temp one");
                        String datasetTableName = ds.getProjectKey() + "_" + ds.getName();
                        ret.table = new SQLUtils.SQLTable(null, null, datasetTableName, true);
                        registerDataset = true;
                    }
                    SparkConnection sparkConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, "@virtual(spark-livy):" + StringUtils.defaultIfBlank((String)ret.table.getSchemaNullIfBlank(), (String)"default"), SparkConnection.class);
                    SparkConnection.SparkSQLConnectionData sqlData = sparkConnection.getConnectionData_NT(authCtx, ds.getProjectKey());
                    ret.connection = sqlData;
                    ret.dialect = sqlData.getDialect();
                    if (registerDataset) {
                        sqlData.addProperty(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.dataset." + ds.getFullName(), ret.table.getTable(), false));
                    }
                    ret.dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                    ret.datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                    ret.projectKey = ds.getProjectKey();
                    return ret;
                }
            }
            throw new Error("Unsupported execution engine: " + String.valueOf((Object)sparkExecutionEngine));
        }
        if (DatasetInspector.isHDFSDatasetOrHiveTableDataset(ds)) {
            DKULogger.getLogger((String)"dku").info((Object)"USE HIVE ? !!!");
            if (!ds.isManaged() || MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)authCtx, (Dataset)ds).requested) {
                SQLUtils.SQLTable tableRef = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
                String clusterId = new ClusterSelector().getClusterForProject(ds.getProjectKey(), Cluster.ClusterArchitecture.HADOOP);
                MetastoreInspectionService metastoreInspectionService = (MetastoreInspectionService)SpringUtils.getBean(MetastoreInspectionService.class);
                MetastoreInspectionService.MetastoreInspector inspector = metastoreInspectionService.newInspector(authCtx, ds.getProjectKey());
                if (inspector.isHiveDatabase(clusterId, tableRef.getSchemaNullIfBlank(), authCtx, ds.getProjectKey())) {
                    if (inspector.isHiveTable(clusterId, tableRef.getSchemaNullIfBlank(), tableRef.getTable(), authCtx, ds.getProjectKey())) {
                        if (ImpalaConfigurator.impalaAvailable(authCtx, ds.getProjectKey())) {
                            ImpalaConnection impalaConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, "@virtual(impala-jdbc):" + tableRef.getSchemaNullIfBlank(), ImpalaConnection.class);
                            SQLConnectionProvider.SQLConnectionData sqlData = impalaConnection.getConnectionData_NT(authCtx, ds.getProjectKey());
                            InputTable ret = new InputTable();
                            ret.connection = sqlData;
                            ret.dialect = sqlData.getDialect();
                            ret.table = new SQLUtils.SQLTable(null, null, tableRef.getTable(), true);
                            ret.dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                            ret.datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                            ret.projectKey = ds.getProjectKey();
                            return ret;
                        }
                        if (HiveConfigurator.hiveAvailableForCharts(authCtx, ds.getProjectKey())) {
                            HiveConnection hiveConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, "@virtual(hive-jdbc):" + tableRef.getSchemaNullIfBlank(), HiveConnection.class);
                            ArrayList overrides = Lists.newArrayList((Object[])new SimpleKeyValue[]{new SimpleKeyValue("hive.resultset.use.unique.column.names", "false")});
                            List<SimpleKeyValue> hiveconf = new HiveConfHelper().getResolvedHiveRuntimeConf(authCtx, ds.getProjectKey(), overrides);
                            hiveConnection.params.hiveconf.addAll(hiveconf);
                            SQLConnectionProvider.SQLConnectionData sqlData = hiveConnection.getConnectionData_NT(authCtx, ds.getProjectKey());
                            InputTable ret = new InputTable();
                            ret.connection = sqlData;
                            ret.dialect = sqlData.getDialect();
                            ret.table = new SQLUtils.SQLTable(null, null, tableRef.getTable(), true);
                            ret.dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                            ret.datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
                            ret.projectKey = ds.getProjectKey();
                            return ret;
                        }
                        throw new UnsupportedOperation("Impala is not correctly installed or configured with DSS, and Hive is not set to handle charts.");
                    }
                    throw new UnsupportedOperation("The Hive table " + tableRef.getSchemaNullIfBlank() + "." + tableRef.getTable() + " doesn't seem to exist, or it has not been created by DSS.");
                }
                throw new UnsupportedOperation("The Hive database " + tableRef.getSchemaNullIfBlank() + " doesn't exist.");
            }
            throw new UnsupportedOperation("The dataset " + ds.getFullName() + " isn't configured to be automatically synchronized with the Hive metastore");
        }
        if (DatasetInspector.isSQLAbleAndSQLTable(authCtx, ds)) {
            DKULogger.getLogger((String)"dku").info((Object)"Frame dataset as SQL !!!");
            SQLConnectionProvider.SQLConnectionData sqlData = DatasetInspector.getSQLConnectionForSQLAbleDatasetOrHive(authCtx, ds);
            InputTable table = new InputTable();
            table.connection = sqlData;
            table.dialect = sqlData.getDialect();
            table.table = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(ds);
            table.dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
            table.datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
            table.projectKey = ds.getProjectKey();
            return table;
        }
        throw new UnsupportedOperation("The dataset " + ds.getFullName() + " isn't compatible with in-database engine. It must be SQL or HDFS.");
    }

    public static class PartitionSelection {
        public String partitioningColumn;
        public List<String> partitions;
    }
}

