/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.pivot.ChartCodes;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.ExcelChartExporter;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.FontFormatting;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExcelChartService {
    @Autowired
    PivotTablesService pivotTablesService;
    private Cache<String, ExcelFile> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static DKULogger logger = DKULogger.getLogger(ExcelChartService.class);

    public ExcelChartService() {
        Preconditions.checkState((!BuiltinsLoader.apachePoiAvailable() || PoiUtils.isInitialized() ? 1 : 0) != 0, (Object)"POI not initialized");
    }

    public String createExcelChart(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx, @Nullable List<FontFormatting> colorMap) throws IOException {
        if (!BuiltinsLoader.apachePoiAvailable()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ChartCodes.ERR_EXCEL_EXPORT_NOT_SUPPORTED_WITH_JAVA7, "Excel export is not available.");
        }
        try {
            String id = SecretKeyGenerator.generateSmall();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ExcelChartExporter.export(chartDef, response, animationFrameIdx, colorMap, baos);
            ExcelFile file = new ExcelFile();
            file.name = chartDef.name + ".xlsx";
            file.content = baos.toByteArray();
            this.cache.put((Object)id, (Object)file);
            return id;
        }
        catch (Exception e) {
            logger.error((Object)("Error while exporting a chart to Excel. Chart def is:\n" + JSON.pretty((Object)chartDef)), (Throwable)e);
            throw e;
        }
    }

    public void handleDownloadRequest(String id, HttpServletResponse resp) throws IOException {
        ExcelFile file = (ExcelFile)this.cache.getIfPresent((Object)id);
        if (file != null) {
            resp.setStatus(200);
            resp.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            String contentDisposition = "attachment; filename=\"" + file.name + "\"";
            resp.setHeader("Content-Disposition", contentDisposition);
            resp.setContentLength(file.content.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(file.content);
        } else {
            resp.setStatus(404);
            resp.getWriter().write("No Excel file for ID: " + id);
        }
    }

    public static class ExcelFile {
        String name;
        byte[] content;
    }
}

