/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.dev;

import com.dataiku.dip.analysis.ml.prediction.CustomPythonPredictionAlgoService;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomJavaPolicyHooksService;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.datasets.fs.plugin.CustomJavaFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.datasets.sample.SampleDatasetsService;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.CustomPythonExportersService;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.metrics.checks.CustomPythonChecksService;
import com.dataiku.dip.metrics.probes.CustomPythonProbesService;
import com.dataiku.dip.metrics.probes.CustomSQLProbesService;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.CustomPythonDatasetsService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginDesc;
import com.dataiku.dip.plugins.presets.PluginParameterSetsService;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.steps.PythonPluginStepsService;
import com.dataiku.dip.scheduler.triggers.PythonPluginTriggersService;
import com.dataiku.dip.shaker.processors.udf.CustomJythonProcessorsService;
import com.dataiku.dip.sql.CustomJavaDialectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.plugins.CustomWebAppsService;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.MalformedJsonException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevPluginValidationService {
    @Autowired
    private CustomCodeRecipesService customCodeRecipesService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomJavaDatasetsService customJavaDatasetsService;
    @Autowired
    private CustomJavaDialectsService customJavaDialectsService;
    @Autowired
    private CustomJavaExportersService customJavaExportersService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    @Autowired
    private CustomJavaFSProvidersService customJavaFSProvidersService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private CustomJavaPolicyHooksService customJavaPolicyHooksService;
    @Autowired
    private CustomJythonProcessorsService customJythonProcessorsService;
    @Autowired
    private CustomPythonChecksService customPythonChecksService;
    @Autowired
    private CustomPythonDatasetsService customPythonDatasetsService;
    @Autowired
    private CustomPythonExportersService customPythonExportersService;
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomPythonFSProvidersService customPythonFSProvidersService;
    @Autowired
    private CustomPythonProbesService customPythonProbesService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private PythonPluginClustersService pythonPluginClustersService;
    @Autowired
    private PythonPluginStepsService pythonPluginStepsService;
    @Autowired
    private PythonPluginTriggersService pythonPluginTriggersService;
    @Autowired
    private CustomSQLProbesService customSQLProbesService;
    @Autowired
    private CustomWebAppsService customWebAppsService;
    @Autowired
    private PluginParameterSetsService pluginParameterSetsService;
    @Autowired
    private CustomPythonPredictionAlgoService customPythonPredictionAlgoService;
    @Autowired
    private SampleDatasetsService sampleDatasetsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.validation");

    public InfoMessage.InfoMessages validatePluginFiles(String pluginId, Map<String, String> fileMap) {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        for (Map.Entry<String, String> e : fileMap.entrySet()) {
            try {
                String path = e.getKey();
                String[] chunks = path.split("/");
                String data = e.getValue();
                messages.mergeFrom(this.validatePluginFileContent(chunks, pluginId, data));
            }
            catch (Exception ex) {
                logger.error((Object)"Failed to validate plugin", (Throwable)ex);
                messages.withFatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_DEFINITION, "Failed to validate plugin: " + ExceptionUtils.getMessageWithCauses((Throwable)ex));
            }
        }
        return messages;
    }

    public InfoMessage.InfoMessages validatePluginFileContent(String[] chunks, String pluginId, String data) {
        if ("plugin.json".equals(chunks[0])) {
            return this.validatePluginDesc(data, pluginId);
        }
        if (chunks.length == 3) {
            for (AbstractElementService<?, ?> service : this.getServices()) {
                if (!chunks[0].equals(service.getFolderName()) || !chunks[2].equals(service.getPrefix() + ".json")) continue;
                return this.validateDesc(data, chunks[1], pluginId, service);
            }
        }
        return new InfoMessage.InfoMessages();
    }

    public InfoMessage.InfoMessages validatePluginDesc(String data, String pluginId) {
        PluginDesc desc;
        try {
            desc = (PluginDesc)JSON.parse((String)data, PluginDesc.class);
        }
        catch (Exception e) {
            return this.invalidJson(e);
        }
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (StringUtils.isBlank((String)desc.id)) {
            messages.withFatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Missing plugin id");
            return messages;
        }
        if (!pluginId.equals(desc.id)) {
            String msg = String.format("Mismatch with 'id' field in plugin.json: '%s' instead of expected '%s'", desc.id, pluginId);
            messages.withFatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, msg);
            return messages;
        }
        if (desc.params != null) {
            desc.params.stream().flatMap(this::validateParameter).forEach(arg_0 -> ((InfoMessage.InfoMessages)messages).addMessage(arg_0));
        }
        if (desc.meta == null) {
            messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "No \"meta\" field in plugin.json");
        } else {
            if (StringUtils.isBlank((String)desc.meta.label)) {
                messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Plugin has no label");
            }
            if (StringUtils.isBlank((String)desc.meta.description)) {
                messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Plugin has no description");
            }
            if (StringUtils.isBlank((String)desc.meta.author)) {
                messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Plugin has no \"author\" field");
            }
            if (desc.meta.tags != null) {
                ArrayList<String> lowercasedUsedNames = new ArrayList<String>(desc.meta.tags.size());
                for (String tag : desc.meta.tags) {
                    if (tag == null) {
                        messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Null tag, make sure there is no trailing comma");
                        continue;
                    }
                    if (StringUtils.isBlank((String)tag)) {
                        messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Empty tag");
                        continue;
                    }
                    if (lowercasedUsedNames.contains(tag)) {
                        messages.withWarning((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, "Duplicate tag: " + tag);
                        continue;
                    }
                    lowercasedUsedNames.add(tag);
                }
            }
        }
        return messages;
    }

    private <Desc> InfoMessage.InfoMessages validateDesc(String data, String componentId, String pluginId, AbstractElementService<Desc, ?> service) {
        Object desc;
        try {
            desc = JSON.parse((String)data, service.getDescClass());
        }
        catch (Exception e) {
            return this.invalidJson(e);
        }
        return service.validate(componentId, pluginId, desc);
    }

    private Stream<InfoMessage> validateParameter(@CheckForNull ParamDesc paramDesc) {
        if (paramDesc == null) {
            return Stream.of(InfoMessage.fatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, (String)"Null param in plugin.json, make sure there is no trailing comma"));
        }
        if (StringUtils.isBlank((String)paramDesc.name)) {
            return Stream.of(InfoMessage.fatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, (String)"Unnamed param in plugin.json"));
        }
        if (paramDesc.type == null) {
            return Stream.of(InfoMessage.fatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, (String)"param without a type in plugin.json"));
        }
        boolean defaultValueValid = true;
        String clazzName = "";
        switch (paramDesc.type) {
            case BOOLEAN: {
                defaultValueValid = this.tryCast(paramDesc.defaultValue, Boolean.class::cast, Boolean.class);
                clazzName = Boolean.TYPE.getSimpleName();
                break;
            }
            case INT: 
            case DOUBLE: {
                defaultValueValid = this.tryCast(paramDesc.defaultValue, Number.class::cast, Number.class);
                clazzName = Double.TYPE.getSimpleName();
                break;
            }
            case MAP: {
                defaultValueValid = this.tryCast(paramDesc.defaultValue, JSON::toJsonObject, JsonObject.class);
                clazzName = JsonObject.class.getSimpleName();
                break;
            }
            case KEY_VALUE_LIST: 
            case DOUBLES: 
            case STRINGS: 
            case MULTISELECT: 
            case ARRAY: 
            case OBJECT_LIST: {
                defaultValueValid = this.tryCast(paramDesc.defaultValue, JSON::toJsonArray, JsonArray.class);
                clazzName = JsonArray.class.getSimpleName();
                break;
            }
        }
        if (!defaultValueValid) {
            return Stream.of(InfoMessage.fatalV((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_DEFINITION, (String)"Parameter '%s' default value '%s' cannot be converted to type '%s'", (Object[])new Object[]{paramDesc.name, paramDesc.defaultValue.toString(), clazzName}));
        }
        return Stream.empty();
    }

    private <T> boolean tryCast(Object value, Function<Object, T> castFunction, Class<T> clazz) {
        try {
            castFunction.apply(value);
            return true;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Plugin contains a default value '%s' that does not match the required type '%s'.", new Object[]{value, clazz.getName()});
            return false;
        }
    }

    private InfoMessage.InfoMessages invalidJson(Exception e) {
        logger.error((Object)e);
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (e.getCause() instanceof MalformedJsonException) {
            e = (MalformedJsonException)e.getCause();
        }
        messages.withFatal((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_DEV_INVALID_COMPONENT_DEFINITION, ExceptionUtils.getMessageWithCauses((Throwable)e));
        return messages;
    }

    private AbstractElementService<?, ?>[] getServices() {
        return new AbstractElementService[]{this.customCodeRecipesService, this.customFieldsService, this.customJavaDatasetsService, this.customJavaDialectsService, this.customJavaExportersService, this.customJavaFormatsService, this.customJavaFSProvidersService, this.customJavaRunnablesService, this.customJavaPolicyHooksService, this.customJythonProcessorsService, this.customPythonChecksService, this.customPythonDatasetsService, this.customPythonExportersService, this.customPythonFormatsService, this.customPythonFSProvidersService, this.customPythonProbesService, this.customPythonRunnablesService, this.pythonPluginClustersService, this.pythonPluginStepsService, this.pythonPluginTriggersService, this.customSQLProbesService, this.customWebAppsService, this.pluginParameterSetsService, this.customPythonPredictionAlgoService, this.sampleDatasetsService};
    }
}

