/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.dev;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.integrations.AttachmentService;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.GlobalLibsChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectLibsChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.RelFileInputStream;
import com.dataiku.dip.transactions.fs.utils.AcceptAllFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.common.io.BaseEncoding;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.input.CloseShieldInputStream;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import javax.mail.internet.ContentDisposition;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FolderEditorService {
    private static final int DEFAULT_MAX_PREVIEW_LENGTH = 0x4000000;
    private static final String FOLDER_EDITOR_PROPERTY_MAX_PREVIEW_LENGTH_BYTES = "dku.folder.editor.max.preview.length.bytes";
    @Autowired
    private PubSubService pubSubService;
    private static final Logger logger = Logger.getLogger((String)"dku.folder.editor");

    private void ensureFolderExists(RelFile baseFolder, TransactionRef t) throws IOException {
        if (!t.exists(baseFolder)) {
            if (t instanceof RWTransaction) {
                ((RWTransaction)t).makeDirectory(baseFolder);
            } else {
                logger.info((Object)"Cannot create directory (not a write transaction), will do later");
            }
            return;
        }
        if (!t.isDirectory(baseFolder)) {
            throw new IOException("The path " + baseFolder.getFullPath() + " is not a folder");
        }
    }

    private void checkFileWithinFolder(RelFile baseFolder, RelFile file, TransactionRef t) throws IOException, DKUSecurityException {
        Path baseFolderPath = t.resolve(baseFolder).getCanonicalFile().toPath();
        Path filePath = t.resolve(file).getCanonicalFile().toPath();
        if (!filePath.startsWith(baseFolderPath)) {
            throw new DKUSecurityException("File " + String.valueOf(filePath) + " refers to a location outside of the folder " + String.valueOf(baseFolderPath)).withCode((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_PATH_ESCAPE);
        }
    }

    public List<FolderContent> getFolderContent(RelFile baseFolder, TransactionRef t) throws Exception {
        this.ensureFolderExists(baseFolder, t);
        ArrayList contents = Lists.newArrayList();
        this.populateContents(baseFolder, baseFolder, contents, t);
        return contents;
    }

    private void populateContents(RelFile baseFolder, RelFile folder, List<FolderContent> contents, TransactionRef t) throws IOException, DKUSecurityException {
        if (!t.exists(folder)) {
            return;
        }
        this.checkFileWithinFolder(baseFolder, folder, t);
        for (RelFile file : t.listFiles(folder)) {
            if (file.getLeafName().startsWith(".git") || file.getLeafName().endsWith(".pyc") || file.getLeafName().endsWith("__pycache__")) continue;
            FolderContent content = this.getSimpleContentForFile(baseFolder, file, true, t);
            contents.add(content);
        }
    }

    private FolderContent getSimpleContentForFile(RelFile baseFolder, RelFile file, boolean recurse, TransactionRef t) throws IOException, DKUSecurityException {
        FolderContent content = new FolderContent();
        content.name = file.getLeafName();
        Object baseFolderFullPath = baseFolder.getFullPath();
        if (((String)baseFolderFullPath).length() > 0 && !((String)baseFolderFullPath).endsWith("/")) {
            baseFolderFullPath = (String)baseFolderFullPath + "/";
        }
        content.path = file.getFullPath().substring(((String)baseFolderFullPath).length());
        long l = content.size = t.isFile(file) ? t.getLength(file) : 0L;
        if (t.isDirectory(file)) {
            content.children = Lists.newArrayList();
            if (recurse) {
                this.populateContents(baseFolder, file, content.children, t);
            }
        } else if (t.isFile(file)) {
            content.lastModified = t.getLastModified(file);
            content.children = null;
            content.mimeType = DKUtils.probeContentTypeWithFallback((File)t.resolve(file));
        }
        return content;
    }

    public FolderContent getFolderContent(RelFile baseFolder, String path, boolean sendAnyway, @Nullable String dataEncoding, Transaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        FolderContent content = new FolderContent();
        content.name = file.getLeafName();
        content.path = path;
        content.size = t.isFile(file) ? t.getLength(file) : 0L;
        content.mimeType = DKUtils.probeContentTypeWithFallback((File)t.resolve(file));
        content.hasData = true;
        content.reason = "";
        int maxPreviewLength = DKUApp.getProperty((String)FOLDER_EDITOR_PROPERTY_MAX_PREVIEW_LENGTH_BYTES, (int)0x4000000);
        if (!sendAnyway) {
            if (!DKUtils.isTextLikeMimeType((String)content.mimeType)) {
                content.hasData = false;
                content.reason = content.reason + "The file may not be text. ";
            } else if (content.size > (long)maxPreviewLength) {
                content.hasData = false;
                content.reason = content.reason + "The file is too large. ";
            }
        }
        if (content.hasData) {
            if (StringUtils.isBlank((String)dataEncoding) || "utf8".equalsIgnoreCase(dataEncoding) || "utf-8".equalsIgnoreCase(dataEncoding)) {
                content.data = t.readStringUTF8(file);
            } else if ("base64".equalsIgnoreCase(dataEncoding) || "base-64".equalsIgnoreCase(dataEncoding)) {
                content.data = BaseEncoding.base64().encode(t.readBytes(file));
            } else {
                throw new IllegalArgumentException("Invalid dataEncoding value: " + dataEncoding + ". Valid values are: '' (empty string), 'utf8', 'base64'.");
            }
        }
        if (t.isFile(file)) {
            content.lastModified = t.getLastModified(file);
        }
        return content;
    }

    public byte[] previewImageStream(RelFile baseFolder, String path, Transaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        return t.readBytes(file);
    }

    public void getRawFolderContent(HttpServletResponse resp, RelFile baseFolder, String path, Transaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        if (!t.exists(file)) {
            resp.setStatus(404);
            resp.getWriter().write("The requested path is not a file.");
        } else if (t.isDirectory(file)) {
            resp.setStatus(404);
            resp.getWriter().write("The requested path is a folder.");
        } else {
            resp.setStatus(200);
            resp.setContentType(DKUtils.probeContentTypeWithFallback((File)t.resolve(file)));
            ContentDisposition contentDisposition = new ContentDisposition();
            contentDisposition.setDisposition("attachment");
            contentDisposition.setParameter("filename", file.getLeafName());
            resp.setHeader("Content-Disposition", contentDisposition.toString());
            resp.setContentLengthLong(t.getLength(file));
            try (RelFileInputStream is = t.readStream(file);){
                IOUtils.copy((InputStream)is, (OutputStream)resp.getOutputStream());
            }
        }
    }

    public FolderContent getFileDetails(RelFile baseFolder, String path, Transaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        if (t.isDirectory(file)) {
            throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_INVALID_PARAMETER, "The requested path is a folder: " + path);
        }
        FolderContent content = new FolderContent();
        content.name = file.getLeafName();
        content.path = path;
        content.size = t.getLength(file);
        content.mimeType = DKUtils.guessMimeTypeFromExtension((String)file.getLeafName());
        content.lastModified = t.getLastModified(file);
        content.hasData = false;
        content.children = null;
        return content;
    }

    public boolean existsFolderContent(RelFile baseFolder, String path, RWTransactionRef t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        return t.exists(file);
    }

    public void setFolderContent(RelFile baseFolder, String path, String data, RWTransactionRef t) throws Exception {
        this.setFolderContent(baseFolder, path, data, t, false);
    }

    public boolean setFolderContent(RelFile baseFolder, String path, String data, RWTransactionRef t, boolean checkChanges) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exist");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        if (checkChanges && FolderEditorService.hasSameContent(data, file, t)) {
            return false;
        }
        t.writeStringUTF8(file, data);
        this.publishLibChangedEvent(baseFolder, t);
        return true;
    }

    private void publishLibChangedEvent(RelFile baseFolder, RWTransactionRef t) {
        Object key;
        BackendEvent event;
        String[] elements = baseFolder.getElements();
        if (elements.length > 1 && "projects".equals(elements[0])) {
            String projectKey = elements[1];
            event = new ProjectLibsChangedEvent(projectKey);
            key = "ProjectLibsChangedEvent-" + projectKey;
        } else if (elements.length == 0 && ProjectLibPathHelper.getGlobalLibPath().equals(t.resolve(baseFolder))) {
            event = new GlobalLibsChangedEvent();
            key = "GlobalLibsChangedEvent";
        } else {
            return;
        }
        int interval = DKUApp.getProperty((String)"dku.docportal.indexingDebounceIntervalMs", (int)30000);
        this.pubSubService.publishAfterTransactionWithDebounce((String)key, (DSSEvent)event, interval);
    }

    public void setOrAddFolderContent(RelFile baseFolder, String path, String data, RWTransaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        t.writeStringUTF8(file, data);
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
    }

    public void setFolderContentList(RelFile baseFolder, Map<String, String> fileMap, RWTransaction t) throws Exception {
        this.setFolderContentList(baseFolder, fileMap, t, false);
    }

    public boolean setFolderContentList(RelFile baseFolder, Map<String, String> fileMap, RWTransaction t, boolean checkChanges) throws Exception {
        boolean hasChanges = false;
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        for (Map.Entry<String, String> pathToData : fileMap.entrySet()) {
            String path = pathToData.getKey();
            String data = pathToData.getValue();
            RelFile file = baseFolder.appendChildPath(path);
            if (!t.exists(file)) {
                throw new IllegalArgumentException("File " + path + " does not exist");
            }
            this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
            if (checkChanges && FolderEditorService.hasSameContent(data, file, (RWTransactionRef)t)) continue;
            t.writeStringUTF8(file, data);
            hasChanges = true;
        }
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
        return hasChanges;
    }

    public void addFolderContent(RelFile baseFolder, String path, boolean isFolder, RWTransactionRef t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " already exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        if (isFolder) {
            t.makeDirectory(file);
        } else {
            t.writeStringUTF8(file, "");
        }
        this.publishLibChangedEvent(baseFolder, t);
    }

    public FileType removeFolderContent(RelFile baseFolder, String path, RWTransaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        if (t.isDirectory(file)) {
            t.deleteDirectory(file);
            this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
            return FileType.FOLDER;
        }
        t.deleteFile(file);
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
        return FileType.FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompressFolderContent(RelFile baseFolder, String path, RWTransaction t) throws Exception {
        block27: {
            this.ensureFolderExists(baseFolder, (TransactionRef)t);
            RelFile file = baseFolder.appendChildPath(path);
            if (!t.exists(file)) {
                throw new IllegalArgumentException("File " + path + " does not exists");
            }
            this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
            if (t.isDirectory(file)) {
                throw new IllegalArgumentException("File " + path + " is a folder");
            }
            ZipArchiveInputStream ais = null;
            GzipCompressorInputStream cis = null;
            try {
                String suffix;
                String fileName = file.getLeafName();
                String fileNameLowerCase = fileName.toLowerCase(Locale.ROOT);
                if (fileNameLowerCase.endsWith(".zip")) {
                    suffix = ".zip";
                    ais = new ZipArchiveInputStream((InputStream)new FileInputStream(t.resolve(file)));
                } else if (fileNameLowerCase.endsWith(".tar")) {
                    suffix = ".tar";
                    ais = new TarArchiveInputStream((InputStream)new FileInputStream(t.resolve(file)));
                } else if (fileNameLowerCase.endsWith(".tar.gz")) {
                    suffix = ".tar.gz";
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(t.resolve(file))));
                } else if (fileNameLowerCase.endsWith(".tgz")) {
                    suffix = ".tgz";
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(t.resolve(file))));
                } else if (fileNameLowerCase.endsWith(".tar.bz2")) {
                    suffix = ".tar.bz2";
                    ais = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(t.resolve(file))));
                } else if (fileNameLowerCase.endsWith(".gz")) {
                    suffix = ".gz";
                    cis = new GzipCompressorInputStream((InputStream)new FileInputStream(t.resolve(file)));
                } else if (fileNameLowerCase.endsWith(".bz2")) {
                    suffix = ".bz2";
                    cis = new BZip2CompressorInputStream((InputStream)new FileInputStream(t.resolve(file)));
                } else {
                    throw new IllegalArgumentException("Doesn't know how to decompress " + fileName);
                }
                RelFile decompressedFile = new RelFile(file.getParent(), new String[]{fileName.substring(0, fileName.length() - suffix.length())});
                if (t.exists(decompressedFile)) {
                    throw new Exception("Destination " + decompressedFile.getFullPath() + " already exist");
                }
                if (cis != null) {
                    logger.info((Object)("Decompress single-file archive to " + decompressedFile.getFullPath()));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)cis, (OutputStream)baos);
                    t.writeBytes(decompressedFile, baos.toByteArray());
                    break block27;
                }
                if (ais != null) {
                    logger.info((Object)("Decompress multi-file archive to " + decompressedFile.getFullPath()));
                    ArchiveEntry entry = ais.getNextEntry();
                    while (entry != null) {
                        if (!entry.isDirectory()) {
                            RelFile entryFile = decompressedFile.appendChildPath(entry.getName());
                            logger.info((Object)("Process enty " + entryFile.getFullPath()));
                            if (t.exists(entryFile)) {
                                throw new IllegalArgumentException("File " + entryFile.getFullPath() + " exists");
                            }
                            this.checkFileWithinFolder(baseFolder, entryFile, (TransactionRef)t);
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)new CloseShieldInputStream((InputStream)ais), (OutputStream)baos);
                            t.writeBytes(entryFile, baos.toByteArray());
                        }
                        entry = ais.getNextEntry();
                    }
                    break block27;
                }
                throw new Error("Unreachable");
            }
            finally {
                if (ais != null) {
                    ais.close();
                }
                if (cis != null) {
                    cis.close();
                }
            }
        }
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
    }

    public void streamContent(RelFile baseFolder, String path, HttpServletResponse resp, Transaction t) throws IOException {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new FileNotFoundException("No file at " + file.toString());
        }
        if (t.isDirectory(file)) {
            resp.setContentType("application/zip");
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getLeafName() + ".zip\"");
            try (ZipOutputStream zos = new ZipOutputStream((OutputStream)resp.getOutputStream());){
                FolderEditorService.zip(file.getLeafName(), file, file, (RelFileFilter)new AcceptAllFilter(), zos, t);
            }
        } else {
            String mimeType = DKUtils.probeContentTypeWithFallback((File)t.resolve(file));
            resp.setContentType(StringUtils.defaultIfBlank((String)mimeType, (String)"application/x-binary"));
            resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getLeafName() + "\"");
            IOUtils.copyLarge((InputStream)t.readStream(file), (OutputStream)resp.getOutputStream());
        }
    }

    public void streamFolderContent(RelFile root, String name, RelFileFilter filter, OutputStream os, Transaction t, Map<String, String> additionalEntries) throws IOException {
        this.ensureFolderExists(root, (TransactionRef)t);
        try (ZipOutputStream zos = new ZipOutputStream(os);){
            FolderEditorService.zip(name, root, root, filter, zos, t);
            if (additionalEntries != null) {
                for (Map.Entry<String, String> e : additionalEntries.entrySet()) {
                    Object fullPath = e.getKey();
                    if (t.exists((String)fullPath)) {
                        logger.warn((Object)("Additional entry " + (String)fullPath + " already present, skipping"));
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)name)) {
                        fullPath = name + File.separator + (String)fullPath;
                    }
                    ZipEntry entry = new ZipEntry((String)fullPath);
                    zos.putNextEntry(entry);
                    IOUtils.write((String)e.getValue(), (OutputStream)zos);
                }
            }
        }
    }

    private static void zip(String name, RelFile rootDir, RelFile sourceDir, RelFileFilter filter, ZipOutputStream zos, Transaction t) throws IOException {
        for (RelFile file : t.listFiles(sourceDir, filter)) {
            if (t.isDirectory(file)) {
                FolderEditorService.zip(name, rootDir, file, filter, zos, t);
                continue;
            }
            String filePath = sourceDir.getFullPath().replaceFirst("^" + File.separator + "?" + Pattern.quote(rootDir.getFullPath()), "");
            String fullPath = StringUtils.isNotBlank((String)name) ? name + File.separator + filePath + File.separator + file.getLeafName() : filePath + File.separator + file.getLeafName();
            ZipEntry entry = new ZipEntry(fullPath);
            zos.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(t.resolve(file));){
                IOUtils.copy((InputStream)in, (OutputStream)zos);
            }
        }
    }

    public FolderContent renameFolderContent(RelFile baseFolder, String path, String newName, RWTransaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        RelFile newFile = file.getParent().appendChildPath(newName);
        String newPath = newFile.getFullPath();
        if (t.exists(newFile)) {
            throw new IllegalArgumentException("File " + newPath + " already exists");
        }
        this.checkFileWithinFolder(baseFolder, newFile, (TransactionRef)t);
        t.moveFile(file, newFile);
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
        return this.getSimpleContentForFile(baseFolder, newFile, false, (TransactionRef)t);
    }

    public FolderContent moveFolderContent(RelFile baseFolder, String path, String toPath, RWTransaction t) throws Exception {
        RelFile toFile;
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        RelFile relFile = toFile = StringUtils.isNotBlank((String)toPath) ? baseFolder.appendChildPath(toPath) : baseFolder;
        if (!t.exists(toFile)) {
            throw new IllegalArgumentException("Destination folder " + toPath + " does not exists");
        }
        if (!t.isDirectory(toFile)) {
            throw new IllegalArgumentException("Destination folder " + toPath + " is not a folder");
        }
        this.checkFileWithinFolder(baseFolder, toFile, (TransactionRef)t);
        RelFile newFile = new RelFile(toFile, new String[]{file.getLeafName()});
        String newPath = newFile.getFullPath();
        if (t.exists(newFile)) {
            throw new IllegalArgumentException("Destination file " + newPath + " already exists");
        }
        this.checkFileWithinFolder(baseFolder, newFile, (TransactionRef)t);
        t.moveFile(file, newFile);
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
        return this.getSimpleContentForFile(baseFolder, newFile, false, (TransactionRef)t);
    }

    public FolderContent copyFolderContent(RelFile baseFolder, String path, RWTransaction t) throws Exception {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        String extensionFreeName = FilenameUtils.removeExtension((String)file.getLeafName());
        String extension = FilenameUtils.getExtension((String)file.getLeafName());
        String copyName = extensionFreeName + "_copy" + (String)(extension.length() > 0 ? "." + extension : "");
        RelFile copyFile = new RelFile(file.getParent(), new String[]{copyName});
        int copyIndex = 0;
        while (t.exists(copyFile)) {
            copyName = extensionFreeName + "_copy_" + ++copyIndex + (String)(extension.length() > 0 ? "." + extension : "");
            copyFile = new RelFile(file.getParent(), new String[]{copyName});
        }
        t.copyRelFile(file, copyFile);
        this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
        return this.getSimpleContentForFile(baseFolder, copyFile, true, (TransactionRef)t);
    }

    public UploadFeasabilities checkUploadContent(RelFile baseFolder, String path, List<String> filePaths, Transaction t) throws IOException, DKUSecurityException {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file) && !file.equals((Object)baseFolder)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        UploadFeasabilities feasabilities = new UploadFeasabilities();
        for (String name : filePaths) {
            RelFile f = file.appendPath_withoutDirectoryTraversalCheck(name);
            if (!t.resolve(f).getCanonicalFile().toPath().startsWith(t.resolve(baseFolder).getCanonicalFile().toPath())) {
                feasabilities.feasabilities.add(UploadFeasability.nok(name, "Requested file name points to a location outside the folder", false));
                continue;
            }
            if (t.exists(f)) {
                feasabilities.feasabilities.add(UploadFeasability.nok(name, "File " + name + " already exists and would be overwritten.", true));
                continue;
            }
            feasabilities.feasabilities.add(UploadFeasability.ok(name));
        }
        return feasabilities;
    }

    public Callable<FolderContent> uploadContent(final RelFile baseFolder, String path, final InputStream is, final String name, final RWTransaction t) throws IOException, DKUSecurityException {
        this.ensureFolderExists(baseFolder, (TransactionRef)t);
        final RelFile file = baseFolder.appendChildPath(path);
        if (!t.exists(file)) {
            throw new IllegalArgumentException("File " + path + " does not exists");
        }
        this.checkFileWithinFolder(baseFolder, file, (TransactionRef)t);
        return new Callable<FolderContent>(){

            @Override
            public FolderContent call() throws Exception {
                RelFile f = file.appendPath_withoutDirectoryTraversalCheck(name);
                FolderEditorService.this.checkFileWithinFolder(baseFolder, f, (TransactionRef)t);
                if (t.exists(f)) {
                    t.deleteFile(f);
                }
                AttachmentService.LimitedByteArrayOutputStream baos = new AttachmentService.LimitedByteArrayOutputStream(0x3200000L);
                IOUtils.copy((InputStream)is, (OutputStream)baos);
                t.writeBytes(f, baos.toByteArray());
                logger.info((Object)("Uploaded a file of size " + baos.size()));
                FolderEditorService.this.publishLibChangedEvent(baseFolder, (RWTransactionRef)t);
                return FolderEditorService.this.getSimpleContentForFile(baseFolder, f, false, (TransactionRef)t);
            }
        };
    }

    private static boolean hasSameContent(String data, RelFile file, RWTransactionRef t) {
        try {
            String existingContent = t.readStringUTF8(file);
            return existingContent != null && existingContent.equals(data);
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to read content of file " + file.getFullPath()), (Throwable)e);
            return false;
        }
    }

    public static class FolderContent {
        public String name;
        public String path;
        public String mimeType;
        long size;
        List<FolderContent> children;
        public String data;
        public boolean hasData;
        long lastModified;
        String reason;
    }

    public static enum FileType {
        FILE,
        FOLDER;

    }

    public static class UploadFeasabilities {
        public List<UploadFeasability> feasabilities = Lists.newArrayList();
    }

    public static class UploadFeasability {
        public final boolean canUpload;
        public final boolean exists;
        public final String reason;
        public final String filePath;

        UploadFeasability(String filePath, boolean canUpload, String reason, boolean exists) {
            this.filePath = filePath;
            this.canUpload = canUpload;
            this.reason = reason;
            this.exists = exists;
        }

        static UploadFeasability ok(String filePath) {
            return new UploadFeasability(filePath, true, null, false);
        }

        static UploadFeasability nok(String filePath, String reason, boolean exists) {
            return new UploadFeasability(filePath, false, reason, exists);
        }
    }
}

