/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.kernel.DSSKernelUtils;
import com.dataiku.dip.kernel.KernelPool;
import com.dataiku.dip.kernel.KernelPoolThreadFactory;
import com.dataiku.dip.kernel.KernelScalingStrategyBuilder;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunRequest;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunResult;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.NDC;
import org.springframework.stereotype.Service;

@Service
public class ProjectStandardsKernelPool {
    public static final String KERNEL_MAX_TOTAL_CONFIG_KEY = "dku.projectStandards.kernels.maxTotal";
    public static final int KERNEL_MAX_TOTAL_DEFAULT = 10;
    public static final String IDLE_TIMEOUT_SECONDS_CONFIG_KEY = "dku.projectStandards.idle.timeoutSeconds";
    private static final int IDLE_TIMEOUT_SECONDS_DEFAULT = 600;
    public static final String PYTHON_PACKAGE = "dataiku.project_standards.server";
    private final ExecutorService executorService;
    private final KernelPool<SimplePythonKernel, KernelDesc, KernelDesc> manager;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projectStandards.pool");

    public CheckResultResponse runCheck(ProjectStandardsCheckRunRequest request, long executionTimeoutMinutes) throws Exception {
        assert (this.isProcessTypeSupported()) : "Project standards checks cannot be performed in " + String.valueOf(DKUApp.getProcessType());
        DSSAuthCtx dssAuthCtx = DSSAuthCtx.internalAdminAuthWithInMemoryAPIKey();
        KernelDesc kernelDesc = new KernelDesc(request, dssAuthCtx, CurrentComputeResourceUsageContext.get(), JobContext.getCurrentJobContext());
        ExecuteCheckCommand command = new ExecuteCheckCommand(request.projectParams.projectKey, request.projectParams.originalProjectKey, request.check.id, request.codeFileRelativePath, request.checkParams);
        CompletableFuture future = this.manager.handle(kernel -> kernel.getLink().getAsyncLink().asyncStreamRequest((Object)command, CheckResultResponse.class).timeout(Duration.ofMinutes(executionTimeoutMinutes)).last().toFuture(), (Object)kernelDesc, kernelDesc.getPoolKey(), (Object)command);
        return (CheckResultResponse)DKUCompletableFuture.collectResponse((CompletableFuture)future);
    }

    public void invalidateKernels(String pluginId) {
        if (this.manager != null) {
            this.manager.clearKernels(kernelDesc -> kernelDesc.pluginId.equals(pluginId), KernelPool.DeathReason.OUTDATED);
        }
    }

    public ProjectStandardsKernelPool() {
        if (this.isProcessTypeSupported()) {
            this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("project-standards-kernel-pool-startstop-%d").build());
            this.manager = this.createKernelPool();
        } else {
            this.executorService = null;
            this.manager = null;
        }
    }

    private boolean isProcessTypeSupported() {
        return DKUApp.getProcessType() != MainLoggingConfigurator.ProcessType.CDE && !ApplicationConfigurator.isInSparkDriver();
    }

    private KernelPool<SimplePythonKernel, KernelDesc, KernelDesc> createKernelPool() {
        return new KernelPool((KernelPool.KernelController)new KernelPool.KernelController<SimplePythonKernel, KernelDesc, KernelDesc>(){

            @Nonnull
            public SimplePythonKernel createKernel(KernelDesc kernelDesc) {
                try {
                    IPluginsRegistryService pluginsService = (IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class);
                    String pythonlibFolderPath = pluginsService.getPluginPythonlibFolder(kernelDesc.pluginId).getAbsolutePath();
                    String resourceFolderPath = kernelDesc.isRunningLocally ? pluginsService.getPluginResourceFolder(kernelDesc.pluginId).getAbsolutePath() : "/home/dataiku/plugin/resource";
                    String kernelId = String.format("project-standards-%s-%s", kernelDesc.pluginId, SecretKeyGenerator.generateSmall());
                    Map<String, String> extraEnv = Map.of("DKU_CUSTOM_RESOURCE_FOLDER", resourceFolderPath, "DKU_PLUGIN_ID", kernelDesc.pluginId);
                    ContainerExecRuntimeConfig containerConfig = null;
                    if (StringUtils.isNotEmpty((CharSequence)kernelDesc.containerConfName)) {
                        containerConfig = new ClusterSelector().selectForCluster(DSSAuthCtx.internalAdminAuth(), "__builtin__", kernelDesc.clusterId).getContainerSettings().getByName(kernelDesc.containerConfName);
                    }
                    return SimplePythonKernelFactory.prepareKernel(kernelDesc.kernelOwner, "__DKU_ANY_PROJECT__", GeneralSettingsDAO.CGrouppableProcessType.PROJECT_STANDARDS, kernelDesc.pluginSettings.codeEnvName, ProjectStandardsKernelPool.PYTHON_PACKAGE, false, false, (Map<String, String>)ImmutableMap.of((Object)"plugin-lib", (Object)pythonlibFolderPath), containerConfig, kernelId, kernelId + "-", false, true, extraEnv);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while creating python kernel for project standards: %s".formatted(ExceptionUtils.getMessageWithCauses((Throwable)e)), e);
                }
            }

            @Nonnull
            public CompletableFuture<Void> startKernel(SimplePythonKernel kernel, KernelDesc kernelDesc) {
                return CompletableFuture.runAsync(() -> {
                    NDC.push((String)("start-project-standards-kernel: " + kernel.getId()));
                    try {
                        DSSKernelUtils.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                        kernel.start();
                        String pluginFolderPath = kernelDesc.isRunningLocally ? ((IPluginsRegistryService)SpringUtils.getBean(IPluginsRegistryService.class)).getActualPluginFolder(kernelDesc.pluginId).getAbsolutePath() : "/home/dataiku/plugin";
                        this.sendStartCommand(kernel, pluginFolderPath, kernelDesc.pluginSettings.config);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error while starting python kernel for project standards: %s".formatted(ExceptionUtils.getMessageWithCauses((Throwable)e)), e);
                    }
                    finally {
                        NDC.pop();
                    }
                }, ProjectStandardsKernelPool.this.executorService);
            }

            public int getGlobalMaxKernelCount() {
                return DKUApp.getParams().getIntParam(ProjectStandardsKernelPool.KERNEL_MAX_TOTAL_CONFIG_KEY, Integer.valueOf(10));
            }

            public int getAutoscaleTimeWindowSeconds() {
                return DKUApp.getParams().getIntParam(ProjectStandardsKernelPool.IDLE_TIMEOUT_SECONDS_CONFIG_KEY, Integer.valueOf(600));
            }

            public int getHardMaxParallelRequests(KernelDesc kernelDesc) {
                return 1;
            }

            public int getSoftMaxParallelRequests(KernelDesc kernelDesc) {
                return 1;
            }

            @Nonnull
            public CompletableFuture<Void> killKernel(SimplePythonKernel kernel) {
                return CompletableFuture.runAsync(() -> {
                    NDC.push((String)("stop-project-standards-kernel: " + kernel.getId()));
                    try {
                        kernel.close();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while closing project standards kernel", (Throwable)e);
                    }
                    finally {
                        NDC.pop();
                    }
                }, ProjectStandardsKernelPool.this.executorService);
            }

            public boolean isAlive(SimplePythonKernel kernel) {
                return kernel.isAlive();
            }

            public String getKernelId(SimplePythonKernel kernel) {
                return kernel.getId();
            }

            public boolean killKernelOnRequestFailure() {
                return true;
            }

            private void sendStartCommand(SimplePythonKernel kernel, String checksFolderPath, JsonObject pluginConfig) {
                kernel.getLink().getAsyncLink().request((Object)new InitKernelServerCommand(checksFolderPath, pluginConfig), InitKernelServerDoneResponse.class);
            }
        }, new KernelScalingStrategyBuilder(), new KernelPoolThreadFactory("project-standards"), logger);
    }

    static class KernelDesc {
        final String clusterId;
        final String pluginId;
        final String containerConfName;
        final boolean isRunningLocally;
        final PluginSettings pluginSettings;
        final DSSAuthCtx kernelOwner;
        ComputeResourceUsageContext cruContext;
        JobContext jobContext;

        public KernelDesc(ProjectStandardsCheckRunRequest request, DSSAuthCtx kernelOwner, ComputeResourceUsageContext cruContext, JobContext jobContext) {
            this.clusterId = request.clusterId;
            this.containerConfName = request.containerConfName;
            this.pluginId = request.pluginParams.pluginId;
            this.pluginSettings = request.pluginParams.pluginSettings;
            this.kernelOwner = kernelOwner;
            this.cruContext = cruContext;
            this.jobContext = jobContext;
            this.isRunningLocally = StringUtils.isEmpty((CharSequence)this.containerConfName);
        }

        public String getPoolKey() {
            MessageDigest digest = DigestUtils.getSha256Digest();
            JSON.updateDigest((MessageDigest)digest, (Object)this.clusterId);
            JSON.updateDigest((MessageDigest)digest, (Object)this.containerConfName);
            JSON.updateDigest((MessageDigest)digest, (Object)this.pluginSettings);
            JSON.updateDigest((MessageDigest)digest, (Object)this.kernelOwner.getIdentifier());
            return "project-standards_" + this.pluginId + "_" + Hex.encodeHexString((byte[])digest.digest()).substring(0, 10);
        }
    }

    static class ExecuteCheckCommand
    extends Command {
        String projectKey;
        String originalProjectKey;
        String checkId;
        String codeFileRelativePath;
        JsonObject checkParams;

        public ExecuteCheckCommand(String projectKey, String originalProjectKey, String checkId, String codeFileRelativePath, JsonObject checkParams) {
            this.projectKey = projectKey;
            this.originalProjectKey = originalProjectKey;
            this.checkId = checkId;
            this.codeFileRelativePath = codeFileRelativePath;
            this.checkParams = checkParams;
        }

        private ExecuteCheckCommand() {
        }
    }

    public static class CheckResultResponse
    extends Response {
        @Nullable
        public ProjectStandardsCheckRunResult checkRunResult;
        @Nullable
        public String error;

        public String toString() {
            return "CheckResultResponse{checkRunResult=" + String.valueOf(this.checkRunResult) + ", error='" + this.error + "'}";
        }
    }

    static class InitKernelServerDoneResponse
    extends Response {
        InitKernelServerDoneResponse() {
        }
    }

    @PolyJSON(value={@Mapping(value=InitKernelServerDoneResponse.class, type="InitKernelServerDone"), @Mapping(value=CheckResultResponse.class, type="CheckResult")})
    static abstract class Response {
        Response() {
        }
    }

    static class InitKernelServerCommand
    extends Command {
        String pluginFolderPath;
        JsonObject pluginConfig;

        public InitKernelServerCommand(String pluginFolderPath, JsonObject pluginConfig) {
            this.pluginFolderPath = pluginFolderPath;
            this.pluginConfig = pluginConfig;
        }

        private InitKernelServerCommand() {
        }
    }

    @PolyJSON(value={@Mapping(value=InitKernelServerCommand.class, type="InitKernelServer"), @Mapping(value=ExecuteCheckCommand.class, type="ExecuteCheck")})
    static abstract class Command {
        Command() {
        }
    }
}

