/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.pig;

import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.pig.PigRecipeTester;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import org.springframework.beans.factory.annotation.Autowired;

public class PigRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GenericRecipesValidationService validationService;
    private String query;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.pig.schema.computer");

    public PigRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public void setPayload(String payload) {
        this.query = payload;
    }

    @Override
    public boolean computesDiffItself() {
        return true;
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResult_NT() throws Exception {
        PigRecipeTester.PigCheckContext ctx;
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
        PigRecipeTester tester = new PigRecipeTester();
        try (Transaction t = this.transactionService.beginRead();){
            this.recipe.name = "testRecipe";
            FlowGraph graph = new FlowGraph();
            FlowRecipe flowRecipe = graph.buildSingleRecipe(this.recipe);
            assert (flowRecipe != null);
            subgraphCallable = this.validationService.getValidationRunnableSubgraph(this.authCtx, flowRecipe, null);
        }
        RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
        try (Transaction t = this.transactionService.beginRead();){
            ctx = tester.startCheckPig(this.authCtx, this.recipe, this.query, subgraph);
        }
        if (ctx.proceed) {
            tester.doCheckPig_NT(ctx);
            tester.finishCheckPig_NG(ctx);
            if (ctx.status.schemaResult != null) {
                return ctx.status.schemaResult;
            }
        }
        throw ErrorContext.iaef((String)"Failed to compute output schema: %s", (Object)ctx.status.gatherAllMessages().firstFatal(), (Object[])new Object[0]);
    }
}

